/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.util;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.internal.XMLUtil;
import quadbase.reportdesigner.lang.IObject;
import quadbase.reportdesigner.report.Formula;
import quadbase.reportdesigner.report.LoadXMLReportHelper;
import quadbase.reportdesigner.report.NewFormulaParser;
import quadbase.reportdesigner.util.IAggregateConstants;

public class ColInfo
implements IAggregateConstants {
    private int mapping = -1;
    private boolean rowBreak = false;
    private boolean colBreak = false;
    private boolean colBreakValue = false;
    private boolean isMaster = false;
    private boolean topN = false;
    private short aggregation = 0;
    private boolean aggregateColumn = false;
    private String formula = null;
    private String formulaName = null;
    private Formula formulaObj;
    private String colName = null;
    private String dbTableName = null;
    private int sqlType = -1;
    private boolean visible = true;
    private boolean repeatBreakField = false;
    private boolean fitGroupOnPage = false;
    public static final String XMLTAG = "COLUMN_INFO";
    private boolean skipFirstValueFitGroup = true;
    private int orderInfo = 0;
    public final int NOT_SORTED = 0;
    public final int ASC = 1;
    public final int DESC = 2;
    private String drillDownName;

    public ColInfo(int colMappedIndex) {
        this.mapping = colMappedIndex;
    }

    public ColInfo(IObject object, String colName) {
        this(object, colName, object.getSQLType());
    }

    public ColInfo(IObject object, String colName, int sqlType) {
        this.formula = object.getFormula();
        this.formulaObj = new Formula(colName, this.formula);
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(this.formula.getBytes("UTF-8"));
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
            NewFormulaParser parser = new NewFormulaParser(inputStreamReader);
            this.formulaObj.setFormula(parser.parse(null, null, null, null));
        }
        catch (Exception ex) {
            System.out.println("invalid formula!");
        }
        this.sqlType = sqlType;
        this.colName = colName != null ? colName : "FORMULA COLUMN";
    }

    public ColInfo(String formula, String colName, int sqlType) {
        formula = QbUtil.removeSkipChar(formula);
        this.formulaObj = new Formula(colName, formula);
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(formula.getBytes("UTF-8"));
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
            NewFormulaParser parser = new NewFormulaParser(inputStreamReader);
            this.formulaObj.setFormula(parser.parse(null, null, null, null));
        }
        catch (Exception ex) {
            System.out.println("invalid formula!");
        }
        if (sqlType >= 0) {
            this.sqlType = sqlType;
        }
        this.colName = colName != null ? colName : "FORMULA COLUMN";
    }

    public ColInfo(Formula formulaObj, String colName, int sqlType) {
        this.formulaObj = formulaObj;
        if (formulaObj != null) {
            this.formula = formulaObj.getText();
            this.formulaName = formulaObj.getName();
        }
        if (sqlType >= 0) {
            this.sqlType = sqlType;
        }
        this.colName = colName != null ? colName : "FORMULA COLUMN";
    }

    public int getMapping() {
        return this.mapping;
    }

    public void setMapping(int colMappedIndex) {
        this.mapping = colMappedIndex;
    }

    public boolean isPrimaryKey() {
        return this.isRowBreak();
    }

    public void setPrimaryKey(boolean isPrimaryKey) {
        this.setRowBreak(isPrimaryKey);
        this.setMaster(isPrimaryKey);
    }

    public boolean isRowBreak() {
        return this.rowBreak;
    }

    public void setRowBreak(boolean breakOnThisColumn) {
        if (this.formula != null) {
            return;
        }
        this.rowBreak = breakOnThisColumn;
    }

    public boolean isColumnBreak() {
        return this.colBreak;
    }

    public void setColumnBreak(boolean breakOnThisColumn) {
        if (this.formula != null) {
            return;
        }
        this.colBreak = breakOnThisColumn;
    }

    public boolean isColumnBreakValue() {
        return this.colBreakValue;
    }

    public void setColumnBreakValue(boolean breakOnThisColumn) {
        if (this.formula != null) {
            return;
        }
        this.colBreakValue = breakOnThisColumn;
    }

    public void setMaster(boolean isMasterField) {
        this.isMaster = isMasterField;
        if (isMasterField) {
            this.setVisible(false);
        }
    }

    public boolean isMaster() {
        return this.isMaster;
    }

    public boolean isTopN() {
        return this.topN;
    }

    public void setTopN(boolean isTopN) {
        this.topN = isTopN;
    }

    public short getAggregation() {
        return this.aggregation;
    }

    public void setAggregation(short agg) {
        this.setAggregation(agg != 0, agg);
    }

    public void setAggregation(boolean aggregateColumn, short agg) {
        this.aggregateColumn = agg == 0 ? false : aggregateColumn;
        this.aggregation = agg;
    }

    public boolean isAggregatedColumn() {
        return this.aggregateColumn;
    }

    public boolean isRepeatBreakField() {
        return this.repeatBreakField;
    }

    public void setRepeatBreakField(boolean isRepeatBreakField) {
        this.repeatBreakField = isRepeatBreakField;
    }

    public boolean isFitGroupOnPage() {
        return this.fitGroupOnPage;
    }

    public void setFitGroupOnPage(boolean isFitGroupOnPage) {
        this.fitGroupOnPage = isFitGroupOnPage;
    }

    public String getName() {
        return this.colName;
    }

    public void setName(String colName) {
        this.colName = colName;
    }

    public String getDBTableName() {
        return this.dbTableName;
    }

    public void setDBTableName(String tableName) {
        this.dbTableName = tableName;
    }

    public String getFormula() {
        if (this.formulaObj != null) {
            return this.formulaObj.getText();
        }
        return this.formula;
    }

    public void setFormula(String txt, int type) {
        this.formula = txt;
        this.sqlType = type;
    }

    public Formula getFormulaObj() {
        return this.formulaObj;
    }

    public void setFormulaObj(Formula formula) {
        this.formulaObj = formula;
        this.formulaName = formula.getName();
        this.formula = formula.getText();
        if (formula.getSQLType() >= 0) {
            this.sqlType = formula.getSQLType();
        }
    }

    public String getFormulaName() {
        if (this.formulaObj != null) {
            return this.formulaObj.getName();
        }
        return this.formulaName;
    }

    public void setFormulaName(String name) {
        this.formulaName = name;
    }

    public int getDataType() {
        if (this.formulaObj != null) {
            this.sqlType = this.formulaObj.getSQLType();
        }
        return this.sqlType;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean b) {
        this.visible = b;
    }

    public Object clone() {
        ColInfo cInfo = new ColInfo(this.mapping);
        cInfo.rowBreak = this.rowBreak;
        cInfo.colBreak = this.colBreak;
        cInfo.colBreakValue = this.colBreakValue;
        cInfo.isMaster = this.isMaster;
        cInfo.aggregation = this.aggregation;
        cInfo.aggregateColumn = this.aggregateColumn;
        cInfo.formula = this.formula == null ? null : this.formula;
        cInfo.formulaName = this.formulaName == null ? null : this.formulaName;
        cInfo.formulaObj = this.formulaObj == null ? null : this.formulaObj.copy();
        cInfo.colName = this.colName == null ? null : this.colName;
        cInfo.sqlType = this.sqlType;
        cInfo.visible = this.visible;
        cInfo.repeatBreakField = this.repeatBreakField;
        cInfo.fitGroupOnPage = this.fitGroupOnPage;
        cInfo.orderInfo = this.orderInfo;
        cInfo.topN = this.topN;
        return cInfo;
    }

    public boolean equals(ColInfo cInfo) {
        return this.equals(cInfo, true);
    }

    public boolean equals(ColInfo cInfo, boolean checkRepeatField) {
        if (cInfo.mapping != this.mapping) {
            return false;
        }
        if (cInfo.rowBreak != this.rowBreak) {
            return false;
        }
        if (cInfo.colBreakValue != this.colBreakValue) {
            return false;
        }
        if (cInfo.isMaster != this.isMaster) {
            return false;
        }
        if (cInfo.aggregation != this.aggregation) {
            return false;
        }
        if (cInfo.aggregateColumn != this.aggregateColumn) {
            return false;
        }
        if (cInfo.formulaObj != this.formulaObj) {
            return false;
        }
        if (checkRepeatField || this.colName != null && cInfo.colName != null) {
            if (cInfo.colName == null && this.colName != null) {
                return false;
            }
            if (cInfo.colName != null && !cInfo.colName.equals(this.colName)) {
                return false;
            }
        }
        if (cInfo.sqlType != this.sqlType) {
            return false;
        }
        if (cInfo.visible != this.visible) {
            return false;
        }
        if (checkRepeatField && cInfo.repeatBreakField != this.repeatBreakField) {
            return false;
        }
        if (cInfo.fitGroupOnPage != this.fitGroupOnPage) {
            return false;
        }
        return cInfo.orderInfo == this.orderInfo;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.mapping);
        out.writeBoolean(this.topN);
        out.writeBoolean(this.rowBreak);
        out.writeBoolean(this.colBreak);
        out.writeBoolean(this.colBreakValue);
        out.writeBoolean(this.isMaster);
        out.writeBoolean(this.visible);
        out.writeBoolean(this.repeatBreakField);
        out.writeBoolean(this.fitGroupOnPage);
        out.writeBoolean(this.aggregateColumn);
        out.writeShort(this.aggregation);
        out.writeInt(this.orderInfo);
        if (this.getFormulaName() != null) {
            IOUtil.writeStr(out, this.getFormulaName());
        } else {
            IOUtil.writeStr(out, this.getFormula());
        }
        IOUtil.writeStr(out, this.colName);
        out.writeInt(this.sqlType);
        IOUtil.writeStr(out, this.getDrillDownName());
    }

    public static ColInfo read(DataInput in, int version) throws Exception {
        ColInfo colInfo = new ColInfo(in.readInt());
        if (version >= 100) {
            colInfo.setTopN(in.readBoolean());
        }
        colInfo.setRowBreak(in.readBoolean());
        colInfo.setColumnBreak(in.readBoolean());
        if (version >= 3) {
            colInfo.setColumnBreakValue(in.readBoolean());
        } else {
            in.readInt();
        }
        if (version >= 4) {
            colInfo.setMaster(in.readBoolean());
            colInfo.setVisible(in.readBoolean());
        }
        if (version >= 44) {
            colInfo.setRepeatBreakField(in.readBoolean());
        }
        if (version >= 45) {
            colInfo.setFitGroupOnPage(in.readBoolean());
        }
        if (version >= 12) {
            colInfo.setAggregation(in.readBoolean(), in.readShort());
        } else {
            colInfo.setAggregation(in.readShort());
        }
        if (version >= 142) {
            colInfo.setOrderInfo(in.readInt());
        }
        if (version >= 70) {
            colInfo.formulaName = IOUtil.readStr(in);
        } else {
            colInfo.formula = IOUtil.readStr(in);
        }
        colInfo.colName = IOUtil.readStr(in);
        colInfo.sqlType = in.readInt();
        if (version >= 210) {
            colInfo.drillDownName = IOUtil.readStr(in);
        }
        return colInfo;
    }

    public void writeXML(Writer out) throws IOException {
        out.write("<COLUMN_INFO Mapping=\"" + this.mapping + "\" TopN=\"" + this.topN + "\" RowBreak=\"" + this.rowBreak + "\" ColumnBreak=\"" + this.colBreak + "\" ColumnBreakValue=\"" + this.colBreakValue + "\" Master=\"" + this.isMaster + "\" Visible=\"" + this.visible + "\" RepeatBreakField=\"" + this.repeatBreakField + "\" FitGroupOnPage=\"" + this.fitGroupOnPage + "\" AggregatedColumn=\"" + this.aggregateColumn + "\" Aggregation=\"" + this.aggregation + "\" OrderInfo=\"" + this.orderInfo + "\" SqlType=\"" + DataType.getTypeName(this.sqlType) + "\">\n");
        if (this.colName != null) {
            out.write("<NAME>" + XMLUtil.encodeCDATA(this.colName) + "</NAME>\n");
        }
        if (this.drillDownName != null) {
            out.write("<DRILLDOWN_NAME>" + XMLUtil.encodeCDATA(this.drillDownName) + "</DRILLDOWN_NAME>\n");
        }
        if (this.formulaObj != null) {
            if (this.getFormulaName() != null) {
                out.write("<FORMULA>" + XMLUtil.encodeCDATA(this.getFormulaName()) + "</FORMULA>\n");
            } else {
                out.write("<FORMULA>" + XMLUtil.encodeCDATA(this.getFormula()) + "</FORMULA>\n");
            }
        }
        out.write("</COLUMN_INFO>\n");
    }

    public static ColInfo readXML(Node dnode, int version) throws Exception {
        if (dnode.getNodeName().equalsIgnoreCase(XMLTAG)) {
            ColInfo colInfo = null;
            NamedNodeMap map = dnode.getAttributes();
            for (int i = 0; i < map.getLength(); ++i) {
                if (!map.item(i).getNodeName().equalsIgnoreCase("Mapping")) continue;
                colInfo = new ColInfo(Integer.parseInt(map.item(i).getNodeValue()));
                break;
            }
            if (colInfo == null) {
                throw new Exception("Invalid 'COLUMN_INFO' element. Missing 'Mapping' attribute.");
            }
            boolean aggregateColumn = false;
            short aggregation = -1;
            boolean visibleCheck = false;
            boolean masterCheck = false;
            boolean colBreakValueCheck = false;
            boolean colBreakCheck = false;
            boolean rowBreakCheck = false;
            boolean sqlTypeCheck = false;
            boolean aggregationCheck = false;
            boolean aggregateColumnCheck = false;
            for (int i = 0; i < map.getLength(); ++i) {
                Node attr = map.item(i);
                if (attr.getNodeName().equalsIgnoreCase("TopN")) {
                    colInfo.setTopN(LoadXMLReportHelper.parseBoolean(attr.getNodeValue()));
                    continue;
                }
                if (attr.getNodeName().equalsIgnoreCase("RowBreak") && !rowBreakCheck) {
                    colInfo.setRowBreak(LoadXMLReportHelper.parseBoolean(attr.getNodeValue()));
                    rowBreakCheck = true;
                    continue;
                }
                if (attr.getNodeName().equalsIgnoreCase("ColumnBreak") && !colBreakCheck) {
                    colInfo.setColumnBreak(LoadXMLReportHelper.parseBoolean(attr.getNodeValue()));
                    colBreakCheck = true;
                    continue;
                }
                if (attr.getNodeName().equalsIgnoreCase("ColumnBreakValue") && !colBreakValueCheck) {
                    colInfo.setColumnBreakValue(LoadXMLReportHelper.parseBoolean(attr.getNodeValue()));
                    colBreakValueCheck = true;
                    continue;
                }
                if (attr.getNodeName().equalsIgnoreCase("Master") && !masterCheck) {
                    colInfo.setMaster(LoadXMLReportHelper.parseBoolean(attr.getNodeValue()));
                    masterCheck = true;
                    continue;
                }
                if (attr.getNodeName().equalsIgnoreCase("Visible") && !visibleCheck) {
                    colInfo.setVisible(LoadXMLReportHelper.parseBoolean(attr.getNodeValue()));
                    visibleCheck = true;
                    continue;
                }
                if (attr.getNodeName().equalsIgnoreCase("RepeatBreakField")) {
                    colInfo.setRepeatBreakField(LoadXMLReportHelper.parseBoolean(attr.getNodeValue()));
                    continue;
                }
                if (attr.getNodeName().equalsIgnoreCase("FitGroupOnPage")) {
                    colInfo.setFitGroupOnPage(LoadXMLReportHelper.parseBoolean(attr.getNodeValue()));
                    continue;
                }
                if (attr.getNodeName().equalsIgnoreCase("AggregatedColumn") && !aggregateColumnCheck) {
                    aggregateColumn = LoadXMLReportHelper.parseBoolean(attr.getNodeValue());
                    aggregateColumnCheck = true;
                    continue;
                }
                if (attr.getNodeName().equalsIgnoreCase("Aggregation") && !aggregationCheck) {
                    aggregation = Short.parseShort(attr.getNodeValue());
                    aggregationCheck = true;
                    continue;
                }
                if (attr.getNodeName().equalsIgnoreCase("OrderInfo")) {
                    colInfo.setOrderInfo(Integer.parseInt(attr.getNodeValue()));
                    continue;
                }
                if (!attr.getNodeName().equalsIgnoreCase("SQLType") || sqlTypeCheck) continue;
                colInfo.sqlType = DataType.findType(attr.getNodeValue());
                sqlTypeCheck = true;
            }
            if (rowBreakCheck && colBreakCheck && colBreakValueCheck && masterCheck && visibleCheck && aggregateColumnCheck && aggregationCheck && sqlTypeCheck) {
                colInfo.setAggregation(aggregateColumn, aggregation);
                colInfo.formula = null;
                colInfo.colName = null;
                NodeList nodeList = dnode.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    if (nodeList.item(i).getNodeName().equalsIgnoreCase("FORMULA")) {
                        if (version >= 70) {
                            colInfo.formulaName = LoadXMLReportHelper.readCDATA(nodeList.item(i));
                            continue;
                        }
                        colInfo.formula = LoadXMLReportHelper.readCDATA(nodeList.item(i));
                        continue;
                    }
                    if (nodeList.item(i).getNodeName().equalsIgnoreCase("NAME")) {
                        colInfo.colName = LoadXMLReportHelper.readCDATA(nodeList.item(i));
                        continue;
                    }
                    if (!nodeList.item(i).getNodeName().equalsIgnoreCase("DRILLDOWN_NAME")) continue;
                    colInfo.drillDownName = LoadXMLReportHelper.readCDATA(nodeList.item(i));
                }
                return colInfo;
            }
            throw new Exception("Invalid 'COLUMN_INFO' element. Missing one or more attributes.");
        }
        return null;
    }

    public boolean skipFirstValueForFitGroup() {
        return this.skipFirstValueFitGroup;
    }

    public void setSkipFirstValueForFitGroup(boolean s) {
        this.skipFirstValueFitGroup = s;
    }

    public void setOrderInfo(int i) {
        this.orderInfo = i;
    }

    public int getOrderInfo() {
        return this.orderInfo;
    }

    public boolean isSorted() {
        return this.orderInfo > 0;
    }

    public boolean isAsc() {
        return this.orderInfo == 1;
    }

    public boolean isDsc() {
        return this.orderInfo == 2;
    }

    public void setDrillDownName(String name) {
        this.drillDownName = name;
    }

    public String getDrillDownName() {
        return this.drillDownName;
    }
}

