/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.util;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.util.IFormat;
import quadbase.reportdesigner.util.internal.FormatUtil;

public class DateTimeFormat
implements IFormat {
    public static final short YEAR_1999 = 0;
    public static final short YEAR_99 = 1;
    public static final short MONTH_INT = 0;
    public static final short MONTH_SHORT_STRING = 1;
    public static final short MONTH_LONG_STRING = 2;
    public static final short MDY = 0;
    public static final short DMY = 1;
    public static final short YMD = 2;
    public short yearSymbol;
    public short monthSymbol;
    public short orderSymbol;
    public String separator1;
    public String separator2;
    public boolean hour24;
    public boolean showMinute;
    public boolean showSecond;
    public String hourMinuteSep;
    public String minuteSecondSep;
    public short nanoDecimal;
    public boolean timeBeforeDate;
    public String timeDateSep;
    public boolean hideyear;
    public boolean hidemonth;
    public boolean hidedate;
    public boolean hideTimestampTime;
    public boolean fixDigitLen;
    public static final String[] MonthString = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};

    public DateTimeFormat() {
        this.setDefault();
    }

    @Override
    public int getFormatType() {
        return 3;
    }

    @Override
    public String format(Object obj) {
        if (obj == null) {
            obj = FormatUtil.nullDateTime;
        }
        if (obj instanceof Time) {
            return this.output((Time)obj);
        }
        if (obj instanceof Timestamp) {
            return this.output((Timestamp)obj);
        }
        if (obj instanceof Date) {
            return this.output((Date)obj);
        }
        return obj.toString();
    }

    public void setDefault() {
        this.yearSymbol = 1;
        this.monthSymbol = 0;
        this.orderSymbol = 0;
        this.separator1 = "/";
        this.separator2 = "/";
        this.hour24 = true;
        this.showMinute = true;
        this.showSecond = true;
        this.hourMinuteSep = ":";
        this.minuteSecondSep = ":";
        this.nanoDecimal = 0;
        this.timeBeforeDate = false;
        this.timeDateSep = " ";
        this.hidedate = false;
        this.hideyear = false;
        this.hidemonth = false;
        this.fixDigitLen = true;
        this.hideTimestampTime = false;
    }

    public String output(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return this.formatDate(cal);
    }

    public String output(Time time) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        return this.formatTime(cal, 0);
    }

    public String output(Timestamp timestamp) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(timestamp);
        String fdate = this.formatDate(cal);
        if (this.hideTimestampTime) {
            return fdate;
        }
        String ftime = this.formatTime(cal, timestamp.getNanos());
        if (this.timeBeforeDate) {
            return ftime + this.timeDateSep + fdate;
        }
        return fdate + this.timeDateSep + ftime;
    }

    private String getYear(Calendar cal) {
        if (this.hideyear) {
            return "";
        }
        int tmp = cal.get(1);
        if (this.yearSymbol == 0) {
            return "" + tmp;
        }
        if ((tmp %= 100) < 10) {
            return "0" + tmp;
        }
        return "" + tmp;
    }

    String formatDate(Calendar cal) {
        String todate;
        String year = this.getYear(cal);
        int dm = cal.get(2);
        String month = this.hidemonth ? "" : (this.monthSymbol == 0 ? this.cov(dm + 1) : (this.monthSymbol == 1 ? MonthString[dm].substring(0, 3) : MonthString[dm]));
        String string = todate = this.hidedate ? "" : this.cov(cal.get(5)) + "";
        return this.orderSymbol == 0 ? month + (this.hidedate || this.hidemonth ? "" : this.separator1) + todate + (this.hidedate || this.hideyear ? (!this.hideyear && !this.hidemonth ? this.separator2 : "") : this.separator2) + year : (this.orderSymbol == 1 ? todate + (this.hidedate || this.hidemonth ? "" : this.separator1) + month + (this.hidemonth || this.hideyear ? (!this.hidedate && !this.hideyear ? this.separator2 : "") : this.separator2) + year : year + (this.hideyear || this.hidemonth ? "" : this.separator1) + month + (this.hidemonth || this.hidedate ? (!this.hideyear && !this.hidedate ? this.separator2 : " ") : this.separator2) + todate);
    }

    String formatTime(Calendar cal, int nano) {
        int hour = cal.get(11);
        String shour = this.hour24 || hour <= 12 ? this.cov(hour) : this.cov(hour - 12);
        return shour + (this.showMinute ? this.hourMinuteSep + this.cov(cal.get(12)) + (this.showSecond ? this.minuteSecondSep + this.cov(cal.get(13)) : "") : "") + this.formatNano(nano) + (!this.hour24 ? (hour < 12 ? "AM" : "PM") : "");
    }

    private String formatNano(int nano) {
        int length;
        if (!this.showSecond || !this.showMinute) {
            return "";
        }
        String snano = "" + nano;
        if (snano.length() < 9) {
            int diff = 9 - snano.length();
            for (int i = 0; i < diff; ++i) {
                snano = "0" + snano;
            }
        }
        if ((length = this.nanoDecimal) > 9) {
            length = 9;
        }
        if (snano.length() < length) {
            length = snano.length();
        }
        return length == 0 ? "" : "." + snano.substring(0, length);
    }

    String cov(int value) {
        return this.fixDigitLen ? (value < 10 ? "0" : "") + value : value + "";
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<< DateTimFormat >>\n");
        sb.append("yearSymbol\t= " + this.yearSymbol + "\n");
        sb.append("monthSymbol\t= " + this.monthSymbol + "\n");
        sb.append("orderSymbol\t= " + this.orderSymbol + "\n");
        sb.append("separator1\t= " + this.separator1 + "\n");
        sb.append("separator2\t= " + this.separator2 + "\n");
        sb.append("hour24\t\t= " + this.hour24 + "\n");
        sb.append("showMinute\t= " + this.showMinute + "\n");
        sb.append("showSeocnd\t= " + this.showSecond + "\n");
        sb.append("hourMinuteSep\t=" + this.hourMinuteSep + "\n");
        sb.append("minuteSecondSep\t=" + this.minuteSecondSep + "\n");
        sb.append("nanoDecimal\t= " + this.nanoDecimal + "\n");
        sb.append("timeBeforeDate\t= " + this.timeBeforeDate + "\n");
        sb.append("timeDataSep\t= " + this.timeDateSep + "\n");
        sb.append("hidemonth\t= " + this.hidemonth + "\n");
        sb.append("hideyear\t= " + this.hideyear + "\n");
        sb.append("hidedate\t= " + this.hidedate + "\n");
        sb.append("fixDigitLen\t= " + this.fixDigitLen + "\n");
        sb.append("hideTimestampTime\t= " + this.hideTimestampTime + "\n");
        return sb.toString();
    }

    @Override
    public String getTextFormat() {
        String sep = ":";
        String tmp = 3 + sep + this.yearSymbol + sep;
        tmp = tmp + this.monthSymbol + sep;
        tmp = tmp + this.orderSymbol + sep;
        tmp = tmp + this.writeString(this.separator1) + sep;
        tmp = tmp + this.writeString(this.separator2) + sep;
        tmp = tmp + (this.hour24 ? "T" : "F") + sep;
        tmp = tmp + (this.showMinute ? "T" : "F") + sep;
        tmp = tmp + (this.showSecond ? "T" : "F") + sep;
        tmp = tmp + this.writeString(this.hourMinuteSep) + sep;
        tmp = tmp + this.writeString(this.minuteSecondSep) + sep;
        tmp = tmp + this.nanoDecimal + sep;
        tmp = tmp + (this.timeBeforeDate ? "T" : "F") + sep;
        tmp = tmp + this.writeString(this.timeDateSep) + sep;
        tmp = tmp + (this.hidedate ? "T" : "F") + sep;
        tmp = tmp + (this.hidemonth ? "T" : "F") + sep;
        tmp = tmp + (this.hideyear ? "T" : "F") + sep;
        tmp = tmp + (this.fixDigitLen ? "T" : "F") + sep;
        tmp = tmp + (this.hideTimestampTime ? "T" : "F");
        return tmp;
    }

    public static DateTimeFormat createFormat(String text) throws Exception {
        int i = 1;
        String[] param = DateTimeFormat.getParam(text);
        DateTimeFormat dt = new DateTimeFormat();
        dt.yearSymbol = (short)Integer.parseInt(param[i++]);
        dt.monthSymbol = (short)Integer.parseInt(param[i++]);
        dt.orderSymbol = (short)Integer.parseInt(param[i++]);
        dt.separator1 = DateTimeFormat.readString(param[i++]);
        dt.separator2 = DateTimeFormat.readString(param[i++]);
        dt.hour24 = param[i++].equals("T");
        dt.showMinute = param[i++].equals("T");
        dt.showSecond = param[i++].equals("T");
        dt.hourMinuteSep = DateTimeFormat.readString(param[i++]);
        dt.minuteSecondSep = DateTimeFormat.readString(param[i++]);
        dt.nanoDecimal = (short)Integer.parseInt(param[i++]);
        dt.timeBeforeDate = param[i++].equals("T");
        dt.timeDateSep = DateTimeFormat.readString(param[i++]);
        dt.hidedate = param[i++].equals("T");
        dt.hidemonth = param[i++].equals("T");
        dt.hideyear = param[i++].equals("T");
        dt.fixDigitLen = param[i++].equals("T");
        dt.hideTimestampTime = param[i++].equals("T");
        return dt;
    }

    private String writeString(String exp) {
        return "\"" + QbUtil.replace(exp, "\"", "\\\"") + "\"";
    }

    private static String readString(String exp) {
        return QbUtil.replace(exp.substring(exp.indexOf(34) + 1, exp.lastIndexOf(34)), "\\\"", "\"");
    }

    public static String[] getParam(String exp) {
        boolean nonString = true;
        Vector<String> vec = new Vector<String>();
        String s2 = "";
        for (int i = 0; i < exp.length(); ++i) {
            char c = exp.charAt(i);
            if (c == '\"' && (i <= 0 || exp.charAt(i - 1) != '\\')) {
                s2 = s2 + c;
                nonString = !nonString;
                continue;
            }
            if (nonString && (c = exp.charAt(i)) == ':') {
                vec.addElement(s2);
                s2 = "";
                continue;
            }
            s2 = s2 + c;
        }
        vec.addElement(s2);
        String[] tmp = new String[vec.size()];
        for (int j = 0; j < vec.size(); ++j) {
            tmp[j] = (String)vec.elementAt(j);
        }
        return tmp;
    }
}

