/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.util;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import quadbase.reportdesigner.util.IFormat;
import quadbase.reportdesigner.util.internal.FormatUtil;

public class LocaleDateTimeFormat
implements IFormat {
    public static int DATE = 0;
    public static int TIME = 1;
    public static int DATETIME = 2;
    private DateFormat df;
    private Locale locale = Locale.getDefault();
    private int type;
    private int style1;
    private int style2;

    private LocaleDateTimeFormat(int type, DateFormat df, int style) {
        this.type = type;
        this.df = df;
        this.style1 = style;
    }

    private LocaleDateTimeFormat(int type, DateFormat df, int style1, int style2) {
        this.type = type;
        this.df = df;
        this.style1 = style1;
        this.style2 = style2;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        TimeZone zone = this.df.getTimeZone();
        if (this.type == DATE) {
            this.df = DateFormat.getDateInstance(this.style1, locale);
        } else if (this.type == DATETIME) {
            this.df = DateFormat.getDateTimeInstance(this.style1, this.style2, locale);
        } else if (this.type == TIME) {
            this.df = DateFormat.getTimeInstance(this.style1, locale);
        }
        if (zone != null) {
            this.setTimeZone(zone);
        }
    }

    public void setTimeZone(TimeZone zone) {
        this.df.setTimeZone(zone);
    }

    public TimeZone getTimeZone() {
        return this.df.getTimeZone();
    }

    @Override
    public int getFormatType() {
        return 4;
    }

    @Override
    public String format(Object obj) {
        if (obj == null) {
            obj = FormatUtil.nullDateTime;
        }
        try {
            if (obj instanceof Time) {
                if (this.getInstanceType() != TIME) {
                    this.df = DateFormat.getTimeInstance(this.style2);
                }
                return this.df.format((Time)obj);
            }
            if (obj instanceof Timestamp) {
                if (this.getInstanceType() != DATETIME) {
                    this.df = DateFormat.getDateTimeInstance(this.style1, this.style2);
                }
                return this.df.format((Timestamp)obj);
            }
            if (obj instanceof Date) {
                if (this.getInstanceType() != DATE) {
                    this.df = DateFormat.getDateInstance(this.style1);
                }
                return this.df.format((Date)obj);
            }
            return obj.toString();
        }
        catch (Exception exception) {
            try {
                if (obj instanceof Time) {
                    return DateFormat.getTimeInstance(this.style1).format((Time)obj);
                }
                if (obj instanceof Timestamp) {
                    return DateFormat.getDateTimeInstance(this.style1, this.style2).format((Timestamp)obj);
                }
                if (obj instanceof Date) {
                    return DateFormat.getDateInstance(this.style1).format((Date)obj);
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return obj.toString();
        }
    }

    public static LocaleDateTimeFormat getDateInstance() {
        return LocaleDateTimeFormat.getDateInstance(2);
    }

    public static LocaleDateTimeFormat getDateInstance(int style) {
        return new LocaleDateTimeFormat(DATE, DateFormat.getDateInstance(style), style);
    }

    public static LocaleDateTimeFormat getDateInstance(Locale locale) {
        return LocaleDateTimeFormat.getDateInstance(2, locale);
    }

    public static LocaleDateTimeFormat getDateInstance(int style, Locale locale) {
        return new LocaleDateTimeFormat(DATE, DateFormat.getDateInstance(style, locale), style);
    }

    public static LocaleDateTimeFormat getDateTimeInstance() {
        return LocaleDateTimeFormat.getDateTimeInstance(2, 2);
    }

    public static LocaleDateTimeFormat getDateTimeInstance(Locale locale) {
        return LocaleDateTimeFormat.getDateTimeInstance(2, 2, locale);
    }

    public static LocaleDateTimeFormat getDateTimeInstance(int dateStyle, int timeStyle) {
        return new LocaleDateTimeFormat(DATETIME, DateFormat.getDateTimeInstance(dateStyle, timeStyle), dateStyle, timeStyle);
    }

    public static LocaleDateTimeFormat getDateTimeInstance(int dateStyle, int timeStyle, Locale locale) {
        return new LocaleDateTimeFormat(DATETIME, DateFormat.getDateTimeInstance(dateStyle, timeStyle, locale), dateStyle, timeStyle);
    }

    public static LocaleDateTimeFormat getTimeInstance() {
        return LocaleDateTimeFormat.getTimeInstance(2);
    }

    public static LocaleDateTimeFormat getTimeInstance(int style) {
        return new LocaleDateTimeFormat(TIME, DateFormat.getTimeInstance(style), style);
    }

    public static LocaleDateTimeFormat getTimeInstance(Locale locale) {
        return LocaleDateTimeFormat.getTimeInstance(2, locale);
    }

    public static LocaleDateTimeFormat getTimeInstance(int style, Locale locale) {
        return new LocaleDateTimeFormat(TIME, DateFormat.getTimeInstance(style, locale), style);
    }

    public int getInstanceType() {
        return this.type;
    }

    public int getDateStyle() {
        if (this.type == DATE || this.type == DATETIME) {
            return this.style1;
        }
        return -1;
    }

    public int getTimeStyle() {
        if (this.type == TIME) {
            return this.style1;
        }
        if (this.type == DATETIME) {
            return this.style2;
        }
        return -1;
    }

    public DateFormat getDateFormat() {
        return this.df;
    }

    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public String getTextFormat() {
        String sep = ":";
        String tmp = 4 + sep + this.getInstanceType() + sep;
        tmp = tmp + this.getDateStyle() + sep;
        tmp = tmp + this.getTimeStyle();
        return tmp;
    }

    public static LocaleDateTimeFormat createFormat(String text) throws Exception {
        StringTokenizer st = new StringTokenizer(text, ":");
        st.nextToken();
        int type = Integer.parseInt(st.nextToken());
        int dateStyle = Integer.parseInt(st.nextToken());
        int timeStyle = Integer.parseInt(st.nextToken());
        if (type == DATE) {
            return LocaleDateTimeFormat.getDateInstance(dateStyle);
        }
        if (type == TIME) {
            return LocaleDateTimeFormat.getTimeInstance(timeStyle);
        }
        if (type == DATETIME) {
            return LocaleDateTimeFormat.getDateTimeInstance(dateStyle, timeStyle);
        }
        throw new Exception("Illegal LocaleDateTimeFormat: " + type);
    }
}

