/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.util;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.StringTokenizer;
import quadbase.reportdesigner.util.IFormat;
import quadbase.reportdesigner.util.internal.FormatUtil;

public class LocaleNumericFormat
implements IFormat {
    public static final int CURRENCY = 0;
    public static final int NUMBER = 1;
    public static final int PERCENT = 2;
    private int type;
    private NumberFormat nf;

    private LocaleNumericFormat(int type, NumberFormat nf) {
        this.type = type;
        this.nf = nf;
    }

    public void setLocale(Locale locale) {
        if (this.type == 0) {
            this.nf = NumberFormat.getCurrencyInstance(locale);
        } else if (this.type == 1) {
            this.nf = NumberFormat.getNumberInstance(locale);
        } else if (this.type == 2) {
            this.nf = NumberFormat.getPercentInstance(locale);
        }
    }

    @Override
    public int getFormatType() {
        return 2;
    }

    @Override
    public String format(Object obj) {
        if (obj == null) {
            obj = FormatUtil.nullNumeric;
        }
        if (obj instanceof Number) {
            if (obj instanceof Double || obj instanceof Float || obj instanceof BigDecimal) {
                Float f;
                Double d;
                double value = ((Number)obj).doubleValue();
                if (obj instanceof Double ? (d = (Double)obj).isNaN() : obj instanceof Float && (f = (Float)obj).isNaN()) {
                    return FormatUtil.nullNumeric.toString();
                }
                if (value == 0.0) {
                    return this.nf.format(0L);
                }
                if (this.getInstanceType() == 2) {
                    return this.nf.format(value / 100.0);
                }
                return this.nf.format(value);
            }
            long value = ((Number)obj).longValue();
            if (value == 0L) {
                return this.nf.format(0L);
            }
            if (this.getInstanceType() == 2) {
                return this.nf.format((double)value / 100.0);
            }
            return this.nf.format(value);
        }
        return obj.toString();
    }

    public static LocaleNumericFormat getCurrencyInstance() {
        return new LocaleNumericFormat(0, NumberFormat.getCurrencyInstance());
    }

    public static LocaleNumericFormat getCurrencyInstance(Locale locale) {
        return new LocaleNumericFormat(0, NumberFormat.getCurrencyInstance(locale));
    }

    public static LocaleNumericFormat getNumberInstance() {
        return new LocaleNumericFormat(1, NumberFormat.getNumberInstance());
    }

    public static LocaleNumericFormat getNumberInstance(Locale locale) {
        return new LocaleNumericFormat(1, NumberFormat.getNumberInstance(locale));
    }

    public static LocaleNumericFormat getPercentInstance() {
        return new LocaleNumericFormat(2, NumberFormat.getPercentInstance());
    }

    public static LocaleNumericFormat getPercentInstance(Locale locale) {
        return new LocaleNumericFormat(2, NumberFormat.getPercentInstance(locale));
    }

    public NumberFormat getNumberFormat() {
        return this.nf;
    }

    public int getInstanceType() {
        return this.type;
    }

    public void setFormat(LocaleNumericFormat obj) {
        NumberFormat temp = obj.getNumberFormat();
        this.nf.setMaximumFractionDigits(temp.getMaximumFractionDigits());
        this.nf.setMaximumIntegerDigits(temp.getMaximumIntegerDigits());
        this.nf.setMinimumFractionDigits(temp.getMinimumFractionDigits());
        this.nf.setMinimumIntegerDigits(temp.getMinimumIntegerDigits());
        this.nf.setGroupingUsed(temp.isGroupingUsed());
        this.nf.setParseIntegerOnly(temp.isParseIntegerOnly());
    }

    @Override
    public String getTextFormat() {
        String sep = ":";
        String tmp = 2 + sep + this.getInstanceType() + sep;
        NumberFormat nf = this.getNumberFormat();
        tmp = tmp + nf.getMaximumFractionDigits() + sep;
        tmp = tmp + nf.getMaximumIntegerDigits() + sep;
        tmp = tmp + nf.getMinimumFractionDigits() + sep;
        tmp = tmp + nf.getMinimumIntegerDigits() + sep;
        tmp = tmp + (nf.isGroupingUsed() ? "T" : "F") + sep;
        tmp = tmp + (nf.isParseIntegerOnly() ? "T" : "F");
        return tmp;
    }

    public static LocaleNumericFormat createFormat(String text) throws Exception {
        LocaleNumericFormat result;
        StringTokenizer st = new StringTokenizer(text, ":");
        st.nextToken();
        int type = Integer.parseInt(st.nextToken());
        if (type == 0) {
            result = LocaleNumericFormat.getCurrencyInstance();
        } else if (type == 1) {
            result = LocaleNumericFormat.getNumberInstance();
        } else if (type == 2) {
            result = LocaleNumericFormat.getPercentInstance();
        } else {
            throw new Exception("Illegal LocaleNumericFormat: " + type);
        }
        NumberFormat nf = result.getNumberFormat();
        nf.setMaximumFractionDigits(Integer.parseInt(st.nextToken()));
        nf.setMaximumIntegerDigits(Integer.parseInt(st.nextToken()));
        nf.setMinimumFractionDigits(Integer.parseInt(st.nextToken()));
        nf.setMinimumIntegerDigits(Integer.parseInt(st.nextToken()));
        nf.setGroupingUsed(st.nextToken().equals("T"));
        nf.setParseIntegerOnly(st.nextToken().equals("T"));
        return result;
    }
}

