/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.util;

import quadbase.reportdesigner.util.IFormat;
import quadbase.reportdesigner.util.internal.FormatUtil;

public class LogicalFormat
implements IFormat {
    public static final int T_F = 0;
    public static final int TRUE_FALSE = 1;
    public static final int YES_NO = 2;
    public static final int Y_N = 3;
    public static final int ONE_ZERO = 4;
    int style;

    public LogicalFormat(int format) {
        this.setformat(format);
    }

    @Override
    public int getFormatType() {
        return 0;
    }

    @Override
    public String format(Object obj) {
        if (obj == null) {
            obj = FormatUtil.nullBoolean;
        }
        if (obj instanceof Boolean) {
            boolean value = (Boolean)obj;
            switch (this.style) {
                case 0: {
                    return value ? "T" : "F";
                }
                case 1: {
                    return value ? "True" : "False";
                }
                case 2: {
                    return value ? "Yes" : "No";
                }
                case 3: {
                    return value ? "Y" : "N";
                }
                case 4: {
                    return value ? "1" : "0";
                }
            }
            return obj.toString();
        }
        return obj.toString();
    }

    public int getformat() {
        return this.style;
    }

    public void setformat(int format) {
        if (format < 0) {
            format = 0;
        } else if (format > 4) {
            format = 4;
        }
        this.style = format;
    }

    @Override
    public String getTextFormat() {
        return "0:" + this.style + "";
    }

    public static LogicalFormat createFormat(String text) throws Exception {
        return new LogicalFormat(Integer.parseInt(text.substring(text.indexOf(58) + 1)));
    }
}

