/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.util;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import quadbase.common.util.internal.DataType;
import quadbase.reportdesigner.util.IRSMetaData;
import quadbase.reportdesigner.util.IResultSet;

public class QueryResultSet
implements IResultSet,
IRSMetaData {
    Statement stmt;
    ResultSet qrs;
    Object[] objectBuffer;
    ResultSetMetaData md;
    int nColumn;
    String[] columnName;
    String[] tableName;
    int[] columnType;
    int[] oracleLongRawColumns = null;
    int[] columnDisplaySize = null;
    boolean error;
    String errorMessage;

    public QueryResultSet(ResultSet rs) throws SQLException {
        this.initMetaData(rs, "");
    }

    public QueryResultSet(Statement stmt) throws SQLException {
        this.stmt = stmt;
        this.initMetaData(stmt.getResultSet(), "");
    }

    public QueryResultSet(Statement stmt, String productName) throws SQLException {
        this.stmt = stmt;
        this.initMetaData(stmt.getResultSet(), productName);
    }

    @Override
    public boolean next() throws SQLException {
        try {
            for (int i = 0; i < this.nColumn; ++i) {
                this.objectBuffer[i] = null;
            }
        }
        catch (Exception ex) {
            throw new SQLException(this.errorMessage);
        }
        boolean nt = false;
        try {
            nt = this.qrs.next();
        }
        catch (Exception ex) {
            nt = false;
        }
        return nt;
    }

    @Override
    public void close() throws SQLException {
        try {
            this.qrs.close();
            if (this.stmt != null) {
                this.stmt.close();
            }
        }
        catch (Exception ex) {
            if (ex instanceof SQLException) {
                throw (SQLException)ex;
            }
            throw new SQLException(this.errorMessage);
        }
    }

    @Override
    public Object getObject(int colNo) throws SQLException {
        try {
            this.initLongRawColumns();
            if (this.objectBuffer[colNo - 1] == null) {
                Object temp;
                this.objectBuffer[colNo - 1] = temp = DataType.getDefaultObject(this.qrs, colNo, this.columnType[colNo - 1]);
                return temp;
            }
            return this.objectBuffer[colNo - 1];
        }
        catch (Exception ex) {
            if (ex instanceof SQLException) {
                throw (SQLException)ex;
            }
            throw new SQLException(this.errorMessage);
        }
    }

    @Override
    public IRSMetaData getMetaData() throws SQLException {
        return this;
    }

    @Override
    public int getColumnCount() throws SQLException {
        if (this.error) {
            throw new SQLException(this.errorMessage);
        }
        return this.nColumn;
    }

    @Override
    public String getColumnName(int col) throws SQLException {
        if (this.error) {
            throw new SQLException(this.errorMessage);
        }
        return this.columnName[col - 1];
    }

    @Override
    public String getTableName(int col) throws SQLException {
        if (this.error) {
            throw new SQLException(this.errorMessage);
        }
        return this.tableName[col - 1];
    }

    @Override
    public int getColumnType(int col) throws SQLException {
        if (this.error) {
            throw new SQLException(this.errorMessage);
        }
        return this.columnType[col - 1];
    }

    public int getColumnDisplaySize(int col) throws SQLException {
        if (this.error) {
            throw new SQLException(this.errorMessage);
        }
        return this.columnDisplaySize[col - 1];
    }

    private void initMetaData(ResultSet rs, String productName) {
        this.qrs = rs;
        try {
            this.md = this.qrs.getMetaData();
            this.nColumn = this.md.getColumnCount();
            this.objectBuffer = new Object[this.nColumn];
            this.columnName = new String[this.nColumn];
            this.tableName = new String[this.nColumn];
            this.columnType = new int[this.nColumn];
            this.columnDisplaySize = new int[this.nColumn];
            boolean isHSQL = productName.toUpperCase().indexOf("HSQL") >= 0;
            int expCounter = 0;
            int sqlType = 0;
            for (int i = 1; i <= this.nColumn; ++i) {
                this.columnName[i - 1] = this.md.getColumnLabel(i);
                if (isHSQL && this.columnName[i - 1].equals("")) {
                    this.columnName[i - 1] = "Expression_" + expCounter;
                    ++expCounter;
                }
                this.tableName[i - 1] = "";
                try {
                    this.tableName[i - 1] = this.md.getTableName(i);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.columnType[i - 1] = sqlType = this.md.getColumnType(i);
                this.columnDisplaySize[i - 1] = this.md.getColumnDisplaySize(i);
                if (sqlType == 1111 && this.md.getColumnTypeName(i).equals("CLOB")) {
                    this.columnType[i - 1] = 2005;
                } else if (sqlType == 1111 && this.md.getColumnTypeName(i).equals("BLOB")) {
                    this.columnType[i - 1] = 2004;
                }
                if (productName.toLowerCase().startsWith("oracle") && sqlType == 91) {
                    this.columnType[i - 1] = 93;
                }
                if (!this.md.isSigned(i)) {
                    this.columnType[i - 1] = DataType.convertUnsigned(sqlType);
                }
                this.checkLongRaw(productName);
            }
        }
        catch (Exception ex) {
            this.error = true;
            this.errorMessage = ex.toString();
        }
    }

    private void checkLongRaw(String productName) {
        if (productName == null) {
            return;
        }
        if (!(productName = productName.trim().toLowerCase()).startsWith("oracle")) {
            return;
        }
        int countLongRaw = 0;
        for (int element : this.columnType) {
            if (element != -4) continue;
            ++countLongRaw;
        }
        if (countLongRaw == 0) {
            return;
        }
        this.oracleLongRawColumns = new int[countLongRaw];
        int j = 0;
        for (int i = 0; i < this.columnType.length; ++i) {
            if (this.columnType[i] != -4) continue;
            this.oracleLongRawColumns[j] = i;
            ++j;
        }
    }

    private void initLongRawColumns() throws SQLException {
        if (this.oracleLongRawColumns == null) {
            return;
        }
        for (int oracleLongRawColumn : this.oracleLongRawColumns) {
            int index = oracleLongRawColumn;
            if (this.objectBuffer[index] != null) continue;
            this.objectBuffer[index] = DataType.getDefaultObject(this.qrs, index + 1, this.columnType[index]);
        }
    }
}

