/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.util;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.common.util.ReplaceColumnInfo;
import quadbase.reportdesigner.util.ReplaceColumnInfoList;

public class ReadReplaceColumnInfo {
    static final int ELEMENT_TYPE = 1;
    static final int ATTR_TYPE = 2;
    static final int TEXT_TYPE = 3;
    static final int CDATA_TYPE = 4;
    static final int ENTITYREF_TYPE = 5;
    static final int ENTITY_TYPE = 6;
    static final int PROCINSTR_TYPE = 7;
    static final int COMMENT_TYPE = 8;
    static final int DOCUMENT_TYPE = 9;
    static final int DOCTYPE_TYPE = 10;
    static final int DOCFRAG_TYPE = 11;
    static final int NOTATION_TYPE = 12;
    Document document;
    String fileUri = null;

    public ReadReplaceColumnInfo(String uri) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.document = builder.parse(uri);
        this.fileUri = uri;
    }

    public ReplaceColumnInfoList createReplaceColumnInfoList() throws Exception {
        return this.createReplaceColumnInfoList(this.document);
    }

    private ReplaceColumnInfoList createReplaceColumnInfoList(Node domNode) throws Exception {
        NodeList nodeList = domNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            short type = node.getNodeType();
            if (type == 1 && node.getNodeName().equalsIgnoreCase("ReplaceColumnInfoList")) {
                return this.parseReplaceColumnInfoList(node);
            }
            ReplaceColumnInfoList list = this.createReplaceColumnInfoList(node);
            if (list == null) continue;
            return list;
        }
        return null;
    }

    private ReplaceColumnInfoList parseReplaceColumnInfoList(Node domNode) throws Exception {
        NodeList nodeList = domNode.getChildNodes();
        ReplaceColumnInfoList infoList = new ReplaceColumnInfoList();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            ReplaceColumnInfo pInfo;
            Node node = nodeList.item(i);
            short type = node.getNodeType();
            if (type != 1 || !node.getNodeName().equalsIgnoreCase("ReplaceColumnInfo") || (pInfo = this.parseReplaceColumnInfo(node)) == null) continue;
            infoList.add(pInfo);
        }
        infoList.setDocumentURI(this.fileUri);
        return infoList;
    }

    private ReplaceColumnInfo parseReplaceColumnInfo(Node domNode) throws Exception {
        ReplaceColumnInfo paramInfo = new ReplaceColumnInfo();
        NodeList nodeList = domNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            short type = node.getNodeType();
            if (type != 1) continue;
            if (node.getNodeName().equalsIgnoreCase("Driver")) {
                paramInfo.setDriver(this.getData(node));
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("URL")) {
                paramInfo.setDBUrl(this.getData(node));
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("TableName")) {
                paramInfo.setTableName(this.getData(node));
                continue;
            }
            if (!node.getNodeName().equalsIgnoreCase("Pair")) continue;
            String[] pair = this.getPair(node);
            paramInfo.addColumn(pair[0], pair[1]);
        }
        return paramInfo;
    }

    private String[] getPair(Node domNode) throws Exception {
        String[] pair = new String[2];
        NodeList nodeList = domNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            short type = node.getNodeType();
            if (type != 1) continue;
            if (node.getNodeName().equalsIgnoreCase("ColumnName")) {
                pair[0] = this.getData(node);
                continue;
            }
            if (!node.getNodeName().equalsIgnoreCase("ReplaceValue")) continue;
            pair[1] = this.getData(node);
        }
        return pair;
    }

    private String getData(Node domNode) {
        if (domNode == null) {
            return "";
        }
        NodeList nodeList = domNode.getChildNodes();
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            short type = node.getNodeType();
            if (type == 1) {
                sbuf.append(this.getData(node));
                continue;
            }
            if (type == 3) {
                sbuf.append(node.getNodeValue());
                continue;
            }
            if (type == 5) {
                sbuf.append(this.getData(node));
                continue;
            }
            if (type != 4) continue;
            sbuf.append(node.getNodeValue());
        }
        return sbuf.toString();
    }
}

