/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.util;

import java.io.Serializable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.util.ReplaceColumnInfo;
import quadbase.common.util.internal.QbDebug;

public class ReplaceColumnInfoList
implements Serializable {
    Vector<ReplaceColumnInfo> infoList = new Vector();
    String docURI = null;

    void setDocumentURI(String uri) {
        this.docURI = uri;
    }

    public String getDocumentURL() {
        return this.docURI;
    }

    public Vector<ReplaceColumnInfo> getReplaceColumnInfo(String driver, String dbURL) {
        Vector<ReplaceColumnInfo> vecList = new Vector<ReplaceColumnInfo>();
        QbDebug.println(5, "REPORT DRIVER = " + driver);
        QbDebug.println(5, "REPORT DB URL = " + dbURL);
        for (int i = 0; i < this.infoList.size(); ++i) {
            ReplaceColumnInfo tmp = this.infoList.elementAt(i);
            if (!tmp.match(driver, dbURL)) continue;
            vecList.add(tmp);
        }
        return vecList;
    }

    public void add(ReplaceColumnInfo info) {
        this.infoList.add(info);
    }

    public String replaceColumnInfoForWhereClause(String query, String driver, String url) {
        Vector<ReplaceColumnInfo> colInfoList = this.getReplaceColumnInfo(driver, url);
        if (colInfoList.size() == 0) {
            return query;
        }
        Pattern patternStart = Pattern.compile("\\sWHERE\\s");
        Matcher mStart = patternStart.matcher(query.toUpperCase());
        String newQuery = query;
        int start = 0;
        while (start < query.length() && mStart.find(start)) {
            int whereInd = mStart.start();
            Pattern patternEnd = Pattern.compile("\\sGROUP BY\\s");
            Matcher mEnd = patternEnd.matcher(query.toUpperCase());
            int whereEnd = -1;
            while (mEnd.find()) {
                if (mEnd.start() <= whereInd) continue;
                whereEnd = mEnd.start();
                break;
            }
            patternEnd = Pattern.compile("\\sORDER BY\\s");
            mEnd = patternEnd.matcher(query.toUpperCase());
            while (mEnd.find() && (whereEnd == -1 || mEnd.start() < whereEnd)) {
                if (mEnd.start() <= whereInd) continue;
                whereEnd = mEnd.start();
                break;
            }
            patternEnd = Pattern.compile("\\sUNION\\s");
            mEnd = patternEnd.matcher(query.toUpperCase());
            while (mEnd.find() && (whereEnd == -1 || mEnd.start() < whereEnd)) {
                if (mEnd.start() <= whereInd) continue;
                whereEnd = mEnd.start();
                break;
            }
            if (whereEnd == -1) {
                whereEnd = query.length();
            }
            String whereClause = query.substring(whereInd, whereEnd);
            for (int i = 0; i < colInfoList.size(); ++i) {
                ReplaceColumnInfo colInfo = colInfoList.elementAt(i);
                Vector<String[]> vec = colInfo.getColumnPair();
                if (vec.size() == 0) continue;
                newQuery = query.substring(0, whereInd) + QueryParser.replaceColumns(whereClause, colInfo.getTableName(), vec);
                if (whereEnd >= query.length()) continue;
                newQuery = newQuery + query.substring(whereEnd);
            }
            query = newQuery;
            start = whereEnd;
            patternStart = Pattern.compile("\\sWHERE\\s");
            mStart = patternStart.matcher(query.toUpperCase());
        }
        return newQuery;
    }
}

