/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.util;

import com.sforce.soap.partner.QueryResult;
import com.sforce.soap.partner.sobject.SObject;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axis.message.MessageElement;
import quadbase.common.paramquery.SalesForceQueryFileInfo;
import quadbase.common.paramquery.SalesForceQueryParser;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.SalesForceConnection;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.util.IRSMetaData;
import quadbase.reportdesigner.util.IResultSet;

public class SalesForceResultSet
implements IResultSet,
IRSMetaData {
    private SalesForceConnection connection;
    QueryResult queryResult;
    int cursor;
    private boolean isClosed = false;
    private boolean isCountQuery = false;
    private boolean isCountQueryDone = false;
    private HashMap indexMap;
    private String[] columnNames;
    private String[] columnAliases;
    private String[] tableNames;
    private int[] columnTypes;
    private Object[] currentRow;

    public SalesForceResultSet(SalesForceConnection connection, String query) throws Exception {
        if (SalesForceQueryParser.isCountQuery(query)) {
            this.queryResult = connection.getBinding().query(query);
            this.columnNames = new String[]{"qbCount"};
            this.columnAliases = new String[]{"qbCount"};
            this.tableNames = new String[]{SalesForceQueryParser.getDefaultTableName(query)};
            this.columnTypes = new int[]{4};
            this.currentRow = new Object[1];
            this.isCountQuery = true;
        } else {
            SalesForceQueryParser.checkForNestedSelects(query);
            query = SalesForceQueryParser.addAggregationAliases(query);
            this.connection = connection;
            String defaultTableName = SalesForceQueryParser.getDefaultTableName(query);
            this.queryResult = connection.getBinding().query(query);
            String[][] nameAndAliases = SalesForceQueryParser.getColumnNamesAndAliases(query);
            this.columnNames = nameAndAliases[0];
            this.columnAliases = nameAndAliases[1];
            this.indexMap = new HashMap(this.columnNames.length);
            this.tableNames = new String[this.columnNames.length];
            this.columnTypes = new int[this.columnNames.length];
            for (int i = 0; i < this.columnNames.length; ++i) {
                this.tableNames[i] = connection.getRealTableName(defaultTableName, this.columnNames[i]);
                this.columnTypes[i] = connection.getColumnDataType(this.tableNames[i], this.columnNames[i]);
                this.indexMap.put(this.columnAliases[i], i);
            }
            this.cursor = -1;
            this.currentRow = new Object[this.columnNames.length];
            this.getDataTypesForAggregatedColumns();
        }
    }

    public SalesForceResultSet(SalesForceQueryFileInfo sfQueryInfo) throws Exception {
        this(sfQueryInfo.getSalesForceConnection(), sfQueryInfo.getQueryWithParameters());
    }

    public ColData[] getColData() throws Exception {
        return ColData.getColData(this);
    }

    public ColData[] getColData(int startIndex, int displayRow) throws Exception {
        return ColData.getColData(this, startIndex, displayRow);
    }

    @Override
    public void close() throws Exception {
        this.isClosed = true;
        this.queryResult = null;
    }

    @Override
    public IRSMetaData getMetaData() throws Exception {
        return this;
    }

    @Override
    public boolean next() throws Exception {
        if (this.isClosed) {
            return false;
        }
        if (this.isCountQuery) {
            if (this.isCountQueryDone) {
                return false;
            }
            this.currentRow[0] = this.queryResult.getSize();
            this.isCountQueryDone = true;
            return true;
        }
        ++this.cursor;
        if (this.cursor >= this.queryResult.getSize()) {
            if (this.queryResult.isDone()) {
                return false;
            }
            this.queryResult = this.connection.getBinding().queryMore(this.queryResult.getQueryLocator());
            this.cursor = 0;
        }
        SObject so = this.queryResult.getRecords(this.cursor);
        MessageElement[] elements = so.get_any();
        this.readCurrentRow(elements);
        return true;
    }

    @Override
    public Object getObject(int colNo) throws Exception {
        if (this.isClosed) {
            throw new Exception("The result set is already closed");
        }
        if (colNo <= 0 || colNo > this.getColumnCount()) {
            throw new IllegalArgumentException("Invalid column index: " + colNo);
        }
        return this.currentRow[colNo - 1];
    }

    @Override
    public int getColumnCount() throws Exception {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int col) throws Exception {
        if (col <= 0 || col > this.getColumnCount()) {
            throw new IllegalArgumentException("Invalid column index: " + col);
        }
        int lastDot = this.columnAliases[col - 1].lastIndexOf(46);
        if (lastDot > -1) {
            return this.columnAliases[col - 1].substring(lastDot + 1);
        }
        return this.columnAliases[col - 1];
    }

    @Override
    public int getColumnType(int col) throws Exception {
        if (col <= 0 || col > this.getColumnCount()) {
            throw new IllegalArgumentException("Invalid column index: " + col);
        }
        return this.columnTypes[col - 1];
    }

    @Override
    public String getTableName(int col) throws Exception {
        if (col <= 0 || col > this.getColumnCount()) {
            throw new IllegalArgumentException("Invalid column index: " + col);
        }
        return this.tableNames[col - 1];
    }

    private void readCurrentRow(MessageElement[] elements) throws Exception {
        for (MessageElement element : elements) {
            QName type = element.getType();
            if (type != null && type.getLocalPart().equalsIgnoreCase("sObject")) {
                this.processNestedObject(element.getLocalName(), element);
                continue;
            }
            if (type != null && type.getLocalPart().equalsIgnoreCase("QueryResult")) {
                throw new UnsupportedOperationException("Parent-to-child relationship queries (nested SELECTs) are not supported");
            }
            this.insertToCurrentRow(element.getLocalName(), element.getValue());
        }
    }

    private void processNestedObject(String parentName, MessageElement parent) throws Exception {
        Iterator iterator = parent.getChildElements();
        while (iterator.hasNext()) {
            MessageElement child = (MessageElement)iterator.next();
            QName type = child.getType();
            if (type != null) {
                if (type.getLocalPart().equalsIgnoreCase("sObject")) {
                    this.processNestedObject(parentName + "." + child.getLocalName(), child);
                    continue;
                }
                if (type.getLocalPart().equalsIgnoreCase("QueryResult")) {
                    throw new UnsupportedOperationException("Parent-to-child relationship queries (nested SELECTs) are not supported");
                }
                throw new Exception("Unexpected type: " + type.getLocalPart());
            }
            this.insertToCurrentRow(parentName + "." + child.getLocalName(), child.getValue());
        }
    }

    private void insertToCurrentRow(String columnName, Object value) {
        Integer index = (Integer)this.indexMap.get(columnName);
        if (index != null) {
            this.currentRow[index.intValue()] = this.castObject((String)value, this.columnTypes[index]);
        }
    }

    private Object castObject(String object, int sqlType) {
        try {
            switch (sqlType) {
                case 93: {
                    return DataType.createObject(object, DataType.mapType(sqlType), "yyyy-MM-dd'T'HH:mm:ss.S'Z'");
                }
                case 91: {
                    return DataType.createObject(object, DataType.mapType(sqlType), "yyyy-MM-dd");
                }
            }
            return DataType.createObject(object, DataType.mapType(sqlType));
        }
        catch (Exception e) {
            return null;
        }
    }

    private void getDataTypesForAggregatedColumns() {
        boolean hasColumnWithoutDataType = true;
        for (int i = 0; i < this.queryResult.getSize() && hasColumnWithoutDataType; ++i) {
            SObject so = this.queryResult.getRecords(i);
            MessageElement[] elements = so.get_any();
            hasColumnWithoutDataType = false;
            for (int j = 0; j < elements.length; ++j) {
                if (this.columnTypes[j] != -1) continue;
                QName type = elements[j].getType();
                if (type != null) {
                    this.columnTypes[j] = SalesForceQueryParser.mapDataType(type.getLocalPart());
                    continue;
                }
                hasColumnWithoutDataType = true;
            }
        }
    }
}

