/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.util;

import java.util.Vector;
import quadbase.common.util.internal.DataType;
import quadbase.reportdesigner.util.ISpreadSheetModel;
import quadbase.reportdesigner.util.ISpreadSheetModelListener;
import quadbase.reportdesigner.util.SpreadSheetModelEvent;

public class SimpleSpreadSheet
implements ISpreadSheetModel {
    Object[] g1;
    Object[] g2;
    Object[][] values;
    int type1;
    int type2;
    int typeVal;
    int length1;
    int length2;
    Vector pushListeners = new Vector();

    public SimpleSpreadSheet() {
        this.type2 = 12;
        this.type1 = 12;
        this.typeVal = 8;
        this.length2 = 0;
        this.length1 = 0;
    }

    public SimpleSpreadSheet(String[] rowVals, String[] columnVals, Double[][] vals) {
        this.g1 = rowVals;
        this.g2 = columnVals;
        this.length1 = this.g1.length;
        this.length2 = this.g2.length;
        this.setValues(vals);
        this.type2 = 12;
        this.type1 = 12;
        this.typeVal = 8;
    }

    public SimpleSpreadSheet(String[] rowVals, String[] columnVals, Integer[][] vals) {
        this.g1 = rowVals;
        this.g2 = columnVals;
        this.length1 = this.g1.length;
        this.length2 = this.g2.length;
        this.setValues(vals);
        this.type2 = 12;
        this.type1 = 12;
        this.typeVal = 4;
    }

    public SimpleSpreadSheet(Object[] rowVals, Object[] columnVals, Object[][] vals) throws IllegalArgumentException {
        this.resetAllValues(rowVals, columnVals, vals);
    }

    private void resetAllValues(Object[] rowVals, Object[] columnVals, Object[][] vals) throws IllegalArgumentException {
        if (rowVals != null) {
            this.g1 = rowVals;
            this.length1 = this.g1.length;
            this.type1 = DataType.findType(rowVals[0]);
        }
        if (columnVals != null) {
            this.g2 = columnVals;
            this.length2 = this.g2.length;
            this.type2 = DataType.findType(columnVals[0]);
        }
        this.setValues(vals);
        this.typeVal = DataType.findType(vals[0][0]);
    }

    public void setRowInfo(int sqlType, Object[] rowVals) {
        this.type1 = sqlType;
        this.g1 = rowVals;
        this.length1 = this.g1.length;
        this.fireSpreadSheetChanged(new SpreadSheetModelEvent(this, 0, -1));
    }

    public void setRowInfo(Object[] rowVals, Object[][] vals) throws IllegalArgumentException {
        this.resetAllValues(rowVals, null, vals);
        this.fireSpreadSheetChanged(new SpreadSheetModelEvent(this));
    }

    public void setColumnInfo(int sqlType, Object[] columnVals) {
        this.type2 = sqlType;
        this.g2 = columnVals;
        this.length2 = this.g2.length;
        this.fireSpreadSheetChanged(new SpreadSheetModelEvent(this, -1, 0));
    }

    public void setColumnInfo(Object[] columnVals, Object[][] vals) throws IllegalArgumentException {
        this.resetAllValues(null, columnVals, vals);
        this.fireSpreadSheetChanged(new SpreadSheetModelEvent(this));
    }

    public void setValueInfo(int sqlType, Object[][] vals) {
        this.typeVal = sqlType;
        this.setValues(vals);
        this.fireSpreadSheetChanged(new SpreadSheetModelEvent(this));
    }

    public void setValueInfo(Object[] rowVals, Object[] columnVals, Object[][] vals) throws IllegalArgumentException {
        this.resetAllValues(rowVals, columnVals, vals);
        this.fireSpreadSheetChanged(new SpreadSheetModelEvent(this));
    }

    private void setValues(Object[][] vals) {
        this.values = new Object[this.length1][this.length2];
        for (int i = 0; i < vals.length; ++i) {
            for (int j = 0; j < vals[0].length; ++j) {
                this.values[i][j] = vals[i][j];
            }
        }
    }

    public void setCellValue(int i, int j, Object x) {
        if (i <= 0 || i > this.length1) {
            throw new IllegalArgumentException("Invalid row index :" + i);
        }
        if (j <= 0 || j > this.length2) {
            throw new IllegalArgumentException("Invalid column index :" + j);
        }
        this.values[i - 1][j - 1] = x;
        this.fireSpreadSheetChanged(new SpreadSheetModelEvent(this, i, j));
    }

    @Override
    public int getColumnCount() {
        return this.length2;
    }

    @Override
    public int getRowCount() {
        return this.length1;
    }

    @Override
    public int getColumnLabelType() {
        return this.type2;
    }

    @Override
    public int getRowLabelType() {
        return this.type1;
    }

    @Override
    public int getValueType() {
        return this.typeVal;
    }

    @Override
    public Object getRowLabel(int i) {
        if (i <= 0 || i > this.length1) {
            throw new IllegalArgumentException("Invalid row index :" + i);
        }
        return this.g1[i - 1];
    }

    @Override
    public Object getColumnLabel(int i) {
        if (i <= 0 || i > this.length2) {
            throw new IllegalArgumentException("Invalid column index :" + i);
        }
        return this.g2[i - 1];
    }

    @Override
    public Object getValueAt(int i, int j) {
        if (i <= 0 || i > this.length1) {
            throw new IllegalArgumentException("Invalid spreadsheet row index :" + i);
        }
        if (j <= 0 || j > this.length2) {
            throw new IllegalArgumentException("Invalid spreadsheet column index :" + j);
        }
        return this.values[i - 1][j - 1];
    }

    @Override
    public synchronized void addSpreadSheetModelListener(ISpreadSheetModelListener l) {
        this.pushListeners.addElement(l);
    }

    @Override
    public synchronized void removeSpreadSheetModelListener(ISpreadSheetModelListener l) {
        this.pushListeners.removeElement(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireSpreadSheetChanged(SpreadSheetModelEvent e) {
        Vector targets;
        SimpleSpreadSheet simpleSpreadSheet = this;
        synchronized (simpleSpreadSheet) {
            targets = (Vector)this.pushListeners.clone();
        }
        for (int i = 0; i < targets.size(); ++i) {
            ISpreadSheetModelListener target = (ISpreadSheetModelListener)targets.elementAt(i);
            target.spreadSheetChanged(e);
        }
    }
}

