/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Vector;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.IOUtil2;
import quadbase.reportdesigner.util.IRSMetaData;
import quadbase.reportdesigner.util.IResultSet;

public class StreamResultSet
implements IResultSet,
IRSMetaData {
    protected static final int US = 0;
    protected static final int FRANCE = 1;
    protected static final int REGION = 0;
    protected InputStream inStream;
    protected IResultSet rs;

    public StreamResultSet() {
    }

    public StreamResultSet(InputStream in) throws IOException {
        this(in, null);
    }

    public StreamResultSet(InputStream in, String encoding) throws IOException {
        this.inStream = in;
        StreamTokenizer st = encoding == null ? new StreamTokenizer(new BufferedReader(new InputStreamReader(in))) : new StreamTokenizer(new BufferedReader(new InputStreamReader(in, encoding)));
        try {
            this.rs = ColData.getResultSet(IOUtil2.readRecord(st));
        }
        catch (Exception ex) {
            throw new IOException(ex.toString());
        }
    }

    @Override
    public boolean next() throws IOException {
        try {
            return this.rs.next();
        }
        catch (Exception ex) {
            throw new IOException(ex.toString());
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.rs.close();
            this.inStream.close();
        }
        catch (Exception ex) {
            throw new IOException(ex.toString());
        }
    }

    @Override
    public Object getObject(int colNo) {
        try {
            return this.rs.getObject(colNo);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.toString());
        }
    }

    @Override
    public IRSMetaData getMetaData() {
        try {
            return this.rs.getMetaData();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.toString());
        }
    }

    @Override
    public int getColumnCount() {
        try {
            return this.rs.getMetaData().getColumnCount();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.toString());
        }
    }

    @Override
    public String getColumnName(int col) {
        try {
            return this.rs.getMetaData().getColumnName(col);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.toString());
        }
    }

    @Override
    public String getTableName(int col) {
        try {
            return this.rs.getMetaData().getTableName(col);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.toString());
        }
    }

    @Override
    public int getColumnType(int col) {
        try {
            return this.rs.getMetaData().getColumnType(col);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.toString());
        }
    }

    public static int readLine(StreamTokenizer st, Vector vec, boolean acceptNo) throws IOException {
        int ttype;
        vec.removeAllElements();
        while ((ttype = st.nextToken()) != 10) {
            if (ttype == -1) {
                if (vec.size() > 0) {
                    return 1;
                }
                return 0;
            }
            if (ttype == -2) {
                if (!acceptNo) {
                    throw new IOException("Data Type Format error !");
                }
                if ((double)((int)st.nval) == st.nval) {
                    vec.addElement((int)st.nval);
                    continue;
                }
                vec.addElement(st.nval);
                continue;
            }
            if (st.sval == null) continue;
            vec.addElement(st.sval);
        }
        return 1;
    }

    private static String removeComma(String s) {
        if (s == null) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if ((c < '0' || c > '9') && c != '.' && c != 'e' && c != 'E' && c != '+' && c != '-') continue;
            sb.append(s.charAt(i));
        }
        return sb.toString();
    }

    public static Object createObject(int dtype, Object elem, StreamTokenizer st) throws IOException {
        if (elem == null || elem instanceof String && ((String)elem).equals("")) {
            return null;
        }
        switch (dtype) {
            case 11: {
                if (elem instanceof Number) {
                    return ((Number)elem).byteValue();
                }
                return Byte.valueOf((String)elem);
            }
            case 12: {
                if (elem instanceof Number) {
                    return ((Number)elem).shortValue();
                }
                return Short.valueOf((String)elem);
            }
            case 1: {
                if (elem instanceof Number) {
                    return ((Number)elem).longValue();
                }
                return Long.valueOf(StreamResultSet.removeComma((String)elem));
            }
            case 2: {
                if (elem instanceof Number) {
                    return ((Number)elem).intValue();
                }
                return Integer.valueOf(StreamResultSet.removeComma((String)elem));
            }
            case 3: {
                if (elem instanceof Number) {
                    return Float.valueOf(((Number)elem).floatValue());
                }
                return Float.valueOf(StreamResultSet.removeComma((String)elem));
            }
            case 4: {
                if (elem instanceof Number) {
                    return ((Number)elem).doubleValue();
                }
                return Double.valueOf(StreamResultSet.removeComma((String)elem));
            }
            case 5: 
            case 13: {
                if (elem instanceof BigDecimal) {
                    return elem;
                }
                if (elem instanceof Number) {
                    return new BigDecimal(((Number)elem).doubleValue());
                }
                return new BigDecimal((String)elem);
            }
            case 6: 
            case 7: {
                if (elem instanceof String) {
                    return elem;
                }
                try {
                    return elem.toString();
                }
                catch (Exception ex) {
                    throw new IOException("Invalid type integer, line " + st.lineno() + " expecting char.");
                }
            }
            case 9: {
                if (elem instanceof String) {
                    long l = Time.valueOf((String)elem).getTime();
                    return new Time(l);
                }
                throw new IOException("Invalid type integer, line " + st.lineno() + " expecting time.");
            }
            case 8: {
                if (elem instanceof String) {
                    long l = Date.valueOf(StreamResultSet.convertDate((String)elem)).getTime();
                    return new Date(l);
                }
                throw new IOException("Invalid type integer, line " + st.lineno() + " expecting date.");
            }
            case 10: {
                if (elem instanceof String) {
                    return Timestamp.valueOf((String)elem);
                }
                throw new IOException("Invalid type integer, line " + st.lineno() + " expecting timestamp.");
            }
            case 0: {
                if (elem instanceof Double) {
                    double val = (Double)elem;
                    if (val == 0.0) {
                        return Boolean.FALSE;
                    }
                    if (val == 1.0) {
                        return Boolean.TRUE;
                    }
                    throw new IOException("Invalid boolean value " + val + ", line " + st.lineno());
                }
                if (elem instanceof Integer) {
                    int val = (Integer)elem;
                    if (val == 0) {
                        return Boolean.FALSE;
                    }
                    if (val == 1) {
                        return Boolean.TRUE;
                    }
                    throw new IOException("Invalid boolean value " + val + ", line " + st.lineno());
                }
                String s = (String)elem;
                if (s.equalsIgnoreCase("true") || s.equalsIgnoreCase("t") || s.equalsIgnoreCase("on") || s.equalsIgnoreCase("1")) {
                    return Boolean.TRUE;
                }
                if (s.equalsIgnoreCase("false") || s.equalsIgnoreCase("f") || s.equalsIgnoreCase("off") || s.equalsIgnoreCase("0")) {
                    return Boolean.FALSE;
                }
                throw new IOException("Invalid boolean value " + s + ", line " + st.lineno());
            }
        }
        throw new IOException("Invalid data type " + dtype + ", line " + st.lineno());
    }

    private static String convertDate(String s) {
        int secondDash;
        int firstDash;
        int idx = s.indexOf(45);
        if (idx > 0 && (idx = s.indexOf(45, idx + 1)) < 0) {
            s = s + "-01";
        }
        if ((firstDash = s.indexOf(45)) > 0 & (secondDash = s.indexOf(45, firstDash + 1)) > 0 & secondDash < s.length() - 1) {
            String day;
            String year = s.substring(0, firstDash);
            String month = s.substring(firstDash + 1, secondDash);
            if (month.length() == 1) {
                month = "0" + month;
            }
            if ((day = s.substring(secondDash + 1)).length() == 1) {
                day = "0" + day;
            }
            return year + "-" + month + "-" + day;
        }
        return s;
    }
}

