/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.util;

import quadbase.reportdesigner.util.IFormat;
import quadbase.reportdesigner.util.internal.FormatUtil;

public class StringFormat
implements IFormat {
    int maxChar = -1;

    public StringFormat(int maxChar) {
        this.setMaxCharacter(maxChar);
    }

    public StringFormat() {
    }

    @Override
    public int getFormatType() {
        return 5;
    }

    @Override
    public String format(Object obj) {
        if (obj == null) {
            obj = FormatUtil.nullString;
        }
        String str = obj.toString();
        if (this.maxChar < 0 || str.length() <= this.maxChar) {
            return str;
        }
        return str.substring(0, this.maxChar);
    }

    public void setMaxCharacter(int i) {
        this.maxChar = i;
    }

    public int getMaxCharacter() {
        return this.maxChar;
    }

    @Override
    public String getTextFormat() {
        return "5:" + this.maxChar + "";
    }

    public static StringFormat createFormat(String text) throws Exception {
        return new StringFormat(Integer.parseInt(text.substring(text.indexOf(58) + 1)));
    }
}

