/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import quadbase.common.client.ServerMessage;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.ReadDataFile;
import quadbase.common.util.internal.XMLConditionNode;
import quadbase.common.util.internal.XMLDataTypeUtil;
import quadbase.common.util.internal.XMLDefaultTreeNode;
import quadbase.common.util.internal.XMLFieldInfo;
import quadbase.common.util.internal.XMLFileQueryInfo;
import quadbase.common.util.internal.XMLOperatorNode;
import quadbase.common.util.xmlcondition.ConditionParser;
import quadbase.reportdesigner.util.IRSMetaData;
import quadbase.reportdesigner.util.IResultSet;

public class XMLQueryResultSet
implements IResultSet {
    final int ELEMENT_TYPE = 1;
    final int ATTR_TYPE = 2;
    final int TEXT_TYPE = 3;
    final int CDATA_TYPE = 4;
    final int ENTITYREF_TYPE = 5;
    final int ENTITY_TYPE = 6;
    final int PROCINSTR_TYPE = 7;
    final int COMMENT_TYPE = 8;
    final int DOCUMENT_TYPE = 9;
    final int DOCTYPE_TYPE = 10;
    final int DOCFRAG_TYPE = 11;
    final int NOTATION_TYPE = 12;
    private String[] fieldName;
    private int[] dataTypes;
    private XMLFieldInfo[] leafNodes;
    private XMLDefaultTreeNode conditionRoot;
    private Vector<DataRow> dataRows = new Vector();
    private int currentRow = -1;

    public XMLQueryResultSet(XMLFileQueryInfo info) throws Exception {
        this(info.getFileName(), info.getFieldInfo(), info.getCondition(), info.getConditionInfo(), info.getDTDName(), info.isVerify(), info.getInSet());
    }

    public XMLQueryResultSet(String uri, XMLFieldInfo[] leafNode, String conditionSQL, XMLFieldInfo[] conditionNode, String externalFile, boolean verify, QueryInParamSet paramSet) throws Exception {
        this(new ReadDataFile().getInputStream(uri, false, true), leafNode, conditionSQL, conditionNode, externalFile, verify, paramSet);
    }

    public XMLQueryResultSet(File file, XMLFieldInfo[] leafNode, String conditionSQL, XMLFieldInfo[] conditionNode, String externalFile, boolean verify, QueryInParamSet paramSet) throws Exception {
        this(new FileInputStream(file), leafNode, conditionSQL, conditionNode, externalFile, verify, paramSet);
    }

    public XMLQueryResultSet(InputStream xmlStream, XMLFieldInfo[] leafNode, String conditionSQL, XMLFieldInfo[] conditionNode, String externalFile, boolean verify, QueryInParamSet paramSet) throws Exception {
        this.leafNodes = leafNode;
        if (conditionSQL != null && !conditionSQL.trim().equals("")) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(conditionSQL.getBytes("UTF-8"));
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
            ConditionParser parser = new ConditionParser(inputStreamReader);
            Vector<QueryInParam> paramVec = new Vector<QueryInParam>();
            for (int i = 0; paramSet != null && paramSet.getParameter() != null && i < paramSet.getParameter().length; ++i) {
                paramVec.addElement(paramSet.getParameter()[i]);
            }
            this.conditionRoot = parser.parse(conditionNode, paramVec);
        }
        this.leafNodes = this.organizeXMLFieldInfo(this.leafNodes);
        this.setDataType();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(verify);
        SAXParser parser = factory.newSAXParser();
        XMLReader reader = parser.getXMLReader();
        SAXContentHandler handler = new SAXContentHandler();
        reader.setContentHandler(handler);
        reader.setErrorHandler(handler);
        InputSource is = new InputSource(xmlStream);
        if (externalFile != null) {
            is.setSystemId(ServerMessage.getPath(externalFile));
        }
        reader.parse(is);
    }

    public XMLQueryResultSet(InputStream xmlStream, XMLFieldInfo[] leafNode, String conditionSQL, XMLFieldInfo[] conditionNode, QueryInParamSet paramSet) throws Exception {
        this(xmlStream, leafNode, conditionSQL, conditionNode, null, false, paramSet);
    }

    private void setDataType() {
        this.dataTypes = new int[this.leafNodes.length];
        this.fieldName = new String[this.leafNodes.length];
        for (int i = 0; i < this.leafNodes.length; ++i) {
            this.dataTypes[i] = this.getDataType(this.leafNodes[i]);
            this.fieldName[i] = this.leafNodes[i].getAlias();
        }
    }

    private int getDataType(XMLFieldInfo leafNode) {
        if (leafNode.getXMLType() == 1) {
            return DataType.findType(leafNode.getElementDataType());
        }
        if (leafNode.getXMLType() == 2) {
            return DataType.findType(leafNode.getAttributeDataType());
        }
        return -1;
    }

    private XMLFieldInfo[] organizeXMLFieldInfo(XMLFieldInfo[] base) {
        Vector condNodes = this.getConditionNodes();
        return this.mergeXMLFieldInfo(base, condNodes);
    }

    private Vector getConditionNodes() {
        Vector res = new Vector();
        if (this.conditionRoot == null) {
            return res;
        }
        return this.getConditionNodes(this.conditionRoot, res);
    }

    private Vector getConditionNodes(XMLDefaultTreeNode tNode, Vector res) {
        int ct = tNode.getChildCount();
        if (ct == 0) {
            XMLConditionNode condNode = (XMLConditionNode)tNode;
            res.addElement(condNode.getXMLFieldInfo());
            return res;
        }
        for (int i = 0; i < ct; ++i) {
            this.getConditionNodes(tNode.getChildAt(i), res);
        }
        return res;
    }

    private XMLFieldInfo[] mergeXMLFieldInfo(XMLFieldInfo[] base, Vector cond) {
        int ct = cond.size();
        for (int i = 0; i < ct; ++i) {
            XMLFieldInfo newInfo = (XMLFieldInfo)cond.elementAt(i);
            base = this.addXMLFieldInfo(base, newInfo);
        }
        return base;
    }

    private XMLFieldInfo[] addXMLFieldInfo(XMLFieldInfo[] base, XMLFieldInfo newInfo) {
        for (XMLFieldInfo element : base) {
            if (!element.equalsPath(newInfo)) continue;
            return base;
        }
        XMLFieldInfo[] res = new XMLFieldInfo[base.length + 1];
        for (int i = 0; i < base.length; ++i) {
            res[i] = base[i];
        }
        res[base.length] = newInfo;
        return res;
    }

    private boolean isRowAccepted(Object[] obj) {
        if (this.conditionRoot == null) {
            return true;
        }
        this.setConditionNode(obj, this.conditionRoot);
        if (this.conditionRoot instanceof XMLOperatorNode) {
            return ((XMLOperatorNode)this.conditionRoot).execute();
        }
        if (this.conditionRoot instanceof XMLConditionNode) {
            return ((XMLConditionNode)this.conditionRoot).execute();
        }
        return false;
    }

    private void setConditionNode(Object[] obj, XMLDefaultTreeNode tNode) {
        int ct = tNode.getChildCount();
        if (ct == 0) {
            XMLConditionNode condNode = (XMLConditionNode)tNode;
            Vector<Object> res = new Vector<Object>();
            res.addElement(obj[this.getXMLFieldInfoIndex(condNode.getXMLFieldInfo())]);
            condNode.setInputData(res);
        } else {
            for (int i = 0; i < ct; ++i) {
                this.setConditionNode(obj, tNode.getChildAt(i));
            }
        }
    }

    private int getXMLFieldInfoIndex(XMLFieldInfo node) {
        for (int i = 0; i < this.leafNodes.length; ++i) {
            if (!this.leafNodes[i].equalsPath(node)) continue;
            return i;
        }
        System.out.println("XMLQueryResultSet:  Should Not happen 2!");
        return -1;
    }

    @Override
    public void close() {
        this.currentRow = -1;
    }

    @Override
    public boolean next() {
        ++this.currentRow;
        while (this.currentRow < this.dataRows.size()) {
            if (this.isRowAccepted(this.dataRows.get(this.currentRow).getValues())) {
                return true;
            }
            ++this.currentRow;
        }
        return false;
    }

    @Override
    public Object getObject(int col) {
        return this.dataRows.get(this.currentRow).getValueAt(col - 1);
    }

    @Override
    public IRSMetaData getMetaData() {
        return new MetaData();
    }

    private class SAXContentHandler
    extends DefaultHandler {
        private Vector<String> currentPath = new Vector();
        private DataRow currentDataRow = null;
        private StringBuffer[] currentStrings;
        private int[] startRows;
        int maxPathLength;
        boolean goingUp;

        private SAXContentHandler() {
        }

        @Override
        public void startDocument() throws SAXException {
            this.currentDataRow = new DataRow();
            XMLQueryResultSet.this.dataRows.add(this.currentDataRow);
            this.maxPathLength = 0;
            for (XMLFieldInfo leafNode : XMLQueryResultSet.this.leafNodes) {
                if (leafNode.getPath().length <= this.maxPathLength) continue;
                this.maxPathLength = leafNode.getPath().length;
            }
            this.currentStrings = new StringBuffer[this.maxPathLength];
            for (int i = 0; i < this.currentStrings.length; ++i) {
                this.currentStrings[i] = new StringBuffer();
            }
            this.startRows = new int[this.maxPathLength];
        }

        @Override
        public void endDocument() throws SAXException {
            if (XMLQueryResultSet.this.dataRows.size() > 0 && !this.currentDataRow.isAllFound()) {
                XMLQueryResultSet.this.dataRows.remove(XMLQueryResultSet.this.dataRows.size() - 1);
            }
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            this.currentPath.add(name);
            this.goingUp = false;
            for (int i = 0; i < XMLQueryResultSet.this.leafNodes.length; ++i) {
                if (!this.equals(this.currentPath, XMLQueryResultSet.this.leafNodes[i]) || XMLQueryResultSet.this.leafNodes[i].getXMLType() != 2) continue;
                String stringValue = attributes.getValue(XMLQueryResultSet.this.leafNodes[i].getAttributeName());
                this.currentDataRow.setValueAt(this.createObject(stringValue, i), i);
            }
            if (this.currentPath.size() <= this.maxPathLength) {
                this.startRows[this.currentPath.size() - 1] = XMLQueryResultSet.this.dataRows.size() - 1;
            }
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            ArrayList<Integer> found = new ArrayList<Integer>();
            for (int i = 0; i < XMLQueryResultSet.this.leafNodes.length; ++i) {
                if (!this.equals(this.currentPath, XMLQueryResultSet.this.leafNodes[i]) || XMLQueryResultSet.this.leafNodes[i].getXMLType() != 1) continue;
                String stringValue = this.currentStrings[this.currentPath.size() - 1].toString();
                this.currentDataRow.setValueAt(this.createObject(stringValue, i), i);
                found.add(i);
            }
            this.markAllSubElementsFound(found);
            this.checkMoveToNextRow();
            this.moveUp(name);
        }

        private void moveUp(String name) {
            for (int i = 0; i < XMLQueryResultSet.this.leafNodes.length; ++i) {
                XMLFieldInfo leafNode = XMLQueryResultSet.this.leafNodes[i];
                if (!this.isSubElement(leafNode.getPath(), this.currentPath) || !this.goingUp) continue;
                this.currentDataRow.removeValueAt(i);
            }
            if (this.currentPath.size() <= this.maxPathLength) {
                this.currentStrings[this.currentPath.size() - 1].setLength(0);
            }
            this.currentPath.remove(this.currentPath.lastIndexOf(name));
        }

        private void markAllSubElementsFound(List<Integer> list) {
            if (this.goingUp) {
                return;
            }
            for (int i : list) {
                XMLFieldInfo leafNode = XMLQueryResultSet.this.leafNodes[i];
                if (!this.isSubElement(leafNode.getPath(), this.currentPath)) continue;
                this.currentDataRow.setFound(i);
            }
        }

        private void checkMoveToNextRow() {
            if (this.currentDataRow.isAllFound()) {
                this.currentDataRow = this.currentDataRow.clone();
                XMLQueryResultSet.this.dataRows.add(this.currentDataRow);
                this.goingUp = true;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.currentPath.size() > this.maxPathLength) {
                return;
            }
            this.currentStrings[this.currentPath.size() - 1].append(ch, start, length);
        }

        private Object createObject(String stringValue, int i) {
            if (stringValue == null || stringValue.length() == 0) {
                return null;
            }
            stringValue = stringValue.trim();
            int dataType = XMLQueryResultSet.this.getDataType(XMLQueryResultSet.this.leafNodes[i]);
            String dateFormat = XMLQueryResultSet.this.leafNodes[i].getDateFormat();
            if (dataType == 91 || dataType == 92 || dataType == 93) {
                return XMLDataTypeUtil.getDate(stringValue, dateFormat, dataType);
            }
            return DataType.createObject(stringValue, DataType.mapType(dataType));
        }

        private boolean isSubElement(String[] elementPath, Vector<String> currentPath) {
            if (elementPath.length < currentPath.size()) {
                return false;
            }
            for (int i = 0; i < currentPath.size(); ++i) {
                String currentPathElement = currentPath.get(i);
                if (currentPathElement.equals(elementPath[i])) continue;
                return false;
            }
            return true;
        }

        private boolean equals(Vector<String> path, XMLFieldInfo leafNode) {
            String[] leafPath = leafNode.getPath();
            if (path.size() != leafPath.length) {
                return false;
            }
            for (int i = 0; i < path.size(); ++i) {
                if (leafPath[i].equalsIgnoreCase(path.get(i))) continue;
                return false;
            }
            return true;
        }
    }

    private class DataRow
    implements Cloneable {
        private Object[] values;
        private boolean[] mapped;
        private boolean[] found;

        public DataRow() {
            this.values = new Object[XMLQueryResultSet.this.leafNodes.length];
            this.mapped = new boolean[XMLQueryResultSet.this.leafNodes.length];
            this.found = new boolean[XMLQueryResultSet.this.leafNodes.length];
        }

        public void setFound(int i) {
            this.found[i] = true;
        }

        public boolean isFound(int i) {
            return this.found[i];
        }

        public boolean isMapped(int i) {
            return this.mapped[i];
        }

        public boolean isAllFound() {
            for (int i = 0; i < this.found.length; ++i) {
                if (this.found[i]) continue;
                return false;
            }
            return true;
        }

        public void setValueAt(Object value, int i) {
            this.values[i] = value;
            this.mapped[i] = true;
            this.found[i] = true;
        }

        public void removeValueAt(int i) {
            this.values[i] = null;
            this.mapped[i] = false;
            this.found[i] = false;
        }

        public Object getValueAt(int i) {
            return this.values[i];
        }

        public Object[] getValues() {
            return this.values;
        }

        protected DataRow clone() {
            DataRow result = new DataRow();
            for (int i = 0; i < this.values.length; ++i) {
                if (this.isFound(i)) {
                    result.setFound(i);
                }
                if (!this.isMapped(i)) continue;
                result.setValueAt(this.getValueAt(i), i);
            }
            return result;
        }
    }

    class MetaData
    implements IRSMetaData {
        MetaData() {
        }

        @Override
        public int getColumnCount() {
            return XMLQueryResultSet.this.dataTypes.length;
        }

        @Override
        public String getColumnName(int col) {
            return XMLQueryResultSet.this.fieldName[col - 1];
        }

        @Override
        public String getTableName(int col) {
            return "";
        }

        @Override
        public int getColumnType(int col) {
            return XMLQueryResultSet.this.dataTypes[col - 1];
        }
    }
}

