/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.ReadDataFile;
import quadbase.reportdesigner.util.IRSMetaData;
import quadbase.reportdesigner.util.IResultSet;

public class XMLResultSet
implements IResultSet {
    private final int ECD = 0;
    private final int ERD = 1;
    private final int ED = 2;
    private final int DTYPE = 3;
    private final int FNAME = 4;
    private final int ROW = 5;
    private final int DATA = 6;
    public static final String QUADBASE_NULL = "[QUADBASE_XML_EXPORT_NULL]";
    String[] elementName = new String[]{"EspressChartData", "EspressReportData", "EspressData", "DataType", "FieldName", "Row", "Data"};
    private int currentRow = -1;
    private int[] dataTypes;
    private String[] fieldNames;
    private Vector<Vector<StringBuffer>> dataRows = new Vector();

    public XMLResultSet(String uri) throws Exception {
        this(new ReadDataFile().getInputStream(uri, false, true));
    }

    public XMLResultSet(File file) throws Exception {
        this(new FileInputStream(file));
    }

    public XMLResultSet(InputStream xmlStream) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        SAXParser parser = factory.newSAXParser();
        XMLReader reader = parser.getXMLReader();
        SAXContentHandler handler = new SAXContentHandler();
        reader.setContentHandler(handler);
        reader.setErrorHandler(handler);
        InputSource is = new InputSource(xmlStream);
        reader.parse(is);
    }

    @Override
    public void close() {
        this.currentRow = -1;
    }

    @Override
    public IRSMetaData getMetaData() {
        return new MetaData();
    }

    @Override
    public boolean next() {
        ++this.currentRow;
        if (ServerMessage.exceedLimit(this.currentRow)) {
            return false;
        }
        return this.currentRow < this.dataRows.size();
    }

    @Override
    public Object getObject(int col) {
        Vector<StringBuffer> row = this.dataRows.elementAt(this.currentRow);
        if (col < 1 || col > this.dataTypes.length || col > row.size()) {
            return null;
        }
        String stringValue = row.elementAt(col - 1).toString();
        if (stringValue.equals(QUADBASE_NULL)) {
            return null;
        }
        return DataType.createObject(stringValue, DataType.mapType(this.dataTypes[col - 1]));
    }

    static /* synthetic */ int[] access$202(XMLResultSet x0, int[] x1) {
        x0.dataTypes = x1;
        return x1;
    }

    static /* synthetic */ String[] access$102(XMLResultSet x0, String[] x1) {
        x0.fieldNames = x1;
        return x1;
    }

    private class SAXContentHandler
    extends DefaultHandler {
        private boolean startElementFound = false;
        private boolean dataTypeFound = false;
        private boolean fieldNameFound = false;
        private boolean rowFound = false;
        private boolean insideRow = false;
        private boolean insideData = false;
        private boolean dataInAttribute = false;
        private boolean finished = false;
        private Vector<StringBuffer> dataTypeStrings = new Vector();
        private Vector<StringBuffer> fieldNameStrings = new Vector();

        private SAXContentHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (this.finished) {
                throw new SAXException("Data found after " + XMLResultSet.this.elementName[2] + " element.");
            }
            if (name.equalsIgnoreCase(XMLResultSet.this.elementName[0]) || name.equalsIgnoreCase(XMLResultSet.this.elementName[1]) || name.equalsIgnoreCase(XMLResultSet.this.elementName[2])) {
                this.startElementFound = true;
            } else if (name.equalsIgnoreCase(XMLResultSet.this.elementName[3])) {
                if (!this.startElementFound) {
                    throw new SAXException("Start element (" + XMLResultSet.this.elementName[2] + ") not found.");
                }
                if (this.fieldNameFound) {
                    throw new SAXException("dataType element must not appear after fieldName element");
                }
                this.dataTypeFound = true;
                this.dataTypeStrings.add(new StringBuffer());
            } else if (name.equalsIgnoreCase(XMLResultSet.this.elementName[4])) {
                if (!this.dataTypeFound) {
                    throw new SAXException("Data type element (" + XMLResultSet.this.elementName[3] + ") not found.");
                }
                if (this.rowFound) {
                    throw new SAXException("fieldName element must not appear after row element");
                }
                this.fieldNameFound = true;
                this.fieldNameStrings.add(new StringBuffer());
            } else if (name.equalsIgnoreCase(XMLResultSet.this.elementName[5])) {
                if (!this.fieldNameFound) {
                    throw new SAXException("Field name element (" + XMLResultSet.this.elementName[4] + ") not found.");
                }
                if (!this.rowFound) {
                    this.rowFound = true;
                    if (this.fieldNameStrings.size() != this.dataTypeStrings.size()) {
                        throw new SAXException("Different count of fieldName and dataType elements.");
                    }
                }
                this.insideRow = true;
                XMLResultSet.this.dataRows.add(new Vector(this.dataTypeStrings.size()));
            } else if (name.equalsIgnoreCase(XMLResultSet.this.elementName[6])) {
                if (!this.insideRow) {
                    throw new SAXException("Data element must be inside row element.");
                }
                this.insideData = true;
                String stringValue = attributes.getValue("value");
                if (stringValue != null) {
                    this.dataInAttribute = true;
                    ((Vector)XMLResultSet.this.dataRows.get(XMLResultSet.this.dataRows.size() - 1)).add(new StringBuffer(stringValue));
                } else {
                    this.dataInAttribute = false;
                    ((Vector)XMLResultSet.this.dataRows.get(XMLResultSet.this.dataRows.size() - 1)).add(new StringBuffer());
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            if (name.equalsIgnoreCase(XMLResultSet.this.elementName[5])) {
                this.insideRow = false;
            } else if (name.equalsIgnoreCase(XMLResultSet.this.elementName[6])) {
                this.insideData = false;
            } else if (name.equalsIgnoreCase(XMLResultSet.this.elementName[0]) || name.equalsIgnoreCase(XMLResultSet.this.elementName[1]) || name.equalsIgnoreCase(XMLResultSet.this.elementName[2])) {
                this.finished = true;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.insideData && !this.dataInAttribute) {
                Vector row = (Vector)XMLResultSet.this.dataRows.get(XMLResultSet.this.dataRows.size() - 1);
                ((StringBuffer)row.get(row.size() - 1)).append(ch, start, length);
            } else {
                if (this.rowFound) {
                    return;
                }
                if (this.fieldNameFound) {
                    this.fieldNameStrings.get(this.fieldNameStrings.size() - 1).append(ch, start, length);
                } else if (this.dataTypeFound) {
                    this.dataTypeStrings.get(this.dataTypeStrings.size() - 1).append(ch, start, length);
                }
            }
        }

        @Override
        public void endDocument() throws SAXException {
            int i;
            XMLResultSet.access$202(XMLResultSet.this, new int[this.dataTypeStrings.size()]);
            for (i = 0; i < XMLResultSet.this.dataTypes.length; ++i) {
                ((XMLResultSet)XMLResultSet.this).dataTypes[i] = DataType.findType(this.dataTypeStrings.get(i).toString().trim());
            }
            XMLResultSet.access$102(XMLResultSet.this, new String[this.fieldNameStrings.size()]);
            for (i = 0; i < XMLResultSet.this.fieldNames.length; ++i) {
                ((XMLResultSet)XMLResultSet.this).fieldNames[i] = this.fieldNameStrings.get(i).toString().trim();
            }
        }
    }

    class MetaData
    implements IRSMetaData {
        MetaData() {
        }

        @Override
        public int getColumnCount() {
            return XMLResultSet.this.fieldNames.length;
        }

        @Override
        public String getColumnName(int col) {
            return XMLResultSet.this.fieldNames[col - 1];
        }

        @Override
        public String getTableName(int col) {
            return "";
        }

        @Override
        public int getColumnType(int col) {
            return XMLResultSet.this.dataTypes[col - 1];
        }
    }
}

