/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.util.internal;

import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageConfig;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import net.sourceforge.barbecue.Barcode;
import net.sourceforge.barbecue.BarcodeFactory;
import net.sourceforge.barbecue.BarcodeImageHandler;
import net.sourceforge.barbecue.output.OutputException;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.BorderSide;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.util.BarcodeFormat;
import quadbase.util.gif.GifEncoder;
import quadbase.util.internal.PNGJimiEncoder;

public class BarcodeUtil {
    private static int maxlen = 0;
    private static int labelHeight = 20;

    public static int getLeftMarginOfBarCode(int widthOfCell, int widthOfBarCode, short align) {
        if (widthOfCell <= widthOfBarCode) {
            return 0;
        }
        int res = 0;
        switch (align) {
            case 1: {
                res = 0;
                break;
            }
            case 2: {
                res = widthOfCell - widthOfBarCode;
                break;
            }
            default: {
                res = (widthOfCell - widthOfBarCode) / 2;
            }
        }
        if (res < 0) {
            res = 0;
        }
        return res;
    }

    private static byte[] generateQRCodeImage(String text, int width, int height, Color foreground, Color background) throws WriterException, IOException {
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        Hashtable<EncodeHintType, String> hints = new Hashtable<EncodeHintType, String>();
        hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        BitMatrix bitMatrix = qrCodeWriter.encode(text, com.google.zxing.BarcodeFormat.QR_CODE, width, height, hints);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        if (background == null) {
            background = new Color(0, 0, 0, 0);
        }
        MatrixToImageConfig conf = new MatrixToImageConfig(foreground.getRGB(), background.getRGB());
        MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"PNG", (OutputStream)os, (MatrixToImageConfig)conf);
        return os.toByteArray();
    }

    public static int getBarcodeLeftMargin(ReportElement cell) throws Exception {
        Barcode bc = BarcodeUtil.createBarCode(cell);
        BufferedImage image = null;
        BarcodeFormat bf = (BarcodeFormat)((ReportCell)cell).getDataFormat();
        if (bc != null) {
            image = BarcodeImageHandler.getImage((Barcode)bc);
        } else if (bf.getformat() == 30) {
            image = BarcodeUtil.getBufferedImage(cell.getText(), cell.getWidthOfElement(), cell.getHeightOfElement(), cell.getFontColor(), cell.getBgColor());
        }
        return BarcodeUtil.getLeftMarginOfBarCode(cell.getWidthOfElement(), image.getWidth(), cell.getAlign());
    }

    public static Object[] getBarCodeImage(ReportElement cell, byte[] data) throws Exception {
        Barcode bc = BarcodeUtil.createBarCode(cell);
        BufferedImage image = null;
        BarcodeFormat bf = (BarcodeFormat)((ReportCell)cell).getDataFormat();
        image = bf.getformat() != 30 ? BarcodeImageHandler.getImage((Barcode)bc) : BarcodeUtil.getBufferedImage(cell.getText(), cell.getWidthOfElement(), cell.getHeightOfElement(), cell.getFontColor(), cell.getBgColor());
        Object[] res = new Object[]{BarcodeUtil.convertImageToByteArray(image), BarcodeUtil.getLeftMarginOfBarCode(QbUtil.toPixel_export(cell.getWidth()), image.getWidth(), cell.getAlign())};
        return res;
    }

    public static BufferedImage getBufferedImage(String text, int width, int height, Color foreground, Color background) throws IOException {
        byte[] ba = null;
        try {
            ba = BarcodeUtil.generateQRCodeImage(text, width, height, foreground, background);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ByteArrayInputStream in = new ByteArrayInputStream(ba);
        return ImageIO.read(in);
    }

    private static byte[] convertImageToByteArray(BufferedImage bi) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            PNGJimiEncoder.createPNGImage((Image)bi, os, 2);
            return os.toByteArray();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static void getBarCodeImage(String text, int format, int cellW, int cellH, String fileName, Font font, Color bgColor, Color fColor) throws Exception {
        if (format != 30) {
            Barcode bc = BarcodeUtil.createBarCode(text, format, cellH, font, bgColor, fColor);
            FileOutputStream out = new FileOutputStream(fileName);
            BufferedImage image = BarcodeImageHandler.getImage((Barcode)bc);
            GifEncoder gifEncoder = new GifEncoder(image, image.getWidth(), image.getHeight(), (OutputStream)out);
            gifEncoder.encode();
        } else {
            FileOutputStream out = new FileOutputStream(fileName);
            BufferedImage image = BarcodeUtil.getBufferedImage(text, cellW, cellH - labelHeight, fColor, bgColor);
            GifEncoder gifEncoder = new GifEncoder(image, image.getWidth(), image.getHeight(), (OutputStream)out);
            gifEncoder.encode();
        }
    }

    public static BufferedImage createBarCodeImage(ReportElement cell) throws Exception {
        BarcodeFormat bf = null;
        bf = cell instanceof ReportColumn && ((ReportColumn)cell).getDataCount() > 0 ? (BarcodeFormat)((ReportColumn)cell).getDataFormat() : (BarcodeFormat)((ReportCell)cell).getDataFormat();
        Barcode bc = BarcodeUtil.createBarCode(cell);
        if (bf.getformat() == 30) {
            return BarcodeUtil.getBufferedImage(cell.getText(), cell.getWidthOfElement() - cell.getBorder(BorderSide.LEFT) - cell.getBorder(BorderSide.RIGHT), cell.getHeightOfElement() - cell.getBorder(BorderSide.TOP) - cell.getBorder(BorderSide.BOTTOM), cell.getFontColor(), cell.getBgColor());
        }
        return BarcodeUtil.convert24(bc);
    }

    public static Barcode createBarCode(ReportElement cell) throws Exception {
        BarcodeFormat bf = null;
        Barcode bc = null;
        if (cell instanceof ReportColumn && ((ReportColumn)cell).getDataCount() > 0) {
            bf = (BarcodeFormat)((ReportColumn)cell).getDataFormat();
            bc = BarcodeUtil.getBarCode(((ReportColumn)cell).getData(0).toString(), bf.getformat());
        } else {
            bf = (BarcodeFormat)((ReportCell)cell).getDataFormat();
            bc = BarcodeUtil.getBarCode(cell.getText(), bf.getformat());
        }
        BufferedImage image = null;
        int cellH = cell.getHeightOfElement() - labelHeight;
        if (bc != null) {
            bc.setBarHeight(cell.getHeightOfElement() - labelHeight);
            bc.setFont(cell.getRefFont());
            if (cell.getBgColor() != null) {
                bc.setBackground(cell.getBgColor());
            }
            if (cell.getFontColor() != null) {
                bc.setForeground(cell.getFontColor());
            }
            if (cell.getRefFont().getSize() < 12) {
                bc.setBarWidth(1);
            } else if (cell.getRefFont().getSize() < 22) {
                bc.setBarWidth(2);
            } else if (cell.getRefFont().getSize() < 38) {
                bc.setBarWidth(3);
            } else {
                bc.setBarWidth(4);
            }
            image = BarcodeUtil.convert24(bc);
        } else if (bf.getformat() == 30) {
            image = BarcodeUtil.getBufferedImage(cell.getText(), cell.getWidthOfElement() - cell.getBorder(BorderSide.RIGHT) - cell.getBorder(BorderSide.LEFT), cell.getHeightOfElement() - cell.getBorder(BorderSide.TOP) - cell.getBorder(BorderSide.BOTTOM), cell.getFontColor(), cell.getBgColor());
        }
        cell.setMinWidth(QbUtil.toInch(image.getWidth()));
        cell.setMinHeight(QbUtil.toInch(image.getHeight()));
        if (bc != null) {
            if (cell.getWidth() < QbUtil.toInch(image.getWidth())) {
                cell.setWidth(QbUtil.toInch(image.getWidth()));
            }
            if (cell.getHeight() < QbUtil.toInch(image.getHeight())) {
                cell.setHeight(QbUtil.toInch(image.getHeight()));
            }
        }
        return bc;
    }

    public static BufferedImage convert24(Barcode bc) throws OutputException {
        BufferedImage image = null;
        image = BarcodeImageHandler.getImage((Barcode)bc);
        image = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        bc.draw(image.createGraphics(), 0, 0);
        return image;
    }

    private static Barcode createBarCode(String text, int format, int cellH, Font font, Color bgColor, Color fColor) throws Exception {
        Barcode bc = BarcodeUtil.getBarCode(text, format);
        bc.setBarWidth(1);
        bc.setBarHeight(cellH);
        bc.setFont(font);
        if (bgColor != null) {
            bc.setBackground(bgColor);
        }
        if (fColor != null) {
            bc.setForeground(fColor);
        }
        return bc;
    }

    public static String getBarcodeString(String str, int format) throws Exception {
        if (format == 6) {
            maxlen = 11;
            return BarcodeUtil.getNumericCode(str, true);
        }
        if (format == 10) {
            maxlen = 12;
            return BarcodeUtil.getNumericCode(str, true);
        }
        if (format == 2) {
            return BarcodeUtil.getInt2Of5Code(str);
        }
        if (format == 24) {
            maxlen = 11;
            return BarcodeUtil.getNumericCode(str, false);
        }
        return str;
    }

    private static String getNumericCode(String str, boolean ignoreLastBit) throws Exception {
        Long l = Double.valueOf(str).longValue();
        String value = l.toString();
        if (ignoreLastBit && value.length() > maxlen) {
            value = value.substring(0, value.length() - 1);
        }
        if (value.length() > maxlen) {
            throw new Exception("This is not a valid barcode for the type you specified.");
        }
        if (value.length() < maxlen) {
            int count = maxlen - value.length();
            for (int i = 0; i < count; ++i) {
                value = "0" + value;
            }
        }
        return value;
    }

    private static String getInt2Of5Code(String str) {
        int C = str.length();
        if (BarcodeUtil.mod(C, 2.0) == 1.0) {
            str = "0" + str;
        }
        return str;
    }

    private static double mod(double a, double b) {
        double f = a / b;
        double i = Math.round(f);
        if (i > f) {
            i -= 1.0;
        }
        return a - b * i;
    }

    public static boolean isBarCodeInUPCAFormat(int format) {
        return format == 6 || format == 10 || format == 24;
    }

    private static Barcode getBarCode(String text, int format) throws Exception {
        String data = BarcodeUtil.getBarcodeString(text, format);
        if (format == 6) {
            return BarcodeFactory.createUPCA((String)data);
        }
        if (format == 10) {
            return BarcodeFactory.createEAN13((String)data);
        }
        if (format == 4) {
            return BarcodeFactory.createCodabar((String)data);
        }
        if (format == 2) {
            return BarcodeFactory.createInt2of5((String)data);
        }
        if (format == 13) {
            return BarcodeFactory.createCode128((String)data);
        }
        if (format == 14) {
            return BarcodeFactory.createCode128A((String)data);
        }
        if (format == 15) {
            return BarcodeFactory.createCode128B((String)data);
        }
        if (format == 16) {
            return BarcodeFactory.createCode128C((String)data);
        }
        if (format == 5) {
            return BarcodeFactory.createEAN128((String)data);
        }
        if (format == 9) {
            return BarcodeFactory.createBookland((String)data);
        }
        if (format == 7) {
            return BarcodeFactory.createStd2of5((String)data, (boolean)true);
        }
        if (format == 8) {
            return BarcodeFactory.createStd2of5((String)data, (boolean)false);
        }
        if (format == 12) {
            return BarcodeFactory.createPDF417((String)data);
        }
        if (format == 0) {
            return BarcodeFactory.createCode39((String)data, (boolean)true);
        }
        if (format == 1) {
            return BarcodeFactory.createCode39((String)data, (boolean)false);
        }
        if (format == 17) {
            return BarcodeFactory.createUSD3((String)data, (boolean)true);
        }
        if (format == 18) {
            return BarcodeFactory.createUSD3((String)data, (boolean)false);
        }
        if (format == 19) {
            return BarcodeFactory.create3of9((String)data, (boolean)true);
        }
        if (format == 20) {
            return BarcodeFactory.create3of9((String)data, (boolean)false);
        }
        if (format == 3) {
            return BarcodeFactory.create2of7((String)data);
        }
        if (format == 21) {
            return BarcodeFactory.createGlobalTradeItemNumber((String)data);
        }
        if (format == 22) {
            return BarcodeFactory.createMonarch((String)data);
        }
        if (format == 23) {
            return BarcodeFactory.createNW7((String)data);
        }
        if (format == 24) {
            return BarcodeFactory.createRandomWeightUPCA((String)data);
        }
        if (format == 25) {
            return BarcodeFactory.createSCC14ShippingCode((String)data);
        }
        if (format == 26) {
            return BarcodeFactory.createShipmentIdentificationNumber((String)data);
        }
        if (format == 27) {
            return BarcodeFactory.createSSCC18((String)data);
        }
        if (format == 28) {
            return BarcodeFactory.createUSPS((String)data);
        }
        if (format == 29) {
            return BarcodeFactory.createUSD4((String)data);
        }
        if (format == 30) {
            return null;
        }
        throw new Exception("Invalid bar code type \"" + format + "\"");
    }
}

