/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.util.internal;

import java.util.Date;

public class DateTime {
    public static final int SECOND = 0;
    public static final int MINUTE = 1;
    public static final int HOUR = 2;
    public static final int DAY = 3;
    public static final int WEEK = 4;
    public static final int MONTH = 5;
    public static final int YEAR = 6;
    public static final int MAX_UNITS = 7;

    public static long getDateVal(Date d, int unit, long value) {
        long dateVal = d.getTime();
        return DateTime.getDateVal(dateVal, unit, value);
    }

    public static long getDateVal(long dateVal, int unit, long value) {
        switch (unit) {
            case 0: {
                return dateVal + 1000L * value;
            }
            case 1: {
                return dateVal + 60000L * value;
            }
            case 2: {
                return dateVal + 3600000L * value;
            }
            case 3: {
                return dateVal + 86400000L * value;
            }
            case 4: {
                return dateVal + 604800000L * value;
            }
            case 5: {
                Date t = new Date(dateVal);
                t.setMonth(t.getMonth() + (int)value);
                return t.getTime();
            }
            case 6: {
                Date t = new Date(dateVal);
                t.setYear(t.getYear() + (int)value);
                return t.getTime();
            }
        }
        throw new IllegalArgumentException("Invalid time unit :" + unit);
    }

    public static final long getMilliseconds(int unit) {
        switch (unit) {
            case 0: {
                return 1000L;
            }
            case 1: {
                return 60000L;
            }
            case 2: {
                return 3600000L;
            }
            case 3: {
                return 86400000L;
            }
            case 4: {
                return 604800000L;
            }
            case 5: {
                return -1702967296L;
            }
            case 6: {
                return 1471228928L;
            }
        }
        throw new IllegalArgumentException("Invalid time unit :" + unit);
    }

    public static Date approxDate(Date d0, int unit) {
        if (unit < 0 || unit > 7) {
            throw new IllegalArgumentException("Illegal time unit");
        }
        Date t = new Date(d0.getTime());
        switch (unit) {
            case 6: {
                t.setMonth(0);
            }
            case 4: 
            case 5: {
                long val;
                if (unit != 4) {
                    t.setDate(1);
                } else {
                    val = t.getTime();
                    t.setTime(val -= (long)(t.getDay() * 86400 * 1000));
                }
            }
            case 3: {
                t.setHours(0);
            }
            case 2: {
                t.setMinutes(0);
            }
            case 1: {
                t.setSeconds(0);
            }
            case 0: {
                long val = t.getTime() / 1000L * 1000L;
                t.setTime(val);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid time unit :" + unit);
            }
        }
        return t;
    }
}

