/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.util.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Writer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.report.LoadXMLReportHelper;
import quadbase.reportdesigner.report.XMLReport;
import quadbase.reportdesigner.util.BarcodeFormat;
import quadbase.reportdesigner.util.DateTimeFormat;
import quadbase.reportdesigner.util.IFormat;
import quadbase.reportdesigner.util.ImageURLFormat;
import quadbase.reportdesigner.util.LocaleDateTimeFormat;
import quadbase.reportdesigner.util.LocaleNumericFormat;
import quadbase.reportdesigner.util.LogicalFormat;
import quadbase.reportdesigner.util.NumericFormat;
import quadbase.reportdesigner.util.StringFormat;
import quadbase.reportdesigner.util.TextURLFormat;

public final class FormatUtil {
    public static String nullString = "Null";
    public static Object nullNumeric = "Null";
    public static Object nullDateTime = "Null";
    public static Object nullBoolean = "Null";
    public static Object nullBarCode = "Null";
    private static LocaleDateTimeFormat defaultDateFormat = LocaleDateTimeFormat.getDateInstance();
    private static LocaleDateTimeFormat defaultTimeFormat = LocaleDateTimeFormat.getTimeInstance();
    private static LocaleDateTimeFormat defaultDateTimeFormat = LocaleDateTimeFormat.getDateTimeInstance();
    private static LogicalFormat defaultLogicalFormat = new LogicalFormat(1);
    private static LocaleNumericFormat defaultWholeNumberFormat = LocaleNumericFormat.getNumberInstance();
    private static LocaleNumericFormat defaultDecimalNumberFormat = LocaleNumericFormat.getNumberInstance();
    private static StringFormat defaultStringFormat = new StringFormat();

    public static final void writeLocaleNumericFormat(DataOutput out, LocaleNumericFormat lnf) throws IOException {
        out.writeInt(lnf.getInstanceType());
        NumberFormat nf = lnf.getNumberFormat();
        out.writeInt(nf.getMaximumFractionDigits());
        out.writeInt(nf.getMaximumIntegerDigits());
        out.writeInt(nf.getMinimumFractionDigits());
        out.writeInt(nf.getMinimumIntegerDigits());
        out.writeBoolean(nf.isGroupingUsed());
        out.writeBoolean(nf.isParseIntegerOnly());
    }

    public static final void writeXMLLocaleNumericFormat(Writer out, LocaleNumericFormat lnf) throws IOException {
        NumberFormat nf = lnf.getNumberFormat();
        out.write("<LOCALE_NUMERIC_FORMAT Type=\"" + lnf.getInstanceType() + "\" MaximumFractionDigits=\"" + nf.getMaximumFractionDigits() + "\" MaximumIntegerDigits=\"" + nf.getMaximumIntegerDigits() + "\" MinimumFractionDigits=\"" + nf.getMinimumFractionDigits() + "\" MinimumIntegerDigits=\"" + nf.getMinimumIntegerDigits() + "\" GroupingUsed=\"" + nf.isGroupingUsed() + "\" ParseIntegerOnly=\"" + nf.isParseIntegerOnly() + "\" />\n");
    }

    public static final LocaleNumericFormat readXMLLocaleNumericFormat(Node node) throws IOException {
        int type = -1;
        int maxFraction = -1;
        int maxInteger = -1;
        int minFraction = -1;
        int minInteger = -1;
        boolean groupingUsed = false;
        boolean parseInteger = false;
        boolean minFractionCheck = false;
        boolean maxIntegerCheck = false;
        boolean maxFractionCheck = false;
        boolean typeCheck = false;
        boolean parseIntegerCheck = false;
        boolean groupingUsedCheck = false;
        boolean minIntegerCheck = false;
        NamedNodeMap map = node.getAttributes();
        for (int i = 0; i < map.getLength(); ++i) {
            Node attr = map.item(i);
            if (attr.getNodeName().equalsIgnoreCase("Type")) {
                type = Integer.parseInt(attr.getNodeValue());
                typeCheck = true;
                continue;
            }
            if (attr.getNodeName().equalsIgnoreCase("MaximumFractionDigits")) {
                maxFraction = Integer.parseInt(attr.getNodeValue());
                maxFractionCheck = true;
                continue;
            }
            if (attr.getNodeName().equalsIgnoreCase("MaximumIntegerDigits")) {
                maxInteger = Integer.parseInt(attr.getNodeValue());
                maxIntegerCheck = true;
                continue;
            }
            if (attr.getNodeName().equalsIgnoreCase("MinimumFractionDigits")) {
                minFraction = Integer.parseInt(attr.getNodeValue());
                minFractionCheck = true;
                continue;
            }
            if (attr.getNodeName().equalsIgnoreCase("MinimumIntegerDigits")) {
                minInteger = Integer.parseInt(attr.getNodeValue());
                minIntegerCheck = true;
                continue;
            }
            if (attr.getNodeName().equalsIgnoreCase("GroupingUsed")) {
                groupingUsed = LoadXMLReportHelper.parseBoolean(attr.getNodeValue());
                groupingUsedCheck = true;
                continue;
            }
            if (!attr.getNodeName().equalsIgnoreCase("ParseIntegerOnly")) continue;
            parseInteger = LoadXMLReportHelper.parseBoolean(attr.getNodeValue());
            parseIntegerCheck = true;
        }
        if (typeCheck && maxFractionCheck && maxIntegerCheck && minFractionCheck && minIntegerCheck && groupingUsedCheck && parseIntegerCheck) {
            LocaleNumericFormat result;
            if (type == 0) {
                result = LocaleNumericFormat.getCurrencyInstance();
            } else if (type == 1) {
                result = LocaleNumericFormat.getNumberInstance();
            } else if (type == 2) {
                result = LocaleNumericFormat.getPercentInstance();
            } else {
                throw new IOException("Illegal LocaleNumericFormat: " + type);
            }
            NumberFormat nf = result.getNumberFormat();
            nf.setMaximumFractionDigits(maxFraction);
            nf.setMaximumIntegerDigits(maxInteger);
            nf.setMinimumFractionDigits(minFraction);
            nf.setMinimumIntegerDigits(minInteger);
            nf.setGroupingUsed(groupingUsed);
            nf.setParseIntegerOnly(parseInteger);
            return result;
        }
        return null;
    }

    public static final LocaleNumericFormat readLocaleNumericFormat(DataInput in, int version) throws IOException {
        LocaleNumericFormat result;
        int type = in.readInt();
        if (type == 0) {
            result = LocaleNumericFormat.getCurrencyInstance();
        } else if (type == 1) {
            result = LocaleNumericFormat.getNumberInstance();
        } else if (type == 2) {
            result = LocaleNumericFormat.getPercentInstance();
        } else {
            throw new IOException("Illegal LocaleNumericFormat: " + type);
        }
        NumberFormat nf = result.getNumberFormat();
        nf.setMaximumFractionDigits(in.readInt());
        nf.setMaximumIntegerDigits(in.readInt());
        nf.setMinimumFractionDigits(in.readInt());
        nf.setMinimumIntegerDigits(in.readInt());
        nf.setGroupingUsed(in.readBoolean());
        nf.setParseIntegerOnly(in.readBoolean());
        return result;
    }

    public static final void writeNumericFormat(DataOutput out, NumericFormat nf) throws IOException {
        out.writeChar(nf.currencySymbol);
        out.writeBoolean(nf.oneSymPerPage);
        out.writeInt(nf.currencyPos);
        out.writeInt(nf.decimal);
        out.writeInt(nf.rounding);
        out.writeInt(nf.negative);
        out.writeChar(nf.decimalSep);
        out.writeChar(nf.thousandSep);
        out.writeBoolean(nf.leadingZero);
        out.writeBoolean(nf.sciExp);
    }

    public static final void writeXMLNumericFormat(Writer out, NumericFormat nf) throws IOException {
        out.write("<NUMERIC_FORMAT CurrencySymbol=\"" + XMLReport.encodeXML(nf.currencySymbol + "") + "\" OneSymbolPerPage=\"" + nf.oneSymPerPage + "\" CurrencyPosition=\"" + nf.currencyPos + "\" Decimal=\"" + nf.decimal + "\" Rounding=\"" + nf.rounding + "\" NegativePosition=\"" + nf.negative + "\" DecimalSeparator=\"" + XMLReport.encodeXML(nf.decimalSep + "") + "\" ThousandSeparator=\"" + XMLReport.encodeXML(nf.thousandSep + "") + "\" LeadingZero=\"" + nf.leadingZero + "\" ScientificExpression=\"" + nf.sciExp + "\" />\n");
    }

    public static final NumericFormat readXMLNumericFormat(Node node) {
        String currencySymbol = null;
        boolean oneSymPerPage = false;
        int currencyPos = -1;
        int decimal = -1;
        int rounding = -1;
        int negative = -1;
        String decimalSep = null;
        String thousandSep = null;
        boolean leadingZero = false;
        boolean sciExp = false;
        boolean negativeCheck = false;
        boolean roundingCheck = false;
        boolean decimalCheck = false;
        boolean currencyPosCheck = false;
        boolean oneSymPerPageCheck = false;
        boolean sciExpCheck = false;
        boolean leadingZeroCheck = false;
        NamedNodeMap map = node.getAttributes();
        for (int i = 0; i < map.getLength(); ++i) {
            Node attr = map.item(i);
            if (attr.getNodeName().equalsIgnoreCase("CurrencySymbol")) {
                currencySymbol = attr.getNodeValue();
                continue;
            }
            if (attr.getNodeName().equalsIgnoreCase("OneSymbolPerPage")) {
                oneSymPerPage = LoadXMLReportHelper.parseBoolean(attr.getNodeValue());
                oneSymPerPageCheck = true;
                continue;
            }
            if (attr.getNodeName().equalsIgnoreCase("CurrencyPosition")) {
                currencyPos = Integer.parseInt(attr.getNodeValue());
                currencyPosCheck = true;
                continue;
            }
            if (attr.getNodeName().equalsIgnoreCase("Decimal")) {
                decimal = Integer.parseInt(attr.getNodeValue());
                decimalCheck = true;
                continue;
            }
            if (attr.getNodeName().equalsIgnoreCase("Rounding")) {
                rounding = Integer.parseInt(attr.getNodeValue());
                roundingCheck = true;
                continue;
            }
            if (attr.getNodeName().equalsIgnoreCase("NegativePosition")) {
                negative = Integer.parseInt(attr.getNodeValue());
                negativeCheck = true;
                continue;
            }
            if (attr.getNodeName().equalsIgnoreCase("DecimalSeparator")) {
                decimalSep = attr.getNodeValue();
                continue;
            }
            if (attr.getNodeName().equalsIgnoreCase("ThousandSeparator")) {
                thousandSep = attr.getNodeValue();
                continue;
            }
            if (attr.getNodeName().equalsIgnoreCase("LeadingZero")) {
                leadingZero = LoadXMLReportHelper.parseBoolean(attr.getNodeValue());
                leadingZeroCheck = true;
                continue;
            }
            if (!attr.getNodeName().equalsIgnoreCase("ScientificExpression")) continue;
            sciExp = LoadXMLReportHelper.parseBoolean(attr.getNodeValue());
            sciExpCheck = true;
        }
        if (oneSymPerPageCheck && currencyPosCheck && decimalCheck && roundingCheck && negativeCheck && leadingZeroCheck && sciExpCheck) {
            NumericFormat nf = new NumericFormat();
            nf.setFormat(currencySymbol.charAt(0), oneSymPerPage, currencyPos, decimal, rounding, negative, decimalSep.charAt(0), thousandSep.charAt(0), leadingZero);
            if (sciExp) {
                nf.setScientifExp(decimal);
            }
            return nf;
        }
        return null;
    }

    public static final NumericFormat readNumericFormat(DataInput in) throws IOException {
        NumericFormat nf = new NumericFormat();
        int decimal = in.readInt();
        nf.setFormat(in.readChar(), in.readBoolean(), in.readInt(), decimal, in.readInt(), in.readInt(), in.readChar(), in.readChar(), in.readBoolean());
        if (in.readBoolean()) {
            nf.setScientifExp(decimal);
        }
        return nf;
    }

    public static final void writeLocaleDateTimeFormat(DataOutput out, LocaleDateTimeFormat ldtf) throws IOException {
        out.writeInt(ldtf.getInstanceType());
        out.writeInt(ldtf.getDateStyle());
        out.writeInt(ldtf.getTimeStyle());
    }

    public static final void writeXMLLocaleDateTimeFormat(Writer out, LocaleDateTimeFormat ldtf) throws IOException {
        out.write("<LOCALE_DATETIME_FORMAT Type=\"" + ldtf.getInstanceType() + "\" DateStyle=\"" + ldtf.getDateStyle() + "\" TimeStyle=\"" + ldtf.getTimeStyle() + "\" />\n");
    }

    public static final LocaleDateTimeFormat readXMLLocaleDateTimeFormat(Node node) throws IOException {
        int type = -1;
        int dateStyle = -1;
        int timeStyle = -1;
        boolean timeStyleCheck = false;
        boolean dateStyleCheck = false;
        boolean typeCheck = false;
        NamedNodeMap map = node.getAttributes();
        for (int i = 0; i < map.getLength(); ++i) {
            Node attr = map.item(i);
            if (attr.getNodeName().equalsIgnoreCase("Type")) {
                type = Integer.parseInt(attr.getNodeValue());
                typeCheck = true;
                continue;
            }
            if (attr.getNodeName().equalsIgnoreCase("DateStyle")) {
                dateStyle = Integer.parseInt(attr.getNodeValue());
                dateStyleCheck = true;
                continue;
            }
            if (!attr.getNodeName().equalsIgnoreCase("TimeStyle")) continue;
            timeStyle = Integer.parseInt(attr.getNodeValue());
            timeStyleCheck = true;
        }
        if (typeCheck && dateStyleCheck && timeStyleCheck) {
            if (type == LocaleDateTimeFormat.DATE) {
                return LocaleDateTimeFormat.getDateInstance(dateStyle);
            }
            if (type == LocaleDateTimeFormat.TIME) {
                return LocaleDateTimeFormat.getTimeInstance(timeStyle);
            }
            if (type == LocaleDateTimeFormat.DATETIME) {
                return LocaleDateTimeFormat.getDateTimeInstance(dateStyle, timeStyle);
            }
            throw new IOException("Illegal LocaleDateTimeFormat: " + type);
        }
        return null;
    }

    public static final LocaleDateTimeFormat readLocaleDateTimeFormat(DataInput in, int version) throws IOException {
        int type = in.readInt();
        int dateStyle = in.readInt();
        int timeStyle = in.readInt();
        if (type == LocaleDateTimeFormat.DATE) {
            return LocaleDateTimeFormat.getDateInstance(dateStyle);
        }
        if (type == LocaleDateTimeFormat.TIME) {
            return LocaleDateTimeFormat.getTimeInstance(timeStyle);
        }
        if (type == LocaleDateTimeFormat.DATETIME) {
            return LocaleDateTimeFormat.getDateTimeInstance(dateStyle, timeStyle);
        }
        throw new IOException("Illegal LocaleDateTimeFormat: " + type);
    }

    public static final void writeDateTimeFormat(DataOutput out, DateTimeFormat dt) throws IOException {
        out.writeShort(dt.yearSymbol);
        out.writeShort(dt.monthSymbol);
        out.writeShort(dt.orderSymbol);
        IOUtil.writeString(out, dt.separator1);
        IOUtil.writeString(out, dt.separator2);
        out.writeBoolean(dt.hour24);
        out.writeBoolean(dt.showMinute);
        out.writeBoolean(dt.showSecond);
        IOUtil.writeString(out, dt.hourMinuteSep);
        IOUtil.writeString(out, dt.minuteSecondSep);
        out.writeShort(dt.nanoDecimal);
        out.writeBoolean(dt.timeBeforeDate);
        IOUtil.writeString(out, dt.timeDateSep);
        out.writeBoolean(dt.hidedate);
        out.writeBoolean(dt.hidemonth);
        out.writeBoolean(dt.hideyear);
        out.writeBoolean(dt.fixDigitLen);
        out.writeBoolean(dt.hideTimestampTime);
    }

    public static final void writeXMLDateTimeFormat(Writer out, DateTimeFormat dt) throws IOException {
        out.write("<DATETIME_FORMAT YearFormat=\"" + dt.yearSymbol + "\" MonthFormat=\"" + dt.monthSymbol + "\" DisplayOrder=\"" + dt.orderSymbol + "\" Separator1=\"" + XMLReport.encodeXML(dt.separator1) + "\" Separator2=\"" + XMLReport.encodeXML(dt.separator2) + "\" Use24Hours=\"" + dt.hour24 + "\" ShowMinute=\"" + dt.showMinute + "\" ShowSecond=\"" + dt.showSecond + "\" HourMinuteSeparator=\"" + XMLReport.encodeXML(dt.hourMinuteSep) + "\" MinuteSecondSeparator=\"" + XMLReport.encodeXML(dt.minuteSecondSep) + "\" NanoSecondDisplay=\"" + dt.nanoDecimal + "\" TimeBeforeDate=\"" + dt.timeBeforeDate + "\" TimeDateSeparator=\"" + XMLReport.encodeXML(dt.timeDateSep) + "\" HideDate=\"" + dt.hidedate + "\" HideMonth=\"" + dt.hidemonth + "\" HideYear=\"" + dt.hideyear + "\" FixDigitLength=\"" + dt.fixDigitLen + "\" HideTimestampTime=\"" + dt.hideTimestampTime + "\" />\n");
    }

    public static final DateTimeFormat readXMLDateTimeFormat(Node node) {
        int yearSymbol = -1;
        int monthSymbol = -1;
        int orderSymbol = -1;
        String separator1 = null;
        String separator2 = null;
        boolean showMinute = false;
        boolean showSecond = false;
        boolean hour24 = false;
        String hourMinuteSep = null;
        String minuteSecondSep = null;
        int nanoDecimal = -1;
        boolean timeBeforeDate = false;
        String timeDateSep = null;
        boolean hidedate = false;
        boolean hidemonth = false;
        boolean hideyear = false;
        boolean fixDigitLen = false;
        boolean hideTimestampTime = false;
        boolean hideTimestampTimeCheck = false;
        boolean showMinuteCheck = false;
        boolean orderSymbolCheck = false;
        boolean monthSymbolCheck = false;
        boolean yearSymbolCheck = false;
        boolean timeBeforeDateCheck = false;
        boolean nanoDecimalCheck = false;
        boolean hour24Check = false;
        boolean showSecondCheck = false;
        boolean fixDigitLenCheck = false;
        boolean hideyearCheck = false;
        boolean hidemonthCheck = false;
        boolean hidedateCheck = false;
        NamedNodeMap map = node.getAttributes();
        for (int i = 0; i < map.getLength(); ++i) {
            Node attr = map.item(i);
            if (attr.getNodeName().equalsIgnoreCase("YearFormat")) {
                yearSymbol = Short.parseShort(attr.getNodeValue());
                yearSymbolCheck = true;
                continue;
            }
            if (attr.getNodeName().equalsIgnoreCase("MonthFormat")) {
                monthSymbol = Short.parseShort(attr.getNodeValue());
                monthSymbolCheck = true;
                continue;
            }
            if (attr.getNodeName().equalsIgnoreCase("DisplayOrder")) {
                orderSymbol = Short.parseShort(attr.getNodeValue());
                orderSymbolCheck = true;
                continue;
            }
            if (attr.getNodeName().equalsIgnoreCase("Separator1")) {
                separator1 = attr.getNodeValue();
                continue;
            }
            if (attr.getNodeName().equalsIgnoreCase("Separator2")) {
                separator2 = attr.getNodeValue();
                continue;
            }
            if (attr.getNodeName().equalsIgnoreCase("ShowMinute")) {
                showMinute = LoadXMLReportHelper.parseBoolean(attr.getNodeValue());
                showMinuteCheck = true;
                continue;
            }
            if (attr.getNodeName().equalsIgnoreCase("ShowSecond")) {
                showSecond = LoadXMLReportHelper.parseBoolean(attr.getNodeValue());
                showSecondCheck = true;
                continue;
            }
            if (attr.getNodeName().equalsIgnoreCase("Use24Hours")) {
                hour24 = LoadXMLReportHelper.parseBoolean(attr.getNodeValue());
                hour24Check = true;
                continue;
            }
            if (attr.getNodeName().equalsIgnoreCase("HourMinuteSeparator")) {
                hourMinuteSep = attr.getNodeValue();
                continue;
            }
            if (attr.getNodeName().equalsIgnoreCase("MinuteSecondSeparator")) {
                minuteSecondSep = attr.getNodeValue();
                continue;
            }
            if (attr.getNodeName().equalsIgnoreCase("NanoSecondDisplay")) {
                nanoDecimal = Short.parseShort(attr.getNodeValue());
                nanoDecimalCheck = true;
                continue;
            }
            if (attr.getNodeName().equalsIgnoreCase("TimeBeforeDate")) {
                timeBeforeDate = LoadXMLReportHelper.parseBoolean(attr.getNodeValue());
                timeBeforeDateCheck = true;
                continue;
            }
            if (attr.getNodeName().equalsIgnoreCase("TimeDateSeparator")) {
                timeDateSep = attr.getNodeValue();
                continue;
            }
            if (attr.getNodeName().equalsIgnoreCase("HideDate")) {
                hidedate = LoadXMLReportHelper.parseBoolean(attr.getNodeValue());
                hidedateCheck = true;
                continue;
            }
            if (attr.getNodeName().equalsIgnoreCase("HideMonth")) {
                hidemonth = LoadXMLReportHelper.parseBoolean(attr.getNodeValue());
                hidemonthCheck = true;
                continue;
            }
            if (attr.getNodeName().equalsIgnoreCase("HideYear")) {
                hideyear = LoadXMLReportHelper.parseBoolean(attr.getNodeValue());
                hideyearCheck = true;
                continue;
            }
            if (attr.getNodeName().equalsIgnoreCase("FixDigitLength")) {
                fixDigitLen = LoadXMLReportHelper.parseBoolean(attr.getNodeValue());
                fixDigitLenCheck = true;
                continue;
            }
            if (!attr.getNodeName().equalsIgnoreCase("HideTimestampTime")) continue;
            hideTimestampTime = LoadXMLReportHelper.parseBoolean(attr.getNodeValue());
            hideTimestampTimeCheck = true;
        }
        if (yearSymbolCheck && monthSymbolCheck && orderSymbolCheck && showMinuteCheck && showSecondCheck && hour24Check && nanoDecimalCheck && timeBeforeDateCheck && hidedateCheck && hidemonthCheck && hideyearCheck && fixDigitLenCheck && hideTimestampTimeCheck) {
            DateTimeFormat dt = new DateTimeFormat();
            dt.yearSymbol = (short)yearSymbol;
            dt.monthSymbol = (short)monthSymbol;
            dt.orderSymbol = (short)orderSymbol;
            dt.separator1 = separator1;
            dt.separator2 = separator2;
            dt.hour24 = hour24;
            dt.showMinute = showMinute;
            dt.showSecond = showSecond;
            dt.hourMinuteSep = hourMinuteSep;
            dt.minuteSecondSep = minuteSecondSep;
            dt.nanoDecimal = (short)nanoDecimal;
            dt.timeBeforeDate = timeBeforeDate;
            dt.timeDateSep = timeDateSep;
            dt.hidedate = hidedate;
            dt.hidemonth = hidemonth;
            dt.hideyear = hideyear;
            dt.fixDigitLen = fixDigitLen;
            dt.hideTimestampTime = hideTimestampTime;
            return dt;
        }
        return null;
    }

    public static final DateTimeFormat readDateTimeFormat(DataInput in, int version) throws IOException {
        boolean isUTF = true;
        DateTimeFormat dt = new DateTimeFormat();
        dt.yearSymbol = in.readShort();
        dt.monthSymbol = in.readShort();
        dt.orderSymbol = in.readShort();
        dt.separator1 = IOUtil.readString(in, isUTF);
        dt.separator2 = IOUtil.readString(in, isUTF);
        dt.hour24 = in.readBoolean();
        dt.showMinute = in.readBoolean();
        dt.showSecond = in.readBoolean();
        dt.hourMinuteSep = IOUtil.readString(in, isUTF);
        dt.minuteSecondSep = IOUtil.readString(in, isUTF);
        dt.nanoDecimal = in.readShort();
        dt.timeBeforeDate = in.readBoolean();
        dt.timeDateSep = IOUtil.readString(in, isUTF);
        dt.hidedate = in.readBoolean();
        dt.hidemonth = in.readBoolean();
        dt.hideyear = in.readBoolean();
        dt.fixDigitLen = in.readBoolean();
        dt.hideTimestampTime = in.readBoolean();
        return dt;
    }

    public static void writeDataFormat(DataOutput out, IFormat dataFormat) throws IOException {
        if (dataFormat == null) {
            out.writeInt(-1);
            return;
        }
        out.writeInt(dataFormat.getFormatType());
        if (dataFormat instanceof NumericFormat) {
            FormatUtil.writeNumericFormat(out, (NumericFormat)dataFormat);
        } else if (dataFormat instanceof DateTimeFormat) {
            FormatUtil.writeDateTimeFormat(out, (DateTimeFormat)dataFormat);
        } else if (dataFormat instanceof LogicalFormat) {
            out.writeInt(((LogicalFormat)dataFormat).getformat());
        } else if (dataFormat instanceof LocaleNumericFormat) {
            FormatUtil.writeLocaleNumericFormat(out, (LocaleNumericFormat)dataFormat);
        } else if (dataFormat instanceof LocaleDateTimeFormat) {
            FormatUtil.writeLocaleDateTimeFormat(out, (LocaleDateTimeFormat)dataFormat);
        } else if (dataFormat instanceof StringFormat) {
            out.writeInt(((StringFormat)dataFormat).getMaxCharacter());
        } else if (dataFormat instanceof BarcodeFormat) {
            out.writeInt(((BarcodeFormat)dataFormat).getformat());
        }
    }

    public static void writeXMLDataFormat(Writer out, IFormat dataFormat) throws IOException {
        if (dataFormat == null) {
            return;
        }
        if (dataFormat instanceof NumericFormat) {
            FormatUtil.writeXMLNumericFormat(out, (NumericFormat)dataFormat);
        } else if (dataFormat instanceof DateTimeFormat) {
            FormatUtil.writeXMLDateTimeFormat(out, (DateTimeFormat)dataFormat);
        } else if (dataFormat instanceof LogicalFormat) {
            out.write("<LOGICAL_FORMAT Format=\"" + ((LogicalFormat)dataFormat).getformat() + "\" />\n");
        } else if (dataFormat instanceof LocaleNumericFormat) {
            FormatUtil.writeXMLLocaleNumericFormat(out, (LocaleNumericFormat)dataFormat);
        } else if (dataFormat instanceof LocaleDateTimeFormat) {
            FormatUtil.writeXMLLocaleDateTimeFormat(out, (LocaleDateTimeFormat)dataFormat);
        } else if (dataFormat instanceof StringFormat) {
            out.write("<STRING_FORMAT MaximumCharacters=\"" + ((StringFormat)dataFormat).getMaxCharacter() + "\" />\n");
        } else if (dataFormat instanceof BarcodeFormat) {
            out.write("<BARCODE_FORMAT Format=\"" + ((BarcodeFormat)dataFormat).getformat() + "\" />\n");
        } else if (dataFormat instanceof ImageURLFormat) {
            out.write("<IMAGEURL_FORMAT/>\n");
        } else if (dataFormat instanceof TextURLFormat) {
            out.write("<TEXTURL_FORMAT/>\n");
        }
    }

    public static IFormat readDataFormat(DataInput in, int version) throws IOException {
        IFormat dataFormat = null;
        int formatType = in.readInt();
        switch (formatType) {
            case 0: {
                dataFormat = new LogicalFormat(in.readInt());
                break;
            }
            case 6: {
                dataFormat = new BarcodeFormat(in.readInt());
                break;
            }
            case 1: {
                dataFormat = FormatUtil.readNumericFormat(in);
                break;
            }
            case 2: {
                dataFormat = FormatUtil.readLocaleNumericFormat(in, version);
                break;
            }
            case 3: {
                dataFormat = FormatUtil.readDateTimeFormat(in, version);
                break;
            }
            case 4: {
                dataFormat = FormatUtil.readLocaleDateTimeFormat(in, version);
                break;
            }
            case 5: {
                dataFormat = new StringFormat(in.readInt());
                break;
            }
            case 7: {
                dataFormat = new ImageURLFormat();
                break;
            }
            case 8: {
                dataFormat = new TextURLFormat();
                break;
            }
        }
        return dataFormat;
    }

    public static IFormat readXMLDataFormat(Node node, int version) throws IOException {
        String nodename = node.getNodeName();
        if (nodename.equalsIgnoreCase("LOGICAL_FORMAT")) {
            NamedNodeMap map = node.getAttributes();
            for (int i = 0; i < map.getLength(); ++i) {
                if (!map.item(i).getNodeName().equalsIgnoreCase("Format")) continue;
                return new LogicalFormat(Integer.parseInt(map.item(i).getNodeValue()));
            }
        } else if (nodename.equalsIgnoreCase("STRING_FORMAT")) {
            NamedNodeMap map = node.getAttributes();
            for (int i = 0; i < map.getLength(); ++i) {
                if (!map.item(i).getNodeName().equalsIgnoreCase("MaximumCharacters")) continue;
                return new StringFormat(Integer.parseInt(map.item(i).getNodeValue()));
            }
        } else if (nodename.equalsIgnoreCase("BARCODE_FORMAT")) {
            NamedNodeMap map = node.getAttributes();
            for (int i = 0; i < map.getLength(); ++i) {
                if (!map.item(i).getNodeName().equalsIgnoreCase("Format")) continue;
                return new BarcodeFormat(Integer.parseInt(map.item(i).getNodeValue()));
            }
        } else {
            if (nodename.equalsIgnoreCase("NUMERIC_FORMAT")) {
                return FormatUtil.readXMLNumericFormat(node);
            }
            if (nodename.equalsIgnoreCase("DATETIME_FORMAT")) {
                return FormatUtil.readXMLDateTimeFormat(node);
            }
            if (nodename.equalsIgnoreCase("LOCALE_NUMERIC_FORMAT")) {
                return FormatUtil.readXMLLocaleNumericFormat(node);
            }
            if (nodename.equalsIgnoreCase("LOCALE_DATETIME_FORMAT")) {
                return FormatUtil.readXMLLocaleDateTimeFormat(node);
            }
            if (nodename.equalsIgnoreCase("IMAGEURL_FORMAT")) {
                return new ImageURLFormat();
            }
            if (nodename.equalsIgnoreCase("TEXTURL_FORMAT")) {
                return new TextURLFormat();
            }
        }
        return null;
    }

    public static String formatLabel(Object obj, IFormat dataFormat) {
        if (dataFormat != null) {
            return dataFormat.format(obj);
        }
        if (obj == null) {
            return nullString;
        }
        return obj.toString();
    }

    public static IFormat createBarcodeFormat(int dataType) {
        BarcodeFormat format = null;
        format = new BarcodeFormat(0);
        return format;
    }

    public static IFormat createFormat(int dataType) {
        return FormatUtil.createFormat(dataType, null, null);
    }

    public static IFormat createFormat(int dataType, Locale locale, TimeZone zone) {
        IFormat format = null;
        switch (dataType) {
            case 9: {
                format = LocaleDateTimeFormat.getTimeInstance();
                break;
            }
            case 8: {
                format = LocaleDateTimeFormat.getDateInstance();
                break;
            }
            case 10: {
                format = LocaleDateTimeFormat.getDateTimeInstance();
                break;
            }
            case 0: {
                format = new LogicalFormat(1);
                break;
            }
            case 1: 
            case 2: 
            case 11: 
            case 12: {
                format = LocaleNumericFormat.getNumberInstance();
                ((LocaleNumericFormat)format).getNumberFormat().setMaximumFractionDigits(0);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 13: {
                format = LocaleNumericFormat.getNumberInstance();
                break;
            }
            default: {
                format = new StringFormat();
            }
        }
        FormatUtil.setLocale(format, locale);
        FormatUtil.setTimeZone(format, zone);
        return format;
    }

    public static IFormat getDefaultFormat(int dataType, Locale locale, TimeZone zone) {
        IFormat format = null;
        switch (dataType) {
            case 9: {
                format = defaultTimeFormat;
                break;
            }
            case 8: {
                format = defaultDateFormat;
                break;
            }
            case 10: {
                format = defaultDateTimeFormat;
                break;
            }
            case 0: {
                format = defaultLogicalFormat;
                break;
            }
            case 1: 
            case 2: 
            case 11: 
            case 12: {
                format = defaultWholeNumberFormat;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 13: {
                format = defaultDecimalNumberFormat;
                break;
            }
            default: {
                format = defaultStringFormat;
            }
        }
        FormatUtil.setLocale(format, locale);
        FormatUtil.setTimeZone(format, zone);
        return format;
    }

    public static boolean isFormatAppliabled(IFormat format1, IFormat format2) {
        int b;
        if (format1 == null || format2 == null) {
            return true;
        }
        int a = format1.getFormatType();
        if (a == (b = format2.getFormatType())) {
            return true;
        }
        if (a == 6 || b == 6) {
            return true;
        }
        if (a == 1 && b == 2) {
            return true;
        }
        if (b == 1 && a == 2) {
            return true;
        }
        if (a == 3 && b == 4) {
            return true;
        }
        if (b == 3 && a == 4) {
            return true;
        }
        if (a == 5 && b == 7) {
            return true;
        }
        if (a == 5 && b == 8) {
            return true;
        }
        if (b == 5 && a == 7) {
            return true;
        }
        return b == 5 && a == 8;
    }

    public static void setLocale(IFormat format, Locale locale) {
        if (locale == null || format == null) {
            return;
        }
        if (format instanceof LocaleNumericFormat) {
            ((LocaleNumericFormat)format).setLocale(locale);
        } else if (format instanceof LocaleDateTimeFormat) {
            ((LocaleDateTimeFormat)format).setLocale(locale);
        }
    }

    public static void setTimeZone(IFormat format, TimeZone zone) {
        if (zone == null || format == null) {
            return;
        }
        if (format instanceof LocaleDateTimeFormat) {
            ((LocaleDateTimeFormat)format).setTimeZone(zone);
        }
    }

    public static Object getNumericNULLDataValue() {
        return nullNumeric;
    }

    public static void setNumericNULLDataValue(Object value) {
        if (value != null) {
            nullNumeric = value;
        }
    }

    public static Object getDateTimeNULLDataValue() {
        return nullDateTime;
    }

    public static void setDateTimeNULLDataValue(Object value) {
        if (value != null) {
            nullDateTime = value;
        }
    }

    public static Object getBooleanNULLDataValue() {
        return nullBoolean;
    }

    public static void setBooleanNULLDataValue(Object value) {
        if (value != null) {
            nullBoolean = value;
        }
    }

    public static String getStringNULLDataValue() {
        return nullString;
    }

    public static void setStringNULLDataValue(String value) {
        if (value != null) {
            nullString = value;
        }
    }

    public static Object getBarcodeNULLDataValue() {
        return nullBarCode;
    }

    public static void setBarcodeNULLDataValue(Object value) {
        if (value != null) {
            nullBarCode = value;
        }
    }

    public static String getDateTimeText(Locale locale, TimeZone zone, String pattern, java.util.Date date) {
        SimpleDateFormat dateFormat = locale == null ? new SimpleDateFormat(pattern) : new SimpleDateFormat(pattern, locale);
        if (zone != null) {
            dateFormat.setTimeZone(zone);
        }
        return dateFormat.format(date);
    }

    public static java.util.Date createDate(String s) throws Exception {
        try {
            Calendar cal = Calendar.getInstance();
            int i = s.indexOf(47);
            int j = s.indexOf("/", i + 1);
            int month = Integer.parseInt(s.substring(0, i)) - 1;
            int date = Integer.parseInt(s.substring(i + 1, j));
            int year = Integer.parseInt(s.substring(j + 1));
            cal.set(year, month, date);
            return cal.getTime();
        }
        catch (Exception e) {
            throw new Exception(LanguageEncoder.getText("Date format: mm/dd/yyyy"));
        }
    }

    public static java.util.Date createDate2(String s) throws Exception {
        try {
            Calendar cal = Calendar.getInstance();
            int i = s.indexOf(45);
            int j = s.indexOf("-", i + 1);
            int year = Integer.parseInt(s.substring(0, i));
            int month = Integer.parseInt(s.substring(i + 1, j)) - 1;
            int date = Integer.parseInt(s.substring(j + 1));
            cal.set(year, month, date);
            return cal.getTime();
        }
        catch (Exception e) {
            throw new Exception(LanguageEncoder.getText("Date format: yyyy-mm-dd"));
        }
    }

    public static java.util.Date createTime(String s) throws Exception {
        try {
            Calendar cal = Calendar.getInstance();
            int hour = Integer.parseInt(s.substring(0, 2));
            int minute = Integer.parseInt(s.substring(3, 5));
            int sec = Integer.parseInt(s.substring(6, 8));
            cal.set(11, hour);
            cal.set(12, minute);
            cal.set(13, sec);
            return cal.getTime();
        }
        catch (Exception e) {
            throw new Exception(LanguageEncoder.getText("Time format: hh:mm:ss"));
        }
    }

    public static Timestamp createTimestamp(String s) throws Exception {
        try {
            Calendar cal = Calendar.getInstance();
            int i = s.indexOf(47);
            int j = s.indexOf("/", i + 1);
            int month = Integer.parseInt(s.substring(0, i)) - 1;
            int date = Integer.parseInt(s.substring(i + 1, j));
            int year = Integer.parseInt(s.substring(j + 1, j + 5));
            int hour = Integer.parseInt(s.substring(j + 6, j + 8));
            int minute = Integer.parseInt(s.substring(j + 9, j + 11));
            int sec = Integer.parseInt(s.substring(j + 12));
            cal.set(year, month, date, hour, minute, sec);
            return new Timestamp(cal.getTime().getTime());
        }
        catch (Exception e) {
            throw new Exception(LanguageEncoder.getText("Timestamp format: mm/dd/yyyy hh:mm:ss"));
        }
    }

    public static Timestamp createTimestamp2(String s) throws Exception {
        try {
            Calendar cal = Calendar.getInstance();
            int i = s.indexOf(45);
            int j = s.indexOf("-", i + 1);
            int year = Integer.parseInt(s.substring(0, i));
            int month = Integer.parseInt(s.substring(i + 1, j)) - 1;
            int date = Integer.parseInt(s.substring(j + 1, j + 3));
            int hour = Integer.parseInt(s.substring(j + 4, j + 6));
            int minute = Integer.parseInt(s.substring(j + 7, j + 9));
            int sec = Integer.parseInt(s.substring(j + 10));
            cal.set(year, month, date, hour, minute, sec);
            return new Timestamp(cal.getTime().getTime());
        }
        catch (Exception e) {
            throw new Exception(LanguageEncoder.getText("Timestamp format: yyyy-mm-dd hh:mm:ss"));
        }
    }

    public static String formatValue(Object value) {
        if (value instanceof Date) {
            return FormatUtil.getDateTimeText(null, null, "MM'/'dd'/'yyyy", (java.util.Date)value);
        }
        if (value instanceof Time) {
            return FormatUtil.getDateTimeText(null, null, "HH:mm:ss", (java.util.Date)value);
        }
        if (value instanceof Timestamp) {
            return FormatUtil.getDateTimeText(null, null, "MM'/'dd'/'yyyy HH:mm:ss", (java.util.Date)value);
        }
        return value.toString();
    }

    static {
        defaultWholeNumberFormat.getNumberFormat().setMaximumFractionDigits(0);
    }
}

