/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.util.internal;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.imageio.ImageIO;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.IQbGraphics;
import quadbase.common.util.internal.LCKey;
import quadbase.reportdesigner.report.ReadDataFile;
import quadbase.reportdesigner.util.internal.ImageResample;
import quadbase.reportdesigner.util.internal.PNGJimiDecoder;

public class ImageData {
    public static final int CENTER = 0;
    public static final int FIT = 1;
    public static final int TILE = 2;
    public static final int NONE = 3;
    URL url;
    Image image;
    Image newimage;
    int display_option;
    int im_w;
    int im_h;
    int width;
    int height;
    boolean changed;
    boolean failed;

    public ImageData(URL url) {
        this(url, 0);
    }

    public ImageData(URL url, int option) {
        this.setOption(option);
        this.setImage(url);
    }

    public void setImage(URL url) {
        this.url = url;
        this.image = null;
        this.changed = true;
        this.failed = false;
    }

    public void setImage(Image image) {
        if (image == null) {
            return;
        }
        this.image = image;
        this.changed = true;
        this.failed = false;
    }

    public void setOption(int option) {
        this.display_option = option;
        this.changed = true;
    }

    public int getOption() {
        return this.display_option;
    }

    public URL getUrl() {
        return this.url;
    }

    public Image getImage() {
        return this.image;
    }

    public void draw(Graphics g, int x, int y, int width, int height, Object comp) {
        ImageObserver obs;
        block18: {
            if (this.url == null || this.display_option == 3) {
                return;
            }
            if (g instanceof IQbGraphics) {
                ((IQbGraphics)((Object)g)).drawImage(this.url, this.display_option, x, y, width, height);
                return;
            }
            if (this.image == null && !this.failed) {
                this.image = ImageData.retrieveImage(this.url, (Component)comp);
                if (this.image == null) {
                    this.failed = true;
                    return;
                }
            }
            this.im_w = this.image.getWidth(null);
            this.im_h = this.image.getHeight(null);
            this.changed = true;
            obs = (ImageObserver)comp;
            if (this.width != width || this.height != height) {
                this.changed = true;
            }
            this.width = width;
            this.height = height;
            if ((this.im_w > width || this.im_h > height) && this.display_option != 1 && this.changed) {
                try {
                    if (this.im_w <= width || this.im_w >= width && this.im_h >= height && this.im_h * width >= this.im_w * height) {
                        this.newimage = new ImageResample(this.image).resample(height * this.im_w / this.im_h, height);
                        break block18;
                    }
                    this.newimage = new ImageResample(this.image).resample(width, width * this.im_h / this.im_w);
                }
                catch (Exception ex) {
                    this.newimage = this.image;
                }
            } else if (this.display_option == 2 || this.display_option == 0 && this.changed) {
                this.newimage = this.image;
            }
        }
        if (this.display_option == 0) {
            g.drawImage(this.newimage, x + (width - this.newimage.getWidth(null)) / 2, y + (height - this.newimage.getHeight(null)) / 2, obs);
        } else if (this.display_option == 2) {
            ImageData.imageTile(g, x, y, width, height, this.newimage, obs);
        } else {
            try {
                if (this.changed) {
                    this.newimage = new ImageResample(this.image).resample(width, height);
                }
            }
            catch (Exception ex) {
                this.newimage = this.image;
            }
            g.drawImage(this.newimage, x, y, width, height, obs);
        }
        this.changed = false;
    }

    public static Image retrieveImage(URL url, Component c) {
        Image image = null;
        if (ServerMessage.getApplet() == null && !LCKey.isERES()) {
            try {
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_7_5) AppleWebKit/537.31 (KHTML, like Gecko) Chrome/26.0.1410.65 Safari/537.31");
                image = ImageIO.read(connection.getInputStream());
            }
            catch (Exception connection) {
                // empty catch block
            }
        }
        if (image == null) {
            try {
                int nread;
                ReadDataFile readDataFile = new ReadDataFile();
                DataInputStream instream = readDataFile.getInputStream(null, url.toString(), true, false);
                ByteArrayOutputStream boutput = new ByteArrayOutputStream(100);
                DataOutputStream dout = new DataOutputStream(boutput);
                byte[] buf = new byte[100];
                while ((nread = instream.read(buf, 0, 100)) >= 0) {
                    dout.write(buf, 0, nread);
                }
                image = ImageData.retrieveImage(boutput.toByteArray(), c);
                readDataFile.close();
                return image;
            }
            catch (Exception ex3) {
                System.out.println("Failed to load image " + url + " " + ex3.getMessage());
            }
        }
        return image;
    }

    public static Dimension getSize(URL url, Component c) {
        Image image = ImageData.retrieveImage(url, c);
        if (image == null) {
            return null;
        }
        return new Dimension(image.getWidth(null), image.getHeight(null));
    }

    public static void imageTile(Graphics g, int x, int y, int width, int height, Image image, ImageObserver obs) {
        int w = image.getWidth(obs);
        int h = image.getHeight(obs);
        if (w == 0 || h == 0) {
            return;
        }
        int col = (int)Math.ceil((double)width / (double)w);
        int row = (int)Math.ceil((double)height / (double)h);
        for (int i = 0; i < row; ++i) {
            for (int j = 0; j < col; ++j) {
                g.drawImage(image, j * w + x, i * h + y, w, h, obs);
            }
        }
    }

    public static Image retrieveImage(byte[] array, Component c) {
        Image image = null;
        try {
            image = Toolkit.getDefaultToolkit().createImage(array);
            MediaTracker tracker = new MediaTracker(c);
            tracker.addImage(image, 0);
            tracker.waitForID(0);
            if (tracker.isErrorID(0)) {
                throw new IOException("");
            }
        }
        catch (Exception ex) {
            try {
                if (IOUtil.isJimiIncluded()) {
                    image = PNGJimiDecoder.getImage(array);
                }
            }
            catch (Exception ex2) {
                image = null;
            }
        }
        return image;
    }
}

