/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.util.internal;

import java.math.BigDecimal;
import quadbase.reportdesigner.util.internal.ICompareObject;

public class NumberCompare
implements ICompareObject {
    Number value;
    boolean isBigDecimal;
    int index;

    public NumberCompare(Number value) {
        this.value = value;
        this.isBigDecimal = value instanceof BigDecimal;
    }

    public NumberCompare(Number value, int index) {
        this.value = value;
        this.isBigDecimal = value instanceof BigDecimal;
        this.index = index;
    }

    @Override
    public boolean greaterThan(boolean isAsc, ICompareObject target) {
        boolean targetNull;
        boolean bl = targetNull = target == null || target.getValue() == null;
        if (this.value == null && targetNull) {
            return false;
        }
        if (this.value == null) {
            return !isAsc;
        }
        if (targetNull) {
            return isAsc;
        }
        if (this.isBigDecimal) {
            BigDecimal temp = new BigDecimal(0);
            try {
                temp = (BigDecimal)target.getValue();
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            return isAsc ? ((BigDecimal)this.value).compareTo(temp) > 0 : temp.compareTo((BigDecimal)this.value) > 0;
        }
        Number temp = 0;
        try {
            temp = (Number)target.getValue();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return isAsc ? this.value.doubleValue() > temp.doubleValue() : temp.doubleValue() > this.value.doubleValue();
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public int getIndex() {
        return this.index;
    }
}

