/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.util.rtf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;

abstract class AbstractFilter
extends OutputStream {
    protected char[] translationTable = latin1TranslationTable;
    protected boolean[] specialsTable = noSpecialsTable;
    static final char[] latin1TranslationTable;
    static final boolean[] noSpecialsTable;
    static final boolean[] allSpecialsTable;

    public void readFromStream(InputStream in) throws IOException {
        int count;
        byte[] buf = new byte[16384];
        while ((count = in.read(buf)) >= 0) {
            this.write(buf, 0, count);
        }
    }

    public void readFromReader(Reader in) throws IOException {
        int count;
        char[] buf = new char[2048];
        while ((count = in.read(buf)) >= 0) {
            for (int i = 0; i < count; ++i) {
                this.write(buf[i]);
            }
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (b < 0) {
            b += 256;
        }
        if (this.specialsTable[b]) {
            this.writeSpecial(b);
        } else {
            char ch = this.translationTable[b];
            if (ch != '\u0000') {
                this.write(ch);
            }
        }
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        StringBuffer accumulator = null;
        while (len > 0) {
            short b = buf[off];
            if (b < 0) {
                b = (short)(b + 256);
            }
            if (this.specialsTable[b]) {
                if (accumulator != null) {
                    this.write(accumulator.toString());
                    accumulator = null;
                }
                this.writeSpecial(b);
            } else {
                char ch = (char)b;
                if (ch != '\u0000') {
                    if (accumulator == null) {
                        accumulator = new StringBuffer();
                    }
                    accumulator.append(ch);
                }
            }
            --len;
            ++off;
        }
        if (accumulator != null) {
            this.write(accumulator.toString());
        }
    }

    public void write(String s) throws IOException {
        int length = s.length();
        for (int index = 0; index < length; ++index) {
            this.write(s.charAt(index));
        }
    }

    protected abstract void write(char var1) throws IOException;

    protected abstract void writeSpecial(int var1) throws IOException;

    static {
        int i;
        noSpecialsTable = new boolean[256];
        for (i = 0; i < 256; ++i) {
            AbstractFilter.noSpecialsTable[i] = false;
        }
        allSpecialsTable = new boolean[256];
        for (i = 0; i < 256; ++i) {
            AbstractFilter.allSpecialsTable[i] = true;
        }
        latin1TranslationTable = new char[256];
        for (i = 0; i < 256; ++i) {
            AbstractFilter.latin1TranslationTable[i] = (char)i;
        }
    }
}

