/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.util.rtf;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import quadbase.reportdesigner.util.rtf.RTFAttribute;
import quadbase.reportdesigner.util.rtf.RTFGenerator;

class RTFAttributes {
    static RTFAttribute[] attributes;

    RTFAttributes() {
    }

    static Dictionary attributesByKeyword() {
        Hashtable<String, RTFAttribute> d = new Hashtable<String, RTFAttribute>(attributes.length);
        int m = attributes.length;
        for (int i = 0; i < m; ++i) {
            ((Dictionary)d).put(attributes[i].rtfName(), attributes[i]);
        }
        return d;
    }

    static {
        Vector<GenericAttribute> a = new Vector<GenericAttribute>();
        int CHR = 0;
        int PGF = 1;
        int DOC = 3;
        int PST = 4;
        Boolean True = Boolean.TRUE;
        Boolean False = Boolean.FALSE;
        a.addElement(new BooleanAttribute(CHR, StyleConstants.Italic, "i"));
        a.addElement(new BooleanAttribute(CHR, StyleConstants.Bold, "b"));
        a.addElement(new BooleanAttribute(CHR, StyleConstants.Underline, "ul"));
        a.addElement(NumericAttribute.newTwips(PGF, StyleConstants.LeftIndent, "li", 0.0f, 0));
        a.addElement(NumericAttribute.newTwips(PGF, StyleConstants.RightIndent, "ri", 0.0f, 0));
        a.addElement(NumericAttribute.newTwips(PGF, StyleConstants.FirstLineIndent, "fi", 0.0f, 0));
        a.addElement(new AssertiveAttribute(PGF, StyleConstants.Alignment, "ql", 0));
        a.addElement(new AssertiveAttribute(PGF, StyleConstants.Alignment, "qr", 2));
        a.addElement(new AssertiveAttribute(PGF, StyleConstants.Alignment, "qc", 1));
        a.addElement(new AssertiveAttribute(PGF, StyleConstants.Alignment, "qj", 3));
        a.addElement(NumericAttribute.newTwips(PGF, StyleConstants.SpaceAbove, "sa", 0));
        a.addElement(NumericAttribute.newTwips(PGF, StyleConstants.SpaceBelow, "sb", 0));
        a.addElement(new AssertiveAttribute(PST, (Object)"tab_alignment", "tqr", 1));
        a.addElement(new AssertiveAttribute(PST, (Object)"tab_alignment", "tqc", 2));
        a.addElement(new AssertiveAttribute(PST, (Object)"tab_alignment", "tqdec", 4));
        a.addElement(new AssertiveAttribute(PST, (Object)"tab_leader", "tldot", 1));
        a.addElement(new AssertiveAttribute(PST, (Object)"tab_leader", "tlhyph", 2));
        a.addElement(new AssertiveAttribute(PST, (Object)"tab_leader", "tlul", 3));
        a.addElement(new AssertiveAttribute(PST, (Object)"tab_leader", "tlth", 4));
        a.addElement(new AssertiveAttribute(PST, (Object)"tab_leader", "tleq", 5));
        a.addElement(new BooleanAttribute(CHR, "caps", "caps"));
        a.addElement(new BooleanAttribute(CHR, "outl", "outl"));
        a.addElement(new BooleanAttribute(CHR, "scaps", "scaps"));
        a.addElement(new BooleanAttribute(CHR, "shad", "shad"));
        a.addElement(new BooleanAttribute(CHR, "v", "v"));
        a.addElement(new BooleanAttribute(CHR, "strike", "strike"));
        a.addElement(new BooleanAttribute(CHR, "deleted", "deleted"));
        a.addElement(new AssertiveAttribute(DOC, (Object)"saveformat", "defformat", "RTF"));
        a.addElement(new AssertiveAttribute(DOC, "landscape", "landscape"));
        a.addElement(NumericAttribute.newTwips(DOC, "paperw", "paperw", 12240));
        a.addElement(NumericAttribute.newTwips(DOC, "paperh", "paperh", 15840));
        a.addElement(NumericAttribute.newTwips(DOC, "margl", "margl", 1800));
        a.addElement(NumericAttribute.newTwips(DOC, "margr", "margr", 1800));
        a.addElement(NumericAttribute.newTwips(DOC, "margt", "margt", 1440));
        a.addElement(NumericAttribute.newTwips(DOC, "margb", "margb", 1440));
        a.addElement(NumericAttribute.newTwips(DOC, "gutter", "gutter", 0));
        a.addElement(new AssertiveAttribute(PGF, (Object)"widowctrl", "nowidctlpar", False));
        a.addElement(new AssertiveAttribute(PGF, (Object)"widowctrl", "widctlpar", True));
        a.addElement(new AssertiveAttribute(DOC, (Object)"widowctrl", "widowctrl", True));
        Object[] attrs = new RTFAttribute[a.size()];
        a.copyInto(attrs);
        attributes = attrs;
    }

    static class NumericAttribute
    extends GenericAttribute
    implements RTFAttribute {
        int rtfDefault;
        Number swingDefault;
        float scale;

        protected NumericAttribute(int d, Object s, String r) {
            super(d, s, r);
            this.rtfDefault = 0;
            this.swingDefault = null;
            this.scale = 1.0f;
        }

        public NumericAttribute(int d, Object s, String r, int ds, int dr) {
            this(d, s, r, ds, dr, 1.0f);
        }

        public NumericAttribute(int d, Object s, String r, Number ds, int dr, float sc) {
            super(d, s, r);
            this.swingDefault = ds;
            this.rtfDefault = dr;
            this.scale = sc;
        }

        public static NumericAttribute newTwips(int d, Object s, String r, float ds, int dr) {
            return new NumericAttribute(d, s, r, Float.valueOf(ds), dr, 20.0f);
        }

        public static NumericAttribute newTwips(int d, Object s, String r, int dr) {
            return new NumericAttribute(d, s, r, null, dr, 20.0f);
        }

        @Override
        public boolean set(MutableAttributeSet target) {
            return false;
        }

        @Override
        public boolean set(MutableAttributeSet target, int parameter) {
            Number swingValue = this.scale == 1.0f ? (Number)parameter : (Number)Float.valueOf((float)parameter / this.scale);
            target.addAttribute(this.swingName, swingValue);
            return true;
        }

        @Override
        public boolean setDefault(MutableAttributeSet target) {
            Number old = (Number)target.getAttribute(this.swingName);
            if (old == null) {
                old = this.swingDefault;
            }
            if (old != null && (this.scale == 1.0f && old.intValue() == this.rtfDefault || Math.round(old.floatValue() * this.scale) == this.rtfDefault)) {
                return true;
            }
            this.set(target, this.rtfDefault);
            return true;
        }

        @Override
        public boolean writeValue(Object o_value, RTFGenerator target, boolean force) throws IOException {
            Number value = (Number)o_value;
            if (value == null) {
                value = this.swingDefault;
            }
            if (value == null) {
                return true;
            }
            int int_value = Math.round(value.floatValue() * this.scale);
            if (force || int_value != this.rtfDefault) {
                target.writeControlWord(this.rtfName, int_value);
            }
            return true;
        }
    }

    static class AssertiveAttribute
    extends GenericAttribute
    implements RTFAttribute {
        Object swingValue;

        public AssertiveAttribute(int d, Object s, String r) {
            super(d, s, r);
            this.swingValue = Boolean.TRUE;
        }

        public AssertiveAttribute(int d, Object s, String r, Object v) {
            super(d, s, r);
            this.swingValue = v;
        }

        public AssertiveAttribute(int d, Object s, String r, int v) {
            super(d, s, r);
            this.swingValue = v;
        }

        @Override
        public boolean set(MutableAttributeSet target) {
            if (this.swingValue == null) {
                target.removeAttribute(this.swingName);
            } else {
                target.addAttribute(this.swingName, this.swingValue);
            }
            return true;
        }

        @Override
        public boolean set(MutableAttributeSet target, int parameter) {
            return false;
        }

        @Override
        public boolean setDefault(MutableAttributeSet target) {
            target.removeAttribute(this.swingName);
            return true;
        }

        @Override
        public boolean writeValue(Object value, RTFGenerator target, boolean force) throws IOException {
            if (value == null) {
                return !force;
            }
            if (value.equals(this.swingValue)) {
                target.writeControlWord(this.rtfName);
                return true;
            }
            return !force;
        }
    }

    static class BooleanAttribute
    extends GenericAttribute
    implements RTFAttribute {
        boolean rtfDefault;
        boolean swingDefault;
        protected static final Boolean True = Boolean.TRUE;
        protected static final Boolean False = Boolean.FALSE;

        public BooleanAttribute(int d, Object s, String r, boolean ds, boolean dr) {
            super(d, s, r);
            this.swingDefault = ds;
            this.rtfDefault = dr;
        }

        public BooleanAttribute(int d, Object s, String r) {
            super(d, s, r);
            this.swingDefault = false;
            this.rtfDefault = false;
        }

        @Override
        public boolean set(MutableAttributeSet target) {
            target.addAttribute(this.swingName, True);
            return true;
        }

        @Override
        public boolean set(MutableAttributeSet target, int parameter) {
            Boolean value = parameter != 0 ? True : False;
            target.addAttribute(this.swingName, value);
            return true;
        }

        @Override
        public boolean setDefault(MutableAttributeSet target) {
            if (this.swingDefault != this.rtfDefault || target.getAttribute(this.swingName) != null) {
                target.addAttribute(this.swingName, this.rtfDefault);
            }
            return true;
        }

        @Override
        public boolean writeValue(Object o_value, RTFGenerator target, boolean force) throws IOException {
            Boolean val = o_value == null ? Boolean.valueOf(this.swingDefault) : (Boolean)o_value;
            if (force || val != this.rtfDefault) {
                if (val.booleanValue()) {
                    target.writeControlWord(this.rtfName);
                } else {
                    target.writeControlWord(this.rtfName, 0);
                }
            }
            return true;
        }
    }

    static abstract class GenericAttribute {
        int domain;
        Object swingName;
        String rtfName;

        protected GenericAttribute(int d, Object s, String r) {
            this.domain = d;
            this.swingName = s;
            this.rtfName = r;
        }

        public int domain() {
            return this.domain;
        }

        public Object swingName() {
            return this.swingName;
        }

        public String rtfName() {
            return this.rtfName;
        }

        abstract boolean set(MutableAttributeSet var1);

        abstract boolean set(MutableAttributeSet var1, int var2);

        abstract boolean setDefault(MutableAttributeSet var1);

        public boolean write(AttributeSet source, RTFGenerator target, boolean force) throws IOException {
            return this.writeValue(source.getAttribute(this.swingName), target, force);
        }

        public boolean writeValue(Object value, RTFGenerator target, boolean force) throws IOException {
            return false;
        }
    }
}

