/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.util.rtf;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.report.Formula;
import quadbase.reportdesigner.report.NewFormulaParser;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportGraphics;
import quadbase.reportdesigner.util.IFormat;
import quadbase.reportdesigner.util.LocaleDateTimeFormat;
import quadbase.reportdesigner.util.rtf.RTFEditorKit;
import quadbase.reportdesigner.util.rtf.RTFStyledDocument;

public class RTFUtil {
    public static RTFStyledDocument getDocument(byte[] barray, Object[] formatMap) {
        RTFStyledDocument document;
        block10: {
            document = null;
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(barray);
                document = new RTFStyledDocument();
                new RTFEditorKit().read(in, (Document)document, 0);
                document.remove(document.getLength() - 1, 1);
                ((InputStream)in).close();
            }
            catch (Exception ex) {
                document = null;
            }
            try {
                if (document == null) break block10;
                int formatIndex = 0;
                String text = document.getText(0, document.getLength());
                int beginIndex = 0;
                boolean first = true;
                while (beginIndex >= 0) {
                    String cur = "";
                    int nextIndex = text.indexOf("<%", beginIndex);
                    cur = nextIndex < 0 ? text.substring(beginIndex) : text.substring(beginIndex, nextIndex);
                    int endIndex = cur.indexOf("%>");
                    if (!first && endIndex >= 0) {
                        endIndex += beginIndex;
                        String formula = "";
                        try {
                            formula = text.substring(beginIndex, endIndex).trim();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (!formula.equals("")) {
                            SimpleAttributeSet aSet = new SimpleAttributeSet();
                            Object ft = "None";
                            if (formatMap != null && formatIndex < formatMap.length && formatMap[formatIndex] != null) {
                                ft = formatMap[formatIndex];
                            }
                            aSet.addAttribute("Data Format", ft);
                            ++formatIndex;
                            document.setCharacterAttributes(beginIndex - 2, endIndex - beginIndex + 4, aSet, false);
                        }
                    }
                    beginIndex = nextIndex < 0 ? -1 : nextIndex + 2;
                    if (!first) continue;
                    first = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return document;
    }

    public static RTFStyledDocument getFormulatedDocument(byte[] array, Object[] formatMap, Vector<Object[]> formats, Report mainreport, ReportTable tbl) throws Exception {
        RTFStyledDocument document = RTFUtil.getDocument(array, formatMap);
        if (document != null) {
            String text = document.getText(0, document.getLength());
            int beginIndex = 0;
            int textbeginIndex = 0;
            boolean first = true;
            while (beginIndex >= 0) {
                String cur = "";
                int nextIndex = text.indexOf("<%", beginIndex);
                cur = nextIndex < 0 ? text.substring(beginIndex) : text.substring(beginIndex, nextIndex);
                int endIndex = cur.indexOf("%>");
                if (!first && endIndex >= 0) {
                    endIndex += beginIndex;
                    String formula = "";
                    try {
                        formula = text.substring(beginIndex, endIndex).trim();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!formula.equals("")) {
                        AttributeSet aSet = document.getCharacterElement(textbeginIndex).getAttributes();
                        Object obj = null;
                        try {
                            Vector<Vector<Formula>> formulaVec = new Vector<Vector<Formula>>();
                            formulaVec.add(mainreport.formulas);
                            for (int j = 0; mainreport.subReports != null && j < mainreport.subReports.size(); ++j) {
                                Report rpt = mainreport.getSubReportArray()[j];
                                if (rpt == null) continue;
                                formulaVec.add(rpt.formulas);
                            }
                            ByteArrayInputStream inputStream = new ByteArrayInputStream(formula.getBytes("UTF-8"));
                            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                            NewFormulaParser parser = new NewFormulaParser(inputStreamReader);
                            Formula form = new Formula(formula, formula);
                            form.setFormula(parser.parse(formulaVec, mainreport.getQueryParameters(), mainreport.getFormulaParameters(), form.getName()));
                            obj = form.getValue(tbl, 0, 1, 1, 1, 1, mainreport, new ReportCell(), new Object());
                            IFormat format = RTFUtil.getFormat((String)aSet.getAttribute("Data Format"), formats);
                            if (format != null) {
                                if (format instanceof LocaleDateTimeFormat) {
                                    int datatype = DataType.mapType(form.getSQLType());
                                    if (datatype == 9) {
                                        format = LocaleDateTimeFormat.getTimeInstance(((LocaleDateTimeFormat)format).getTimeStyle());
                                    } else if (datatype == 8) {
                                        format = LocaleDateTimeFormat.getDateInstance(((LocaleDateTimeFormat)format).getDateStyle());
                                    }
                                }
                                obj = format.format(obj);
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        if (obj == null) {
                            obj = "";
                        }
                        document.remove(textbeginIndex, endIndex - beginIndex + 4);
                        document.insertString(textbeginIndex, obj.toString(), aSet);
                        textbeginIndex += obj.toString().length();
                    } else {
                        document.remove(textbeginIndex, endIndex - beginIndex + 4);
                    }
                    textbeginIndex = textbeginIndex + cur.length() - endIndex + beginIndex - 2;
                } else {
                    textbeginIndex += cur.length();
                }
                beginIndex = nextIndex < 0 ? -1 : nextIndex + 2;
                if (!first) continue;
                first = false;
            }
        }
        return document;
    }

    private static IFormat getFormat(String name, Vector<Object[]> formats) {
        if (formats == null) {
            return null;
        }
        for (int i = 0; i < formats.size(); ++i) {
            Object[] f = formats.elementAt(i);
            if (!f[0].equals(name)) continue;
            return (IFormat)f[1];
        }
        return null;
    }

    public static String getFullText(byte[] array, Object[] formatMap, Vector<Object[]> formats, Report report, ReportTable tbl) {
        try {
            RTFStyledDocument document = RTFUtil.getFormulatedDocument(array, formatMap, formats, report, tbl);
            return document.getText(0, document.getLength());
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static Vector<Vector<Object[]>> breakRichText(byte[] array, Object[] formatMap, Vector<Object[]> formats, Report mainreport, ReportTable tbl, int width, Graphics graphics, boolean forHTML, ReportGraphics reportGraphics) throws Exception {
        RTFStyledDocument document = RTFUtil.getFormulatedDocument(array, formatMap, formats, mainreport, tbl);
        Hashtable<String, FontMetrics> fontTable = new Hashtable<String, FontMetrics>();
        if (document.getLength() == 0) {
            return new Vector<Vector<Object[]>>();
        }
        Vector<Vector<Object[]>> rows = new Vector<Vector<Object[]>>();
        AttributeSet attributes = null;
        AttributeSet old_attr = null;
        String runningText = "";
        int remainingWidth = width;
        for (int i = 0; i <= document.getLength(); ++i) {
            block16: {
                block17: {
                    block18: {
                        attributes = i < document.getLength() ? (document.getText(i, 1).equals("\t") ? null : document.getCharacterElement(i).getAttributes()) : null;
                        if (old_attr != null && attributes != null && attributes.isEqual(old_attr)) break block16;
                        if (runningText.length() <= 0 || old_attr == null) break block17;
                        if (StyleConstants.getIcon(old_attr) == null) break block18;
                        Icon icon = StyleConstants.getIcon(old_attr);
                        if (!(icon instanceof ImageIcon)) break block17;
                        Image image = ((ImageIcon)icon).getImage();
                        Object[] segment = new Object[4];
                        int imageWidth = image.getWidth(null);
                        segment[0] = image;
                        segment[1] = imageWidth;
                        segment[2] = image.getHeight(null);
                        segment[3] = null;
                        if (imageWidth <= remainingWidth && rows.size() > 0) {
                            rows.elementAt(rows.size() - 1).addElement(segment);
                            remainingWidth -= imageWidth;
                        } else {
                            Vector<Object[]> row = new Vector<Object[]>();
                            row.addElement(segment);
                            rows.addElement(row);
                            remainingWidth = width - imageWidth;
                        }
                        if (remainingWidth >= 0) break block17;
                        remainingWidth = 0;
                        break block17;
                    }
                    int style = 0;
                    if (StyleConstants.isBold(old_attr)) {
                        ++style;
                    }
                    if (StyleConstants.isItalic(old_attr)) {
                        style += 2;
                    }
                    Font font = new Font(StyleConstants.getFontFamily(old_attr), style, StyleConstants.getFontSize(old_attr));
                    Color fontColor = StyleConstants.getForeground(old_attr);
                    boolean underline = StyleConstants.isUnderline(old_attr);
                    FontMetrics fontMetrics = (FontMetrics)fontTable.get(font.getName() + ":" + font.getSize() + ":" + font.getStyle());
                    if (fontMetrics == null) {
                        String hashString = font.getFontName() + ":" + font.getSize() + ":" + font.getStyle();
                        if (reportGraphics != null) {
                            String sampleText = runningText;
                            if (sampleText.length() > 10) {
                                sampleText = sampleText.substring(0, 10);
                            }
                            if (sampleText.length() == 0) {
                                sampleText = "abcdefghimk";
                            }
                            font = reportGraphics.resizeFont(font, sampleText);
                        }
                        fontMetrics = graphics.getFontMetrics(font);
                        fontTable.put(hashString, fontMetrics);
                    }
                    int resizedFontSize = QbUtil.resizeViewerFont(font.getSize(), mainreport.isAdjustFont());
                    Font resizedViewerFont = new Font(font.getName(), font.getStyle(), resizedFontSize);
                    FontMetrics newFM = graphics.getFontMetrics(resizedViewerFont);
                    Vector<Object> vec = ReportGraphics.tokenizer(runningText, newFM, width, remainingWidth, false);
                    remainingWidth = (Integer)vec.elementAt(1);
                    String[] lines = (String[])vec.elementAt(0);
                    for (int j = 0; j < lines.length; ++j) {
                        Object[] segment = new Object[]{lines[j], fontMetrics, fontColor, underline};
                        if (j == 0 && rows.size() > 0) {
                            rows.elementAt(rows.size() - 1).addElement(segment);
                            continue;
                        }
                        Vector<Object[]> row = new Vector<Object[]>();
                        row.addElement(segment);
                        rows.addElement(row);
                    }
                }
                if (i < document.getLength()) {
                    if (document.getText(i, 1).equals("\t")) {
                        runningText = "       ";
                        attributes = new SimpleAttributeSet();
                        String fontN = "Monospaced";
                        if (forHTML) {
                            fontN = "Courier";
                        }
                        StyleConstants.setFontFamily((SimpleAttributeSet)attributes, fontN);
                        StyleConstants.setFontSize((SimpleAttributeSet)attributes, 12);
                        StyleConstants.setUnderline((SimpleAttributeSet)attributes, StyleConstants.isUnderline(document.getCharacterElement(i).getAttributes()));
                    } else {
                        runningText = document.getText(i, 1);
                    }
                }
                old_attr = attributes;
                continue;
            }
            runningText = runningText + document.getText(i, 1);
        }
        return rows;
    }

    public static Object[] getFormatMap(RTFStyledDocument document) {
        Vector<Object> formatMap;
        block8: {
            formatMap = new Vector<Object>();
            try {
                if (document == null) break block8;
                String text = document.getText(0, document.getLength());
                int beginIndex = 0;
                boolean first = true;
                while (beginIndex >= 0) {
                    String cur = "";
                    int nextIndex = text.indexOf("<%", beginIndex);
                    cur = nextIndex < 0 ? text.substring(beginIndex) : text.substring(beginIndex, nextIndex);
                    int endIndex = cur.indexOf("%>");
                    if (!first && endIndex >= 0) {
                        endIndex += beginIndex;
                        String formula = "";
                        try {
                            formula = text.substring(beginIndex, endIndex).trim();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (!formula.equals("")) {
                            AttributeSet aSet = document.getCharacterElement(beginIndex - 2).getAttributes();
                            formatMap.addElement(aSet.getAttribute("Data Format"));
                        }
                    }
                    beginIndex = nextIndex < 0 ? -1 : nextIndex + 2;
                    if (!first) continue;
                    first = false;
                }
            }
            catch (Exception text) {
                // empty catch block
            }
        }
        Object[] ret = new Object[formatMap.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = formatMap.elementAt(i);
        }
        return ret;
    }

    public static int getTotalRowWidth(Report report, Graphics graphics, Vector segments) {
        int totalWidth = 0;
        for (int j = 0; j < segments.size(); ++j) {
            Object[] seg = (Object[])segments.elementAt(j);
            if (seg[0] != null && seg[0] instanceof Image) {
                totalWidth += ((Integer)seg[1]).intValue();
                continue;
            }
            FontMetrics fontMetrics = QbUtil.getViewerFontMetrics((FontMetrics)seg[1], report.isAdjustFont());
            String text = (String)seg[0];
            totalWidth += (int)fontMetrics.getStringBounds(text, graphics).getWidth();
        }
        return totalWidth;
    }

    public static int getXForSingleRow(Report report, Graphics graphics, int x, int elementWidth, Vector segments, int align) {
        if (align == 1) {
            return x;
        }
        int totalWidth = RTFUtil.getTotalRowWidth(report, graphics, segments);
        if (align == 0) {
            return x + (elementWidth - totalWidth) / 2;
        }
        if (align == 2) {
            return x + elementWidth - totalWidth;
        }
        return x;
    }
}

