/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportutil;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import quadbase.common.client.ServerMessage;
import quadbase.common.server.DBRefresh;
import quadbase.common.server.Server;
import quadbase.common.util.internal.LanguageEncoder;

public class EspressManager {
    Server server;
    ServletContext context;
    static String ESMANAGER = "ESPRESSMANAGER";
    boolean serverIsOn = false;
    private static final String NA = LanguageEncoder.getText("N/A");

    public void setLanguageEncoding(String fileName, String enc) {
        try {
            if (fileName == null || fileName.trim().equals("")) {
                return;
            }
            if (enc == null || fileName.trim().equals("enc")) {
                return;
            }
            LanguageEncoder.load(fileName, enc);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void processRequest(HttpServletRequest request, ServletContext context) throws Exception {
        this.context = context;
        this.serverIsOn = this.checkServerOn();
        String switchBut = request.getParameter("SWITCH");
        if (switchBut != null) {
            if (switchBut.equalsIgnoreCase("OFF")) {
                if (this.serverIsOn) {
                    this.stopServer();
                }
                this.serverIsOn = false;
            } else if (switchBut.equalsIgnoreCase("ON")) {
                if (!this.serverIsOn) {
                    this.startServer(request);
                }
                this.serverIsOn = true;
            }
        }
        if (this.serverIsOn) {
            String cleanupBut = request.getParameter("CLEANBUFFERS");
            if (cleanupBut != null && cleanupBut.equalsIgnoreCase("YES")) {
                System.out.println("ESPRESSMANAGER - CLEAN UP BUFFERS NOW...");
                this.server.getConnectionBuffer().refreshAll();
            }
            if (request.getParameter("DAY") != null) {
                System.out.println("ESPRESSMANAGER - CHANGING SETTINGS...");
                int iday = this.getInt(request.getParameter("DAY"));
                int ihour = this.getInt(request.getParameter("HOUR"));
                int imin = this.getInt(request.getParameter("MINUTE"));
                if (iday + ihour + imin == 0) {
                    ihour = 0;
                    iday = 0;
                    imin = 1;
                }
                DBRefresh.day = iday;
                DBRefresh.hour = ihour;
                DBRefresh.minute = imin;
            }
        }
    }

    private int getInt(String str) {
        if (str.trim().equals("")) {
            return 0;
        }
        return Integer.valueOf(str);
    }

    public boolean isServerOn() {
        return this.serverIsOn;
    }

    public String getStatus() {
        if (this.isServerOn()) {
            return LanguageEncoder.getText("EspressManager is running");
        }
        return LanguageEncoder.getText("EspressManager is not running");
    }

    public String getBuffers() {
        if (!this.isServerOn()) {
            return NA;
        }
        return Server.nBuffer + "";
    }

    public String getDay() {
        if (!this.isServerOn()) {
            return NA;
        }
        if (Server.dbr == null) {
            return NA;
        }
        return DBRefresh.day + "";
    }

    public String getHour() {
        if (!this.isServerOn()) {
            return NA;
        }
        if (Server.dbr == null) {
            return NA;
        }
        return DBRefresh.hour + "";
    }

    public String getMinute() {
        if (!this.isServerOn()) {
            return NA;
        }
        if (Server.dbr == null) {
            return NA;
        }
        return DBRefresh.minute + "";
    }

    public String getStartButton() {
        if (this.isServerOn()) {
            return "<img src=\"Web_Component/ESPRESSMANAGER/Start_NA.gif\">";
        }
        return "<a href=\"EspressManager.jsp?SWITCH=ON\"><img src=\"Web_Component/ESPRESSMANAGER/Start.gif\" border=0></a>";
    }

    public String getStopButton() {
        if (!this.isServerOn()) {
            return "<img src=\"Web_Component/ESPRESSMANAGER/ShutDown_NA.gif\">";
        }
        return "<a href=\"EspressManager.jsp?SWITCH=OFF\"><img src=\"Web_Component/ESPRESSMANAGER/ShutDown.gif\" border=0></a>";
    }

    public String getChangeSettingsButton() {
        if (!this.isServerOn()) {
            return "<img src=\"Web_Component/ESPRESSMANAGER/ChangeSettings_NA.gif\">";
        }
        return "<input type=\"image\" name=\"submit\" src=\"Web_Component/ESPRESSMANAGER/ChangeSettings.gif\" border=0>";
    }

    public String getCleanBuffersButton() {
        if (!this.isServerOn()) {
            return "<img src=\"Web_Component/ESPRESSMANAGER/CleanBuffers_NA.gif\">";
        }
        return "<a href=\"EspressManager.jsp?CLEANBUFFERS=YES\"><img src=\"Web_Component/ESPRESSMANAGER/CleanBuffers.gif\" border=0></a>";
    }

    public void startServer(HttpServletRequest req) {
        if (this.server != null) {
            return;
        }
        Object obj = this.context.getAttribute(ESMANAGER);
        if (obj == null) {
            String serverName = req.getServerName();
            int port = req.getServerPort();
            String protocol = req.getScheme() + "://";
            String portStr = "";
            if (port != 80) {
                portStr = ":" + port;
            }
            ServerMessage.setConnectServlet(protocol + serverName + portStr);
            ServerMessage.startServletServer();
            this.server = new Server();
            this.server.initServer(this.server, new String[]{"-monitor:OFF", "-DBCleanAll:000800"});
            this.context.setAttribute(ESMANAGER, (Object)this.server);
        } else {
            this.server = (Server)obj;
        }
    }

    public void stopServer() {
        if (!this.isServerOn()) {
            return;
        }
        this.server.stopServer();
        ServerMessage.stopServletServer();
        this.server = null;
        this.context.removeAttribute(ESMANAGER);
    }

    private boolean checkServerOn() {
        if (this.server != null) {
            return true;
        }
        Object obj = this.context.getAttribute(ESMANAGER);
        if (obj != null) {
            this.server = (Server)obj;
        }
        return this.server != null;
    }

    public void destroy() {
        System.out.println("DESTROY................................");
        Object obj = this.context.getAttribute(ESMANAGER);
        if (obj != null) {
            this.stopServer();
        }
    }

    public String getEncodeText(String str) {
        return LanguageEncoder.getText(str);
    }
}

