/*
 * Decompiled with CFR 0.152.
 */
package quadbase.scheduler;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.scheduler.PackageDialog;
import quadbase.scheduler.RecipientsPanel;
import quadbase.scheduler.Scheduler;
import quadbase.scheduler.UserGroupPanel;

public class BrowseUserGroupDialog
extends JDialog
implements ActionListener {
    private Scheduler organizer;
    JButton addBut;
    JButton closeBut;
    UserGroupPanel ugPanel;
    RecipientsPanel recipientsPanel;
    private boolean enableMultiSelection = false;
    private Vector previousSelectionList = null;

    public BrowseUserGroupDialog(Scheduler og, PackageDialog packageDialog, RecipientsPanel prevPanel) {
        super(packageDialog, LanguageEncoder.getText("Previous Emails"), true);
        this.organizer = og;
        this.recipientsPanel = prevPanel;
        this.enableMultiSelection = true;
        this.previousSelectionList = packageDialog.collectRecipientEmailAddresses();
        this.init();
        this.setPosition();
    }

    void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    void init() {
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.ugPanel = new UserGroupPanel(this.enableMultiSelection, this.previousSelectionList);
        this.ugPanel.setParentDialog(this);
        contentPane.add("Center", this.ugPanel);
        JPanel butPanel = new JPanel();
        butPanel.setLayout(new GridLayout(1, 2, 5, 5));
        this.addBut = new JButton(LanguageEncoder.getText("Add"));
        this.closeBut = new JButton(LanguageEncoder.getText("Close"));
        this.addBut.addActionListener(this);
        this.closeBut.addActionListener(this);
        butPanel.add(this.addBut);
        butPanel.add(this.closeBut);
        contentPane.add("South", butPanel);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        if (target == this.closeBut) {
            this.setVisible(false);
            this.dispose();
        } else if (target == this.addBut) {
            if (this.recipientsPanel != null) {
                Object[] owners = this.ugPanel.getSelectedObjects();
                this.recipientsPanel.addToAddresses(owners);
                return;
            }
            Object owner = this.ugPanel.getSelectedObject();
            if (owner == null) {
                new JMessageDialog((Frame)this.organizer.getFrame(), LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please slect a user/ group first"));
                return;
            }
        }
    }
}

