/*
 * Decompiled with CFR 0.152.
 */
package quadbase.scheduler;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import quadbase.common.swing.UndoTextArea;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.scheduler.PackageDialog;
import quadbase.scheduler.PackageObject;
import quadbase.scheduler.ScheduleObject;

public class DeliveryOptionPanel
extends JPanel
implements ActionListener,
ItemListener {
    private JButton ok;
    private JButton cancel;
    private JButton back;
    private JButton done;
    private JRadioButton asAttachmentButton;
    private JRadioButton asLinkButton;
    private JRadioButton asHTMLButton;
    private JTextField fromField;
    private JTextField addressField;
    private JTextField subjectField;
    private UndoTextArea bodyTextArea;
    private JTextField urlMappingField;
    private JCheckBox sendEmail;
    private JTextField subjectField2;
    private UndoTextArea bodyTextArea2;
    private boolean isBack = false;
    private JCheckBox emailErrorLog;
    private JTextField emailLogAddr;
    private boolean isCancel = false;
    private PackageDialog pDialog;
    private boolean popWarning = false;
    private ScheduleObject schObj;

    public DeliveryOptionPanel(PackageDialog pDialog, ScheduleObject schObj) {
        this.schObj = schObj;
        this.pDialog = pDialog;
        this.init();
    }

    void init() {
        this.setLayout(new BorderLayout());
        JPanel successPanel = new JPanel();
        successPanel.setLayout(new BoxLayout(successPanel, 1));
        JPanel infoPanel = new JPanel();
        infoPanel.setBorder(new TitledBorder(LanguageEncoder.getText("General Email Infomation:")));
        infoPanel.setLayout(new BorderLayout());
        JPanel infoPanelWest = new JPanel(new GridLayout(3, 1, 5, 5));
        JPanel infoPanelCenter = new JPanel(new GridLayout(3, 1, 5, 5));
        JLabel fromLbl = new JLabel(LanguageEncoder.getText("From:"));
        JLabel subjectLbl = new JLabel(LanguageEncoder.getText("Subject:"));
        this.fromField = new JTextField("", 30);
        this.addressField = new JTextField("", 30);
        this.subjectField = new JTextField("", 30);
        infoPanelWest.add(fromLbl);
        infoPanelWest.add(subjectLbl);
        infoPanelCenter.add(this.fromField);
        infoPanelCenter.add(this.subjectField);
        infoPanel.add("West", infoPanelWest);
        infoPanel.add("Center", infoPanelCenter);
        JPanel bodyTextPanel = new JPanel();
        bodyTextPanel.setLayout(new FlowLayout(0));
        bodyTextPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Email Body Text:")));
        JLabel bodyTextLbl = new JLabel(LanguageEncoder.getText("Body Text:"));
        bodyTextLbl.setAlignmentY(0.5f);
        this.bodyTextArea = new UndoTextArea(7, 70);
        this.bodyTextArea.setLineWrap(true);
        this.bodyTextArea.setText("");
        JScrollPane textAreaPanel = new JScrollPane(20, 31);
        textAreaPanel.getViewport().add(this.bodyTextArea);
        bodyTextPanel.add(bodyTextLbl);
        bodyTextPanel.add(textAreaPanel);
        JPanel optionPanel = new JPanel();
        optionPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Email Option...")));
        optionPanel.setLayout(new BorderLayout());
        JPanel radioButtonPanel = new JPanel();
        radioButtonPanel.setLayout(new FlowLayout(0));
        this.asAttachmentButton = new JRadioButton(LanguageEncoder.getText("As Attachment"), true);
        this.asLinkButton = new JRadioButton(LanguageEncoder.getText("As Link"), false);
        this.asHTMLButton = new JRadioButton(LanguageEncoder.getText("As HTML"), false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.asAttachmentButton);
        group.add(this.asLinkButton);
        if (!(this.schObj instanceof PackageObject)) {
            group.add(this.asHTMLButton);
        }
        radioButtonPanel.add(this.asAttachmentButton);
        radioButtonPanel.add(this.asLinkButton);
        if (!(this.schObj instanceof PackageObject)) {
            radioButtonPanel.add(this.asHTMLButton);
        }
        this.asAttachmentButton.addItemListener(this);
        this.asLinkButton.addItemListener(this);
        if (!(this.schObj instanceof PackageObject)) {
            this.asHTMLButton.addItemListener(this);
        }
        JPanel urlMappingPanel = new JPanel();
        urlMappingPanel.setLayout(new FlowLayout(0));
        JLabel urlMappingLbl = new JLabel(LanguageEncoder.getText("URL Mapping:"));
        this.urlMappingField = new JTextField(25);
        urlMappingLbl.setAlignmentY(0.5f);
        urlMappingPanel.add(urlMappingLbl);
        urlMappingPanel.add(this.urlMappingField);
        JPanel checkBoxPanel = new JPanel();
        checkBoxPanel.setLayout(new FlowLayout(0));
        this.sendEmail = new JCheckBox(LanguageEncoder.getText("Send Email"), true);
        checkBoxPanel.add(this.sendEmail);
        this.sendEmail.addItemListener(this);
        optionPanel.add("North", radioButtonPanel);
        optionPanel.add("Center", urlMappingPanel);
        optionPanel.add("South", checkBoxPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(new EmptyBorder(20, 0, 20, 0));
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        this.back = new JButton(LanguageEncoder.getText("Back"));
        this.ok = new JButton(LanguageEncoder.getText("Next"));
        this.cancel = new JButton(LanguageEncoder.getText("Cancel"));
        this.done = new JButton(LanguageEncoder.getText("Done"));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.back);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.ok);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.cancel);
        buttonPanel.add(Box.createHorizontalGlue());
        if (this.pDialog.inEditMode()) {
            buttonPanel.add(this.done);
            buttonPanel.add(Box.createHorizontalGlue());
        }
        this.back.addActionListener(this);
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        this.done.addActionListener(this);
        successPanel.add(infoPanel);
        successPanel.add(bodyTextPanel);
        successPanel.add(optionPanel);
        JPanel failPanel = new JPanel();
        failPanel.setLayout(new BorderLayout());
        JPanel infoPanel2 = new JPanel();
        infoPanel2.setBorder(new TitledBorder(LanguageEncoder.getText("General Email Infomation:")));
        infoPanel2.setLayout(new BorderLayout());
        JLabel subjectLbl2 = new JLabel(LanguageEncoder.getText("Subject:"));
        this.subjectField2 = new JTextField("", 30);
        infoPanel2.add("West", subjectLbl2);
        infoPanel2.add("Center", this.subjectField2);
        JPanel bodyTextPanel2 = new JPanel();
        bodyTextPanel2.setLayout(new BorderLayout());
        bodyTextPanel2.setBorder(new TitledBorder(LanguageEncoder.getText("Email Body Text:")));
        JLabel bodyTextLbl2 = new JLabel(LanguageEncoder.getText("Body Text:"));
        bodyTextLbl2.setAlignmentY(0.5f);
        this.bodyTextArea2 = new UndoTextArea(7, 70);
        this.bodyTextArea2.setLineWrap(true);
        this.bodyTextArea2.setText("");
        JScrollPane textAreaPanel2 = new JScrollPane(20, 31);
        textAreaPanel2.getViewport().add(this.bodyTextArea2);
        bodyTextPanel2.add("West", bodyTextLbl2);
        bodyTextPanel2.add("Center", textAreaPanel2);
        JPanel optionPanel2 = new JPanel();
        optionPanel2.setBorder(new TitledBorder(LanguageEncoder.getText("Email Error Log...")));
        optionPanel2.setLayout(new FlowLayout(0));
        this.emailErrorLog = new JCheckBox(LanguageEncoder.getText("Send Email Log To:"), false);
        optionPanel2.add(this.emailErrorLog);
        this.emailLogAddr = new JTextField(25);
        optionPanel2.add(this.emailLogAddr);
        this.emailErrorLog.addItemListener(this);
        failPanel.add("North", infoPanel2);
        failPanel.add("Center", bodyTextPanel2);
        failPanel.add("South", optionPanel2);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab(LanguageEncoder.getText("Successful Email"), successPanel);
        tabbedPane.addTab(LanguageEncoder.getText("Failed Email"), failPanel);
        this.add("Center", tabbedPane);
        this.add("South", buttonPanel);
        this.preSetValues(this.schObj);
        this.itemStateChanged(null);
    }

    void preSetValues(ScheduleObject schObj) {
        if (schObj == null) {
            return;
        }
        this.sendEmail.setSelected(schObj.isSendEmail());
        if (schObj.isSendEmail()) {
            this.fromField.setText(schObj.getFromAddress());
            this.subjectField.setText(schObj.getSubject());
            this.bodyTextArea.setText(schObj.getBodyText());
            if (schObj.getEmailType() == 2) {
                this.asHTMLButton.setSelected(true);
                this.bodyTextArea.setText("");
                this.bodyTextArea.setEnabled(false);
            } else if (schObj.getEmailType() == 1) {
                this.asLinkButton.setSelected(true);
            } else {
                this.asAttachmentButton.setSelected(true);
            }
            this.subjectField2.setText(schObj.getFailSubject());
            this.bodyTextArea2.setText(schObj.getFailBodyText());
            String errorAddr = schObj.getFailToAddress();
            if (errorAddr != null && !errorAddr.equals("")) {
                this.emailErrorLog.setSelected(true);
                this.emailLogAddr.setText(errorAddr);
            } else {
                this.emailErrorLog.setSelected(false);
            }
            this.urlMappingField.setEnabled(this.enableURLMapping());
            if (this.enableURLMapping()) {
                this.urlMappingField.setText(schObj.getURLMapping());
            }
        }
        this.asHTMLButton.setEnabled(true);
        if (schObj.getReportType() != 4) {
            if (this.asHTMLButton.isSelected()) {
                this.asAttachmentButton.setSelected(true);
                this.bodyTextArea.setEnabled(true);
            }
            this.asHTMLButton.setEnabled(false);
        }
        this.asLinkButton.setEnabled(true);
    }

    private boolean enableURLMapping() {
        return this.asLinkButton.isSelected() || this.schObj.getReportType() == 4;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.urlMappingField.setEnabled(this.enableURLMapping());
        this.fromField.setEnabled(this.sendEmail.isSelected());
        this.addressField.setEnabled(this.sendEmail.isSelected());
        this.subjectField.setEnabled(this.sendEmail.isSelected());
        this.bodyTextArea.setEnabled(this.sendEmail.isSelected());
        this.bodyTextArea.setEnabled(!this.asHTMLButton.isSelected());
        if (this.asHTMLButton.isSelected()) {
            this.bodyTextArea.setEnabled(false);
            this.bodyTextArea.setText("");
        } else {
            this.bodyTextArea.setEnabled(true);
        }
        this.emailLogAddr.setEnabled(this.emailErrorLog.isSelected());
    }

    boolean isCancel() {
        return this.isCancel;
    }

    boolean isBack() {
        return this.isBack;
    }

    boolean popWarning() {
        return this.popWarning;
    }

    void resetWarning() {
        this.popWarning = false;
    }

    void setValues(ScheduleObject schObj) {
        schObj.setSendEmail(this.sendEmail.isSelected());
        if (this.sendEmail.isSelected()) {
            schObj.setFromAddress(this.fromField.getText().trim());
            schObj.setSubject(this.subjectField.getText().trim());
            schObj.setBodyText(this.bodyTextArea.getText().trim());
        }
        if (this.asAttachmentButton.isSelected()) {
            schObj.setEmailType(0);
        }
        if (this.asLinkButton.isSelected()) {
            schObj.setEmailType(1);
        }
        if (this.asHTMLButton.isSelected()) {
            schObj.setEmailType(2);
            schObj.setBodyText("");
        }
        schObj.setFailSubject(this.subjectField2.getText().trim());
        schObj.setFailBodyText(this.bodyTextArea2.getText().trim());
        if (this.emailErrorLog.isSelected()) {
            schObj.setFailToAddress(this.emailLogAddr.getText().trim());
        } else {
            schObj.setFailToAddress("");
        }
        schObj.setURLMapping(this.urlMappingField.getText());
    }

    String[] getToAddresses(String str) {
        Vector<String> tokens = new Vector<String>();
        str = str.replace(',', ';');
        StringTokenizer token = new StringTokenizer(str, ";");
        while (token.hasMoreTokens()) {
            tokens.addElement(token.nextToken().trim());
        }
        String[] addresses = new String[tokens.size()];
        for (int i = 0; i < tokens.size(); ++i) {
            addresses[i] = (String)tokens.elementAt(i);
        }
        return addresses;
    }

    String errorCheck(String str, boolean toAddress) {
        String[] addresses;
        for (String addresse : addresses = this.getToAddresses(str)) {
            if (toAddress && (addresse.indexOf("(G)") >= 0 || addresse.indexOf("(U)") >= 0)) continue;
            boolean error = false;
            int pt1 = addresse.indexOf(64);
            int pt2 = addresse.indexOf("@", pt1 + 1);
            int pt3 = addresse.lastIndexOf(46);
            if (pt1 > 0 && pt2 == -1 && pt3 > pt1 + 1) {
                if (Character.isLetter(addresse.charAt(0))) {
                    for (int j = 1; j < addresse.length(); ++j) {
                        char c = addresse.charAt(j);
                        if (Character.isLetterOrDigit(c) || c == '.' || c == '-' || c == '_' || c == '@') continue;
                        error = true;
                        break;
                    }
                } else {
                    error = true;
                }
            } else {
                error = true;
            }
            if (!error) continue;
            return addresse + " " + LanguageEncoder.getText("is an invalid address!");
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target;
        this.popWarning = false;
        boolean switchByTab = false;
        if (e == null) {
            target = this.ok;
            switchByTab = true;
        } else {
            target = e.getSource();
        }
        this.isBack = false;
        if (target == this.back) {
            this.isBack = true;
            if (this.pDialog.enableSetParametersPanel()) {
                this.pDialog.showSetParametersPanel();
            } else {
                this.pDialog.showSetTimingPanel(true);
            }
        } else if (target == this.cancel) {
            this.isCancel = true;
            this.pDialog.setCancelled();
            this.pDialog.setVisible(false);
            this.pDialog.dispose();
        } else if (target == this.ok || target == this.done) {
            String msg = null;
            if (this.sendEmail.isSelected()) {
                if (this.fromField.getText() == null || this.fromField.getText().trim().equals("")) {
                    msg = LanguageEncoder.getText("Please enter the from address!");
                }
                if ((msg = this.errorCheck(this.fromField.getText(), false)) == null && this.emailErrorLog.isSelected()) {
                    msg = this.errorCheck(this.emailLogAddr.getText(), false);
                }
                if (msg != null) {
                    new JMessageDialog((Dialog)this.pDialog, LanguageEncoder.getText("Warning"), msg);
                    return;
                }
            }
            this.setValues(this.schObj);
            if (this.sendEmail.isSelected() && (this.schObj.getFromAddress() == null || this.schObj.getFromAddress().equals(""))) {
                msg = LanguageEncoder.getText("Please provide email information!");
            }
            if (msg != null) {
                this.popWarning = true;
                new JMessageDialog((Dialog)this.pDialog, LanguageEncoder.getText("Warning"), msg);
                return;
            }
            this.isCancel = false;
            this.pDialog.enableRecipientsPanel();
            if (target == this.done) {
                this.pDialog.showSummaryDialog();
                return;
            }
            if (!switchByTab) {
                this.pDialog.showRecipientsPanel();
            }
        }
    }
}

