/*
 * Decompiled with CFR 0.152.
 */
package quadbase.scheduler;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.scheduler.ScheduleObject;
import quadbase.scheduler.Scheduler;

public class FixedDaysDialog
extends JDialog
implements ActionListener,
ItemListener {
    private JRadioButton selDate;
    private JRadioButton selDay;
    private JTextField datesField;
    private JList daysList;
    private JButton ok;
    private JButton cancel;
    private int[] specifyDates = new int[0];
    private int[] specifyDays = new int[0];
    private boolean isCancel = false;

    public FixedDaysDialog(Scheduler scheduler) {
        super(scheduler.getFrame(), LanguageEncoder.getText("Set Fixed Days/Dates Interval"), true);
        this.init();
        this.setPosition();
    }

    void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    void init() {
        JPanel specifyDatesPanel = new JPanel();
        specifyDatesPanel.setLayout(new BorderLayout());
        this.selDate = new JRadioButton(LanguageEncoder.getText("Dates (of the month)"));
        this.selDate.setSelected(true);
        this.datesField = new JTextField();
        specifyDatesPanel.add("North", this.selDate);
        specifyDatesPanel.add("Center", this.datesField);
        JPanel specifyDaysPanel = new JPanel();
        specifyDaysPanel.setLayout(new BorderLayout());
        this.selDay = new JRadioButton(LanguageEncoder.getText("Days (of the week)"));
        this.daysList = new JList<Object>(new Object[]{LanguageEncoder.getText("Sun"), LanguageEncoder.getText("Mon"), LanguageEncoder.getText("Tue"), LanguageEncoder.getText("Wed"), LanguageEncoder.getText("Thu"), LanguageEncoder.getText("Fri"), LanguageEncoder.getText("Sat")});
        this.daysList.setBackground(Color.white);
        this.daysList.setSelectionMode(2);
        JScrollPane scrollPane = new JScrollPane(this.daysList);
        scrollPane.setBounds(0, 0, 150, 150);
        specifyDaysPanel.add("North", this.selDay);
        specifyDaysPanel.add("Center", scrollPane);
        ButtonGroup radio_gp1 = new ButtonGroup();
        radio_gp1.add(this.selDate);
        radio_gp1.add(this.selDay);
        JPanel specifyPanel = new JPanel();
        specifyPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Specify dates/days")));
        specifyPanel.setLayout(new BorderLayout());
        specifyPanel.add("North", specifyDatesPanel);
        specifyPanel.add("Center", specifyDaysPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(new EmptyBorder(20, 0, 20, 0));
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        this.ok = new JButton(LanguageEncoder.getText("OK"));
        this.cancel = new JButton(LanguageEncoder.getText("Cancel"));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.ok);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.cancel);
        buttonPanel.add(Box.createHorizontalGlue());
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        this.selDate.addItemListener(this);
        this.selDay.addItemListener(this);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", specifyPanel);
        contentPane.add("South", buttonPanel);
        this.itemStateChanged(null);
    }

    void preSetValues(ScheduleObject obj) {
        this.daysList.setSelectedIndices(obj.getSpecifyDays());
        this.datesField.setText(this.setDatesField(obj.getSpecifyDates()));
        this.itemStateChanged(null);
        this.selDay.setSelected(obj.getSpecifyDays().length > 0);
    }

    boolean isCancel() {
        return this.isCancel;
    }

    void setValues(ScheduleObject schObj) {
        schObj.setSpecifyDates(this.specifyDates);
        schObj.setSpecifyDays(this.specifyDays);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.datesField.setEnabled(this.selDate.isSelected());
        this.daysList.setEnabled(this.selDay.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        this.isCancel = true;
        if (target == this.cancel) {
            this.setVisible(false);
            this.dispose();
        } else if (target == this.ok) {
            this.isCancel = false;
            String msg = null;
            if (this.selDate.isSelected()) {
                String str = this.datesField.getText();
                if (str == null || str.trim().equals("")) {
                    msg = LanguageEncoder.getText("Please enter dates!");
                }
                try {
                    this.specifyDates = this.getSpecifyDates();
                }
                catch (Exception ex) {
                    msg = LanguageEncoder.getText("Invalid dates format!");
                }
                if (msg != null) {
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), msg);
                    return;
                }
                this.specifyDays = new int[0];
            } else {
                this.specifyDays = this.getSpecifyDays();
                if (this.specifyDays.length <= 0) {
                    msg = LanguageEncoder.getText("Please select days!");
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), msg);
                    return;
                }
                this.specifyDates = new int[0];
            }
            this.setVisible(false);
            this.dispose();
        }
    }

    private int[] getSpecifyDays() {
        return this.daysList.getSelectedIndices();
    }

    private String setDatesField(int[] tmp) {
        if (tmp == null) {
            return "";
        }
        String str = null;
        for (int element : tmp) {
            str = str == null ? element + "" : str + ", " + element;
        }
        return str;
    }

    private int[] getSpecifyDates() throws Exception {
        int maxDays = 31;
        String str = this.datesField.getText();
        if (str == null || str.trim().equals("")) {
            return new int[0];
        }
        StringTokenizer st = new StringTokenizer(str, " ,\t\n\r\f");
        int[] vals = new int[st.countTokens()];
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = Integer.parseInt(st.nextToken());
            if (vals[i] > 0 && vals[i] <= maxDays) continue;
            throw new Exception("Invalid Dates!");
        }
        return vals;
    }
}

