/*
 * Decompiled with CFR 0.152.
 */
package quadbase.scheduler;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import quadbase.common.util.BrowseDirectories;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.scheduler.DeliveryOptionPanel;
import quadbase.scheduler.PackageObject;
import quadbase.scheduler.ParamReport;
import quadbase.scheduler.ParamReportPanel;
import quadbase.scheduler.RecipientsPanel;
import quadbase.scheduler.ScheduleModifier;
import quadbase.scheduler.ScheduleObject;
import quadbase.scheduler.ScheduleReportPanel;
import quadbase.scheduler.ScheduleSummaryDialog;
import quadbase.scheduler.Scheduler;
import quadbase.scheduler.SetTimingPanel;

public class PackageDialog
extends JDialog
implements ChangeListener {
    private JTabbedPane tabbedPane;
    private JPanel firstPanel;
    private ScheduleReportPanel scheduleReportPanel;
    private String lastCheckReport;
    private SetTimingPanel setTimingPanel;
    private JTabbedPane setParametersPanel;
    private DeliveryOptionPanel deliveryOptionPanel;
    private JTabbedPane setRecipientsPanel;
    private boolean isCancelled = false;
    private Scheduler parent;
    private ScheduleObject mainSchedObj = null;
    private String securityLevel = null;
    private boolean isScheduling = true;
    private boolean inEditMode = false;
    private int selectedTab = 0;
    private boolean ignoreStateChange = false;
    private int row;
    static final int CUT = 0;
    static final int COPY = 1;
    int action = -1;
    RecipientsPanel cutRecipientsPanel = null;
    String selectedParamName = null;
    int[] cutRow = null;
    String[] tableRowPasteData = null;

    public PackageDialog(Scheduler parent) {
        super(parent.getFrame(), LanguageEncoder.getText("Create Scheduled Task"), true);
        this.parent = parent;
        this.scheduleReportPanel = new ScheduleReportPanel(parent, this);
        this.mainSchedObj = this.scheduleReportPanel.getScheduleObject();
        this.firstPanel = this.scheduleReportPanel;
        this.init();
        this.setPosition();
    }

    public PackageDialog(Scheduler parent, ScheduleObject schObj, int row) {
        super(parent.getFrame(), LanguageEncoder.getText("Edit Scheduled Task"), true);
        this.parent = parent;
        this.inEditMode = true;
        this.mainSchedObj = schObj;
        this.row = row;
        this.scheduleReportPanel = new ScheduleReportPanel(parent, this, schObj);
        this.firstPanel = this.scheduleReportPanel;
        this.init();
        this.setPosition();
    }

    void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    void init() {
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        this.setTimingPanel = new SetTimingPanel(this.parent, this, this.mainSchedObj, this.inEditMode, true);
        this.setParametersPanel = new JTabbedPane();
        this.setParametersPanel.setTabPlacement(2);
        if (this.isScheduling()) {
            this.setRecipientsPanel = new JTabbedPane();
            this.setRecipientsPanel.setTabPlacement(2);
        }
        if (!this.inEditMode) {
            this.tabbedPane.addTab(LanguageEncoder.getText("Create Task"), this.firstPanel);
            this.tabbedPane.addTab(LanguageEncoder.getText("Set Timing"), this.setTimingPanel);
            this.tabbedPane.addTab(LanguageEncoder.getText("Set Parameters"), this.setParametersPanel);
            this.tabbedPane.setEnabledAt(1, false);
            this.tabbedPane.setEnabledAt(2, false);
            if (this.isScheduling) {
                this.tabbedPane.addTab(LanguageEncoder.getText("Set Delivery Options"), new JPanel());
                this.tabbedPane.addTab(LanguageEncoder.getText("Recipients"), this.setRecipientsPanel);
                this.tabbedPane.setEnabledAt(3, false);
                this.tabbedPane.setEnabledAt(4, false);
            }
        } else {
            this.setTimingPanel = new SetTimingPanel(this.parent, this, this.mainSchedObj, this.inEditMode, true);
            this.setTimingPanel.preSetValues(this.mainSchedObj);
            try {
                this.createSetParametersPanel();
            }
            catch (Exception ex) {
                this.isCancelled = true;
            }
            this.tabbedPane.addTab(LanguageEncoder.getText("Create Task"), this.firstPanel);
            this.tabbedPane.addTab(LanguageEncoder.getText("Set Timing"), this.setTimingPanel);
            this.tabbedPane.addTab(LanguageEncoder.getText("Set Parameters"), this.setParametersPanel);
            if (this.isScheduling) {
                this.deliveryOptionPanel = new DeliveryOptionPanel(this, this.mainSchedObj);
                this.deliveryOptionPanel.preSetValues(this.mainSchedObj);
                this.tabbedPane.addTab(LanguageEncoder.getText("Set Delivery Options"), this.deliveryOptionPanel);
                this.tabbedPane.addTab(LanguageEncoder.getText("Recipients"), this.setRecipientsPanel);
                this.enableRecipientsPanel();
            }
            this.enableSetParametersPanel();
        }
        contentPane.add("Center", this.tabbedPane);
        this.tabbedPane.addChangeListener(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PackageDialog.this.isCancelled = true;
            }
        });
    }

    ScheduleObject getScheduleObject() {
        return this.mainSchedObj;
    }

    void setScheduleObject(ScheduleObject obj) {
        this.mainSchedObj = obj;
    }

    boolean isScheduling() {
        return this.isScheduling;
    }

    @Override
    public void setVisible(boolean b) {
        if (b && this.isCancelled()) {
            return;
        }
        super.setVisible(b);
    }

    boolean inEditMode() {
        return this.inEditMode;
    }

    boolean isTabbedPanelEnabled(int idx) {
        if (idx >= this.tabbedPane.getTabCount()) {
            return false;
        }
        return this.tabbedPane.isEnabledAt(idx);
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void setCancelled() {
        this.isCancelled = true;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int newIdx = this.tabbedPane.getSelectedIndex();
        if (this.ignoreStateChange) {
            this.selectedTab = newIdx;
            return;
        }
        if (this.selectedTab == newIdx) {
            return;
        }
        switch (this.selectedTab) {
            case 0: {
                if (this.scheduleReportPanel == null) break;
                this.scheduleReportPanel.actionPerformed(null);
                if (!this.scheduleReportPanel.popWarning()) break;
                this.scheduleReportPanel.resetWarning();
                this.tabbedPane.setSelectedIndex(0);
                return;
            }
            case 1: {
                this.setTimingPanel.actionPerformed(null);
                if (!this.setTimingPanel.popWarning()) break;
                this.setTimingPanel.resetWarning();
                this.tabbedPane.setSelectedIndex(1);
                return;
            }
            case 2: {
                if (this.setValuesForParameterTab()) break;
                this.tabbedPane.setSelectedIndex(2);
                return;
            }
            case 3: {
                this.deliveryOptionPanel.actionPerformed(null);
                if (!this.deliveryOptionPanel.popWarning()) break;
                this.deliveryOptionPanel.resetWarning();
                this.tabbedPane.setSelectedIndex(3);
                return;
            }
            case 4: {
                this.setValuesForRecipientTab();
            }
        }
        this.selectedTab = newIdx;
        switch (newIdx) {
            case 2: {
                this.showSetParametersPanel();
                break;
            }
            case 3: {
                this.showDeliveryOptionsPanel();
                break;
            }
            case 4: {
                if (this.createRecipientsPanel()) {
                    this.tabbedPane.setSelectedComponent(this.setRecipientsPanel);
                    break;
                }
                this.selectedTab = 3;
                this.tabbedPane.setSelectedIndex(3);
            }
        }
    }

    public boolean errorCheck() {
        if (!this.setValuesForParameterTab()) {
            this.selectedTab = 2;
            this.tabbedPane.setSelectedIndex(2);
            return false;
        }
        return true;
    }

    public void showSetTimingPanel(boolean isBack) {
        if (this.setTimingPanel == null) {
            this.setTimingPanel = new SetTimingPanel(this.parent, this, this.mainSchedObj, this.inEditMode, true);
            this.tabbedPane.setComponentAt(1, this.setTimingPanel);
        }
        boolean oldState = this.ignoreStateChange;
        if (isBack) {
            this.ignoreStateChange = true;
        }
        this.setTimingPanel.preSetValues(this.mainSchedObj);
        this.tabbedPane.setEnabledAt(1, true);
        this.tabbedPane.setSelectedComponent(this.setTimingPanel);
        this.ignoreStateChange = oldState;
    }

    public void showFirstPanel() {
        this.tabbedPane.setEnabledAt(0, true);
        this.tabbedPane.setSelectedComponent(this.firstPanel);
    }

    public boolean enableSetParametersPanel() {
        boolean state = this.setParametersPanel.getTabCount() > 0;
        this.tabbedPane.setEnabledAt(2, state);
        return state;
    }

    public boolean enableRecipientsPanel() {
        this.tabbedPane.setEnabledAt(4, this.mainSchedObj.isSendEmail());
        return this.mainSchedObj.isSendEmail();
    }

    public void createSetParametersPanel() throws Exception {
        this.setParametersPanel.removeAll();
        if (this.mainSchedObj instanceof PackageObject) {
            Vector<ScheduleObject> rptObjs = ((PackageObject)this.mainSchedObj).getReportScheduleObjects();
            for (int i = 0; i < rptObjs.size(); ++i) {
                ScheduleObject schObj = rptObjs.elementAt(i);
                ParamReportPanel pPanel = this.getParamReportPanel(schObj);
                if (pPanel == null) continue;
                this.setParametersPanel.addTab(this.getName(schObj), pPanel);
            }
        } else {
            ParamReportPanel pPanel = this.getParamReportPanel(this.mainSchedObj);
            if (pPanel != null) {
                this.setParametersPanel.addTab(this.getNameFromLocation(this.mainSchedObj), pPanel);
            }
        }
    }

    public void showSetParametersPanel() {
        if (this.setParametersPanel.getTabCount() > 0) {
            this.tabbedPane.setEnabledAt(2, true);
            this.tabbedPane.setSelectedComponent(this.setParametersPanel);
        } else {
            this.showDeliveryOptionsPanel();
        }
    }

    String getName(ScheduleObject schObj) {
        String location = schObj.getName();
        int idx = location.lastIndexOf(47);
        return location.substring(idx + 1);
    }

    String getNameFromLocation(ScheduleObject schObj) {
        String location = schObj.getReportLocation();
        System.out.println("ORG LOCATION = " + location);
        location = location.replace('\\', '/');
        int idx = location.lastIndexOf(47);
        if (location.toUpperCase().endsWith(".RPT") || location.toUpperCase().endsWith(".PAK") || location.toUpperCase().endsWith(".QRP") || location.toUpperCase().endsWith(".CHT") || location.toUpperCase().endsWith(".TPL") || location.toUpperCase().endsWith(".PAC") || location.toUpperCase().endsWith(".QCH") || location.toUpperCase().endsWith(".XML")) {
            location = location.substring(0, location.length() - 4);
        }
        return location.substring(idx + 1);
    }

    ParamReportPanel getParamReportPanel(ScheduleObject rptSchObj) throws Exception {
        ParamReport paramReport = new ParamReport(rptSchObj.getReportLocation(), this);
        String[] securitylevels = paramReport.getSecurityLevels();
        if (this.lastCheckReport == null || !this.lastCheckReport.equalsIgnoreCase(rptSchObj.getReportLocation())) {
            if (securitylevels.length > 0) {
                Object[] choices = new String[securitylevels.length + 1];
                choices[0] = "-- Default --";
                boolean showDialog = true;
                for (int i = 0; i < securitylevels.length; ++i) {
                    if (this.securityLevel != null && this.securityLevel.equals(securitylevels[i])) {
                        showDialog = false;
                        rptSchObj.setSecurityLevel(this.securityLevel);
                    }
                    choices[i + 1] = securitylevels[i];
                }
                if (showDialog) {
                    Object selectedValue;
                    String initialChoice = rptSchObj.getSecurityLevel();
                    if (initialChoice == null) {
                        initialChoice = "-- Default --";
                    }
                    if ((selectedValue = JOptionPane.showInputDialog(this.parent, LanguageEncoder.getText("Choose Security Level:"), LanguageEncoder.getText("Export Security Level"), 1, null, choices, initialChoice)) == null) {
                        throw new Exception("CANCEL");
                    }
                    if (selectedValue.equals("-- Default --")) {
                        rptSchObj.setSecurityLevel(null);
                    } else {
                        rptSchObj.setSecurityLevel(selectedValue.toString());
                    }
                }
            }
            this.lastCheckReport = rptSchObj.getReportLocation();
        }
        paramReport.setSecurityLevel(rptSchObj.getSecurityLevel());
        if (paramReport.containsPromptParam()) {
            return new ParamReportPanel(this.parent, this, paramReport, rptSchObj);
        }
        return null;
    }

    boolean setValuesForParameterTab() {
        JPanel panel;
        int i;
        String msg = LanguageEncoder.getText("Please insert parameter set!");
        for (i = 0; i < this.setParametersPanel.getTabCount(); ++i) {
            panel = (JPanel)this.setParametersPanel.getComponentAt(i);
            if (!(panel instanceof ParamReportPanel) || ((ParamReportPanel)panel).isParameterSet()) continue;
            this.setParametersPanel.setSelectedComponent(panel);
            new JMessageDialog((Frame)this.parent.getFrame(), LanguageEncoder.getText("Error"), msg, 6);
            return false;
        }
        for (i = 0; i < this.setParametersPanel.getTabCount(); ++i) {
            panel = (JPanel)this.setParametersPanel.getComponentAt(i);
            if (!(panel instanceof ParamReportPanel)) continue;
            ((ParamReportPanel)panel).setValues();
        }
        return true;
    }

    void goToNextParamPanel() {
        if (this.setValuesForParameterTab()) {
            this.showDeliveryOptionsPanel();
        }
    }

    void showDeliveryOptionsPanel() {
        if (!this.isScheduling) {
            this.showSummaryDialog();
            return;
        }
        if (this.deliveryOptionPanel == null) {
            this.deliveryOptionPanel = new DeliveryOptionPanel(this, this.mainSchedObj);
            this.tabbedPane.setComponentAt(3, this.deliveryOptionPanel);
        }
        this.deliveryOptionPanel.preSetValues(this.mainSchedObj);
        this.tabbedPane.setEnabledAt(3, true);
        this.tabbedPane.setSelectedComponent(this.deliveryOptionPanel);
    }

    boolean createRecipientsPanel() {
        this.setRecipientsPanel.removeAll();
        if (this.mainSchedObj instanceof PackageObject) {
            Vector<ScheduleObject> rptObjs = ((PackageObject)this.mainSchedObj).getReportScheduleObjects();
            for (int i = 0; i < rptObjs.size(); ++i) {
                ScheduleObject schObj = rptObjs.elementAt(i);
                RecipientsPanel pPanel = this.getRecipientsPanel(schObj);
                if (pPanel == null) continue;
                this.setRecipientsPanel.addTab(this.getName(schObj), pPanel);
            }
        } else if (this.mainSchedObj.isChart()) {
            RecipientsPanel pPanel = this.getRecipientsPanel(this.mainSchedObj);
            if (pPanel != null) {
                this.setRecipientsPanel.addTab(this.getNameFromLocation(this.mainSchedObj), pPanel);
            }
        } else {
            RecipientsPanel pPanel = this.getRecipientsPanel(this.mainSchedObj);
            if (pPanel != null) {
                this.setRecipientsPanel.addTab(this.getNameFromLocation(this.mainSchedObj), pPanel);
            }
        }
        if (this.setRecipientsPanel.getTabCount() > 0) {
            this.tabbedPane.setEnabledAt(4, true);
            return true;
        }
        return false;
    }

    void showRecipientsPanel() {
        if (this.createRecipientsPanel()) {
            this.tabbedPane.setSelectedComponent(this.setRecipientsPanel);
        } else {
            this.showSummaryDialog();
        }
    }

    RecipientsPanel getRecipientsPanel(ScheduleObject schObj) {
        if (this.mainSchedObj.isSendEmail()) {
            return new RecipientsPanel(this.parent, this, schObj);
        }
        return null;
    }

    void setValuesForRecipientTab() {
        for (int i = 0; i < this.setRecipientsPanel.getTabCount(); ++i) {
            RecipientsPanel panel = (RecipientsPanel)this.setRecipientsPanel.getComponentAt(i);
            panel.setValues();
        }
    }

    void copyAllForRecipientTab(String[] addr) {
        for (int i = 0; i < this.setRecipientsPanel.getTabCount(); ++i) {
            RecipientsPanel panel = (RecipientsPanel)this.setRecipientsPanel.getComponentAt(i);
            panel.copyAddresses(addr);
        }
    }

    Vector<String> collectRecipientEmailAddresses() {
        Vector<String> list = new Vector<String>();
        for (int i = 0; i < this.setRecipientsPanel.getTabCount(); ++i) {
            RecipientsPanel panel = (RecipientsPanel)this.setRecipientsPanel.getComponentAt(i);
            list = panel.collectRecipientEmailAddresses(list);
        }
        return list;
    }

    void goToNextRecipientsPanel() {
        this.setValuesForRecipientTab();
        this.showSummaryDialog();
    }

    void showSummaryDialog() {
        if (!this.errorCheck()) {
            return;
        }
        if (this.inEditMode) {
            this.mainSchedObj.resetExportTime();
        }
        new ScheduleSummaryDialog(this.parent, this.mainSchedObj, this).setVisible(true);
    }

    void setValues() {
        try {
            if (this.inEditMode) {
                this.mainSchedObj.resetExportTime();
                ScheduleModifier.modifyScheduleTask(this.mainSchedObj, this.row);
            } else {
                ScheduleModifier.addScheduleTask(this.mainSchedObj);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setSecurityLevel(String sl) {
        this.securityLevel = sl;
    }

    public String getSecurityLevel() {
        return this.securityLevel;
    }

    public void setBrowseDirectories(BrowseDirectories dir) {
        this.scheduleReportPanel.setBrowseDirectories(dir);
    }

    public void actionClear() {
        this.action = -1;
        this.cutRow = null;
        this.cutRecipientsPanel = null;
    }

    void cutOrCopyRow(int action, RecipientsPanel recipientsPanel) {
        JTable table = recipientsPanel.getAddressTable();
        if (table.getSelectedRow() < 0) {
            String msg = LanguageEncoder.getText("Please select an address first!");
            new JMessageDialog((Dialog)this, "Cut/Copy File", msg);
            return;
        }
        this.actionClear();
        if (action == 0) {
            this.tableRowPasteData = new String[table.getSelectedRowCount()];
            this.cutRecipientsPanel = recipientsPanel;
            this.selectedParamName = recipientsPanel.getSelectedParamSetName();
            this.cutRow = table.getSelectedRows();
        } else {
            this.tableRowPasteData = new String[table.getSelectedRowCount()];
        }
        this.action = action;
        int[] rows = table.getSelectedRows();
        for (int i = 0; i < this.tableRowPasteData.length; ++i) {
            this.tableRowPasteData[i] = (String)table.getModel().getValueAt(rows[i], 0);
        }
    }

    void paste(RecipientsPanel panel) {
        String[] rowData = this.tableRowPasteData;
        if (this.action == 0 && this.cutRow != null) {
            this.cutRecipientsPanel.deleteAddresses(this.selectedParamName, this.cutRow);
        }
        for (String element : rowData) {
            panel.insertAddress(element);
        }
        if (this.action == 0) {
            this.actionClear();
        }
        ((DefaultTableModel)panel.getAddressTable().getModel()).fireTableDataChanged();
        panel.getAddressTable().clearSelection();
    }
}

