/*
 * Decompiled with CFR 0.152.
 */
package quadbase.scheduler;

import java.util.Vector;
import quadbase.scheduler.ScheduleObject;

public class PackageObject
extends ScheduleObject {
    Vector<ScheduleObject> rptScheduleList = new Vector();

    public PackageObject(String name) {
        super(name, 1);
    }

    public PackageObject(PackageObject src) {
        this(src.getName());
        src.copyPackage(this);
    }

    public PackageObject(ScheduleObject sobj) {
        this(sobj.getName());
        sobj.copy(this);
        this.setPackageID(sobj.getPackageID());
    }

    @Override
    public void setID(int id) {
        super.setID(id);
        this.setPackageID(id);
    }

    public Vector<ScheduleObject> getReportScheduleObjects() {
        return this.rptScheduleList;
    }

    public Vector<String> getReportLocations() {
        Vector<String> rptLoc = new Vector<String>();
        for (int i = 0; i < this.rptScheduleList.size(); ++i) {
            rptLoc.add(this.rptScheduleList.elementAt(i).getReportLocation());
        }
        return rptLoc;
    }

    public Vector<String> getReportPaths() {
        Vector<String> rptLoc = new Vector<String>();
        for (int i = 0; i < this.rptScheduleList.size(); ++i) {
            rptLoc.add(this.rptScheduleList.elementAt(i).getName());
        }
        return rptLoc;
    }

    public int getReportCount() {
        return this.rptScheduleList.size();
    }

    public ScheduleObject getReportExportObject(int i) {
        ScheduleObject rptObj = this.rptScheduleList.elementAt(i);
        this.copy(rptObj, true);
        return rptObj;
    }

    public ScheduleObject getReportObject(int i) {
        ScheduleObject rptObj = this.rptScheduleList.elementAt(i);
        this.copy(rptObj, true);
        return rptObj;
    }

    public ScheduleObject getSubFile(int id) {
        ScheduleObject tmp = null;
        for (int i = 0; i < this.rptScheduleList.size() && (tmp = this.rptScheduleList.elementAt(i)).getID() != id; ++i) {
        }
        if (tmp == null) {
            return tmp;
        }
        this.copy(tmp, true);
        return tmp;
    }

    public void setReportList(Vector<ScheduleObject> reportList) {
        this.rptScheduleList = reportList;
    }

    public void copyPackage(PackageObject des) {
        this.copy(des);
        des.rptScheduleList = new Vector();
        for (int i = 0; i < this.rptScheduleList.size(); ++i) {
            ScheduleObject src = this.rptScheduleList.get(i);
            ScheduleObject newObj = new ScheduleObject(src);
            des.rptScheduleList.add(newObj);
        }
    }
}

