/*
 * Decompiled with CFR 0.152.
 */
package quadbase.scheduler;

import java.awt.Dialog;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JDialog;
import quadbase.common.formula.Formula;
import quadbase.common.param.Param;
import quadbase.common.param.Parameters;
import quadbase.common.paramquery.EnterParamDialog;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryMultiValueInParam;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.util.IQueryInParam;
import quadbase.common.util.IQueryMultiValueInParam;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.report.LoadReport;
import quadbase.reportdesigner.report.Report;
import quadbase.scheduler.PackageDialog;

public class ParamReport {
    private Report report;
    private boolean errorOccur = true;
    private Parameters parameters;
    public static final String QUERY_PARAM_NAME = "&QueryParamName=";
    public static final String QUERY_PARAM_SIZE = "&QueryParamSize=";
    public static final String QUERY_PARAM_VAL = "&QueryParamValue=";
    private PackageDialog pDialog;

    public ParamReport(Report report) {
        this.report = report;
        this.errorOccur = false;
    }

    ParamReport(String file, PackageDialog packageDialog) {
        if (file == null) {
            return;
        }
        if (!(file.endsWith(".rpt") || file.endsWith(".xml") || file.endsWith(".qrp") || file.endsWith(".pak"))) {
            file = file + ".rpt";
        }
        LoadReport readfile = new LoadReport();
        readfile.readOnly = true;
        readfile.setBackupDataUsed(true);
        this.pDialog = packageDialog;
        try {
            this.report = readfile.loadReportFromFile(file, null, null, true, false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.report = null;
        }
        if (this.report == null) {
            new JMessageDialog((Dialog)this.pDialog, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Cannot create report!\n"));
            return;
        }
        this.errorOccur = false;
    }

    boolean isReportCreated() {
        return !this.errorOccur;
    }

    public boolean isParamReport(String secLevel) {
        if (secLevel != null && !secLevel.equals("") && this.getParametersForSecurityLevel(secLevel) != null) {
            return false;
        }
        return this.isParamReport();
    }

    boolean promptServletPortDialog(int rptType) {
        return this.report.currentNode.getChildCount() > 0 && (rptType == 4 || rptType == 2 || rptType == 6);
    }

    boolean isParamReport() {
        return this.report.getQueryParameters() != null && this.report.getQueryParameters().size() != 0 || this.report.getFormulaParameters() != null && this.report.getFormulaParameters().size() != 0;
    }

    boolean containsPromptParam() {
        return this.report.getParametersInSequence().size() > 0;
    }

    String[] getSecurityLevels() {
        return this.report.getSecurityLevels();
    }

    String getSecurityLevel() {
        return this.report.getPreviewSecurityLevel();
    }

    void setSecurityLevel(String sl) {
        this.report.setPreviewSecurityLevel(sl);
    }

    String getParamList() {
        QueryInParam[] inParam;
        String str = "";
        Vector<QueryInParamSet> parameters = QueryFileInfo.getParameter(this.report.getQueryFileInfo());
        if (parameters == null) {
            return str;
        }
        QueryInParamSet inSet = parameters.elementAt(0);
        for (QueryInParam element : inParam = inSet.getParameter()) {
            str = str + QUERY_PARAM_NAME + element.getParamName() + QUERY_PARAM_VAL + this.toString(element);
        }
        return str;
    }

    String toString(IQueryInParam inparam) {
        Object value = inparam.getValue();
        String dateFormat = ((QueryInParam)inparam).getDateFormat();
        return this.toString(value, dateFormat);
    }

    String toString(Object value, String dateFormat) {
        if (!(value instanceof Date)) {
            return value.toString();
        }
        if (dateFormat != null) {
            SimpleDateFormat df = new SimpleDateFormat(dateFormat);
            return df.format((Date)value);
        }
        return value.toString();
    }

    String getParamList(Object[] params) {
        StringBuffer str = new StringBuffer(params.length * 128);
        Parameters parameters = this.getParameters(this.report);
        for (int i = 0; i < parameters.size(); ++i) {
            Param p = parameters.get(i);
            str.append(QUERY_PARAM_NAME);
            str.append(p.name());
            if (p.multiValue()) {
                Vector values = (Vector)params[i];
                int size = values.size();
                str.append(QUERY_PARAM_SIZE);
                str.append(size);
                Iterator it = values.iterator();
                while (it.hasNext()) {
                    str.append(QUERY_PARAM_VAL);
                    str.append(this.toString(it.next(), p.getDateFormat()));
                }
                continue;
            }
            str.append("&QueryParamSize=1");
            str.append(QUERY_PARAM_VAL);
            str.append(this.toString(params[i], p.getDateFormat()));
        }
        return str.toString();
    }

    String[] getParamName() {
        Parameters allPromptParams = this.getParameters(this.report);
        String[] paramName = new String[allPromptParams.size()];
        for (int i = 0; i < allPromptParams.size(); ++i) {
            paramName[i] = allPromptParams.get(i).name();
        }
        return paramName;
    }

    Object[] getSelectedParam(JDialog dialog) {
        return this.getSelectedParam(dialog, null);
    }

    Object[] getSelectedParam(JDialog dialog, Object[] data) {
        EnterParamDialog enterDialog = null;
        Parameters allPromptParams = this.getParameters(this.report);
        if (data != null) {
            for (int i = 0; i < allPromptParams.size(); ++i) {
                Param param = allPromptParams.get(i);
                if (param.multiValue()) {
                    if (!(data[i] instanceof Vector)) continue;
                    param.setValues((Vector)data[i]);
                    continue;
                }
                if (param.getValueVariable() != null) {
                    if (!(data[i] instanceof Formula)) continue;
                    param.setValueVariable((Formula)data[i]);
                    continue;
                }
                param.setValue(data[i]);
            }
        }
        if (allPromptParams.size() > 0) {
            enterDialog = new EnterParamDialog(dialog, this.report, null, this.report.getFormulaParameters(), -1, true, null, null, data == null);
            enterDialog.setVisible(true);
            if (enterDialog.isCancelled()) {
                return null;
            }
        }
        if (enterDialog != null) {
            allPromptParams = enterDialog.getParameterValue();
        }
        Object[] values = new Object[allPromptParams.size()];
        for (int i = 0; i < allPromptParams.size(); ++i) {
            Param param = allPromptParams.get(i);
            if (param.multiValue()) {
                values[i] = param.getValues();
                if (values[i] != null) continue;
                new JMessageDialog((Dialog)dialog, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Please select value(s) for multi parameter field!\n"));
                return this.getSelectedParam(dialog);
            }
            if (param.getValueVariable() != null) {
                System.out.println("ParamReport: " + param.getValueVariable());
                values[i] = param.getValueVariable();
                continue;
            }
            values[i] = param.getValue();
        }
        return values;
    }

    public Object[] getParametersForSecurityLevel(String securityLevel) {
        if (securityLevel != null && this.report.getSecurityQueryParameterMap() != null && this.report.dbInfo != null && this.report.dbInfo instanceof QueryFileInfo) {
            QueryInParam[] masterParams = ((QueryFileInfo)this.report.dbInfo).getInSet().getParameter();
            IQueryInParam[] securityParams = QueryParser.verifyParameters(masterParams, (IQueryInParam[])this.report.getSecurityQueryParameterMap().get(securityLevel));
            Vector<QueryInParam> unselectedParameters = new Vector<QueryInParam>();
            Object[] selectedValues = new Object[masterParams.length];
            if (securityParams != null) {
                for (int i = 0; i < masterParams.length; ++i) {
                    Vector<Object> sourceObj = null;
                    if (masterParams[i] instanceof QueryMultiValueInParam) {
                        sourceObj = ((IQueryMultiValueInParam)securityParams[i]).getValues();
                        ((QueryMultiValueInParam)masterParams[i]).setValues(sourceObj);
                    } else {
                        sourceObj = securityParams[i].getValue();
                        masterParams[i].setValue(sourceObj);
                    }
                    if (sourceObj == null) {
                        unselectedParameters.addElement(masterParams[i]);
                    }
                    selectedValues[i] = sourceObj;
                }
                if (unselectedParameters.size() > 0) {
                    QueryInParam[] unselectedParams = new QueryInParam[unselectedParameters.size()];
                    for (int i = 0; i < unselectedParams.length; ++i) {
                        unselectedParams[i] = (QueryInParam)unselectedParameters.elementAt(i);
                    }
                    QueryFileInfo reportqfi = (QueryFileInfo)this.report.dbInfo;
                    if (reportqfi.isUseJNDIDataSource()) {
                        DBInfoBasic newDBInfo = new DBInfoBasic(reportqfi.getJNDIName(), reportqfi.getQuery(), reportqfi.getEnvProperties());
                    } else {
                        DBInfoBasic dBInfoBasic = new DBInfoBasic(reportqfi.getURLString(), reportqfi.getDriverName(), reportqfi.getUserID(), reportqfi.getPassword(), reportqfi.getQuery());
                    }
                } else {
                    return selectedValues;
                }
            }
        }
        return null;
    }

    private Parameters getParameters(Report report) {
        this.parameters = report.getParametersInSequence();
        return this.parameters;
    }
}

