/*
 * Decompiled with CFR 0.152.
 */
package quadbase.scheduler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.scheduler.ParamReport;
import quadbase.scheduler.ScheduleObject;
import quadbase.scheduler.Scheduler;

public class ParamReportDialog
extends JDialog
implements ActionListener,
ItemListener {
    private JButton back;
    private JButton ok;
    private JButton cancel;
    private JButton addBut;
    private JButton removeBut;
    private JTable table;
    private ScheduleObject schObj = null;
    private ParamReport paramReport;
    private JCheckBox selectAllBox;
    private boolean isCancelled = false;
    private boolean isBack = false;
    private String[] header;

    public ParamReportDialog(Scheduler parent, ParamReport paramReport, ScheduleObject obj) {
        super(parent.getFrame(), LanguageEncoder.getText("Set Parameters"), true);
        this.schObj = obj;
        this.paramReport = paramReport;
        this.init();
        this.setPosition();
    }

    void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    void init() {
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        Vector<Object[]> list = this.schObj.getParamList();
        this.selectAllBox = new JCheckBox("Select All", list == null);
        this.selectAllBox.addItemListener(this);
        JPanel topPanel = new JPanel(new FlowLayout(0));
        topPanel.add(this.selectAllBox);
        this.header = this.paramReport.getParamName();
        this.table = new JTable(0, this.header.length);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                ((DefaultTableModel)this.table.getModel()).addRow(list.elementAt(i));
            }
        }
        TableColumnModel colModel = this.table.getColumnModel();
        JTextField notEditableField = new JTextField();
        notEditableField.setEditable(false);
        notEditableField.setHorizontalAlignment(2);
        DefaultCellEditor notEditor = new DefaultCellEditor(notEditableField);
        notEditor.setClickCountToStart(15);
        TextRenderer renderer = new TextRenderer();
        this.table.clearSelection();
        for (int i = 0; i < this.header.length; ++i) {
            colModel.getColumn(i).setCellRenderer(renderer);
            colModel.getColumn(i).setHeaderValue(this.header[i]);
            colModel.getColumn(i).setCellEditor(notEditor);
        }
        this.table.setShowGrid(false);
        JScrollPane scroller = new JScrollPane();
        scroller.getViewport().add(this.table);
        scroller.getViewport().setBackground(this.table.getBackground());
        scroller.setBackground(this.table.getBackground());
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(new EmptyBorder(20, 0, 20, 0));
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        this.addBut = new JButton(LanguageEncoder.getText("Add"));
        this.removeBut = new JButton(LanguageEncoder.getText("Remove"));
        this.back = new JButton(LanguageEncoder.getText("Back"));
        this.ok = new JButton(LanguageEncoder.getText("Next"));
        this.cancel = new JButton(LanguageEncoder.getText("Cancel"));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.addBut);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.removeBut);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.back);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.ok);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.cancel);
        buttonPanel.add(Box.createHorizontalGlue());
        this.addBut.addActionListener(this);
        this.removeBut.addActionListener(this);
        this.back.addActionListener(this);
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        contentPane.add("North", topPanel);
        contentPane.add("Center", scroller);
        contentPane.add("South", buttonPanel);
        this.itemStateChanged(null);
    }

    ScheduleObject getScheduleObject() {
        return this.schObj;
    }

    boolean isCancelled() {
        return this.isCancelled;
    }

    boolean isBack() {
        return this.isBack;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.addBut.setEnabled(!this.selectAllBox.isSelected());
        this.removeBut.setEnabled(!this.selectAllBox.isSelected());
        this.table.setEnabled(!this.selectAllBox.isSelected());
    }

    void resetDialog() {
        this.isCancelled = false;
        this.isBack = false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        this.isBack = false;
        if (target == this.back) {
            this.isBack = true;
            this.setVisible(false);
        } else if (target == this.cancel) {
            this.isCancelled = true;
            this.setVisible(false);
            this.dispose();
        } else if (target == this.ok) {
            if (this.selectAllBox.isSelected()) {
                this.schObj.setParamList(null);
            } else {
                DefaultTableModel model = (DefaultTableModel)this.table.getModel();
                Vector<Object[]> paramList = new Vector<Object[]>();
                for (int i = 0; i < model.getRowCount(); ++i) {
                    Object[] row = new Object[this.header.length];
                    for (int j = 0; j < row.length; ++j) {
                        row[j] = model.getValueAt(i, j);
                    }
                    paramList.addElement(row);
                }
                this.schObj.setParamList(paramList);
            }
            this.setVisible(false);
            this.dispose();
        } else if (target == this.addBut) {
            Object[] row = this.paramReport.getSelectedParam(this);
            if (row == null) {
                return;
            }
            ((DefaultTableModel)this.table.getModel()).addRow(row);
            ((DefaultTableModel)this.table.getModel()).fireTableDataChanged();
            this.table.repaint();
        } else if (target == this.removeBut) {
            int row = this.table.getSelectedRow();
            String msg = null;
            if (row < 0) {
                msg = LanguageEncoder.getText("Please select a row first!");
            }
            if (msg != null) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), msg, 6);
                return;
            }
            ((DefaultTableModel)this.table.getModel()).removeRow(row);
            this.table.clearSelection();
            ((DefaultTableModel)this.table.getModel()).fireTableDataChanged();
        }
    }

    private class TextRenderer
    extends JLabel
    implements TableCellRenderer {
        public TextRenderer() {
            this.setHorizontalAlignment(0);
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(this.toString(value));
            JTextField label = new JTextField("TEMP");
            this.setFont(label.getFont());
            if (isSelected) {
                this.setBackground(label.getSelectionColor());
                this.setForeground(label.getSelectedTextColor());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            return this;
        }

        public String toString(Object value) {
            if (value == null) {
                return "";
            }
            if (value instanceof Vector) {
                Vector values = (Vector)value;
                return values.toString();
            }
            return value.toString();
        }
    }
}

