/*
 * Decompiled with CFR 0.152.
 */
package quadbase.scheduler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.scheduler.PackageDialog;
import quadbase.scheduler.ParamReport;
import quadbase.scheduler.ScheduleObject;
import quadbase.scheduler.Scheduler;
import quadbase.scheduler.ServerPortDialog;

public class ParamReportPanel
extends JPanel
implements ActionListener {
    private JButton back;
    private JButton ok;
    private JButton editBut;
    private JButton cancel;
    private JButton done;
    private JButton addBut;
    private JButton removeBut;
    private JTable table;
    private Scheduler parent;
    private ScheduleObject schObj = null;
    private ParamReport paramReport;
    private boolean isCancelled = false;
    private boolean isBack = false;
    private String[] paramName;
    private PackageDialog packageDialog;
    private CellEditor cellEditor;

    public ParamReportPanel(Scheduler parent, PackageDialog packageDialog, ParamReport paramReport, ScheduleObject obj) {
        this.parent = parent;
        this.packageDialog = packageDialog;
        this.paramReport = paramReport;
        this.schObj = obj;
        this.init();
    }

    void init() {
        this.setLayout(new BorderLayout());
        Vector<Object[]> list = this.schObj.getParamList();
        this.paramName = this.paramReport.getParamName();
        this.table = new JTable(0, this.paramName.length + 1);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                ((DefaultTableModel)this.table.getModel()).addRow(this.rearrangeData(list.elementAt(i), this.paramName.length, i));
            }
        }
        TableColumnModel colModel = this.table.getColumnModel();
        JTextField notEditableField = new JTextField();
        notEditableField.setEditable(false);
        notEditableField.setHorizontalAlignment(2);
        DefaultCellEditor notEditor = new DefaultCellEditor(notEditableField);
        notEditor.setClickCountToStart(15);
        TextRenderer renderer = new TextRenderer();
        this.table.clearSelection();
        colModel.getColumn(0).setCellRenderer(renderer);
        colModel.getColumn(0).setHeaderValue(LanguageEncoder.getText("Set Name"));
        this.cellEditor = new CellEditor();
        colModel.getColumn(0).setCellEditor(this.cellEditor);
        for (int i = 0; i < this.paramName.length; ++i) {
            colModel.getColumn(i + 1).setCellRenderer(renderer);
            colModel.getColumn(i + 1).setHeaderValue(this.paramName[i]);
            colModel.getColumn(i + 1).setCellEditor(notEditor);
        }
        this.table.setShowGrid(false);
        JScrollPane scroller = new JScrollPane();
        scroller.getViewport().add(this.table);
        scroller.getViewport().setBackground(this.table.getBackground());
        scroller.setBackground(this.table.getBackground());
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(new EmptyBorder(20, 0, 20, 0));
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        this.addBut = new JButton(LanguageEncoder.getText("Add"));
        this.removeBut = new JButton(LanguageEncoder.getText("Remove"));
        this.back = new JButton(LanguageEncoder.getText("Back"));
        this.ok = new JButton(LanguageEncoder.getText("Next"));
        this.cancel = new JButton(LanguageEncoder.getText("Cancel"));
        this.editBut = new JButton(LanguageEncoder.getText("Edit"));
        this.done = new JButton(LanguageEncoder.getText("Done"));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.addBut);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.editBut);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.removeBut);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.back);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.ok);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.cancel);
        buttonPanel.add(Box.createHorizontalGlue());
        if (this.packageDialog.inEditMode()) {
            buttonPanel.add(this.done);
            buttonPanel.add(Box.createHorizontalGlue());
        }
        this.addBut.addActionListener(this);
        this.removeBut.addActionListener(this);
        this.back.addActionListener(this);
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        this.editBut.addActionListener(this);
        this.done.addActionListener(this);
        this.add("Center", scroller);
        this.add("South", buttonPanel);
    }

    ScheduleObject getScheduleObject() {
        return this.schObj;
    }

    private Object[] rearrangeData(Object[] row, int paramCt, int rowIdx) {
        Object[] newRow = new Object[paramCt + 1];
        for (int i = 0; i < paramCt; ++i) {
            newRow[i + 1] = row[i];
        }
        newRow[0] = row.length > paramCt ? row[paramCt] : this.getNewName("Parameter Set ", rowIdx + 1);
        return newRow;
    }

    boolean isParameterSet() {
        DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        return model.getRowCount() > 0;
    }

    boolean isCancelled() {
        return this.isCancelled;
    }

    boolean isBack() {
        return this.isBack;
    }

    private boolean isExisted(String val) {
        DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            String paramName = (String)model.getValueAt(i, 0);
            if (!paramName.equals(val)) continue;
            return true;
        }
        return false;
    }

    private String getNewName(String prefix, int idx) {
        while (this.isExisted(prefix + idx)) {
            ++idx;
        }
        return prefix + idx;
    }

    public void setValues() {
        DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        if (model.getRowCount() == 0) {
            String msg = LanguageEncoder.getText("Please add parameters!");
            new JMessageDialog((Frame)this.parent.getFrame(), LanguageEncoder.getText("Error"), msg, 6);
            return;
        }
        Vector<Object[]> paramList = new Vector<Object[]>();
        for (int i = 0; i < model.getRowCount(); ++i) {
            Object[] row = new Object[this.paramName.length + 1];
            for (int j = 0; j < this.paramName.length; ++j) {
                row[j] = model.getValueAt(i, j + 1);
            }
            row[row.length - 1] = model.getValueAt(i, 0);
            paramList.addElement(row);
        }
        this.schObj.setParamList(paramList);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        this.isBack = false;
        if (target == this.back) {
            this.isBack = true;
            this.packageDialog.showSetTimingPanel(true);
        } else if (target == this.cancel) {
            this.isCancelled = true;
            this.packageDialog.setCancelled();
            this.packageDialog.setVisible(false);
            this.packageDialog.dispose();
        } else if (target == this.ok || target == this.done) {
            if (this.cellEditor != null) {
                this.cellEditor.stopCellEditing();
            }
            if (this.paramReport.promptServletPortDialog(this.schObj.getReportType())) {
                ServerPortDialog sDialog = new ServerPortDialog(this.parent.getFrame());
                sDialog.setVisible(true);
                if (sDialog.isModified()) {
                    this.schObj.setServerName(sDialog.getServerName());
                    this.schObj.setServletDirectory(sDialog.getServletDirectory());
                    this.schObj.setPortNumber(sDialog.getPortNumber());
                } else {
                    this.packageDialog.setCancelled();
                    this.packageDialog.setVisible(false);
                    this.packageDialog.dispose();
                    return;
                }
            }
            if (target == this.done && this.packageDialog.inEditMode()) {
                this.packageDialog.showSummaryDialog();
                return;
            }
            this.packageDialog.goToNextParamPanel();
        } else if (target == this.addBut) {
            Object[] row = this.paramReport.getSelectedParam(this.packageDialog);
            if (row == null) {
                return;
            }
            ((DefaultTableModel)this.table.getModel()).addRow(this.rearrangeData(row, this.paramName.length, this.table.getModel().getRowCount()));
            ((DefaultTableModel)this.table.getModel()).fireTableDataChanged();
        } else if (target == this.removeBut) {
            int row = this.table.getSelectedRow();
            String msg = null;
            if (row < 0) {
                msg = LanguageEncoder.getText("Please select a row first!");
            }
            if (msg != null) {
                new JMessageDialog((Frame)this.parent.getFrame(), LanguageEncoder.getText("Error"), msg, 6);
                return;
            }
            ((DefaultTableModel)this.table.getModel()).removeRow(row);
            this.table.clearSelection();
            ((DefaultTableModel)this.table.getModel()).fireTableDataChanged();
        } else if (target == this.editBut) {
            int row = this.table.getSelectedRow();
            String msg = null;
            if (row < 0) {
                msg = LanguageEncoder.getText("Please select a row first!");
            }
            if (msg != null) {
                new JMessageDialog((Frame)this.parent.getFrame(), LanguageEncoder.getText("Error"), msg, 6);
                return;
            }
            DefaultTableModel model = (DefaultTableModel)this.table.getModel();
            Object[] data = new Object[this.paramName.length];
            for (int j = 0; j < this.paramName.length; ++j) {
                data[j] = model.getValueAt(row, j + 1);
            }
            Object[] rowObj = this.paramReport.getSelectedParam(this.packageDialog, data);
            if (rowObj == null) {
                return;
            }
            for (int i = 0; i < rowObj.length; ++i) {
                model.setValueAt(rowObj[i], row, i + 1);
            }
            ((DefaultTableModel)this.table.getModel()).fireTableDataChanged();
        }
    }

    private class CellEditor
    extends DefaultCellEditor
    implements TableCellEditor,
    MouseListener {
        private JTextField text;
        private JComponent comp;
        private String defaultValue;

        public CellEditor() {
            super(new JTextField());
            this.text = new JTextField("TEMP");
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.defaultValue = value == null ? "" : value.toString();
            JTextField textField = new JTextField(this.defaultValue);
            this.comp = textField;
            return this.comp;
        }

        @Override
        public Object getCellEditorValue() {
            if (this.comp == null) {
                return null;
            }
            String val = ((JTextField)this.comp).getText();
            if (val.equals(this.defaultValue)) {
                return val;
            }
            if (ParamReportPanel.this.isExisted(val)) {
                return this.defaultValue;
            }
            return val;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.stopCellEditing();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    private class TextRenderer
    extends JLabel
    implements TableCellRenderer {
        public TextRenderer() {
            this.setHorizontalAlignment(0);
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(this.toString(value));
            JTextField label = new JTextField("TEMP");
            this.setFont(label.getFont());
            if (isSelected) {
                this.setBackground(label.getSelectionColor());
                this.setForeground(label.getSelectedTextColor());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            return this;
        }

        public String toString(Object value) {
            if (value == null) {
                return "";
            }
            if (value instanceof Vector) {
                Vector values = (Vector)value;
                return values.toString();
            }
            return value.toString();
        }
    }
}

