/*
 * Decompiled with CFR 0.152.
 */
package quadbase.scheduler;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.scheduler.PackageDialog;
import quadbase.scheduler.RecipientsPanel;

class PopupMenuForAddressTable
extends JPopupMenu
implements ActionListener {
    private boolean isReady = false;
    PackageDialog packageDialog;
    RecipientsPanel recipientsPanel;

    public PopupMenuForAddressTable(PackageDialog pDialog, RecipientsPanel recipientsPanel) {
        this.packageDialog = pDialog;
        this.recipientsPanel = recipientsPanel;
    }

    public void addMenu() {
        this.isReady = false;
        this.removeAll();
        this.add(this.newMenuItem(LanguageEncoder.getText("Cut"), "Cut"));
        this.add(this.newMenuItem(LanguageEncoder.getText("Copy"), "Copy"));
        if (this.packageDialog.tableRowPasteData != null) {
            this.add(this.newMenuItem(LanguageEncoder.getText("Paste"), "Paste"));
        }
        this.addSeparator();
        this.add(this.newMenuItem(LanguageEncoder.getText("Delete"), "Delete"));
        this.addSeparator();
        if (this.recipientsPanel.isParamReport()) {
            this.add(this.newMenuItem(LanguageEncoder.getText("Copy to Other Parameter Set"), "Copy to Other Parameter Set"));
        }
        this.add(this.newMenuItem(LanguageEncoder.getText("Copy All"), "Copy All"));
        this.isReady = true;
    }

    JMenuItem newMenuItem(String s, String cmd) {
        JMenuItem m = new JMenuItem(s);
        m.setActionCommand(cmd);
        m.addActionListener(this);
        return m;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isReady) {
            return;
        }
        String cmd = e.getActionCommand();
        if (cmd.equals("Cut")) {
            this.packageDialog.cutOrCopyRow(0, this.recipientsPanel);
        } else if (cmd.equals("Copy")) {
            this.packageDialog.cutOrCopyRow(1, this.recipientsPanel);
        } else if (cmd.equals("Paste")) {
            this.packageDialog.paste(this.recipientsPanel);
        } else if (cmd.equals("Delete")) {
            this.recipientsPanel.deleteAddresses();
        } else if (cmd.equals("Copy to Other Parameter Set")) {
            this.recipientsPanel.copyToOtherParamSet();
        } else if (cmd.equals("Copy All")) {
            this.packageDialog.copyAllForRecipientTab(this.recipientsPanel.getAddresses());
        } else {
            System.out.println("Action = " + cmd);
        }
    }
}

