/*
 * Decompiled with CFR 0.152.
 */
package quadbase.scheduler;

import java.applet.Applet;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import quadbase.common.client.ServerMessage;
import quadbase.common.swing.BrowseDialog;
import quadbase.common.util.internal.QbDebug;
import quadbase.scheduler.Scheduler;

public class QbScheduler {
    Scheduler scheduler;

    public static void setCommProtocol(String str) {
        if (str != null) {
            if (str.equalsIgnoreCase("http")) {
                ServerMessage.useHttp();
            } else if (str.equalsIgnoreCase("servlet")) {
                ServerMessage.useServlet();
            }
        }
    }

    public static void setCommUrl(String comm_url) {
        if (comm_url != null) {
            if (ServerMessage.isServlet()) {
                ServerMessage.setConnectServlet(comm_url);
            } else {
                ServerMessage.setConnectURL(comm_url);
            }
        }
    }

    public static final void setDebugMode(String mode) {
        QbDebug.setDebugMode(mode);
    }

    public static final void setDebugMode(int mode) {
        QbDebug.setDebugMode(mode);
    }

    public QbScheduler(Applet applet, JFrame frame) {
        ServerMessage.useServer = true;
        ServerMessage.setParent(applet);
        try {
            this.scheduler = new Scheduler(frame);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JPanel getScheduler() {
        return this.scheduler;
    }

    public void setRootDirectoryForBrowse(String browseRoot) {
        BrowseDialog.setPresetDirectory(browseRoot);
        BrowseDialog.setGoUpEnabled(ServerMessage.isAdmin());
    }

    public void setInsertCommandEnabled(boolean b) {
        this.scheduler.isInsertCommandEnabled = b;
    }

    public boolean getInsertCommandEnabled() {
        return this.scheduler.isInsertCommandEnabled;
    }

    public void setSecurityLevel(String securityLevel) {
        this.scheduler.setSecurityLevel(securityLevel);
    }

    public String getSecurityLevel() {
        return this.scheduler.getSecurityLevel();
    }

    public static void setServerAddress(String address) throws UnknownHostException {
        ServerMessage.setAddress(address);
    }

    public static void setServerPortNumber(int port) {
        ServerMessage.setPortNumber(port);
    }

    public static void setServerHosts(Vector<String> hostnames) {
        ServerMessage.setHosts(hostnames);
    }

    public static void setServletRunner(String comm_url) {
        ServerMessage.setConnectServlet(comm_url);
    }

    public static void useServlet(boolean b) {
        if (b) {
            ServerMessage.useServlet();
        } else {
            ServerMessage.useSocket();
        }
    }

    public static void setServletContext(String context) {
        ServerMessage.setServletContext(context);
    }

    public static String getServletContext() {
        return ServerMessage.getServletContext();
    }

    public void setSysExitOnExit(boolean state) {
        this.scheduler.setSysExitOnExit(state);
    }

    public boolean sysExitOnExit() {
        return this.scheduler.sysExitOnExit();
    }
}

