/*
 * Decompiled with CFR 0.152.
 */
package quadbase.scheduler;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import quadbase.common.swing.listeners.MousePopUpAdapter;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.report.Parameter;
import quadbase.reportdesigner.report.Report;
import quadbase.scheduler.BrowseUserGroupDialog;
import quadbase.scheduler.PackageDialog;
import quadbase.scheduler.PopupMenuForAddressTable;
import quadbase.scheduler.ScheduleObject;
import quadbase.scheduler.Scheduler;

public class RecipientsPanel
extends JPanel
implements ActionListener,
ItemListener,
ListSelectionListener,
TreeSelectionListener {
    private JButton ok;
    private JButton cancel;
    private JButton back;
    private JButton done;
    private JCheckBox emailUsingColumn;
    private Scheduler parent;
    private boolean isCancel = false;
    private boolean isBack = false;
    private JTable addressTable;
    private DefaultTableModel model;
    private JButton addUserBut;
    private JButton removeUserBut;
    private JComboBox toAddressColumn;
    private Object[] columnNames;
    private ScheduleObject schObj;
    private boolean isChart = false;
    private boolean init = false;
    private Report report;
    private PackageDialog packageDialog;
    private JTree tree;
    private String selectedParamSet;
    private Hashtable paramAddrTable;
    private PopupMenuForAddressTable popupMenu;
    private static int ADDR_SIZE = 100;

    public RecipientsPanel(Scheduler parent, PackageDialog packageDialog, ScheduleObject schObj) {
        this.parent = parent;
        this.schObj = schObj;
        this.packageDialog = packageDialog;
        this.isChart = schObj.isChart();
        if (!this.isChart) {
            this.report = ScheduleObject.createReport(schObj.getReportLocation(), null);
            this.columnNames = this.getReportColumns(this.report);
        }
        this.init();
    }

    void init() {
        RecipientsPanel contentPane = this;
        contentPane.setLayout(new BorderLayout());
        JPanel infoPanel = null;
        if (!this.schObj.isChart() && this.report.getReportType() != 0 && this.report.getReportType() != 4 && (this.report.getOriginalSourceData() == 1 || this.report.sourceData == 1) && this.isNotBreakOnParameterizedColumn(this.report)) {
            infoPanel = new JPanel(new BorderLayout());
            JPanel infoPanel1 = new JPanel();
            infoPanel1.setBorder(new TitledBorder(LanguageEncoder.getText("Burst Report Options:")));
            infoPanel1.setLayout(new FlowLayout(0));
            this.emailUsingColumn = new JCheckBox(LanguageEncoder.getText("Email Using Report Column values"), false);
            this.emailUsingColumn.addItemListener(this);
            this.toAddressColumn = new JComboBox<Object>((Object[])this.columnNames[0]);
            this.toAddressColumn.setEnabled(false);
            infoPanel1.add("West", this.emailUsingColumn);
            infoPanel1.add("Center", this.toAddressColumn);
            infoPanel.add("Center", infoPanel1);
        }
        Vector<Object[]> paramList = this.schObj.getParamList();
        JPanel paramPanel = null;
        if (paramList != null && paramList.size() > 0) {
            this.paramAddrTable = new Hashtable();
            paramPanel = new JPanel();
            paramPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Parameter Sets")));
            paramPanel.setLayout(new BorderLayout());
            DefaultMutableTreeNode root = new DefaultMutableTreeNode("ROOT");
            for (int i = 0; i < paramList.size(); ++i) {
                Object[] obj = paramList.elementAt(i);
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(obj[obj.length - 1]);
                for (int j = 0; j < obj.length - 1; ++j) {
                    node.add(new DefaultMutableTreeNode(obj[j]));
                }
                if (i == 0) {
                    this.selectedParamSet = (String)obj[obj.length - 1];
                }
                root.add(node);
            }
            this.tree = new JTree(root);
            this.tree.setRootVisible(false);
            this.tree.setSelectionRow(0);
            this.tree.getSelectionModel().setSelectionMode(1);
            this.tree.addTreeSelectionListener(this);
            JScrollPane sPane = new JScrollPane(this.tree);
            paramPanel.add("Center", sPane);
        }
        JPanel addressPanel = new JPanel();
        addressPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Recipients Email Address:")));
        addressPanel.setLayout(new BorderLayout());
        this.model = new DefaultTableModel(new String[]{"Address"}, ADDR_SIZE);
        this.addressTable = new JTable(this.model);
        this.addressTable.getTableHeader().setVisible(false);
        this.popupMenu = new PopupMenuForAddressTable(this.packageDialog, this);
        TextRenderer renderer = new TextRenderer(this);
        this.addressTable.getColumnModel().getColumn(0).setCellRenderer(renderer);
        this.addressTable.setShowGrid(false);
        JScrollPane scroller = new JScrollPane();
        scroller.getViewport().add(this.addressTable);
        scroller.getViewport().setBackground(this.addressTable.getBackground());
        scroller.setBackground(this.addressTable.getBackground());
        scroller.addMouseListener(new MousePopUpAdapter(){

            @Override
            public void showPopup(MouseEvent e) {
                if (RecipientsPanel.this.model == null) {
                    return;
                }
                RecipientsPanel.this.popupMenu.addMenu();
                RecipientsPanel.this.popupMenu.show((JComponent)e.getSource(), e.getX(), e.getY());
            }
        });
        addressPanel.add("Center", scroller);
        JPanel addButPanel = new JPanel(new GridLayout(1, 2, 10, 10));
        this.addUserBut = new JButton(LanguageEncoder.getText("Previous Emails"));
        this.removeUserBut = new JButton(LanguageEncoder.getText("Remove"));
        addButPanel.add(this.addUserBut);
        addButPanel.add(this.removeUserBut);
        this.addUserBut.addActionListener(this);
        this.removeUserBut.addActionListener(this);
        addressPanel.add("South", addButPanel);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 0, 10, 10));
        this.back = new JButton(LanguageEncoder.getText("Back"));
        this.ok = new JButton(LanguageEncoder.getText("OK"));
        this.cancel = new JButton(LanguageEncoder.getText("Cancel"));
        this.done = new JButton(LanguageEncoder.getText("Done"));
        buttonPanel.add(this.back);
        if (this.packageDialog.inEditMode()) {
            buttonPanel.add(this.done);
        } else {
            buttonPanel.add(this.ok);
        }
        buttonPanel.add(this.cancel);
        this.back.addActionListener(this);
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        this.done.addActionListener(this);
        JPanel mainPanel = new JPanel(new BorderLayout());
        if (infoPanel != null) {
            mainPanel.add("North", infoPanel);
        }
        mainPanel.add("Center", addressPanel);
        if (paramPanel != null) {
            mainPanel.add("West", paramPanel);
        }
        contentPane.add("Center", mainPanel);
        contentPane.add("South", buttonPanel);
        this.preSetValues(this.schObj);
        this.itemStateChanged(null);
        this.addressTable.addMouseListener(new MousePopUpAdapter(){

            @Override
            public void showPopup(MouseEvent e) {
                RecipientsPanel.this.popupMenu.addMenu();
                RecipientsPanel.this.popupMenu.show((JComponent)e.getSource(), e.getX(), e.getY());
            }
        });
    }

    JTable getAddressTable() {
        return this.addressTable;
    }

    String getSelectedParamSetName() {
        return this.selectedParamSet;
    }

    boolean isParamReport() {
        return this.tree != null;
    }

    void copyToOtherParamSet() {
        this.copyToOtherParamSet(this.getAddresses());
    }

    void copyToOtherParamSet(Object[] addrs) {
        if (this.paramAddrTable == null) {
            return;
        }
        Vector<Object[]> paramList = this.schObj.getParamList();
        for (int i = 0; i < paramList.size(); ++i) {
            Object[] obj = paramList.elementAt(i);
            this.paramAddrTable.put(obj[obj.length - 1], addrs);
        }
    }

    void copyAddresses(String[] addrs) {
        this.copyToOtherParamSet(addrs);
        this.setAddresses(addrs);
    }

    void stopEditing() {
        if (this.addressTable == null) {
            return;
        }
        int row = this.addressTable.getSelectedRow();
        if (row < 0) {
            return;
        }
        try {
            this.addressTable.getCellEditor(row, 0).stopCellEditing();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.stopEditing();
        TreePath path = e.getPath();
        if (this.selectedParamSet != null) {
            this.paramAddrTable.put(this.selectedParamSet, this.getAddresses());
        }
        if (path != null && path.getPathCount() >= 1) {
            this.selectedParamSet = path.getPath()[1].toString();
            String[] addr = (String[])this.paramAddrTable.get(this.selectedParamSet);
            this.setAddresses(addr);
        }
    }

    void setAddresses(String[] addr) {
        int i = 0;
        if (addr != null) {
            for (i = 0; i < addr.length; ++i) {
                this.model.setValueAt(addr[i], i, 0);
            }
        }
        while (i < this.model.getRowCount()) {
            this.model.setValueAt("", i, 0);
            ++i;
        }
        ((DefaultTableModel)this.addressTable.getModel()).fireTableDataChanged();
        this.addressTable.clearSelection();
    }

    String[] getAddresses() {
        Vector<String> vec = new Vector<String>();
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            String str = (String)this.model.getValueAt(i, 0);
            if (str == null || str.trim().equals("") || vec.contains(str)) continue;
            vec.add(str);
        }
        String[] arr = new String[vec.size()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = (String)vec.elementAt(i);
        }
        return arr;
    }

    void insertAddress(String addr) {
        int i = 0;
        if (addr != null) {
            for (i = 0; i < this.model.getRowCount(); ++i) {
                String str = (String)this.model.getValueAt(i, 0);
                if (str == null || str.trim().equals("")) {
                    this.model.setValueAt(addr, i, 0);
                    return;
                }
                if (!addr.equals(str)) continue;
                return;
            }
        }
        ((DefaultTableModel)this.addressTable.getModel()).fireTableDataChanged();
        this.addressTable.clearSelection();
    }

    void deleteAddresses() {
        if (this.addressTable.getSelectedRow() < 0) {
            String msg = LanguageEncoder.getText("Please select an address first!");
            new JMessageDialog((Dialog)this.packageDialog, "Delete Address", msg);
            return;
        }
        this.deleteAddresses(this.selectedParamSet, this.addressTable.getSelectedRows());
    }

    void deleteAddresses(String delParamSet, int[] delRows) {
        if (delParamSet == null) {
            for (int i = delRows.length - 1; i >= 0; --i) {
                this.model.removeRow(delRows[i]);
                this.model.addRow(new String[]{""});
            }
            this.schObj.setToAddresses(this.getAddresses());
        } else if (delParamSet.equals(this.selectedParamSet)) {
            for (int i = delRows.length - 1; i >= 0; --i) {
                this.model.removeRow(delRows[i]);
                this.model.addRow(new String[]{""});
                this.paramAddrTable.put(this.selectedParamSet, this.getAddresses());
            }
        } else {
            String[] addr = (String[])this.paramAddrTable.get(this.selectedParamSet);
            String[] newAddr = new String[addr.length - delRows.length];
            int k = 0;
            int g = 0;
            for (int i = 0; i < addr.length; ++i) {
                if (i == delRows[k]) {
                    ++k;
                    continue;
                }
                newAddr[g++] = addr[i];
            }
            this.paramAddrTable.put(this.selectedParamSet, newAddr);
        }
    }

    boolean isExportToMultiPages(ScheduleObject schObj) {
        int rptType = schObj.getReportType();
        return rptType == 4 && schObj.isExportToMultiPages();
    }

    void preSetValues(ScheduleObject schObj) {
        this.init = true;
        if (schObj == null) {
            return;
        }
        if (this.columnNames != null) {
            for (int i = 0; i < ((int[])this.columnNames[1]).length; ++i) {
                if (((int[])this.columnNames[1])[i] != schObj.getEmailColumnIndex()) continue;
                this.toAddressColumn.setSelectedIndex(i);
                break;
            }
        }
        if (this.emailUsingColumn != null) {
            this.emailUsingColumn.setSelected(schObj.getBurstReport() == ScheduleObject.ALLBURSTING);
            this.toAddressColumn.setEnabled(this.emailUsingColumn.isSelected());
            this.addressTable.setEnabled(!this.emailUsingColumn.isSelected());
            if (this.tree != null) {
                this.tree.setEnabled(!this.emailUsingColumn.isSelected());
            }
        }
        if (this.isExportToMultiPages(schObj) && this.emailUsingColumn != null) {
            this.emailUsingColumn.setSelected(false);
            this.emailUsingColumn.setEnabled(false);
            this.toAddressColumn.setEnabled(false);
        }
        if (this.toAddressColumn != null && this.emailUsingColumn.isSelected()) {
            this.toAddressColumn.setEnabled(this.emailUsingColumn.isSelected());
        }
        if (this.paramAddrTable != null && this.selectedParamSet != null) {
            String[] addr;
            this.paramAddrTable = schObj.getBurstEmail();
            if (this.paramAddrTable == null) {
                this.paramAddrTable = new Hashtable();
            }
            if ((addr = (String[])this.paramAddrTable.get(this.selectedParamSet)) != null) {
                this.setAddresses(addr);
            }
        } else {
            this.setAddresses(schObj.getToAddresses());
        }
        this.init = false;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.init) {
            return;
        }
        this.stopEditing();
        if (e != null && e.getItem() == this.emailUsingColumn) {
            this.toAddressColumn.setEnabled(this.emailUsingColumn.isSelected());
            this.addressTable.setEnabled(!this.emailUsingColumn.isSelected());
            if (this.tree != null) {
                this.tree.setEnabled(!this.emailUsingColumn.isSelected());
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
    }

    boolean isCancel() {
        return this.isCancel;
    }

    boolean isBack() {
        return this.isBack;
    }

    void setValues() {
        this.schObj.setBurstEmail(null);
        this.schObj.setBurstReport(ScheduleObject.NOBURSTING);
        this.schObj.setEmailColumnIndex(-1);
        this.schObj.setToAddresses(new String[0]);
        if (!this.schObj.isChart() && this.report.getReportType() != 0 && this.report.getReportType() != 4 && (this.report.getOriginalSourceData() == 1 || this.report.sourceData == 1) && this.isNotBreakOnParameterizedColumn(this.report) && this.emailUsingColumn.isSelected()) {
            this.schObj.setEmailColumnIndex(((int[])this.columnNames[1])[this.toAddressColumn.getSelectedIndex()]);
            this.schObj.setBurstReport(ScheduleObject.ALLBURSTING);
        } else if (this.paramAddrTable != null) {
            if (this.selectedParamSet != null) {
                this.paramAddrTable.put(this.selectedParamSet, this.getAddresses());
            }
            this.schObj.setBurstEmail(this.paramAddrTable);
        } else {
            this.schObj.setToAddresses(this.getAddresses());
        }
    }

    Vector<String> collectRecipientEmailAddresses(Vector<String> vec) {
        block6: {
            if (!this.schObj.isChart() && this.report.getReportType() != 0 && this.report.getReportType() != 4 && (this.report.getOriginalSourceData() == 1 || this.report.sourceData == 1) && this.isNotBreakOnParameterizedColumn(this.report) && this.emailUsingColumn.isSelected()) break block6;
            if (this.paramAddrTable != null) {
                if (this.selectedParamSet != null) {
                    this.paramAddrTable.put(this.selectedParamSet, this.getAddresses());
                }
                Enumeration e = this.paramAddrTable.keys();
                while (e.hasMoreElements()) {
                    String paramSetName = (String)e.nextElement();
                    String[] addresses = (String[])this.paramAddrTable.get(paramSetName);
                    if (addresses == null) continue;
                    for (int i = 0; i < addresses.length; ++i) {
                        if (vec.contains(addresses[i].toLowerCase())) continue;
                        vec.add(addresses[i].toLowerCase());
                    }
                }
            } else {
                String[] addr = this.getAddresses();
                for (int i = 0; i < addr.length; ++i) {
                    if (vec.contains(addr[i].toLowerCase())) continue;
                    vec.add(addr[i].toLowerCase());
                }
            }
        }
        return vec;
    }

    void addToAddresses(Object[] newusers) {
        for (Object newuser : newusers) {
            String str = "";
            str = (String)newuser;
            this.insertAddress(str);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.stopEditing();
        Object target = e.getSource();
        this.isBack = false;
        if (target == this.back) {
            this.isBack = true;
            this.packageDialog.showDeliveryOptionsPanel();
        } else if (target == this.cancel) {
            this.isCancel = true;
            this.packageDialog.setCancelled();
            this.packageDialog.setVisible(false);
            this.packageDialog.dispose();
        } else if (target == this.ok || target == this.done) {
            this.setValues();
            String msg = null;
            if (this.emailUsingColumn != null && this.emailUsingColumn.isSelected() && this.schObj.getEmailColumnIndex() == -1) {
                msg = LanguageEncoder.getText("Please provide email information for report bursting");
            }
            if (msg != null) {
                new JMessageDialog((Dialog)this.packageDialog, LanguageEncoder.getText("Warning"), msg);
                return;
            }
            this.isCancel = false;
            if (target == this.done && this.packageDialog.inEditMode()) {
                this.packageDialog.showSummaryDialog();
                return;
            }
            this.packageDialog.goToNextRecipientsPanel();
        } else if (target == this.addUserBut) {
            BrowseUserGroupDialog browse = new BrowseUserGroupDialog(this.parent, this.packageDialog, this);
            browse.setVisible(true);
        } else if (target == this.removeUserBut) {
            this.deleteAddresses();
        }
    }

    private Object[] getReportColumns(Report report) {
        if (report != null) {
            Vector<String> vec = new Vector<String>();
            Vector<Integer> vec2 = new Vector<Integer>();
            int ct = 0;
            for (int i = 0; i < report.colInfo.length; ++i) {
                if (report.colInfo[i].getMapping() > -1) {
                    String datatype = DataType.getTypeName(report.colData[report.colInfo[i].getMapping()].getOriginalDataType());
                    if (!datatype.equals("Varchar") && !datatype.equals("String")) continue;
                    vec.addElement(report.colInfo[i].getName());
                    vec2.addElement(i);
                    ++ct;
                    continue;
                }
                if (report.colInfo[i].getDataType() != 12) continue;
                vec.addElement(report.colInfo[i].getFormulaName());
                vec2.addElement(i);
                ++ct;
            }
            Object[] columnNames = new Object[ct];
            int[] colIndex = new int[ct];
            for (int i = 0; i < ct; ++i) {
                columnNames[i] = vec.elementAt(i);
                colIndex[i] = (Integer)vec2.elementAt(i);
            }
            Object[] result = new Object[]{columnNames, colIndex};
            return result;
        }
        return null;
    }

    boolean isNotBreakOnParameterizedColumn(Report report) {
        if (report.getQueryFileInfo() == null) {
            return true;
        }
        int mapping = report.breakColInfo[0].getMapping();
        Vector<Parameter> vec = report.getQueryParameters();
        for (int i = 0; i < vec.size(); ++i) {
            Vector<Object> values;
            Parameter param = vec.elementAt(i);
            if (!(param.getColumnName().equals(report.colData[mapping].getName()) ? param.getMapColIdx() == mapping : (values = report.colData[mapping].getDistinctValue()) == null || values.size() == 0)) continue;
            return false;
        }
        return true;
    }

    private class TextRenderer
    extends JLabel
    implements TableCellRenderer {
        private Color mDefaultBackground = new Color(240, 240, 240);
        private RecipientsPanel recipientsPanel;

        public TextRenderer(RecipientsPanel recipientsPanel2) {
            this.recipientsPanel = recipientsPanel2;
            this.setHorizontalAlignment(2);
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JTextField label = new JTextField("TEMP");
            if (value != null) {
                this.setText(value.toString());
            } else {
                this.setText("");
            }
            this.setFont(label.getFont());
            if (isSelected && !table.isEditing()) {
                this.setBackground(label.getSelectionColor());
                this.setForeground(label.getSelectedTextColor());
            } else {
                if (row % 2 == 0) {
                    this.setBackground(this.mDefaultBackground);
                } else {
                    this.setBackground(table.getBackground());
                }
                this.setForeground(table.getForeground());
            }
            if (((RecipientsPanel)RecipientsPanel.this).packageDialog.action == 0 && ((RecipientsPanel)RecipientsPanel.this).packageDialog.cutRecipientsPanel == this.recipientsPanel && ((RecipientsPanel)RecipientsPanel.this).packageDialog.cutRow != null) {
                for (int element : ((RecipientsPanel)RecipientsPanel.this).packageDialog.cutRow) {
                    if (element != row) continue;
                    this.setForeground(Color.lightGray);
                    break;
                }
            }
            return this;
        }
    }
}

