/*
 * Decompiled with CFR 0.152.
 */
package quadbase.scheduler;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.util.IDelimiterConstants;
import quadbase.scheduler.ScheduleObject;

public class ReportOptionPanel
extends JPanel
implements ActionListener,
ItemListener {
    private JButton optionBut;
    private ScheduleObject schObj = null;
    private int[] exportMap = new int[]{4, 2, 9, 17, 3, 5, 13, 6, 7, 8};
    private String[] exportMapStr = new String[]{"DHTML", "PDF", "XLS", "XLSX", "CSV", "TXT", "RTF", "XML (Data + Format)", "XML (Pure Data)", "XML (Template)"};
    boolean isExportToMultiPages = false;
    boolean showAllExportType = true;
    JComboBox rptCombo = null;
    JPanel exportOptionPanel = null;
    protected OptionDialog optionDialog = null;
    JDialog parent = null;
    boolean isOptionModified = false;

    public ReportOptionPanel(JDialog parent, ScheduleObject schObj) {
        this(parent, schObj, true);
    }

    public ReportOptionPanel(JDialog parent, ScheduleObject schObj, boolean showAllExportType) {
        this.showAllExportType = showAllExportType;
        this.schObj = schObj;
        this.parent = parent;
        this.init();
    }

    void init() {
        this.setBorder(new TitledBorder(LanguageEncoder.getText("Export Format")));
        this.setLayout(new BorderLayout());
        this.rptCombo = new JComboBox();
        int expCount = this.exportMapStr.length;
        if (!this.showAllExportType) {
            expCount = 6;
        }
        for (int i = 0; i < expCount; ++i) {
            this.rptCombo.addItem(this.exportMapStr[i]);
        }
        this.rptCombo.addItemListener(this);
        this.optionBut = new JButton("Options...");
        this.optionBut.addActionListener(this);
        JPanel butPanel = new JPanel();
        butPanel.setLayout(new FlowLayout(2));
        butPanel.add(this.optionBut);
        this.add("Center", this.rptCombo);
        this.add("South", butPanel);
        this.setValues();
    }

    void setValues() {
        if (this.schObj == null) {
            return;
        }
        for (int i = 0; i < this.exportMap.length; ++i) {
            if (this.schObj.getReportType() != this.exportMap[i]) continue;
            this.rptCombo.setSelectedIndex(i);
        }
    }

    int getReportType() {
        return this.exportMap[this.rptCombo.getSelectedIndex()];
    }

    String getReportTypeName() {
        return this.exportMapStr[this.rptCombo.getSelectedIndex()];
    }

    boolean isOptionChanged() {
        return this.isOptionModified;
    }

    boolean isExportToMultiPages() {
        return this.optionDialog.multiPageButton.isSelected();
    }

    boolean isMemoryOptimized() {
        return false;
    }

    boolean isExportToSingleWPagination() {
        return this.optionDialog.singlePageWPagination.isSelected();
    }

    boolean isUseInternalStyleSheet() {
        return this.optionDialog.chkInternalStyleSheet.isSelected();
    }

    boolean isUseExternalStyleSheet() {
        return this.optionDialog.chkExternalStyleSheet.isSelected();
    }

    String getExternalStyleSheetName() {
        return this.optionDialog.externalStyleSheetField.getText();
    }

    boolean isEncodePDF() {
        return this.optionDialog.chkEncodePDF.isSelected();
    }

    String getPDFUserPassword() {
        return this.optionDialog.userPassField.getText();
    }

    String getPDFOwnerPassword() {
        return this.optionDialog.ownerPassField.getText();
    }

    int getTextDelimiter() {
        return this.optionDialog.delimiterList.getSelectedIndex();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.optionDialog = null;
        this.isOptionModified = false;
        int rptType = this.getReportType();
        this.optionBut.setEnabled(rptType == 4 || rptType == 2 || rptType == 3 || rptType == 5);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        if (target == this.optionBut) {
            if (this.optionDialog == null) {
                this.optionDialog = new OptionDialog(this.parent, this.getReportType(), this.getReportTypeName());
            }
            this.optionDialog.setVisible(true);
        }
    }

    protected class OptionDialog
    extends JDialog
    implements ItemListener,
    ActionListener {
        private int rptType;
        JPanel pdfPassFieldPanel;
        JPanel externalCSSPanel;
        JButton okButton;
        JButton cancelButton;
        JRadioButton singlePageButton;
        JRadioButton multiPageButton;
        JRadioButton singlePageWPagination;
        JCheckBox chkInternalStyleSheet;
        JCheckBox chkExternalStyleSheet;
        JTextField externalStyleSheetField;
        JCheckBox chkEncodePDF;
        JPasswordField userPassField;
        JPasswordField ownerPassField;
        JComboBox delimiterList;

        public OptionDialog(JDialog dialog, int rptType, String typeName) {
            super(dialog, typeName + " " + LanguageEncoder.getText("Options"), true);
            this.rptType = -1;
            this.chkInternalStyleSheet = null;
            this.chkExternalStyleSheet = null;
            this.externalStyleSheetField = null;
            this.rptType = rptType;
            this.init();
            this.setPosition();
        }

        void setPosition() {
            this.pack();
            this.setLocationRelativeTo(this.getParent());
        }

        void setValues() {
            if (ReportOptionPanel.this.schObj == null) {
                return;
            }
            this.multiPageButton.setSelected(ReportOptionPanel.this.schObj.isExportToMultiPages());
            this.singlePageWPagination.setSelected(ReportOptionPanel.this.schObj.isExportToSingleWPagination());
            this.chkInternalStyleSheet.setSelected(ReportOptionPanel.this.schObj.isUseInternalStyleSheet());
            this.chkExternalStyleSheet.setSelected(ReportOptionPanel.this.schObj.isUseExternalStyleSheet());
            this.externalStyleSheetField.setText(ReportOptionPanel.this.schObj.getExternalStyleSheetName());
            this.chkEncodePDF.setSelected(ReportOptionPanel.this.schObj.isEncodePDF());
            this.userPassField.setText(ReportOptionPanel.this.schObj.getPDFUserPassword());
            this.ownerPassField.setText(ReportOptionPanel.this.schObj.getPDFOwnerPassword());
            this.delimiterList.setSelectedIndex(ReportOptionPanel.this.schObj.getTextDelimiter());
        }

        void init() {
            JPanel contentPane = (JPanel)this.getContentPane();
            contentPane.setLayout(new BorderLayout());
            this.singlePageButton = new JRadioButton(LanguageEncoder.getText("Single Page"), true);
            this.multiPageButton = new JRadioButton(LanguageEncoder.getText("Multi-Page"), false);
            this.singlePageWPagination = new JRadioButton(LanguageEncoder.getText("Paginated Single Page"), false);
            ButtonGroup group = new ButtonGroup();
            group.add(this.singlePageButton);
            group.add(this.multiPageButton);
            group.add(this.singlePageWPagination);
            JPanel pagePanel = new JPanel();
            pagePanel.setLayout(new BorderLayout());
            pagePanel.add("West", this.singlePageButton);
            pagePanel.add("East", this.multiPageButton);
            if (this.rptType == 4) {
                pagePanel.add("Center", this.singlePageWPagination);
            }
            JPanel cssOptionPanel = new JPanel(new BorderLayout());
            JPanel cssChkBoxPanel = new JPanel(new FlowLayout(0));
            this.chkInternalStyleSheet = new JCheckBox(LanguageEncoder.getText("Use Internal Style Sheet"), false);
            this.chkExternalStyleSheet = new JCheckBox(LanguageEncoder.getText("Use External Style Sheet"), false);
            this.chkExternalStyleSheet.addItemListener(this);
            cssChkBoxPanel.add(this.chkInternalStyleSheet);
            cssChkBoxPanel.add(this.chkExternalStyleSheet);
            this.externalCSSPanel = new JPanel(new FlowLayout(0));
            this.externalCSSPanel.add(new JLabel(LanguageEncoder.getText("External CSS")));
            this.externalStyleSheetField = new JTextField("", 25);
            this.externalCSSPanel.add(this.externalStyleSheetField);
            this.externalCSSPanel.setVisible(this.chkExternalStyleSheet.isSelected());
            cssOptionPanel.add("North", cssChkBoxPanel);
            cssOptionPanel.add("Center", this.externalCSSPanel);
            JPanel pdfOptionPanel = new JPanel();
            this.chkEncodePDF = new JCheckBox(LanguageEncoder.getText("Encrypt PDF Export"), false);
            pdfOptionPanel.setLayout(new FlowLayout(0));
            this.chkEncodePDF.addItemListener(this);
            pdfOptionPanel.add(this.chkEncodePDF);
            this.pdfPassFieldPanel = new JPanel();
            this.pdfPassFieldPanel.setLayout(new BorderLayout());
            JPanel userPassPanel = new JPanel();
            userPassPanel.setLayout(new BorderLayout());
            userPassPanel.add("Center", new JLabel(LanguageEncoder.getText("User Password")));
            this.userPassField = new JPasswordField("", 10);
            userPassPanel.add("East", this.userPassField);
            JPanel ownerPassPanel = new JPanel();
            ownerPassPanel.setLayout(new BorderLayout());
            ownerPassPanel.add("Center", new JLabel(LanguageEncoder.getText("Owner Password")));
            this.ownerPassField = new JPasswordField("", 10);
            ownerPassPanel.add("East", this.ownerPassField);
            this.pdfPassFieldPanel.add("North", userPassPanel);
            this.pdfPassFieldPanel.add("South", ownerPassPanel);
            JPanel pdfPanel = new JPanel();
            pdfPanel.setLayout(new BorderLayout());
            pdfPanel.add("North", pdfOptionPanel);
            pdfPanel.add("Center", this.pdfPassFieldPanel);
            this.pdfPassFieldPanel.setVisible(false);
            JPanel delimPanel = new JPanel();
            this.delimiterList = new JComboBox();
            for (String element : IDelimiterConstants.DELIMLIST) {
                this.delimiterList.addItem(element);
            }
            this.delimiterList.addActionListener(this);
            delimPanel.setLayout(new FlowLayout(0));
            delimPanel.add(new JLabel(LanguageEncoder.getText("Delimiter")));
            delimPanel.add(this.delimiterList);
            JPanel mainPanel = new JPanel();
            mainPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Options")));
            mainPanel.setLayout(new BoxLayout(mainPanel, 1));
            JPanel okpanel = new JPanel();
            okpanel.setLayout(new FlowLayout());
            this.okButton = new JButton(LanguageEncoder.getText("OK"));
            this.okButton.addActionListener(this);
            okpanel.add(this.okButton);
            this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
            this.cancelButton.addActionListener(this);
            okpanel.add(this.cancelButton);
            contentPane.add("Center", mainPanel);
            contentPane.add("South", okpanel);
            this.setValues();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            JCheckBox cb = (JCheckBox)e.getItem();
            if (cb == this.chkEncodePDF) {
                this.pdfPassFieldPanel.setVisible(cb.isSelected());
                this.pack();
            } else if (cb == this.chkExternalStyleSheet) {
                this.externalCSSPanel.setVisible(cb.isSelected());
                this.pack();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object target = e.getSource();
            if (target == this.okButton) {
                String str;
                if (this.chkExternalStyleSheet.isSelected() && (str = this.externalStyleSheetField.getText()).equals("")) {
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), "Please enter external style sheet name.");
                    return;
                }
                if (this.chkEncodePDF.isSelected() && (str = this.userPassField.getText()).equals("")) {
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), "Please enter user password.");
                    return;
                }
                ReportOptionPanel.this.isOptionModified = true;
            }
            this.setVisible(false);
        }
    }
}

