/*
 * Decompiled with CFR 0.152.
 */
package quadbase.scheduler;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Calendar;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.scheduler.ScheduleModifier;
import quadbase.scheduler.ScheduleObject;
import quadbase.scheduler.ScheduleSummaryDialog;
import quadbase.scheduler.Scheduler;
import quadbase.scheduler.SetScheduleDialog;

public class ScheduleCommandDialog
extends JDialog
implements ActionListener {
    private JButton ok;
    private JButton cancel;
    private JTextField cmdField;
    private JTextField nameField;
    private Scheduler parent;
    private ScheduleObject schObj = null;
    private SetScheduleDialog schDialog = null;
    private boolean editSchedule = false;
    private int row;
    private boolean isCancelled = false;

    public ScheduleCommandDialog(Scheduler parent) {
        super(parent.getFrame(), LanguageEncoder.getText("Set Schedule"), true);
        this.parent = parent;
        this.init();
        this.setPosition();
    }

    public ScheduleCommandDialog(Scheduler parent, ScheduleObject schObj, int row) {
        super(parent.getFrame(), LanguageEncoder.getText("Edit Schedule"), true);
        this.parent = parent;
        this.editSchedule = true;
        this.schObj = schObj;
        this.row = row;
        this.init();
        this.setPosition();
    }

    void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    void init() {
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JPanel topPanel = new JPanel();
        topPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Name")));
        topPanel.setLayout(new FlowLayout(0));
        JLabel nameLbl = new JLabel(LanguageEncoder.getText("Display Name:"));
        this.nameField = new JTextField(20);
        nameLbl.setAlignmentY(0.5f);
        topPanel.add(nameLbl);
        topPanel.add(this.nameField);
        JPanel filePanel = new JPanel();
        filePanel.setBorder(new TitledBorder(LanguageEncoder.getText("Command Line")));
        filePanel.setLayout(new BorderLayout());
        this.cmdField = new JTextField(20);
        filePanel.add("Center", this.cmdField);
        contentPane.add(topPanel);
        contentPane.add(filePanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(new EmptyBorder(20, 0, 20, 0));
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        this.ok = new JButton(LanguageEncoder.getText("Next"));
        this.cancel = new JButton(LanguageEncoder.getText("Cancel"));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.ok);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.cancel);
        buttonPanel.add(Box.createHorizontalGlue());
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        contentPane.add(buttonPanel);
        this.setValues();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ScheduleCommandDialog.this.isCancelled = true;
            }
        });
    }

    private void setValues() {
        if (this.schObj == null) {
            return;
        }
        this.cmdField.setText(this.schObj.getCommand());
        this.nameField.setText(this.schObj.getName());
    }

    ScheduleObject getScheduleObject() {
        return this.schObj;
    }

    boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        if (target == this.cancel) {
            this.isCancelled = true;
            this.setVisible(false);
            this.dispose();
        } else if (target == this.ok) {
            try {
                String msg = null;
                if (this.cmdField.getText() == null || this.cmdField.getText().trim().equals("")) {
                    msg = LanguageEncoder.getText("Please enter command!");
                }
                if (msg != null) {
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), msg);
                    return;
                }
                if (this.nameField.getText() == null || this.nameField.getText().trim().equals("")) {
                    msg = LanguageEncoder.getText("Invalid Task Title!");
                } else if (this.nameField.getText().length() > 40) {
                    msg = LanguageEncoder.getText("A task title you specified contains more than 40 characters");
                }
                if (msg != null) {
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), msg);
                    return;
                }
                this.setVisible(false);
                String schName = "";
                schName = this.nameField.getText();
                if (this.schObj == null) {
                    this.schObj = new ScheduleObject(schName, 2);
                    Calendar startDate = Calendar.getInstance();
                    startDate.add(12, 10);
                    Calendar endDate = Calendar.getInstance();
                    endDate.add(12, 15);
                    this.schObj.setStartDate(startDate.getTime().getTime());
                    this.schObj.setEndDate(endDate.getTime().getTime());
                } else {
                    this.schObj.setName(schName);
                }
                this.schObj.setCommand(this.cmdField.getText());
                if (this.schDialog == null) {
                    this.schDialog = new SetScheduleDialog(this.parent, this.schObj);
                }
                if (this.schObj != null) {
                    this.schDialog.preSetValues(this.schObj);
                }
                this.schDialog.setVisible(true);
                if (this.schDialog.goBack()) {
                    this.setVisible(true);
                    return;
                }
                this.dispose();
                if (this.schDialog.isCancel()) {
                    this.isCancelled = true;
                    return;
                }
                this.schDialog.setValues(this.schObj);
                if (this.editSchedule) {
                    this.schObj.resetExportTime();
                    ScheduleModifier.modifyScheduleTask(this.schObj, this.row);
                } else {
                    ScheduleModifier.addScheduleTask(this.schObj);
                }
                new ScheduleSummaryDialog(this.parent, this.schObj).setVisible(true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

