/*
 * Decompiled with CFR 0.152.
 */
package quadbase.scheduler;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import quadbase.common.util.internal.ReadDataFile;
import quadbase.scheduler.FailedScheduledJob;

public class ScheduleLog {
    public static String SCHEDULE_LOG = "schedule.log";
    private static Vector<FailedScheduledJob> failedJobs;

    public static Vector<FailedScheduledJob> getFailedScheduledJob() throws Exception {
        ScheduleLog.init();
        return failedJobs;
    }

    private static void init() throws Exception {
        failedJobs = new Vector();
        ReadDataFile readDataFile = new ReadDataFile();
        DataInputStream in = readDataFile.getInputStream(SCHEDULE_LOG);
        InputStreamReader inputStream = new InputStreamReader(in);
        BufferedReader reader = new BufferedReader(inputStream);
        String text = reader.readLine();
        while (text != null) {
            if (text.equals("EXPORT FAILS - BEGIN")) {
                FailedScheduledJob fJob = ScheduleLog.readFailedScheduledJob(reader);
                failedJobs.addElement(fJob);
            }
            text = reader.readLine();
        }
        try {
            reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            readDataFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static FailedScheduledJob readFailedScheduledJob(BufferedReader reader) throws Exception {
        String name = reader.readLine();
        String fileLoc = reader.readLine();
        String time = reader.readLine();
        StringBuffer stackTrace = new StringBuffer();
        String startDate = null;
        String endDate = null;
        String exportLoc = null;
        String tmp = reader.readLine();
        if (tmp != null && tmp.startsWith("SCHEDULE START DATE: ")) {
            startDate = tmp.substring(21);
            tmp = reader.readLine();
        }
        if (tmp != null && tmp.startsWith("SCHEDULE END DATE: ")) {
            endDate = tmp.substring(19);
            tmp = reader.readLine();
        }
        if (tmp != null && tmp.startsWith("EXPORT LOC: ")) {
            exportLoc = tmp.substring(12);
            tmp = reader.readLine();
        }
        while (tmp != null && !tmp.equals("EXPORT FAILS - END")) {
            stackTrace.append(tmp).append("\n");
            tmp = reader.readLine();
        }
        FailedScheduledJob fJob = new FailedScheduledJob(name, fileLoc, time, stackTrace.toString());
        fJob.setScheduleStartDate(startDate);
        fJob.setScheduleEndDate(endDate);
        fJob.setExportLocation(exportLoc);
        return fJob;
    }
}

