/*
 * Decompiled with CFR 0.152.
 */
package quadbase.scheduler;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Vector;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.VersioningDataInput;
import quadbase.scheduler.ScheduleObject;

public class ScheduleModifier {
    public static void connectServer(Object object) {
        ServerMessage.setParent(object);
    }

    public static void setServerAddress(String address) throws UnknownHostException {
        ServerMessage.setAddress(address);
    }

    public static void setServerPortNumber(int port) {
        ServerMessage.setPortNumber(port);
    }

    public static void setServerHosts(Vector<String> hostnames) {
        ServerMessage.setHosts(hostnames);
    }

    public static void setServletRunner(String comm_url) {
        ServerMessage.setConnectServlet(comm_url);
    }

    public static void useServlet(boolean b) {
        if (b) {
            ServerMessage.useServlet();
        } else {
            ServerMessage.useSocket();
        }
    }

    public static String getServletContext() {
        return ServerMessage.getServletContext();
    }

    public static void setServletContext(String context) {
        ServerMessage.setServletContext(context);
    }

    public static Vector<ScheduleObject> getScheduleList() throws Exception {
        IConnection socket = ServerMessage.createConnection();
        ScheduleModifier.sendMessage(socket, 31001);
        return (Vector)ScheduleModifier.receiveReply(socket, 31001);
    }

    public static Vector<ScheduleObject> getScheduleList(String searchTips) throws Exception {
        Vector<ScheduleObject> vec = ScheduleModifier.getScheduleList();
        if (vec == null || searchTips == null) {
            return vec;
        }
        Vector<ScheduleObject> res = new Vector<ScheduleObject>();
        searchTips = searchTips.toUpperCase();
        for (int i = 0; i < vec.size(); ++i) {
            ScheduleObject obj = vec.elementAt(i);
            if (obj.getExportLocation().toUpperCase().indexOf(searchTips) >= 0) {
                res.addElement(obj);
                continue;
            }
            if (obj.getName().toUpperCase().indexOf(searchTips) < 0) continue;
            res.addElement(obj);
        }
        return res;
    }

    public static void modifyScheduleTask(ScheduleObject schObj, int idx) throws Exception {
        IConnection socket = ServerMessage.createConnection();
        ScheduleModifier.sendMessage(socket, 31002, schObj, idx);
        ScheduleModifier.receiveReply(socket, 31002);
    }

    public static void addScheduleTask(ScheduleObject schObj) throws Exception {
        IConnection socket = ServerMessage.createConnection();
        ScheduleModifier.sendMessage(socket, 31003, schObj, -1);
        ScheduleModifier.receiveReply(socket, 31003);
    }

    public static void removeScheduleTask(ScheduleObject schObj) throws Exception {
        IConnection socket = ServerMessage.createConnection();
        ScheduleModifier.sendMessage(socket, 31004, schObj, -1);
        ScheduleModifier.receiveReply(socket, 31004);
    }

    public static void saveScheduleTask() throws Exception {
        IConnection socket = ServerMessage.createConnection();
        ScheduleModifier.sendMessage(socket, 31005, null, -1);
        ScheduleModifier.receiveReply(socket, 31005);
    }

    private static void sendMessage(IConnection socket, int type) throws Exception {
        ScheduleModifier.sendMessage(socket, type, null, -1);
    }

    private static void sendMessage(IConnection socket, int type, ScheduleObject schObj, int index) throws Exception {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeShort(type);
        switch (type) {
            case 31001: 
            case 31005: {
                break;
            }
            case 31003: {
                ScheduleModifier.writeAddSchedule(dout, schObj);
                break;
            }
            case 31002: {
                ScheduleModifier.writeModSchedule(dout, schObj, index);
                break;
            }
            case 31004: {
                ScheduleModifier.writeDelSchedule(dout, schObj);
                break;
            }
        }
        try {
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            socket.close();
            throw ex;
        }
    }

    private static Object receiveReply(IConnection socket, int type) throws Exception {
        try {
            DataInputStream dstream = new DataInputStream(socket.getInputStream());
            int code = dstream.readInt();
            if (code != 0) {
                throw new IOException(IOUtil.getErrorString(code) + IOUtil.readString(dstream, true));
            }
            Vector<ScheduleObject> result = null;
            switch (type) {
                case 31001: {
                    result = ScheduleModifier.readScheduleList(dstream);
                    break;
                }
            }
            dstream.close();
            socket.close();
            return result;
        }
        catch (Exception ex) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ex;
        }
        catch (Error err) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new Exception(err.getMessage());
        }
    }

    private static void writeModSchedule(DataOutputStream out, ScheduleObject schObj, int index) throws Exception {
        out.writeInt(index);
        schObj.write(out);
    }

    private static void writeDelSchedule(DataOutputStream out, ScheduleObject schObj) throws Exception {
        schObj.write(out);
    }

    private static void writeAddSchedule(DataOutputStream out, ScheduleObject schObj) throws Exception {
        schObj.write(out);
    }

    private static Vector<ScheduleObject> readScheduleList(DataInputStream orgIn) throws Exception {
        VersioningDataInput dstream = new VersioningDataInput(orgIn, 7004);
        int size = dstream.readInt();
        Vector<ScheduleObject> output = new Vector<ScheduleObject>();
        for (int i = 0; i < size; ++i) {
            ScheduleObject obj = ScheduleObject.readComplete(dstream, 148);
            output.addElement(obj);
        }
        return output;
    }
}

