/*
 * Decompiled with CFR 0.152.
 */
package quadbase.scheduler;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import quadbase.common.client.FileInfo;
import quadbase.common.util.internal.Coder;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.internal.VersioningDataInput;
import quadbase.common.util.internal.VersioningDataOutput;
import quadbase.reportdesigner.report.LoadReport;
import quadbase.reportdesigner.report.Report;
import quadbase.scheduler.ScheduleReportDialog;
import quadbase.util.internal.ICompareObject;
import quadbase.util.internal.NumberCompare;
import quadbase.util.internal.SortObject;

public class ScheduleObject
implements Serializable {
    public static final int CHARTOBJ = 0;
    public static final int REPORTOBJ = 1;
    public static final int COMMANDOBJ = 2;
    public static final int PNG_COMPRESSSION_DEFAULT = 0;
    public static final int PNG_COMPRESSSION_FAST = 1;
    public static final int PNG_COMPRESSSION_MAX = 2;
    public static final int PNG_COMPRESSSION_NONE = 3;
    public static final int removeScheduleIconInterval = 1;
    public static final int ASATTACHMENT = 0;
    public static final int ASLINK = 1;
    public static final int ASHTML = 2;
    public static final int ONE_TIME = 0;
    public static final int TIME_INTERVAL = 1;
    public static final int FIXED_DAYS = 2;
    public static final String[] TYPE = new String[]{LanguageEncoder.getText("ONE TIME"), LanguageEncoder.getText("TIME INTERVAL"), LanguageEncoder.getText("FIXED DAYS")};
    public static final int TIME = 0;
    public static final int DAYS = 1;
    public static final int MONTHS = 2;
    public static int NOBURSTING = 0;
    public static int GROUPBURSTING = 1;
    public static int ALLBURSTING = -1;
    private static boolean runMissedJob = false;
    protected int packageID = -1;
    private int scheduleType = 1;
    private String name = "";
    private int id = -1;
    private int exportType = 2;
    private int jpegQuality = 99;
    private boolean gifTransparent = false;
    private int pngCompression = 0;
    private int imageWidth = -1;
    private int imageHeight = -1;
    private String chartLocation = "";
    private String reportLocation = "";
    private String exportLocation = "";
    private int taskOption = 0;
    private int[] specifyDates = new int[0];
    private int[] specifyDays = new int[0];
    private int[] specifyTime = new int[0];
    private long startDate = -1L;
    private long endDate = -1L;
    private int startTime = -1;
    private int endTime = -1;
    private int timeInterval = 0;
    private int monthInterval = 0;
    private int dayInterval = 0;
    private int intervalType = 0;
    private String userName = "";
    private boolean isChartObject = true;
    private boolean multiPages = false;
    private boolean oneShotExport = false;
    private String securityLevel = null;
    private long exportTime = -1L;
    private boolean deleteJob = false;
    private int reportType = 4;
    private String command = "";
    private Vector paramList = null;
    private boolean sendEmail = true;
    private String fromAddress = "";
    private String[] toAddresses = new String[0];
    private String subject = "";
    private String bodyText = "";
    private int emailType = 0;
    private String urlMapping = "";
    private String subjectFail = "";
    private String bodyTextFail = "";
    private String toAddressFail = "";
    private String serverName = "";
    private int portNumber = -1;
    private String servletDir = "";
    private int burstReport = 0;
    private Hashtable burstEmail;
    private int emailColumnIndex = -1;
    private boolean isExportToSingleWPagination = false;
    private boolean isUseInternalStyleSheet = false;
    private boolean isUseExternalStyleSheet = false;
    private String externalStyleSheetName = "";
    private boolean isEncodePDF = false;
    private String pdfUserPassword = "";
    private String pdfOwnerPassword = "";
    private int textDelimiter = -1;
    private int newlineDelimiter = -1;
    private boolean attachTimestamp = false;
    private String lastExportFile = null;
    private long originalExportTime = -1L;
    private long startExportTime = -1L;
    private boolean limitExcelCellSplit = false;

    public ScheduleObject(String name) {
        this(name, true);
    }

    public ScheduleObject(String name, boolean isChartObject) {
        this(name, isChartObject ? 0 : 1);
    }

    public ScheduleObject(ScheduleObject src) {
        this(src.getName(), src.isChart());
        src.copy(this);
    }

    public ScheduleObject(String name, int type) {
        this.name = name;
        this.scheduleType = type;
    }

    public static boolean isRunMissedJob() {
        return runMissedJob;
    }

    public static void setRunMissedJob(boolean b) {
        runMissedJob = b;
    }

    public static Report createReport(String urlPath, String filePath) {
        Report report;
        Report report2;
        if (urlPath == null) {
            return null;
        }
        if (!(urlPath.endsWith(".rpt") || urlPath.endsWith(".pak") || urlPath.endsWith(".xml") || urlPath.endsWith(".qrp"))) {
            urlPath = urlPath + ".rpt";
        }
        LoadReport readfile = new LoadReport();
        readfile.readOnly = true;
        try {
            readfile.setBackupDataUsed(true);
            if (filePath != null) {
                if (!(filePath.endsWith(".rpt") || filePath.endsWith(".pak") || filePath.endsWith(".xml") || filePath.endsWith(".qrp"))) {
                    filePath = filePath + ".rpt";
                }
                report2 = readfile.loadReportFromFile(filePath, null, null, true, false);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            report2 = null;
        }
        try {
            report = readfile.loadReportFromFile(urlPath, null, null, true, false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            report = null;
        }
        return report;
    }

    public static ScheduleObject read(DataInput orgIn, int version) throws Exception {
        DataInput in = orgIn;
        if (version >= 147 && !(orgIn instanceof VersioningDataInput)) {
            in = new VersioningDataInput(orgIn, (short)version);
        }
        ScheduleObject obj = new ScheduleObject(Coder.decode(IOUtil.readString(in, true)));
        obj.setValues(in, version);
        return obj;
    }

    public static ScheduleObject readComplete(DataInput orgIn, int version) throws Exception {
        DataInput in = orgIn;
        if (version >= 147 && !(orgIn instanceof VersioningDataInput)) {
            in = new VersioningDataInput(orgIn, (short)version);
        }
        ScheduleObject obj = new ScheduleObject(Coder.decode(IOUtil.readString(in, true)));
        obj.setValues(in, version);
        obj.exportTime = in.readLong();
        return obj;
    }

    public void print() {
        System.out.println("NAME = " + this.name);
        System.out.println("ID = " + this.id);
        System.out.println("SCHEDULE TYPE = " + this.scheduleType);
        System.out.println("EXPORT TYPE = " + this.exportType);
        System.out.println("JPEG QUALITY = " + this.jpegQuality);
        System.out.println("GIF TRANSPARENT = " + this.gifTransparent);
        System.out.println("PNG COMPRESSION = " + this.pngCompression);
        System.out.println("IMAGE WIDTH = " + this.imageWidth);
        System.out.println("IMAGE HEIGHT = " + this.imageHeight);
        System.out.println("CHART LOCATION = " + this.chartLocation);
        System.out.println("IS CHART = " + this.isChartObject);
        System.out.println("REPORT LOCATION = " + this.reportLocation);
        System.out.println("EXPORT LOCATION = " + this.exportLocation);
        System.out.println("COMMAND = " + this.command);
        System.out.println("MULTI PAGES = " + this.multiPages);
        System.out.println("OPTIMIZE MEMORY = " + this.oneShotExport);
        System.out.println("TASK OPTION = " + this.taskOption);
        System.out.println("SPECIFY DAYS = " + this.print(this.specifyDays));
        System.out.println("SPECIFY DATES = " + this.print(this.specifyDates));
        System.out.println("SPECIFY TIME = " + this.print(this.specifyTime));
        System.out.println("START DATE = " + this.startDate);
        System.out.println("END DATE = " + this.endDate);
        System.out.println("TIME INTERVAL = " + this.timeInterval);
        System.out.println("MONTH INTERVAL = " + this.monthInterval);
        System.out.println("DAY INTERVAL = " + this.dayInterval);
        System.out.println("INTERVAL TYPE = " + this.intervalType);
        System.out.println("USER NAME = " + this.userName);
        System.out.println("EXPORT TIME = " + this.exportTime);
        System.out.println("DELETE JOB = " + this.deleteJob);
        System.out.println("SEND EMAIL = " + this.sendEmail);
        System.out.println("FROM ADDRESS = " + this.fromAddress);
        System.out.println("ATTACH TIMESTAMP = " + this.attachTimestamp);
        System.out.println("SUBJECT = " + this.subject);
    }

    private String print(int[] val) {
        String str = "";
        for (int element : val) {
            str = str + element + " ";
        }
        return str;
    }

    public boolean isChart() {
        return this.scheduleType == 0;
    }

    public void setChart(boolean b) {
        this.scheduleType = b ? 0 : 1;
    }

    public boolean isReport() {
        return this.scheduleType == 1;
    }

    public boolean isCommand() {
        return this.scheduleType == 2;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getID() {
        return this.id;
    }

    public void setID(int id) {
        this.id = id;
    }

    public int getPackageID() {
        return this.packageID;
    }

    public void setPackageID(int packageID) {
        this.packageID = packageID;
    }

    public String getFullID() {
        if (this.packageID == -1) {
            return this.getID() + "";
        }
        return this.packageID + "-" + this.getID();
    }

    public int getReportType() {
        return this.reportType;
    }

    public void setReportType(int type) {
        this.reportType = type;
    }

    public int getExportType() {
        return this.exportType;
    }

    public int getJPEGQuality() {
        return this.jpegQuality;
    }

    public void setJPEGQuality(int qual) {
        this.jpegQuality = qual;
    }

    public boolean isGIFTransparent() {
        return this.gifTransparent;
    }

    public void setGIFTransparent(boolean b) {
        this.gifTransparent = b;
    }

    public int getPNGCompression() {
        return this.pngCompression;
    }

    public void setPNGCompression(int c) {
        this.pngCompression = c;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(int w) {
        this.imageWidth = w;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public void setImageHeight(int h) {
        this.imageHeight = h;
    }

    public String getFileLocation() {
        if (this.isChart()) {
            return this.getChartLocation();
        }
        return this.getReportLocation();
    }

    public void setFileLocation(String loc) {
        if (this.isChart()) {
            this.setChartLocation(loc);
        } else {
            this.setReportLocation(loc);
        }
    }

    public String getChartLocation() {
        return this.chartLocation;
    }

    public void setChartLocation(String loc) {
        this.chartLocation = loc;
    }

    public String getReportLocation() {
        return this.reportLocation;
    }

    public void setReportLocation(String loc) {
        this.reportLocation = loc;
    }

    public String getExportLocation() {
        return this.exportLocation;
    }

    public void setExportLocation(String loc) {
        this.exportLocation = loc;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String cmd) {
        this.command = cmd;
    }

    public int getTaskOption() {
        return this.taskOption;
    }

    public void setTaskOption(int opt) {
        this.taskOption = opt;
    }

    public int[] getSpecifyDates() {
        return this.specifyDates;
    }

    public void setSpecifyDates(int[] dates) {
        ICompareObject[] num = new NumberCompare[dates.length];
        for (int i = 0; i < dates.length; ++i) {
            num[i] = new NumberCompare(dates[i]);
        }
        Object[] obj = SortObject.sort(num, true);
        for (int i = 0; i < obj.length; ++i) {
            dates[i] = (Integer)obj[i];
        }
        this.specifyDates = dates;
    }

    public int[] getSpecifyDays() {
        return this.specifyDays;
    }

    public void setSpecifyDays(int[] days) {
        ICompareObject[] num = new NumberCompare[days.length];
        for (int i = 0; i < days.length; ++i) {
            num[i] = new NumberCompare(days[i]);
        }
        Object[] obj = SortObject.sort(num, true);
        for (int i = 0; i < obj.length; ++i) {
            days[i] = (Integer)obj[i];
        }
        this.specifyDays = days;
    }

    public int[] getSpecifyTime() {
        return this.specifyTime;
    }

    public void setSpecifyTime(int[] time) {
        ICompareObject[] num = new NumberCompare[time.length];
        for (int i = 0; i < time.length; ++i) {
            num[i] = new NumberCompare(time[i]);
        }
        Object[] obj = SortObject.sort(num, true);
        for (int i = 0; i < obj.length; ++i) {
            time[i] = (Integer)obj[i];
        }
        this.specifyTime = time;
    }

    public long getStartDate() {
        return this.startDate;
    }

    public void setStartDate(long sDate) {
        this.startDate = sDate;
    }

    public long getEndDate() {
        return this.endDate;
    }

    public void setEndDate(long eDate) {
        this.endDate = eDate;
    }

    public int getIntervalType() {
        return this.intervalType;
    }

    public void setIntervalType(int type) {
        this.intervalType = type;
    }

    public int getStartTime() {
        return this.startTime;
    }

    public void setStartTime(int stTime) {
        this.startTime = stTime;
    }

    public int getEndTime() {
        return this.endTime;
    }

    public void setEndTime(int edTime) {
        this.endTime = edTime;
    }

    public int getTimeInterval() {
        return this.timeInterval;
    }

    public void setTimeInterval(int timeInt) {
        this.timeInterval = timeInt;
    }

    public int getMonthInterval() {
        return this.monthInterval;
    }

    public void setMonthInterval(int monInt) {
        this.monthInterval = monInt;
    }

    public int getDayInterval() {
        return this.dayInterval;
    }

    public void setDayInterval(int dayInt) {
        this.dayInterval = dayInt;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String name) {
        this.userName = name;
    }

    public int getBurstReport() {
        return this.burstReport;
    }

    public void setBurstReport(int i) {
        this.burstReport = i;
    }

    public boolean isExportToMultiPages() {
        return this.multiPages;
    }

    public void setExportToMultiPages(boolean b) {
        this.multiPages = b;
    }

    public boolean isMemoryOptimized() {
        return this.oneShotExport;
    }

    public void setMemoryOptimized(boolean b) {
        this.oneShotExport = b;
    }

    public Vector<Object[]> getParamList() {
        return this.paramList;
    }

    public void setParamList(Vector paramList) {
        this.paramList = paramList;
    }

    public boolean isSendEmail() {
        return this.sendEmail;
    }

    public void setSendEmail(boolean state) {
        this.sendEmail = state;
    }

    public String getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(String from) {
        this.fromAddress = from;
    }

    public String[] getToAddresses() {
        return this.toAddresses;
    }

    public void setToAddresses(String[] to) {
        this.toAddresses = to;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getBodyText() {
        return this.bodyText;
    }

    public void setBodyText(String bodyText) {
        this.bodyText = bodyText;
    }

    public String getFailSubject() {
        return this.subjectFail;
    }

    public void setFailSubject(String subjectFail) {
        this.subjectFail = subjectFail;
    }

    public String getFailBodyText() {
        return this.bodyTextFail;
    }

    public void setFailBodyText(String bodyTextFail) {
        this.bodyTextFail = bodyTextFail;
    }

    public String getFailToAddress() {
        return this.toAddressFail;
    }

    public void setFailToAddress(String toAddressFail) {
        this.toAddressFail = toAddressFail;
    }

    public int getEmailType() {
        return this.emailType;
    }

    public void setEmailType(int type) {
        this.emailType = type;
    }

    public String getURLMapping() {
        return this.urlMapping;
    }

    public void setURLMapping(String urlMapping) {
        this.urlMapping = urlMapping;
    }

    public String getSecurityLevel() {
        return this.securityLevel;
    }

    public void setSecurityLevel(String sl) {
        this.securityLevel = sl;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String sn) {
        this.serverName = sn;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(int pn) {
        this.portNumber = pn;
    }

    public String getServletDirectory() {
        return this.servletDir;
    }

    public void setServletDirectory(String sd) {
        this.servletDir = sd;
    }

    public boolean isExportToSingleWPagination() {
        return this.isExportToSingleWPagination;
    }

    public void setExportToSingleWPagination(boolean b) {
        this.isExportToSingleWPagination = b;
    }

    public boolean isUseInternalStyleSheet() {
        return this.isUseInternalStyleSheet;
    }

    public void setUseInternalStyleSheet(boolean b) {
        this.isUseInternalStyleSheet = b;
    }

    public boolean isUseExternalStyleSheet() {
        return this.isUseExternalStyleSheet;
    }

    public void setUseExternalStyleSheet(boolean b) {
        this.isUseExternalStyleSheet = b;
    }

    public String getExternalStyleSheetName() {
        return this.externalStyleSheetName;
    }

    public void setExternalStyleSheetName(String s) {
        this.externalStyleSheetName = s;
    }

    public boolean isEncodePDF() {
        return this.isEncodePDF;
    }

    public void setEncodePDF(boolean b) {
        this.isEncodePDF = b;
    }

    public String getPDFUserPassword() {
        return this.pdfUserPassword;
    }

    public void setPDFUserPassword(String s) {
        this.pdfUserPassword = s;
    }

    public String getPDFOwnerPassword() {
        return this.pdfOwnerPassword;
    }

    public void setPDFOwnerPassword(String s) {
        this.pdfOwnerPassword = s;
    }

    public int getTextDelimiter() {
        return this.textDelimiter;
    }

    public void setTextDelimiter(int i) {
        this.textDelimiter = i;
    }

    public int getNewLineDelimiter() {
        return this.newlineDelimiter;
    }

    public void setNewLineDelimiter(int i) {
        this.newlineDelimiter = i;
    }

    public boolean isTimestampAttached() {
        return this.attachTimestamp;
    }

    public void setTimestampAttached(boolean attach) {
        this.attachTimestamp = attach;
    }

    public Hashtable getParamAddresses() {
        return this.getBurstEmail();
    }

    public void setParamAddresses(Hashtable table) {
        this.setBurstEmail(table);
    }

    public Hashtable getBurstEmail() {
        return this.burstEmail;
    }

    public void setBurstEmail(Hashtable table) {
        this.burstEmail = table;
    }

    public int getEmailColumnIndex() {
        return this.emailColumnIndex;
    }

    public void setEmailColumnIndex(int i) {
        this.emailColumnIndex = i;
    }

    public String pickDefaultExportLocation() throws Exception {
        String name = QbUtil.findName(this.getFileLocation());
        String absPath = new FileInfo(ScheduleReportDialog.SCHEDULEDREPORT + ScheduleReportDialog.SEPARATOR + name + System.currentTimeMillis()).getAbsolutePath();
        this.setExportLocation(absPath);
        return absPath;
    }

    public void setParamList(Vector paramListName, Vector paramList) {
        Vector<Object[]> newParamList = new Vector<Object[]>();
        for (int i = 0; i < paramList.size(); ++i) {
            Object[] tmp = (Object[])paramList.elementAt(i);
            Object[] newList = new Object[tmp.length + 1];
            for (int j = 0; j < tmp.length; ++j) {
                newList[j] = tmp[j];
            }
            newList[tmp.length] = paramListName.elementAt(i);
            newParamList.add(newList);
        }
        this.setParamList(newParamList);
    }

    public void setLastExportFile(String str) {
        this.lastExportFile = str;
    }

    public void setDeleted() {
        this.deleteJob = true;
        if (this.taskOption == 0 && this.endDate == -1L) {
            this.endDate = this.startDate;
        }
        this.startDate = -1L;
        this.exportTime = -1L;
    }

    public long getExportTime() {
        return this.exportTime;
    }

    public void setExportTime(long time) {
        this.exportTime = time;
    }

    public void resetExportTime() {
        this.exportTime = -1L;
    }

    public long getNextExportTime() {
        if (this.deleteJob) {
            return -1L;
        }
        if (this.exportTime == -1L) {
            this.exportNow(System.currentTimeMillis());
        }
        if (this.deleteJob) {
            return -1L;
        }
        return this.exportTime;
    }

    public boolean exportNow(long curTime) {
        Calendar exportCal = null;
        if (this.deleteJob) {
            return false;
        }
        this.originalExportTime = this.exportTime;
        this.startExportTime = this.startDate;
        boolean firstTimeCalcExportTime = false;
        if (this.exportTime == -1L) {
            firstTimeCalcExportTime = true;
            this.exportTime = this.startDate;
        }
        this.exportTime = (long)(Math.floor((double)this.exportTime / 60000.0) * 60000.0);
        exportCal = Calendar.getInstance();
        exportCal.setTime(new Date(this.exportTime));
        if (!(firstTimeCalcExportTime && this.taskOption == 2 || this.exportTime <= curTime)) {
            return false;
        }
        if (this.taskOption == 0) {
            if (this.equals(this.exportTime, curTime)) {
                this.setDeleted();
                return true;
            }
            if (this.exportTime > curTime) {
                return false;
            }
            if (runMissedJob) {
                this.setDeleted();
                return true;
            }
            this.setDeleted();
            return false;
        }
        if (this.endDate > 0L && this.endDate < this.exportTime) {
            this.setDeleted();
            return runMissedJob;
        }
        boolean exportNow = false;
        if (this.equals(this.exportTime, curTime)) {
            this.exportTime = this.getNextExportTime(curTime, this.exportTime);
            if (this.endDate > 0L && this.endDate < this.exportTime) {
                this.setDeleted();
            }
            return true;
        }
        if (runMissedJob && curTime > this.exportTime) {
            this.exportTime = this.getNextExportTime(curTime, this.exportTime);
            if (this.endDate > 0L && this.endDate < this.exportTime) {
                this.setDeleted();
            }
            return true;
        }
        this.exportTime = this.getNextExportTime(curTime, this.exportTime);
        if (this.endDate > 0L && this.endDate < this.exportTime) {
            this.setDeleted();
            return false;
        }
        if (this.equals(this.exportTime, curTime)) {
            this.exportTime = this.getNextExportTime(curTime, this.exportTime);
            if (this.endDate > 0L && this.endDate < this.exportTime) {
                this.setDeleted();
            }
            return true;
        }
        return false;
    }

    public boolean deleteJob() {
        if (this.deleteJob) {
            this.setDeleted();
        }
        return this.deleteJob;
    }

    public boolean deleteJobPermanently(long curTime) {
        boolean deleteVal = this.deleteJob() && curTime - this.endDate > 86400000L;
        return deleteVal;
    }

    public boolean updateTime() {
        if (this.originalExportTime != this.exportTime || this.startDate != this.startExportTime) {
            this.originalExportTime = this.exportTime;
            this.startExportTime = this.startDate;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long getNextExportTime(long curTime, long exportTime) {
        Calendar exportCal = Calendar.getInstance();
        exportCal.setTime(new Date(exportTime));
        if (this.taskOption == 1) {
            while (exportTime < curTime) {
                long expT = exportTime;
                if (this.intervalType == 0) {
                    exportCal.add(12, this.timeInterval);
                    expT = exportCal.getTime().getTime();
                } else if (this.intervalType == 1) {
                    exportCal.add(5, this.dayInterval);
                    expT = exportCal.getTime().getTime();
                } else if (this.intervalType == 2) {
                    exportCal.add(2, this.monthInterval);
                    expT = exportCal.getTime().getTime();
                }
                if (exportTime == expT) return exportTime;
                exportTime = expT;
            }
            return exportTime;
        }
        if (this.taskOption != 2) return exportTime;
        try {
            if (this.specifyDates.length > 0) {
                return this.getNextFixedDate(curTime, exportTime);
            }
            if (this.specifyDays.length <= 0) return exportTime;
            return this.getNextFixedDay(curTime, exportTime);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return exportTime;
    }

    private long getNextFixedDate(long curTime, long exportTime) {
        Calendar exportDate = Calendar.getInstance();
        exportDate.setTime(new Date(exportTime));
        while (true) {
            int month = exportDate.get(2);
            for (int specifyDate : this.specifyDates) {
                exportDate.set(5, specifyDate);
                exportTime = exportDate.getTime().getTime();
                exportDate.set(2, month);
                if (this.specifyTime != null && this.specifyTime.length > 0) {
                    for (int element : this.specifyTime) {
                        exportDate.set(11, element / 60);
                        exportDate.set(12, element % 60);
                        exportTime = exportDate.getTime().getTime();
                        if (exportTime <= curTime) continue;
                        return exportTime;
                    }
                    continue;
                }
                if (this.timeInterval > 0) {
                    int startPt = this.startTime;
                    if (this.startTime == -1) {
                        startPt = 0;
                    }
                    int endPt = this.endTime;
                    if (this.endTime == -1) {
                        endPt = 719;
                    }
                    for (int j = startPt; j <= endPt; j += this.timeInterval) {
                        exportDate.set(11, j / 60);
                        exportDate.set(12, j % 60);
                        exportTime = exportDate.getTime().getTime();
                        if (exportTime <= curTime) continue;
                        return exportTime;
                    }
                    continue;
                }
                exportTime = exportDate.getTime().getTime();
                if (exportTime <= curTime) continue;
                return exportTime;
            }
            exportDate.add(2, 1);
        }
    }

    private boolean equals(long time1, long time2) {
        return Math.abs((double)(time1 - time2)) < 60000.0;
    }

    private long getNextFixedDay(long curTime, long exportTime) {
        try {
            int j;
            Calendar exportDate = Calendar.getInstance();
            exportDate.setTime(new Date(exportTime));
            int curDayOfWeek = exportDate.get(7) - 1;
            if (this.isExportDay(curDayOfWeek, this.specifyDays)) {
                if (this.specifyTime != null && this.specifyTime.length > 0) {
                    for (int element : this.specifyTime) {
                        exportDate.set(11, element / 60);
                        exportDate.set(12, element % 60);
                        exportTime = exportDate.getTime().getTime();
                        if (exportTime <= curTime) continue;
                        return exportTime;
                    }
                } else if (this.timeInterval > 0) {
                    int startPt = this.startTime;
                    if (this.startTime == -1) {
                        startPt = 0;
                    }
                    int endPt = this.endTime;
                    if (this.endTime == -1) {
                        endPt = 719;
                    }
                    for (j = startPt; j <= endPt; j += this.timeInterval) {
                        exportDate.set(11, j / 60);
                        exportDate.set(12, j % 60);
                        exportTime = exportDate.getTime().getTime();
                        if (exportTime <= curTime) continue;
                        return exportTime;
                    }
                } else {
                    exportTime = exportDate.getTime().getTime();
                    if (exportTime > curTime) {
                        return exportTime;
                    }
                }
            }
            block4: while (true) {
                int nextDay;
                if ((nextDay = this.getNextExportDay(curDayOfWeek = exportDate.get(7) - 1, this.specifyDays)) <= curDayOfWeek) {
                    exportDate.add(5, 7 - curDayOfWeek + nextDay);
                } else {
                    exportDate.add(5, nextDay - curDayOfWeek);
                }
                curDayOfWeek = nextDay;
                if (this.specifyTime != null && this.specifyTime.length > 0) {
                    int element;
                    int[] endPt = this.specifyTime;
                    j = endPt.length;
                    element = 0;
                    while (true) {
                        if (element >= j) continue block4;
                        int element2 = endPt[element];
                        System.out.println("SPECIFY TIME = " + element2);
                        exportDate.set(11, element2 / 60);
                        exportDate.set(12, element2 % 60);
                        exportTime = exportDate.getTime().getTime();
                        if (exportTime > curTime) {
                            return exportTime;
                        }
                        ++element;
                    }
                }
                if (this.timeInterval > 0) {
                    int startPt = this.startTime;
                    if (this.startTime == -1) {
                        startPt = 0;
                    }
                    int endPt = this.endTime;
                    if (this.endTime == -1) {
                        endPt = 719;
                    }
                    int j2 = startPt;
                    while (true) {
                        if (j2 > endPt) continue block4;
                        exportDate.set(11, j2 / 60);
                        exportDate.set(12, j2 % 60);
                        exportTime = exportDate.getTime().getTime();
                        if (exportTime > curTime) {
                            return exportTime;
                        }
                        j2 += this.timeInterval;
                    }
                }
                exportTime = exportDate.getTime().getTime();
                if (exportTime > curTime) break;
            }
            return exportTime;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return exportTime;
        }
    }

    public boolean isExportDay(int curDay, int[] specifyDays) {
        for (int specifyDay : specifyDays) {
            if (curDay != specifyDay) continue;
            return true;
        }
        return false;
    }

    public int getNextExportDay(int curDay, int[] specifyDays) {
        int firstDay = 8;
        int nextDay = 8;
        for (int specifyDay : specifyDays) {
            if (specifyDay < firstDay) {
                firstDay = specifyDay;
            }
            if (specifyDay <= curDay || specifyDay >= nextDay) continue;
            nextDay = specifyDay;
        }
        if (nextDay != 8) {
            return nextDay;
        }
        return firstDay;
    }

    ScheduleObject copy() {
        return this.copy(new ScheduleObject(this.getName()), false);
    }

    ScheduleObject copy(ScheduleObject tmp) {
        return this.copy(tmp, false);
    }

    ScheduleObject copy(ScheduleObject tmp, boolean skipPackageItemAttr) {
        if (!skipPackageItemAttr) {
            tmp.id = this.id;
            tmp.name = this.name;
            tmp.isChartObject = this.isChartObject;
            tmp.reportLocation = this.reportLocation;
            tmp.exportLocation = this.exportLocation;
            tmp.paramList = this.paramList != null ? (Vector)this.paramList.clone() : null;
            tmp.toAddresses = this.toAddresses;
            tmp.burstReport = this.burstReport;
            tmp.emailColumnIndex = this.emailColumnIndex;
            tmp.deleteJob = this.deleteJob;
            tmp.burstEmail = this.burstEmail;
            tmp.urlMapping = this.urlMapping;
            tmp.lastExportFile = this.lastExportFile;
        }
        tmp.reportType = this.reportType;
        tmp.packageID = this.packageID;
        tmp.exportType = this.exportType;
        tmp.multiPages = this.multiPages;
        tmp.oneShotExport = this.oneShotExport;
        tmp.jpegQuality = this.jpegQuality;
        tmp.gifTransparent = this.gifTransparent;
        tmp.pngCompression = this.pngCompression;
        tmp.imageWidth = this.imageWidth;
        tmp.imageHeight = this.imageHeight;
        tmp.chartLocation = this.chartLocation;
        tmp.reportLocation = this.reportLocation;
        tmp.exportLocation = this.exportLocation;
        tmp.command = this.command;
        tmp.taskOption = this.taskOption;
        tmp.specifyDates = this.specifyDates;
        tmp.specifyDays = this.specifyDays;
        tmp.specifyTime = this.specifyTime;
        tmp.startDate = this.startDate;
        tmp.endDate = this.endDate;
        tmp.intervalType = this.intervalType;
        tmp.timeInterval = this.timeInterval;
        tmp.monthInterval = this.monthInterval;
        tmp.dayInterval = this.dayInterval;
        tmp.userName = this.userName;
        tmp.sendEmail = this.sendEmail;
        tmp.fromAddress = this.fromAddress;
        tmp.subject = this.subject;
        tmp.bodyText = this.bodyText;
        tmp.subjectFail = this.subjectFail;
        tmp.bodyTextFail = this.bodyTextFail;
        tmp.toAddressFail = this.toAddressFail;
        tmp.emailType = this.emailType;
        tmp.securityLevel = this.securityLevel;
        tmp.serverName = this.serverName;
        tmp.portNumber = this.portNumber;
        tmp.servletDir = this.servletDir;
        tmp.isExportToSingleWPagination = this.isExportToSingleWPagination;
        tmp.isUseInternalStyleSheet = this.isUseInternalStyleSheet;
        tmp.isUseExternalStyleSheet = this.isUseExternalStyleSheet;
        tmp.externalStyleSheetName = this.externalStyleSheetName;
        tmp.isEncodePDF = this.isEncodePDF;
        tmp.pdfUserPassword = this.pdfUserPassword;
        tmp.pdfOwnerPassword = this.pdfOwnerPassword;
        tmp.textDelimiter = this.textDelimiter;
        tmp.newlineDelimiter = this.newlineDelimiter;
        tmp.attachTimestamp = this.attachTimestamp;
        tmp.startTime = this.startTime;
        tmp.endTime = this.endTime;
        tmp.limitExcelCellSplit = this.limitExcelCellSplit;
        return tmp;
    }

    public boolean equals(ScheduleObject obj) {
        int i;
        if (obj == this) {
            return true;
        }
        if (!this.name.equals(obj.name)) {
            return false;
        }
        if (this.id != obj.id) {
            return false;
        }
        if (this.packageID != obj.packageID) {
            return false;
        }
        if (this.scheduleType != obj.scheduleType) {
            return false;
        }
        if (this.reportType != obj.reportType) {
            return false;
        }
        if (this.exportType != obj.exportType) {
            return false;
        }
        if (this.multiPages != obj.multiPages) {
            return false;
        }
        if (this.oneShotExport != obj.oneShotExport) {
            return false;
        }
        if (this.jpegQuality != obj.jpegQuality) {
            return false;
        }
        if (this.gifTransparent != obj.gifTransparent) {
            return false;
        }
        if (this.pngCompression != obj.pngCompression) {
            return false;
        }
        if (this.imageWidth != obj.imageWidth) {
            return false;
        }
        if (this.imageHeight != obj.imageHeight) {
            return false;
        }
        if (!this.chartLocation.equals(obj.chartLocation)) {
            return false;
        }
        if (!this.reportLocation.equals(obj.reportLocation)) {
            return false;
        }
        if (!this.exportLocation.equals(obj.exportLocation)) {
            return false;
        }
        if (!this.command.equals(obj.command)) {
            return false;
        }
        if (this.taskOption != obj.taskOption) {
            return false;
        }
        if (this.specifyDates.length != obj.specifyDates.length) {
            return false;
        }
        for (i = 0; i < this.specifyDates.length; ++i) {
            if (this.specifyDates[i] == obj.specifyDates[i]) continue;
            return false;
        }
        if (this.specifyDays.length != obj.specifyDays.length) {
            return false;
        }
        for (i = 0; i < this.specifyDays.length; ++i) {
            if (this.specifyDays[i] == obj.specifyDays[i]) continue;
            return false;
        }
        if (this.specifyTime.length != obj.specifyTime.length) {
            return false;
        }
        for (i = 0; i < this.specifyTime.length; ++i) {
            if (this.specifyTime[i] == obj.specifyTime[i]) continue;
            return false;
        }
        if (this.startDate != obj.startDate) {
            return false;
        }
        if (this.endDate != obj.endDate) {
            return false;
        }
        if (this.startTime != obj.startTime) {
            return false;
        }
        if (this.endTime != obj.endTime) {
            return false;
        }
        if (obj.intervalType != this.intervalType) {
            return false;
        }
        if (obj.timeInterval != this.timeInterval) {
            return false;
        }
        if (obj.monthInterval != this.monthInterval) {
            return false;
        }
        if (obj.dayInterval != this.dayInterval) {
            return false;
        }
        if (!this.userName.equals(obj.userName)) {
            return false;
        }
        if (obj.sendEmail != this.sendEmail) {
            return false;
        }
        if (!this.fromAddress.equals(obj.fromAddress)) {
            return false;
        }
        if (this.toAddresses != null) {
            if (this.toAddresses.length != obj.toAddresses.length) {
                return false;
            }
            for (i = 0; i < this.toAddresses.length; ++i) {
                if (this.toAddresses[i].equals(obj.toAddresses[i])) continue;
                return false;
            }
        }
        if (!this.subject.equals(obj.subject)) {
            return false;
        }
        if (!this.bodyText.equals(obj.bodyText)) {
            return false;
        }
        if (!this.toAddressFail.equals(obj.toAddressFail)) {
            return false;
        }
        if (!this.subjectFail.equals(obj.subjectFail)) {
            return false;
        }
        if (!this.bodyTextFail.equals(obj.bodyTextFail)) {
            return false;
        }
        if (this.emailType != obj.emailType) {
            return false;
        }
        if (!this.urlMapping.equals(obj.urlMapping)) {
            return false;
        }
        if (this.securityLevel != null && obj.getSecurityLevel() != null ? !this.securityLevel.equals(obj.getSecurityLevel()) : this.securityLevel != null || obj.getSecurityLevel() != null) {
            return false;
        }
        if (!this.serverName.equals(obj.getServerName())) {
            return false;
        }
        if (!this.servletDir.equals(obj.getServletDirectory())) {
            return false;
        }
        if (this.portNumber != obj.getPortNumber()) {
            return false;
        }
        if (this.isExportToSingleWPagination != obj.isExportToSingleWPagination) {
            return false;
        }
        if (this.isUseInternalStyleSheet != obj.isUseInternalStyleSheet) {
            return false;
        }
        if (this.isUseExternalStyleSheet != obj.isUseExternalStyleSheet) {
            return false;
        }
        if (this.externalStyleSheetName != null && obj.externalStyleSheetName != null ? !this.externalStyleSheetName.equals(obj.externalStyleSheetName) : this.externalStyleSheetName != null || obj.externalStyleSheetName != null) {
            return false;
        }
        if (obj.isEncodePDF != this.isEncodePDF) {
            return false;
        }
        if (this.pdfUserPassword != null && obj.pdfUserPassword != null ? !this.pdfUserPassword.equals(obj.pdfUserPassword) : this.pdfUserPassword != null || obj.pdfUserPassword != null) {
            return false;
        }
        if (this.pdfOwnerPassword != null && obj.pdfOwnerPassword != null ? !this.pdfOwnerPassword.equals(obj.pdfOwnerPassword) : this.pdfOwnerPassword != null || obj.pdfOwnerPassword != null) {
            return false;
        }
        if (this.textDelimiter != obj.textDelimiter) {
            return false;
        }
        if (this.attachTimestamp != obj.attachTimestamp) {
            return false;
        }
        if (this.burstReport != obj.burstReport) {
            return false;
        }
        if (this.emailColumnIndex != obj.emailColumnIndex) {
            return false;
        }
        if (this.newlineDelimiter != obj.newlineDelimiter) {
            return false;
        }
        if (this.limitExcelCellSplit != obj.limitExcelCellSplit) {
            return false;
        }
        return !(this.lastExportFile != null && obj.lastExportFile != null ? !this.lastExportFile.equals(obj.lastExportFile) : this.lastExportFile != null || obj.lastExportFile != null);
    }

    public void write(DataOutput orgOut) throws Exception {
        DataOutput out = orgOut;
        if (!(orgOut instanceof VersioningDataOutput)) {
            out = new VersioningDataOutput(orgOut);
        }
        System.out.println("WRITE OUTPUT = " + (out instanceof VersioningDataOutput));
        IOUtil.writeString(out, Coder.encode(this.name));
        out.writeInt(this.scheduleType);
        out.writeInt(this.exportType);
        out.writeInt(this.reportType);
        out.writeBoolean(this.multiPages);
        out.writeBoolean(this.oneShotExport);
        out.writeInt(this.jpegQuality);
        out.writeBoolean(this.gifTransparent);
        out.writeInt(this.pngCompression);
        out.writeInt(this.imageWidth);
        out.writeInt(this.imageHeight);
        IOUtil.writeString(out, Coder.encode(this.chartLocation));
        IOUtil.writeString(out, Coder.encode(this.reportLocation));
        IOUtil.writeString(out, Coder.encode(this.exportLocation));
        IOUtil.writeString(out, Coder.encode(this.command));
        out.writeInt(this.taskOption);
        out.writeInt(this.specifyDates.length);
        IOUtil.writeInts(out, this.specifyDates, this.specifyDates.length);
        out.writeInt(this.specifyDays.length);
        IOUtil.writeInts(out, this.specifyDays, this.specifyDays.length);
        out.writeLong(this.startDate);
        out.writeLong(this.endDate);
        out.writeInt(this.intervalType);
        out.writeInt(this.timeInterval);
        out.writeInt(this.monthInterval);
        out.writeInt(this.dayInterval);
        IOUtil.writeString(out, Coder.encode(this.userName));
        out.writeBoolean(this.paramList != null);
        if (this.paramList != null) {
            out.writeInt(this.paramList.size());
            for (int i = 0; i < this.paramList.size(); ++i) {
                Object[] obj = (Object[])this.paramList.elementAt(i);
                out.writeInt(obj.length);
                for (Object element : obj) {
                    if (element instanceof Vector) {
                        out.writeInt(1);
                        Vector values = (Vector)element;
                        out.writeInt(values.size());
                        for (int j = 0; j < values.size(); ++j) {
                            IOUtil.writeString(out, Coder.encode(DataType.write(values.elementAt(j))));
                        }
                        continue;
                    }
                    out.writeInt(2);
                    IOUtil.writeString(out, Coder.encode(DataType.write(element)));
                }
            }
        }
        out.writeBoolean(this.sendEmail);
        IOUtil.writeString(out, Coder.encode(this.fromAddress));
        out.writeBoolean(this.toAddresses != null);
        if (this.toAddresses != null) {
            out.writeInt(this.toAddresses.length);
            for (String toAddresse : this.toAddresses) {
                IOUtil.writeString(out, Coder.encode(toAddresse));
            }
        }
        IOUtil.writeString(out, Coder.encode(this.subject));
        IOUtil.writeString(out, Coder.encode(this.bodyText));
        out.writeInt(this.emailType);
        IOUtil.writeString(out, Coder.encode(this.urlMapping));
        IOUtil.writeStr(out, this.securityLevel);
        IOUtil.writeString(out, Coder.encode(this.serverName));
        IOUtil.writeString(out, Coder.encode(this.servletDir));
        out.writeInt(this.portNumber);
        out.writeBoolean(this.isExportToSingleWPagination);
        out.writeBoolean(this.isUseInternalStyleSheet);
        out.writeBoolean(this.isUseExternalStyleSheet);
        IOUtil.writeString(out, Coder.encode(this.externalStyleSheetName));
        out.writeBoolean(this.isEncodePDF);
        IOUtil.writeString(out, Coder.encode(this.pdfUserPassword));
        IOUtil.writeString(out, Coder.encode(this.pdfOwnerPassword));
        out.writeInt(this.textDelimiter);
        out.writeBoolean(this.attachTimestamp);
        VersioningDataOutput vout = (VersioningDataOutput)out;
        vout.writeInt(this.id, (short)147);
        vout.writeInt(this.packageID, (short)147);
        vout.writeInt(this.specifyTime.length, (short)147);
        IOUtil.writeInts(vout, this.specifyTime, this.specifyTime.length, (short)147);
        vout.writeInt(this.startTime, (short)147);
        vout.writeInt(this.endTime, (short)147);
        IOUtil.writeString(vout, Coder.encode(this.toAddressFail), (short)147);
        IOUtil.writeString(vout, Coder.encode(this.subjectFail), (short)147);
        IOUtil.writeString(vout, Coder.encode(this.bodyTextFail), (short)147);
        vout.writeInt(this.burstReport, (short)147);
        vout.writeInt(this.emailColumnIndex, (short)147);
        if (this.burstEmail == null || !this.sendEmail) {
            vout.writeInt(0, (short)147);
        } else {
            vout.writeInt(this.burstEmail.size(), (short)147);
            Enumeration e = this.burstEmail.keys();
            while (e.hasMoreElements()) {
                String paramSetName = (String)e.nextElement();
                String[] addresses = (String[])this.burstEmail.get(paramSetName);
                IOUtil.writeString(vout, paramSetName, (short)147);
                if (addresses == null) {
                    vout.writeInt(0, (short)147);
                    continue;
                }
                vout.writeInt(addresses.length, (short)147);
                for (String addresse : addresses) {
                    IOUtil.writeString(vout, Coder.encode(addresse), (short)147);
                }
            }
        }
        vout.writeInt(this.newlineDelimiter, (short)147);
        vout.writeBoolean(this.limitExcelCellSplit, (short)148);
    }

    public void writeComplete(DataOutput orgOut) throws Exception {
        DataOutput out = orgOut;
        if (!(orgOut instanceof VersioningDataOutput)) {
            out = new VersioningDataOutput(orgOut);
        }
        this.write(out);
        out.writeLong(this.exportTime);
    }

    private void setValues(DataInput orgIn, int version) throws Exception {
        int i;
        System.out.println("SET VALUE - VERSION = " + version);
        DataInput in = orgIn;
        if (version >= 147 && !(orgIn instanceof VersioningDataInput)) {
            in = new VersioningDataInput(orgIn, (short)version);
        }
        this.scheduleType = version <= 40 ? (in.readBoolean() ? 0 : 1) : in.readInt();
        this.exportType = in.readInt();
        this.reportType = in.readInt();
        this.multiPages = in.readBoolean();
        if (version > 41) {
            this.oneShotExport = in.readBoolean();
        }
        this.jpegQuality = in.readInt();
        this.gifTransparent = in.readBoolean();
        this.pngCompression = in.readInt();
        this.imageWidth = in.readInt();
        this.imageHeight = in.readInt();
        this.chartLocation = Coder.decode(IOUtil.readString(in, true));
        this.reportLocation = Coder.decode(IOUtil.readString(in, true));
        this.exportLocation = Coder.decode(IOUtil.readString(in, true));
        if (version > 40) {
            this.command = Coder.decode(IOUtil.readString(in, true));
        }
        this.taskOption = in.readInt();
        int ct = in.readInt();
        this.specifyDates = IOUtil.readInts(in, ct);
        ct = in.readInt();
        this.specifyDays = IOUtil.readInts(in, ct);
        this.startDate = in.readLong();
        this.endDate = in.readLong();
        this.intervalType = in.readInt();
        this.timeInterval = in.readInt();
        this.monthInterval = in.readInt();
        this.dayInterval = in.readInt();
        this.userName = Coder.decode(IOUtil.readString(in, true));
        if (version >= 104) {
            if (in.readBoolean()) {
                this.paramList = new Vector();
                int size = in.readInt();
                for (i = 0; i < size; ++i) {
                    int nCol = in.readInt();
                    Object[] row = new Object[nCol];
                    for (int k = 0; k < nCol; ++k) {
                        int choice = in.readInt();
                        if (choice == 1) {
                            Vector<Object> vec = new Vector<Object>();
                            int arr = in.readInt();
                            for (int j = 0; j < arr; ++j) {
                                vec.addElement(DataType.read(Coder.decode(IOUtil.readString(in, true))));
                            }
                            row[k] = vec;
                            continue;
                        }
                        row[k] = DataType.read(Coder.decode(IOUtil.readString(in, true)));
                    }
                    this.paramList.addElement(row);
                }
            } else {
                this.paramList = null;
            }
        }
        if (version >= 133) {
            this.sendEmail = in.readBoolean();
            this.fromAddress = Coder.decode(IOUtil.readString(in, true));
            boolean hasToAddress = in.readBoolean();
            if (hasToAddress) {
                int size = in.readInt();
                this.toAddresses = new String[size];
                for (int i2 = 0; i2 < size; ++i2) {
                    this.toAddresses[i2] = Coder.decode(IOUtil.readString(in, true));
                }
            }
            this.subject = Coder.decode(IOUtil.readString(in, true));
            this.bodyText = Coder.decode(IOUtil.readString(in, true));
            this.emailType = in.readInt();
            this.urlMapping = Coder.decode(IOUtil.readString(in, true));
        }
        if (version >= 143) {
            this.securityLevel = IOUtil.readStr(in);
        }
        if (version >= 144) {
            this.serverName = Coder.decode(IOUtil.readString(in, true));
            this.servletDir = Coder.decode(IOUtil.readString(in, true));
            this.portNumber = in.readInt();
        }
        if (version >= 145) {
            this.isExportToSingleWPagination = in.readBoolean();
            this.isUseInternalStyleSheet = in.readBoolean();
            this.isUseExternalStyleSheet = in.readBoolean();
            this.externalStyleSheetName = Coder.decode(IOUtil.readString(in, true));
            this.isEncodePDF = in.readBoolean();
            this.pdfUserPassword = Coder.decode(IOUtil.readString(in, true));
            this.pdfOwnerPassword = Coder.decode(IOUtil.readString(in, true));
            this.textDelimiter = in.readInt();
        }
        if (version >= 146) {
            this.attachTimestamp = in.readBoolean();
        }
        if (version >= 147) {
            VersioningDataInput vi = (VersioningDataInput)in;
            this.id = vi.readInt();
            this.packageID = vi.readInt();
            ct = vi.readInt();
            this.specifyTime = IOUtil.readInts(vi, ct);
            this.startTime = vi.readInt();
            this.endTime = vi.readInt();
            this.toAddressFail = Coder.decode(IOUtil.readString(vi, true));
            this.subjectFail = Coder.decode(IOUtil.readString(vi, true));
            this.bodyTextFail = Coder.decode(IOUtil.readString(vi, true));
            this.burstReport = vi.readInt();
            this.emailColumnIndex = vi.readInt();
            ct = vi.readInt();
            if (ct > 0) {
                this.burstEmail = new Hashtable();
                for (i = 0; i < ct; ++i) {
                    String paramName = IOUtil.readString(vi, true);
                    int ct2 = vi.readInt();
                    if (ct2 == 0) {
                        this.burstEmail.put(paramName, null);
                        continue;
                    }
                    String[] toAddresses2 = new String[ct2];
                    for (int ii = 0; ii < ct2; ++ii) {
                        toAddresses2[ii] = Coder.decode(IOUtil.readString(vi, true));
                    }
                    this.burstEmail.put(paramName, toAddresses2);
                }
            } else {
                this.burstEmail = null;
            }
            this.newlineDelimiter = in.readInt();
            if (version >= 148) {
                this.limitExcelCellSplit = in.readBoolean();
            }
        }
    }

    String print(long time) {
        return DateFormat.getDateTimeInstance().format(new Date(time));
    }

    public boolean isLimitExcelCellSplit() {
        return this.limitExcelCellSplit;
    }

    public void setLimitExcelCellSplit(boolean limitExcelCellSplit) {
        this.limitExcelCellSplit = limitExcelCellSplit;
    }
}

