/*
 * Decompiled with CFR 0.152.
 */
package quadbase.scheduler;

import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Calendar;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import quadbase.common.client.FileInfo;
import quadbase.common.swing.BrowseDialog;
import quadbase.common.util.BrowseDirectories;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.scheduler.ParamReport;
import quadbase.scheduler.ParamReportDialog;
import quadbase.scheduler.ReportOptionPanel;
import quadbase.scheduler.ScheduleModifier;
import quadbase.scheduler.ScheduleObject;
import quadbase.scheduler.ScheduleSummaryDialog;
import quadbase.scheduler.Scheduler;
import quadbase.scheduler.ServerPortDialog;
import quadbase.scheduler.SetScheduleDialog;
import quadbase.scheduler.SetScheduleEmailDialog2;

public class ScheduleReportDialog
extends JDialog
implements ActionListener,
ItemListener {
    private JButton browse;
    private JButton ok;
    private JButton cancel;
    private JButton browse2;
    private JTextField fileField;
    private JTextField nameField;
    private JTextField pathField;
    private JCheckBox chosenByServer;
    private JCheckBox appendTimestamp;
    private Scheduler parent;
    private BrowseDialog browseDialog;
    private BrowseDialog browseDialog2;
    private ScheduleObject schObj = null;
    private SetScheduleDialog schDialog = null;
    private SetScheduleEmailDialog2 emailDialog = null;
    private String reportLocation;
    private boolean editSchedule = false;
    private int row;
    private ReportOptionPanel rptPanel;
    static String SEPARATOR = "/";
    static String SCHEDULEDREPORT = "ScheduledReports";
    private boolean isCancelled = false;
    private boolean showEmailDialog = true;
    private String securityLevel = null;
    BrowseDirectories browseDir;
    private ParamReportDialog paramDialog = null;

    public ScheduleReportDialog(Scheduler parent) {
        super(parent.getFrame(), LanguageEncoder.getText("Set Schedule"), true);
        this.parent = parent;
        this.init();
        this.setPosition();
    }

    public ScheduleReportDialog(Scheduler parent, ScheduleObject schObj, int row) {
        super(parent.getFrame(), LanguageEncoder.getText("Edit Schedule"), true);
        this.parent = parent;
        this.editSchedule = true;
        this.schObj = schObj;
        this.row = row;
        this.reportLocation = schObj.getReportLocation();
        this.init();
        this.setPosition();
    }

    void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    void init() {
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JPanel topPanel = new JPanel();
        topPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Name")));
        topPanel.setLayout(new FlowLayout(0));
        JLabel nameLbl = new JLabel(LanguageEncoder.getText("Display Name:"));
        this.nameField = new JTextField(20);
        nameLbl.setAlignmentY(0.5f);
        topPanel.add(nameLbl);
        topPanel.add(this.nameField);
        JPanel filePanel = new JPanel();
        filePanel.setBorder(new TitledBorder(LanguageEncoder.getText("Report Location")));
        filePanel.setLayout(new FlowLayout(0));
        this.fileField = new JTextField(20);
        this.browse2 = new JButton(LanguageEncoder.getText("Browse..."));
        this.browse2.addActionListener(this);
        filePanel.add(this.fileField);
        filePanel.add(this.browse2);
        this.rptPanel = new ReportOptionPanel(this, this.schObj);
        JPanel radioPanel = new JPanel();
        radioPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Export Location")));
        radioPanel.setLayout(new BoxLayout(radioPanel, 1));
        JPanel pathPanel = new JPanel();
        pathPanel.setLayout(new FlowLayout(0));
        JPanel urlPanel = new JPanel();
        urlPanel.setLayout(new FlowLayout(0));
        JPanel pathFieldPanel = new JPanel();
        pathFieldPanel.setLayout(new FlowLayout(0));
        this.pathField = new JTextField(20);
        this.browse = new JButton(LanguageEncoder.getText("Browse..."));
        this.browse.addActionListener(this);
        pathFieldPanel.add(this.pathField);
        pathFieldPanel.add(this.browse);
        radioPanel.add(pathPanel);
        radioPanel.add(pathFieldPanel);
        radioPanel.add(urlPanel);
        JPanel checkBoxPanel = new JPanel();
        checkBoxPanel.setLayout(new FlowLayout(0));
        this.chosenByServer = new JCheckBox(LanguageEncoder.getText("Chosen by server"), true);
        checkBoxPanel.add(this.chosenByServer);
        this.appendTimestamp = new JCheckBox(LanguageEncoder.getText("Append Timestamp"), true);
        checkBoxPanel.add(this.appendTimestamp);
        this.chosenByServer.addItemListener(this);
        this.appendTimestamp.addItemListener(this);
        radioPanel.add(checkBoxPanel);
        contentPane.add(topPanel);
        contentPane.add(filePanel);
        contentPane.add(this.rptPanel);
        contentPane.add(radioPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(new EmptyBorder(20, 0, 20, 0));
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        this.ok = new JButton(LanguageEncoder.getText("Next"));
        this.cancel = new JButton(LanguageEncoder.getText("Cancel"));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.ok);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.cancel);
        buttonPanel.add(Box.createHorizontalGlue());
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        contentPane.add(buttonPanel);
        this.setValues();
        this.itemStateChanged(null);
    }

    private void setValues() {
        if (this.schObj == null) {
            return;
        }
        this.fileField.setText(this.schObj.getReportLocation());
        this.nameField.setText(this.schObj.getName());
        this.pathField.setText(this.schObj.getExportLocation());
        this.chosenByServer.setSelected(false);
        this.rptPanel.setValues();
    }

    private String loadFile() {
        if (this.browseDialog == null) {
            this.browseDialog = BrowseDialog.create(this.parent.getFrame(), this.browseDir.getSchedulerReportExportsDir());
        }
        this.browseDialog.setVisible(true);
        if (this.browseDialog.getSelectedFile() != null) {
            this.browseDir.setSchedulerReportExportsDir(this.browseDialog.getCurrentDirectory());
        }
        return this.browseDialog.getSelectedFile();
    }

    private String loadFile2() {
        if (this.browseDialog2 == null) {
            this.browseDialog2 = BrowseDialog.create(this.parent.getFrame(), this.browseDir.getReportTemplatesDirectory(), new String[]{"RPT", "XML", "PAK"});
        }
        this.browseDialog2.setVisible(true);
        if (this.browseDialog2.getSelectedFile() != null) {
            this.browseDir.setReportTemplatesDirectory(this.browseDialog2.getCurrentDirectory());
        }
        return this.browseDialog2.getSelectedFile();
    }

    ScheduleObject getScheduleObject() {
        return this.schObj;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.pathField.setEditable(!this.chosenByServer.isSelected());
        this.browse.setEnabled(!this.chosenByServer.isSelected());
    }

    boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        if (target == this.cancel) {
            this.isCancelled = true;
            this.setVisible(false);
            this.dispose();
        } else if (target == this.browse) {
            String path;
            boolean replaceName = false;
            if (this.nameField.getText().trim().equals("") || this.nameField.getText() == null) {
                replaceName = true;
            }
            if (!replaceName && !QbUtil.findName(this.pathField.getText()).equals("") && QbUtil.findName(this.pathField.getText()).equals(this.nameField.getText())) {
                replaceName = true;
            }
            if ((path = this.loadFile()) != null) {
                this.pathField.setText(path);
                if (replaceName) {
                    this.nameField.setText(QbUtil.findName(path));
                }
            }
        } else if (target == this.browse2) {
            String path = this.loadFile2();
            if (path != null) {
                this.fileField.setText(path);
            }
        } else if (target == this.ok) {
            try {
                String absolutePath = "";
                String msg = null;
                if (this.fileField.getText() == null || this.fileField.getText().trim().equals("")) {
                    msg = LanguageEncoder.getText("Please enter report file location!");
                }
                FileInfo fileInfo = new FileInfo(this.fileField.getText());
                if (msg == null && !fileInfo.exists()) {
                    msg = LanguageEncoder.getText("File doesn't exist!");
                }
                if (msg == null && fileInfo.isDirectory()) {
                    msg = LanguageEncoder.getText("Please enter report file location!");
                }
                if (msg != null) {
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), msg);
                    return;
                }
                this.reportLocation = fileInfo.getAbsolutePath();
                if (!this.chosenByServer.isSelected()) {
                    if (this.pathField.getText() == null || this.pathField.getText().trim().equals("")) {
                        msg = LanguageEncoder.getText("Please enter export file location!");
                        new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), msg);
                        return;
                    }
                    absolutePath = new FileInfo(this.pathField.getText()).getAbsolutePath();
                } else {
                    absolutePath = new FileInfo(SCHEDULEDREPORT + SEPARATOR + QbUtil.findName(this.reportLocation)).getAbsolutePath();
                }
                if (this.nameField.getText() == null || this.nameField.getText().trim().equals("")) {
                    msg = LanguageEncoder.getText("Invalid Task Title!");
                } else if (this.nameField.getText().length() > 40) {
                    msg = LanguageEncoder.getText("A task title you specified contains more than 40 characters");
                }
                if (msg != null) {
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), msg);
                    return;
                }
                this.setVisible(false);
                String schName = "";
                schName = this.nameField.getText();
                if (this.schObj == null) {
                    this.schObj = new ScheduleObject(schName, false);
                    Calendar startDate = Calendar.getInstance();
                    startDate.add(12, 10);
                    Calendar endDate = Calendar.getInstance();
                    endDate.add(12, 15);
                    this.schObj.setStartDate(startDate.getTime().getTime());
                    this.schObj.setEndDate(endDate.getTime().getTime());
                } else {
                    this.schObj.setName(schName);
                }
                this.schObj.setReportType(this.rptPanel.getReportType());
                if (this.rptPanel.isOptionChanged()) {
                    this.schObj.setExportToMultiPages(this.rptPanel.isExportToMultiPages());
                    this.schObj.setMemoryOptimized(this.rptPanel.isMemoryOptimized());
                    this.schObj.setExportToSingleWPagination(this.rptPanel.isExportToSingleWPagination());
                    this.schObj.setUseInternalStyleSheet(this.rptPanel.isUseInternalStyleSheet());
                    this.schObj.setUseExternalStyleSheet(this.rptPanel.isUseExternalStyleSheet());
                    if (this.rptPanel.isUseExternalStyleSheet()) {
                        this.schObj.setExternalStyleSheetName(this.rptPanel.getExternalStyleSheetName());
                    }
                    this.schObj.setEncodePDF(this.rptPanel.isEncodePDF());
                    if (this.rptPanel.isEncodePDF()) {
                        this.schObj.setPDFUserPassword(this.rptPanel.getPDFUserPassword());
                        this.schObj.setPDFOwnerPassword(this.rptPanel.getPDFOwnerPassword());
                    }
                    this.schObj.setTextDelimiter(this.rptPanel.getTextDelimiter());
                }
                this.schObj.setTimestampAttached(this.appendTimestamp.isSelected());
                this.schObj.setReportLocation(this.reportLocation);
                this.schObj.setExportLocation(absolutePath);
                if (this.next()) {
                    this.setVisible(true);
                } else {
                    this.setVisible(false);
                    this.dispose();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    boolean next() throws Exception {
        boolean finish;
        do {
            if (this.schDialog == null) {
                this.schDialog = new SetScheduleDialog(this.parent, this.schObj);
            }
            if (this.schObj != null) {
                this.schDialog.preSetValues(this.schObj);
            }
            this.schDialog.setVisible(true);
            if (this.schDialog.goBack()) {
                return true;
            }
            this.schDialog.setValues(this.schObj);
            if (!this.schDialog.isCancel()) continue;
            this.isCancelled = true;
            return false;
        } while ((finish = this.next1()) || this.paramDialog != null && this.paramDialog.isBack());
        return false;
    }

    boolean next1() throws Exception {
        ParamReport paramReport = new ParamReport(this.schObj.getReportLocation(), null);
        if (!paramReport.isReportCreated()) {
            this.isCancelled = true;
            return false;
        }
        if (paramReport.promptServletPortDialog(this.schObj.getReportType())) {
            ServerPortDialog sDialog = new ServerPortDialog(this.parent.getFrame());
            sDialog.setVisible(true);
            if (sDialog.isModified()) {
                this.schObj.setServerName(sDialog.getServerName());
                this.schObj.setServletDirectory(sDialog.getServletDirectory());
                this.schObj.setPortNumber(sDialog.getPortNumber());
            } else {
                this.isCancelled = true;
                return false;
            }
        }
        if (this.paramDialog != null) {
            this.paramDialog.resetDialog();
        }
        String[] securitylevels = paramReport.getSecurityLevels();
        String oldSecurityLevel = null;
        if (securitylevels.length > 0) {
            Object[] choices = new String[securitylevels.length + 1];
            choices[0] = "-- Default --";
            boolean showDialog = true;
            for (int i = 0; i < securitylevels.length; ++i) {
                if (this.securityLevel != null && this.securityLevel.equals(securitylevels[i])) {
                    showDialog = false;
                    this.schObj.setSecurityLevel(this.securityLevel);
                }
                choices[i + 1] = securitylevels[i];
            }
            if (showDialog) {
                Object selectedValue;
                String initialChoice;
                oldSecurityLevel = initialChoice = this.schObj.getSecurityLevel();
                if (initialChoice == null) {
                    initialChoice = "-- Default --";
                }
                if ((selectedValue = JOptionPane.showInputDialog(this.parent, LanguageEncoder.getText("Choose Security Level:"), LanguageEncoder.getText("Export Security Level"), 1, null, choices, initialChoice)) == null) {
                    this.isCancelled = true;
                    return false;
                }
                if (selectedValue.equals("-- Default --")) {
                    this.schObj.setSecurityLevel(null);
                } else {
                    this.schObj.setSecurityLevel(selectedValue.toString());
                }
            }
        }
        Vector<Object[]> paramList = this.schObj.getParamList();
        paramReport.setSecurityLevel(this.schObj.getSecurityLevel());
        if (paramReport.containsPromptParam()) {
            if (oldSecurityLevel == null && this.schObj.getSecurityLevel() != null || oldSecurityLevel != null && this.schObj.getSecurityLevel() == null || oldSecurityLevel != null && this.schObj.getSecurityLevel() != null && !oldSecurityLevel.equals(this.schObj.getSecurityLevel())) {
                this.schObj.setParamList(null);
            }
            do {
                this.paramDialog = new ParamReportDialog(this.parent, paramReport, this.schObj);
                this.paramDialog.setVisible(true);
                if (this.paramDialog.isCancelled() || this.paramDialog.isBack()) {
                    this.schObj.setParamList(paramList);
                    this.isCancelled = true;
                    return false;
                }
                if (this.next2()) {
                    return true;
                }
                if (!this.emailDialog.isCancel()) continue;
                this.isCancelled = true;
                return false;
            } while (this.emailDialog.isBack());
            return false;
        }
        boolean result = this.next2();
        if (this.emailDialog.isBack()) {
            return true;
        }
        return result;
    }

    boolean next2() throws Exception {
        if (this.schObj != null && this.schObj.isExportToMultiPages()) {
            this.schObj.setSendEmail(false);
            this.showEmailDialog = false;
        }
        if (this.showEmailDialog) {
            if (this.emailDialog == null) {
                this.emailDialog = new SetScheduleEmailDialog2(this.parent, this.schObj);
            }
            if (this.schObj != null && this.emailDialog != null) {
                this.emailDialog.preSetValues(this.schObj);
            }
            this.emailDialog.setVisible(true);
            if (this.emailDialog.isCancel()) {
                this.isCancelled = true;
                return false;
            }
            if (this.emailDialog.isBack()) {
                return false;
            }
            this.emailDialog.setValues(this.schObj);
        }
        if (this.editSchedule) {
            this.schObj.resetExportTime();
            ScheduleModifier.modifyScheduleTask(this.schObj, this.row);
        } else {
            ScheduleModifier.addScheduleTask(this.schObj);
        }
        new ScheduleSummaryDialog(this.parent, this.schObj).setVisible(true);
        return false;
    }

    public void setSecurityLevel(String sl) {
        this.securityLevel = sl;
    }

    public String getSecurityLevel() {
        return this.securityLevel;
    }

    public void setBrowseDirectories(BrowseDirectories dir) {
        this.browseDir = dir;
        if (this.fileField.getText() == null || this.fileField.getText().trim().length() == 0) {
            this.fileField.setText(this.browseDir.getReportTemplatesDirectory());
        }
        if (this.pathField.getText() == null || this.pathField.getText().trim().length() == 0) {
            this.pathField.setText(this.browseDir.getSchedulerReportExportsDir());
        }
    }
}

