/*
 * Decompiled with CFR 0.152.
 */
package quadbase.scheduler;

import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Calendar;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import quadbase.common.client.FileInfo;
import quadbase.common.swing.BrowseDialog;
import quadbase.common.util.BrowseDirectories;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.scheduler.PackageDialog;
import quadbase.scheduler.ReportOptionPanel2;
import quadbase.scheduler.ScheduleObject;
import quadbase.scheduler.Scheduler;

public class ScheduleReportPanel
extends JPanel
implements ActionListener,
ItemListener {
    static String SEPARATOR = "/";
    static String SCHEDULEDREPORT = "ScheduledReports";
    private JButton browse;
    private JButton browse2;
    private JButton ok;
    private JButton cancel;
    private JButton done;
    private JTextField fileField;
    private JTextField nameField;
    private JTextField pathField;
    private JCheckBox chosenByServer;
    private JCheckBox attachTimestamp;
    private Scheduler parent;
    private BrowseDialog browseDialog;
    private BrowseDialog browseDialog2;
    private ScheduleObject schObj = null;
    private String reportLocation;
    private boolean editSchedule = false;
    private ReportOptionPanel2 rptPanel;
    private boolean isCancelled = false;
    private PackageDialog parentDialog = null;
    private boolean popWarning = false;

    public ScheduleReportPanel(Scheduler parent, PackageDialog parentDialog) {
        this.parent = parent;
        this.parentDialog = parentDialog;
        this.reportLocation = null;
        this.init();
    }

    public ScheduleReportPanel(Scheduler parent, PackageDialog parentDialog, ScheduleObject schObj) {
        this.parent = parent;
        this.parentDialog = parentDialog;
        this.editSchedule = true;
        this.schObj = schObj;
        this.reportLocation = schObj.getReportLocation();
        this.init();
    }

    void init() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel topPanel = new JPanel();
        topPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Name")));
        topPanel.setLayout(new FlowLayout(0));
        JLabel nameLbl = new JLabel(LanguageEncoder.getText("Display Name:"));
        this.nameField = new JTextField(20);
        nameLbl.setAlignmentY(0.5f);
        topPanel.add(nameLbl);
        topPanel.add(this.nameField);
        if (this.parentDialog.isScheduling()) {
            this.rptPanel = new ReportOptionPanel2(this.parentDialog, this.schObj);
        }
        JPanel filePanel = new JPanel();
        filePanel.setBorder(new TitledBorder(LanguageEncoder.getText("Report Location")));
        filePanel.setLayout(new FlowLayout(0));
        this.fileField = new JTextField(20);
        this.browse2 = new JButton(LanguageEncoder.getText("Browse..."));
        this.browse2.addActionListener(this);
        filePanel.add(this.fileField);
        filePanel.add(this.browse2);
        JPanel radioPanel = new JPanel();
        radioPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Export Location")));
        radioPanel.setLayout(new BoxLayout(radioPanel, 1));
        JPanel pathPanel = new JPanel();
        pathPanel.setLayout(new FlowLayout(0));
        JPanel urlPanel = new JPanel();
        urlPanel.setLayout(new FlowLayout(0));
        JPanel pathFieldPanel = new JPanel();
        pathFieldPanel.setLayout(new FlowLayout(0));
        this.pathField = new JTextField(20);
        this.browse = new JButton(LanguageEncoder.getText("Browse..."));
        this.browse.addActionListener(this);
        pathFieldPanel.add(this.pathField);
        pathFieldPanel.add(this.browse);
        radioPanel.add(pathPanel);
        radioPanel.add(pathFieldPanel);
        radioPanel.add(urlPanel);
        JPanel checkBoxPanel = new JPanel();
        checkBoxPanel.setLayout(new FlowLayout(0));
        this.chosenByServer = new JCheckBox(LanguageEncoder.getText("Chosen by server"), true);
        if (!this.editSchedule) {
            checkBoxPanel.add(this.chosenByServer);
        }
        this.attachTimestamp = new JCheckBox(LanguageEncoder.getText("Append Timestamp"), false);
        if (this.parentDialog.isScheduling()) {
            checkBoxPanel.add(this.attachTimestamp);
        }
        this.chosenByServer.addItemListener(this);
        this.attachTimestamp.addItemListener(this);
        radioPanel.add(checkBoxPanel);
        this.add(topPanel);
        this.add(filePanel);
        if (this.rptPanel != null) {
            this.add(this.rptPanel);
        }
        this.add(radioPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(new EmptyBorder(20, 0, 20, 0));
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        this.ok = new JButton(LanguageEncoder.getText("Next"));
        this.cancel = new JButton(LanguageEncoder.getText("Cancel"));
        this.done = new JButton(LanguageEncoder.getText("Done"));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.ok);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.cancel);
        buttonPanel.add(Box.createHorizontalGlue());
        if (this.parentDialog.inEditMode()) {
            buttonPanel.add(this.done);
            buttonPanel.add(Box.createHorizontalGlue());
        }
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        this.done.addActionListener(this);
        this.add(buttonPanel);
        this.setValues();
        this.itemStateChanged(null);
    }

    private void setValues() {
        if (this.schObj == null) {
            return;
        }
        this.nameField.setText(this.schObj.getName());
        this.pathField.setText(this.schObj.getExportLocation());
        this.fileField.setText(this.schObj.getReportLocation());
        this.chosenByServer.setSelected(false);
        this.attachTimestamp.setSelected(this.schObj.isTimestampAttached());
        if (this.rptPanel != null) {
            this.rptPanel.setValues();
        }
    }

    private String loadFile() {
        if (this.browseDialog == null) {
            this.browseDialog = BrowseDialog.create(this.parent.getFrame(), this.parent.browseDir.getSchedulerReportExportsDir());
        }
        this.browseDialog.setVisible(true);
        if (this.browseDialog.getSelectedFile() != null) {
            this.parent.browseDir.setSchedulerReportExportsDir(this.browseDialog.getCurrentDirectory());
        }
        return this.browseDialog.getSelectedFile();
    }

    private String loadFile2() {
        if (this.browseDialog2 == null) {
            this.browseDialog2 = BrowseDialog.create(this.parent.getFrame(), this.parent.browseDir.getReportTemplatesDirectory(), new String[]{"RPT", "XML", "PAK"});
        }
        this.browseDialog2.setVisible(true);
        if (this.browseDialog2.getSelectedFile() != null) {
            this.parent.browseDir.setReportTemplatesDirectory(this.browseDialog2.getCurrentDirectory());
        }
        return this.browseDialog2.getSelectedFile();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.pathField.setEditable(!this.chosenByServer.isSelected());
        this.browse.setEnabled(!this.chosenByServer.isSelected());
    }

    ScheduleObject getScheduleObject() {
        return this.schObj;
    }

    public boolean popWarning() {
        return this.popWarning;
    }

    public void resetWarning() {
        this.popWarning = false;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void setBrowseDirectories(BrowseDirectories dir) {
        this.parent.browseDir = dir;
        if (this.fileField.getText() == null || this.fileField.getText().trim().length() == 0) {
            this.fileField.setText(this.parent.browseDir.getReportTemplatesDirectory());
        }
        if (this.pathField.getText() == null || this.pathField.getText().trim().length() == 0) {
            this.pathField.setText(this.parent.browseDir.getSchedulerReportExportsDir());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target;
        this.popWarning = false;
        boolean switchByTab = false;
        if (e == null) {
            target = this.ok;
            switchByTab = true;
        } else {
            target = e.getSource();
        }
        if (target == this.cancel) {
            this.isCancelled = true;
            this.parentDialog.setCancelled();
            this.parentDialog.setVisible(false);
            this.parentDialog.dispose();
        } else if (target == this.browse) {
            String path;
            boolean replaceName = false;
            if (this.nameField.getText().trim().equals("") || this.nameField.getText() == null) {
                replaceName = true;
            }
            if (!replaceName && !QbUtil.findName(this.pathField.getText()).equals("") && QbUtil.findName(this.pathField.getText()).equals(this.nameField.getText())) {
                replaceName = true;
            }
            if ((path = this.loadFile()) != null) {
                this.pathField.setText(path);
                if (replaceName) {
                    this.nameField.setText(QbUtil.findName(path));
                }
            }
        } else if (target == this.browse2) {
            String path = this.loadFile2();
            if (path != null) {
                this.fileField.setText(path);
            }
        } else if (target == this.ok || target == this.done) {
            try {
                String absolutePath = "";
                String url = "http://";
                String msg = null;
                if (this.fileField.getText() == null || this.fileField.getText().trim().equals("")) {
                    msg = LanguageEncoder.getText("Please enter report file location!");
                }
                FileInfo fileInfo = new FileInfo(this.fileField.getText());
                if (msg == null && !fileInfo.exists()) {
                    msg = LanguageEncoder.getText("File doesn't exist!");
                }
                if (msg == null && fileInfo.isDirectory()) {
                    msg = LanguageEncoder.getText("Please enter report file location!");
                }
                if (msg != null) {
                    new JMessageDialog((Frame)this.parent.getFrame(), LanguageEncoder.getText("Error"), msg);
                    return;
                }
                this.reportLocation = fileInfo.getAbsolutePath();
                if (this.editSchedule || !this.chosenByServer.isSelected()) {
                    if (this.pathField.getText() == null || this.pathField.getText().trim().equals("")) {
                        msg = LanguageEncoder.getText("Please enter export file location!");
                        this.popWarning = true;
                        new JMessageDialog((Dialog)this.parentDialog, LanguageEncoder.getText("Error"), msg);
                        return;
                    }
                    if (this.pathField.getText().endsWith("\\") || this.pathField.getText().endsWith("/")) {
                        msg = LanguageEncoder.getText("Invalid path: Please enter file name!");
                        this.popWarning = true;
                        new JMessageDialog((Dialog)this.parentDialog, LanguageEncoder.getText("Error"), msg);
                        return;
                    }
                    if (this.pathField.getText() == null || this.pathField.getText().trim().equals("")) {
                        msg = LanguageEncoder.getText("Please enter export file location!");
                        new JMessageDialog((Frame)this.parent.getFrame(), LanguageEncoder.getText("Error"), msg);
                        return;
                    }
                    absolutePath = new FileInfo(this.pathField.getText()).getAbsolutePath();
                    if (QbUtil.containInvalidChar(absolutePath)) {
                        msg = LanguageEncoder.getText("A file location cannot contain any of the following characters:") + " " + QbUtil.invalidCharSet;
                        this.popWarning = true;
                        new JMessageDialog((Dialog)this.parentDialog, LanguageEncoder.getText("Error"), msg);
                        return;
                    }
                    absolutePath = QbUtil.removeExtension(absolutePath);
                    if (this.nameField.getText() == null || this.nameField.getText().trim().equals("")) {
                        this.nameField.setText(QbUtil.findName(absolutePath));
                    }
                } else {
                    absolutePath = new FileInfo(SCHEDULEDREPORT + SEPARATOR + QbUtil.findName(this.reportLocation)).getAbsolutePath();
                }
                if (this.nameField.getText() == null || this.nameField.getText().trim().equals("")) {
                    msg = LanguageEncoder.getText("Invalid Task Title!");
                } else if (this.nameField.getText().length() > 40) {
                    msg = LanguageEncoder.getText("A task title you specified contains more than 40 characters");
                } else if (QbUtil.containInvalidChar(this.nameField.getText())) {
                    msg = LanguageEncoder.getText("A filename cannot contain any of the following characters:") + " " + QbUtil.invalidCharSet;
                }
                if (msg != null) {
                    this.popWarning = true;
                    new JMessageDialog((Dialog)this.parentDialog, LanguageEncoder.getText("Warning"), msg);
                    return;
                }
                String schName = "";
                schName = this.nameField.getText();
                if (this.schObj == null) {
                    this.schObj = new ScheduleObject(schName, false);
                    Calendar startDate = Calendar.getInstance();
                    startDate.add(12, 10);
                    Calendar endDate = Calendar.getInstance();
                    endDate.add(5, 1);
                    endDate.add(12, 10);
                    this.schObj.setStartDate(startDate.getTime().getTime());
                    this.schObj.setEndDate(endDate.getTime().getTime());
                } else {
                    this.schObj.setName(schName);
                }
                this.schObj.setTimestampAttached(this.attachTimestamp.isSelected());
                if (!this.parentDialog.inEditMode()) {
                    this.schObj.setURLMapping(url);
                }
                if (this.rptPanel != null) {
                    this.schObj.setReportType(this.rptPanel.getReportType());
                    if (this.rptPanel.isOptionChanged()) {
                        this.schObj.setExportToMultiPages(this.rptPanel.isExportToMultiPages());
                        this.schObj.setMemoryOptimized(this.rptPanel.isMemoryOptimized());
                        this.schObj.setExportToSingleWPagination(this.rptPanel.isExportToSingleWPagination());
                        this.schObj.setUseInternalStyleSheet(this.rptPanel.isUseInternalStyleSheet());
                        this.schObj.setUseExternalStyleSheet(this.rptPanel.isUseExternalStyleSheet());
                        if (this.rptPanel.isUseExternalStyleSheet()) {
                            this.schObj.setExternalStyleSheetName(this.rptPanel.getExternalStyleSheetName());
                        }
                        this.schObj.setEncodePDF(this.rptPanel.isEncodePDF());
                        if (this.rptPanel.isEncodePDF()) {
                            this.schObj.setPDFUserPassword(this.rptPanel.getPDFUserPassword());
                            this.schObj.setPDFOwnerPassword(this.rptPanel.getPDFOwnerPassword());
                        }
                        this.schObj.setTextDelimiter(this.rptPanel.getTextDelimiter());
                        this.schObj.setNewLineDelimiter(this.rptPanel.getNewLineDelimiter());
                        this.schObj.setLimitExcelCellSplit(this.rptPanel.isLimitExcelCellSplit());
                    }
                }
                this.schObj.setReportLocation(this.reportLocation);
                this.schObj.setExportLocation(absolutePath);
                this.parentDialog.setScheduleObject(this.schObj);
                try {
                    this.parentDialog.createSetParametersPanel();
                }
                catch (Exception ex1) {
                    return;
                }
                if (this.parentDialog.inEditMode() || this.parentDialog.isTabbedPanelEnabled(2) || this.parentDialog.isTabbedPanelEnabled(3)) {
                    this.parentDialog.enableSetParametersPanel();
                }
                if (target == this.done) {
                    this.parentDialog.showSummaryDialog();
                    return;
                }
                if (!switchByTab) {
                    this.parentDialog.showSetTimingPanel(false);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    void setValues(ScheduleObject rptObj) {
        rptObj.setTimestampAttached(this.attachTimestamp.isSelected());
        if (this.rptPanel != null) {
            rptObj.setReportType(this.rptPanel.getReportType());
            if (this.rptPanel.isOptionChanged()) {
                rptObj.setExportToMultiPages(this.rptPanel.isExportToMultiPages());
                rptObj.setMemoryOptimized(this.rptPanel.isMemoryOptimized());
                rptObj.setExportToSingleWPagination(this.rptPanel.isExportToSingleWPagination());
                rptObj.setUseInternalStyleSheet(this.rptPanel.isUseInternalStyleSheet());
                rptObj.setUseExternalStyleSheet(this.rptPanel.isUseExternalStyleSheet());
                if (this.rptPanel.isUseExternalStyleSheet()) {
                    rptObj.setExternalStyleSheetName(this.rptPanel.getExternalStyleSheetName());
                }
                rptObj.setEncodePDF(this.rptPanel.isEncodePDF());
                if (this.rptPanel.isEncodePDF()) {
                    rptObj.setPDFUserPassword(this.rptPanel.getPDFUserPassword());
                    rptObj.setPDFOwnerPassword(this.rptPanel.getPDFOwnerPassword());
                }
                rptObj.setTextDelimiter(this.rptPanel.getTextDelimiter());
                rptObj.setNewLineDelimiter(this.rptPanel.getNewLineDelimiter());
            }
        }
    }
}

