/*
 * Decompiled with CFR 0.152.
 */
package quadbase.scheduler;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.scheduler.PackageDialog;
import quadbase.scheduler.ScheduleObject;
import quadbase.scheduler.Scheduler;

public class ScheduleSummaryDialog
extends JDialog
implements ActionListener {
    private JButton ok;
    private JButton cancel;
    private ScheduleObject schObj;
    private PackageDialog packageDialog;

    public ScheduleSummaryDialog(Scheduler org, ScheduleObject schObj) {
        this(org, schObj, null);
    }

    public ScheduleSummaryDialog(Scheduler org, ScheduleObject schObj, PackageDialog packageDialog) {
        super(org.getFrame(), LanguageEncoder.getText("Schedule Detail"), true);
        this.schObj = schObj;
        this.packageDialog = packageDialog;
        this.init();
        this.setPosition();
    }

    void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    void init() {
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JPanel topPanel = new JPanel();
        topPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Information")));
        topPanel.setLayout(new BorderLayout());
        JLabel displayNameLbl = new JLabel(LanguageEncoder.getText("Display Name:"));
        JTextField displayNameVal = new JTextField(this.schObj.getName());
        displayNameVal.setEditable(false);
        JLabel exportTimeLbl = new JLabel(LanguageEncoder.getText("Next Export Time:"));
        long time = this.schObj.getNextExportTime();
        if (time == -1L) {
            JTextField jTextField = new JTextField(LanguageEncoder.getText("Deleted"));
        }
        JTextField exportTimeVal = new JTextField(DateFormat.getDateTimeInstance(2, 3).format(new Date(time)));
        exportTimeVal.setEditable(false);
        JLabel chartLbl = new JLabel(LanguageEncoder.getText("File Name:"));
        JTextField chartVal = new JTextField(this.schObj.getFileLocation());
        chartVal.setEditable(false);
        JLabel exportPathLbl = new JLabel(LanguageEncoder.getText("Export Path:"));
        JTextField exportPathVal = new JTextField(this.schObj.getExportLocation());
        exportPathVal.setEditable(false);
        JLabel commandLbl = new JLabel(LanguageEncoder.getText("Command:"));
        JTextField commandVal = new JTextField(this.schObj.getCommand());
        commandVal.setEditable(false);
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new GridLayout(0, 1, 5, 5));
        labelPanel.add(displayNameLbl);
        labelPanel.add(exportTimeLbl);
        if (this.schObj.isCommand()) {
            labelPanel.add(commandLbl);
        } else {
            labelPanel.add(chartLbl);
            labelPanel.add(exportPathLbl);
        }
        JPanel valPanel = new JPanel();
        valPanel.setLayout(new GridLayout(0, 1, 5, 5));
        valPanel.add(displayNameVal);
        valPanel.add(exportTimeVal);
        if (this.schObj.isCommand()) {
            valPanel.add(commandVal);
        } else {
            valPanel.add(chartVal);
            valPanel.add(exportPathVal);
        }
        topPanel.add("West", labelPanel);
        topPanel.add("Center", valPanel);
        contentPane.add(topPanel);
        JPanel buttonPanel = new JPanel();
        if (this.packageDialog != null) {
            this.ok = new JButton(LanguageEncoder.getText("confirm"));
            this.ok.addActionListener(this);
            this.cancel = new JButton(LanguageEncoder.getText("back"));
            this.cancel.addActionListener(this);
            buttonPanel.setBorder(new EmptyBorder(20, 0, 20, 0));
            buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
            buttonPanel.add(Box.createHorizontalGlue());
            buttonPanel.add(this.ok);
            buttonPanel.add(Box.createHorizontalGlue());
            buttonPanel.add(this.cancel);
            buttonPanel.add(Box.createHorizontalGlue());
        } else {
            this.ok = new JButton(LanguageEncoder.getText("ok"));
            this.ok.addActionListener(this);
            buttonPanel.setLayout(new BorderLayout());
            buttonPanel.add("Center", this.ok);
        }
        contentPane.add(buttonPanel);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        this.setVisible(false);
        this.dispose();
        if (this.packageDialog != null && target == this.ok) {
            this.packageDialog.setValues();
            this.packageDialog.setVisible(false);
            this.packageDialog.dispose();
        }
    }
}

