/*
 * Decompiled with CFR 0.152.
 */
package quadbase.scheduler;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.scheduler.ScheduleModifier;
import quadbase.scheduler.ScheduleObject;

public class ScheduleTableModel
extends DefaultTableModel
implements Serializable {
    private Vector<ScheduleObject> schedList;
    private Vector<Vector<Object>> data = null;
    private String[] header = new String[]{LanguageEncoder.getText("TASK"), LanguageEncoder.getText("NEXT EXPORT TIME"), LanguageEncoder.getText("FILE LOCATION"), LanguageEncoder.getText("EXPORT LOCATION"), LanguageEncoder.getText("COMMAND")};

    public ScheduleTableModel(Vector<ScheduleObject> schedList) {
        this.schedList = schedList;
        this.updateDataVector();
    }

    private void updateDataVector() {
        try {
            this.data = new Vector();
            if (this.schedList == null) {
                return;
            }
            for (int i = 0; i < this.schedList.size(); ++i) {
                Vector<String> row = new Vector<String>();
                ScheduleObject schObj = this.schedList.elementAt(i);
                row.addElement(schObj.getName());
                long time = schObj.getNextExportTime();
                if (time == -1L) {
                    this.schedList.removeElementAt(i);
                    --i;
                    continue;
                }
                row.addElement(DateFormat.getDateTimeInstance(2, 3).format(new Date(time)));
                row.addElement(schObj.getFileLocation());
                row.addElement(schObj.getExportLocation());
                row.addElement(schObj.getCommand());
                this.data.addElement(row);
            }
            this.fireTableDataChanged();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public int getRowCount() {
        if (this.data == null) {
            this.updateDataVector();
        }
        return this.data.size();
    }

    public void updateScheduleList() {
        try {
            this.schedList = ScheduleModifier.getScheduleList();
            this.updateDataVector();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public int getColumnCount() {
        return this.header.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.header[columnIndex];
    }

    public Class getColumnClass(int columnIndex) {
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.data == null) {
            this.updateDataVector();
        }
        return this.data.elementAt(rowIndex).elementAt(columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        try {
            this.data.elementAt(rowIndex).setElementAt(aValue, columnIndex);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void addRow(Object[] rowData) {
        try {
            Vector<Object> vec = new Vector<Object>();
            for (Object element : rowData) {
                vec.addElement(element);
            }
            this.data.addElement(vec);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void insertRow(int row, Object[] rowData) {
        try {
            Vector<Object> vec = new Vector<Object>();
            for (Object element : rowData) {
                vec.addElement(element);
            }
            this.data.insertElementAt(vec, row);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void modifyRow(int row, ScheduleObject obj) {
        try {
            this.schedList.setElementAt(obj, row);
            this.updateDataVector();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void addRow(ScheduleObject obj) {
        try {
            this.schedList.add(obj);
            this.updateDataVector();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void moveRow(int startIndex, int endIndex, int toIndex) {
    }

    @Override
    public void removeRow(int row) {
        try {
            this.schedList.removeElementAt(row);
            this.data.removeElementAt(row);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public ScheduleObject getScheduleObject(int idx) {
        return this.schedList.elementAt(idx);
    }
}

