/*
 * Decompiled with CFR 0.152.
 */
package quadbase.scheduler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableColumnModel;
import quadbase.common.util.BrowseDirectories;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LCKey;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbBrowseDirectories;
import quadbase.scheduler.PackageDialog;
import quadbase.scheduler.RefreshScheduleThread;
import quadbase.scheduler.ScheduleCommandDialog;
import quadbase.scheduler.ScheduleModifier;
import quadbase.scheduler.ScheduleObject;
import quadbase.scheduler.ScheduleSummaryDialog;
import quadbase.scheduler.ScheduleTableModel;
import quadbase.scheduler.SelectScheduleObjectDialog;

public class Scheduler
extends JPanel
implements ActionListener {
    private JTable folderTable;
    private ScheduleTableModel model;
    private JScrollPane scroller;
    private JButton refresh;
    private JButton add;
    private JButton edit;
    private JButton remove;
    private JButton details;
    private JButton done;
    private Component parent;
    private JFrame frame;
    private RefreshScheduleThread refreshScheduleThread;
    private long refreshTime = 60000L;
    boolean isInsertCommandEnabled = true;
    private String securityLevel = null;
    private boolean sysExitOnExit = true;
    BrowseDirectories browseDir;

    public Scheduler(Component parent) throws Exception {
        this.parent = parent;
        this.init();
        this.startRefreshScheduleThread();
    }

    JFrame getFrame() {
        if (this.frame != null) {
            return this.frame;
        }
        this.frame = this.parent instanceof JFrame ? (JFrame)this.parent : new JFrame();
        return this.frame;
    }

    void startRefreshScheduleThread() {
        this.refreshScheduleThread = new RefreshScheduleThread(this);
        this.refreshScheduleThread.setPriority(1);
        this.refreshScheduleThread.setTime(this.refreshTime);
        this.refreshScheduleThread.start();
    }

    void init() throws Exception {
        this.browseDir = new QbBrowseDirectories();
        this.setLayout(new BorderLayout());
        this.model = new ScheduleTableModel(ScheduleModifier.getScheduleList());
        this.folderTable = new JTable(this.model);
        this.folderTable.setRowSelectionAllowed(true);
        this.folderTable.setSelectionMode(0);
        TableColumnModel colModel = this.folderTable.getColumnModel();
        JTextField notEditableField = new JTextField();
        notEditableField.setEditable(false);
        notEditableField.setHorizontalAlignment(2);
        DefaultCellEditor notEditor = new DefaultCellEditor(notEditableField);
        this.folderTable.clearSelection();
        for (int i = 0; i < 5; ++i) {
            colModel.getColumn(i).setCellEditor(notEditor);
        }
        this.folderTable.setShowGrid(false);
        this.folderTable.addMouseListener(new MouseAdapter(){
            private int rowIndex;
            private int leftClickMask = 0;

            @Override
            public void mousePressed(MouseEvent e) {
                this.rowIndex = -1;
                int mouseMask = e.getModifiers() & 0xFFFFFFEF;
                if (mouseMask == this.leftClickMask) {
                    Scheduler.this.folderTable.setCursor(Cursor.getPredefinedCursor(13));
                    this.rowIndex = Scheduler.this.folderTable.getSelectedRow();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.rowIndex != -1) {
                    Scheduler.this.folderTable.setCursor(Cursor.getPredefinedCursor(0));
                    int newRowIndex = Scheduler.this.folderTable.getSelectedRow();
                    if (this.rowIndex == newRowIndex) {
                        this.rowIndex = -1;
                        return;
                    }
                    Scheduler.this.model.moveRow(this.rowIndex, this.rowIndex, newRowIndex);
                    this.rowIndex = -1;
                    Scheduler.this.folderTable.clearSelection();
                }
            }
        });
        this.scroller = new JScrollPane();
        this.scroller.getViewport().add(this.folderTable);
        this.scroller.getViewport().setBackground(this.folderTable.getBackground());
        this.scroller.setBackground(this.folderTable.getBackground());
        JPanel buttonPanel = new JPanel();
        if (this.parent instanceof JFrame) {
            buttonPanel.setLayout(new GridLayout(6, 1, 5, 5));
        } else {
            buttonPanel.setLayout(new GridLayout(5, 1, 5, 5));
        }
        this.refresh = new JButton(LanguageEncoder.getText("Refresh"));
        this.details = new JButton(LanguageEncoder.getText("Details"));
        this.edit = new JButton(LanguageEncoder.getText("Edit"));
        this.add = new JButton(LanguageEncoder.getText("Add"));
        this.remove = new JButton(LanguageEncoder.getText("Remove"));
        this.done = this.parent instanceof JFrame ? new JButton(LanguageEncoder.getText("Done")) : new JButton(LanguageEncoder.getText("Save"));
        buttonPanel.add(this.refresh);
        buttonPanel.add(this.details);
        buttonPanel.add(this.add);
        buttonPanel.add(this.edit);
        buttonPanel.add(this.remove);
        if (LCKey.isFree()) {
            this.refresh.setEnabled(false);
            this.details.setEnabled(false);
            this.edit.setEnabled(false);
            this.add.setEnabled(false);
            this.remove.setEnabled(false);
            this.done.setEnabled(false);
            JMessageDialog.optionDialog(this.parent, LanguageEncoder.getText("EspressReport"), "Report Scheduler is only included in full version.\nWith Report Scheduler, you can export reports at a specific time or specific interval.\nFor more information, please contact sales@quadbase.com.", 0);
        }
        if (this.parent instanceof JFrame) {
            buttonPanel.add(this.done);
        }
        this.refresh.addActionListener(this);
        this.details.addActionListener(this);
        this.add.addActionListener(this);
        this.edit.addActionListener(this);
        this.remove.addActionListener(this);
        this.done.addActionListener(this);
        this.add("Center", this.scroller);
        this.add("East", buttonPanel);
        this.setBackground(this.folderTable.getBackground());
        this.setButtons();
    }

    private void setButtons() {
        int rowCt = this.model.getRowCount();
        if (rowCt == 0) {
            this.edit.setEnabled(false);
            this.remove.setEnabled(false);
            this.details.setEnabled(false);
        } else {
            this.edit.setEnabled(true);
            this.remove.setEnabled(true);
            this.details.setEnabled(true);
        }
    }

    public void deleteTask() {
        int row = this.folderTable.getSelectedRow();
        String msg = null;
        if (row < 0) {
            msg = LanguageEncoder.getText("Please select a job first!");
        }
        if (msg != null) {
            JMessageDialog.errorDialog(this.parent, msg);
            return;
        }
        msg = LanguageEncoder.getText("Delete this job?");
        JMessageDialog dialog = new JMessageDialog((Frame)this.getFrame(), "Confirmation", msg, 2);
        int response = dialog.getResponse();
        if (response == 4) {
            try {
                ScheduleObject obj = this.model.getScheduleObject(row);
                ScheduleModifier.removeScheduleTask(obj);
                this.model.removeRow(row);
                this.folderTable.clearSelection();
                this.folderTable.validate();
                this.folderTable.repaint();
                this.setButtons();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void addTask() {
        if (this.isInsertCommandEnabled) {
            SelectScheduleObjectDialog schDialog = new SelectScheduleObjectDialog(this);
            schDialog.setBrowseDirectories(this.browseDir);
            schDialog.setVisible(true);
            if (schDialog.isCancelled()) {
                return;
            }
            this.model.addRow(schDialog.getScheduleObject());
        } else {
            PackageDialog schDialog = new PackageDialog(this);
            schDialog.setBrowseDirectories(this.browseDir);
            schDialog.setSecurityLevel(this.securityLevel);
            schDialog.setVisible(true);
            if (schDialog.isCancelled()) {
                return;
            }
            this.model.addRow(schDialog.getScheduleObject());
        }
        this.folderTable.validate();
        this.folderTable.repaint();
        this.setButtons();
    }

    public void editTask() {
        String msg = null;
        int row = this.folderTable.getSelectedRow();
        if (row < 0) {
            msg = LanguageEncoder.getText("Please select a job first!");
        }
        if (msg != null) {
            JMessageDialog.errorDialog(this.parent, msg);
            return;
        }
        ScheduleObject obj = this.model.getScheduleObject(row);
        if (obj.isCommand()) {
            ScheduleCommandDialog schDialog = new ScheduleCommandDialog(this, obj, row);
            schDialog.setVisible(true);
            if (schDialog.isCancelled()) {
                return;
            }
            this.model.modifyRow(row, schDialog.getScheduleObject());
        } else {
            PackageDialog schDialog = new PackageDialog(this, obj, row);
            schDialog.setBrowseDirectories(this.browseDir);
            schDialog.setSecurityLevel(this.securityLevel);
            schDialog.setVisible(true);
            if (schDialog.isCancelled()) {
                return;
            }
            this.model.modifyRow(row, schDialog.getScheduleObject());
        }
        this.folderTable.validate();
        this.folderTable.repaint();
        this.setButtons();
    }

    public void detailsTask() {
        String msg = null;
        int row = this.folderTable.getSelectedRow();
        if (row < 0) {
            msg = LanguageEncoder.getText("Please select a job first!");
        }
        if (msg != null) {
            JMessageDialog.errorDialog(this.parent, msg);
            return;
        }
        new ScheduleSummaryDialog(this, this.model.getScheduleObject(row)).setVisible(true);
    }

    public void refreshList() {
        this.model.updateScheduleList();
        this.setButtons();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        if (target == this.add) {
            this.addTask();
        } else if (target == this.refresh) {
            this.refreshList();
        } else if (target == this.edit) {
            this.editTask();
        } else if (target == this.details) {
            this.detailsTask();
        } else if (target == this.remove) {
            this.deleteTask();
        } else if (target == this.done) {
            try {
                ScheduleModifier.saveScheduleTask();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (this.parent instanceof JFrame) {
                JFrame frame = (JFrame)this.parent;
                frame.setVisible(false);
                frame.dispose();
                System.exit(0);
            }
        }
    }

    public void setSecurityLevel(String sl) {
        this.securityLevel = sl;
    }

    public String getSecurityLevel() {
        return this.securityLevel;
    }

    public void setSysExitOnExit(boolean state) {
        this.sysExitOnExit = state;
    }

    public boolean sysExitOnExit() {
        return this.sysExitOnExit;
    }
}

