/*
 * Decompiled with CFR 0.152.
 */
package quadbase.scheduler;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jnlp.ServiceManager;
import javax.jnlp.SingleInstanceListener;
import javax.jnlp.SingleInstanceService;
import javax.jnlp.UnavailableServiceException;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JPanel;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbDebug;
import quadbase.common.util.internal.QbUtil;
import quadbase.scheduler.ScheduleModifier;
import quadbase.scheduler.Scheduler;

public class SchedulerClient
extends JApplet {
    private static final Logger LOGGER = Logger.getLogger(SchedulerClient.class.getName());
    static JApplet applet;
    private static String servletURL;
    private static String QLOGO;

    public static void main(String[] args) {
        applet = null;
        QbUtil.setWindowsLAF();
        String filename = null;
        String enc = null;
        for (String arg : args) {
            if (arg.equalsIgnoreCase("-http")) {
                ServerMessage.useHttp();
                continue;
            }
            if (arg.startsWith("-servlet:")) {
                ServerMessage.useServlet();
                String tmp = arg.substring(9);
                if (tmp.equals("")) continue;
                servletURL = tmp;
                continue;
            }
            if (arg.equalsIgnoreCase("-servlet")) {
                ServerMessage.useServlet();
                continue;
            }
            if (arg.startsWith("-file:")) {
                filename = arg.substring(6);
                continue;
            }
            if (arg.startsWith("-enc:")) {
                enc = arg.substring(5);
                continue;
            }
            if (!arg.startsWith("-debug:")) continue;
            QbDebug.setDebugMode(arg.substring(7));
        }
        if (filename != null && enc != null) {
            try {
                LanguageEncoder.loadFromServer(filename, enc);
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        ServerMessage.useServer = true;
        SchedulerClient.startProgram(null);
    }

    @Override
    public void init() {
        String debugMode;
        String servletContext;
        String comm_url;
        SchedulerClient.initJNLP();
        applet = this;
        QbUtil.setWindowsLAF();
        String proto = this.getParameter("comm_protocol");
        if (proto != null) {
            if (proto.equalsIgnoreCase("http")) {
                ServerMessage.useHttp();
            } else if (proto.equalsIgnoreCase("servlet")) {
                ServerMessage.useServlet();
            }
        }
        if ((comm_url = this.getParameter("comm_url")) != null) {
            if (ServerMessage.isServlet()) {
                ServerMessage.setConnectServlet(comm_url);
            } else {
                ServerMessage.setConnectURL(comm_url);
            }
        }
        if ((servletContext = this.getParameter("servlet_context")) != null) {
            ServerMessage.setServletContext(servletContext);
        }
        ServerMessage.useServer = true;
        String filename = this.getParameter("file");
        String enc = this.getParameter("enc");
        if (filename != null && enc != null) {
            try {
                LanguageEncoder.loadFromServer(filename, enc);
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        if ((debugMode = this.getParameter("debug")) != null) {
            QbDebug.setDebugMode(debugMode);
        }
        SchedulerClient.startProgram(this);
    }

    public static void startProgram(JApplet applet) {
        block5: {
            try {
                if (servletURL != null) {
                    String tmp = servletURL;
                    String servletBaseStr = ServerMessage.getServletBaseString(tmp);
                    String servletContext = ServerMessage.getServletContext(tmp);
                    ServerMessage.setConnectServlet(servletBaseStr);
                    ServerMessage.setServletContext(servletContext);
                }
                ServerMessage.setApplet(applet);
                if (applet == null) {
                    JFrame frame = new JFrame(LanguageEncoder.getText("Scheduler"));
                    frame.setIconImage(IOUtil.getImage(QLOGO));
                    Scheduler scheduler = new Scheduler(frame);
                    JPanel contentPane = (JPanel)frame.getContentPane();
                    contentPane.setLayout(new BorderLayout());
                    contentPane.add("Center", scheduler);
                    SchedulerClient.setPosition(frame);
                    frame.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent ev) {
                            try {
                                ScheduleModifier.saveScheduleTask();
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            System.exit(0);
                        }
                    });
                    frame.setVisible(true);
                } else {
                    Scheduler scheduler = new Scheduler(applet);
                    JPanel contentPane = (JPanel)applet.getContentPane();
                    contentPane.setLayout(new BorderLayout());
                    contentPane.add("Center", scheduler);
                }
            }
            catch (Exception ex) {
                System.out.println("Cannot start program!");
                ex.printStackTrace();
                if (applet != null) break block5;
                System.exit(1);
            }
        }
    }

    static Image getImage(Class<? extends JFrame> classObj, String s) {
        InputStream inputstream = classObj.getResourceAsStream(s);
        if (inputstream == null) {
            return null;
        }
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        byte[] abyte0 = new byte[1024];
        try {
            int i;
            do {
                if ((i = inputstream.read(abyte0)) == -1) continue;
                bytearrayoutputstream.write(abyte0, 0, i);
            } while (i != -1);
            inputstream.close();
        }
        catch (IOException _ex) {
            try {
                inputstream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
        return Toolkit.getDefaultToolkit().createImage(bytearrayoutputstream.toByteArray());
    }

    private static void setPosition(JFrame frame) {
        frame.pack();
        Dimension screenSize = frame.getToolkit().getScreenSize();
        Dimension dim = frame.getPreferredSize();
        int x = (screenSize.width - dim.width) / 2;
        int y = (screenSize.height - dim.height) / 2;
        frame.setBounds(x, y, dim.width, dim.height);
        frame.setSize(dim);
    }

    private static void initJNLP() {
        if (ServerMessage.isJnlp()) {
            SchedulerClient.deleteJNLPFile();
            SchedulerClient.registerJNLPSingleton();
        }
    }

    private static void deleteJNLPFile() {
        File jnlpFile;
        String jnlpPath = System.getProperty("jnlpx.origFilenameArg");
        if (jnlpPath != null && !(jnlpFile = new File(jnlpPath)).delete()) {
            LOGGER.warning("Failed to delete JNLP file " + jnlpPath);
        }
    }

    private static void registerJNLPSingleton() {
        try {
            SingleInstanceService singleInstanceService = (SingleInstanceService)ServiceManager.lookup((String)"javax.jnlp.SingleInstanceService");
            singleInstanceService.addSingleInstanceListener(new SingleInstanceListener(){

                public void newActivation(String[] strings) {
                    SchedulerClient.deleteJNLPFile();
                }
            });
        }
        catch (UnavailableServiceException e) {
            LOGGER.log(Level.WARNING, "Failed to register SingleInstanceService", e);
        }
    }

    static {
        QLOGO = ServerMessage.reportImagesPath + "QuadLogo.png";
    }
}

