/*
 * Decompiled with CFR 0.152.
 */
package quadbase.scheduler;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import quadbase.common.util.BrowseDirectories;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.scheduler.PackageDialog;
import quadbase.scheduler.ScheduleCommandDialog;
import quadbase.scheduler.ScheduleObject;
import quadbase.scheduler.Scheduler;

public class SelectScheduleObjectDialog
extends JDialog
implements ActionListener {
    private JButton ok;
    private JButton cancel;
    private Scheduler parent;
    private ScheduleObject schObj = null;
    private JRadioButton insertReport;
    private JRadioButton insertCommand;
    private boolean isCancelled = false;
    BrowseDirectories browseDir;

    public SelectScheduleObjectDialog(Scheduler parent) {
        super(parent.getFrame(), LanguageEncoder.getText("Set Schedule"), true);
        this.parent = parent;
        this.init();
        this.setPosition();
    }

    void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    void init() {
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JPanel topPanel = new JPanel();
        topPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Select Schedule Object")));
        topPanel.setLayout(new GridLayout(1, 2, 5, 5));
        this.insertReport = new JRadioButton(LanguageEncoder.getText("Insert Report"));
        this.insertReport.setSelected(true);
        this.insertCommand = new JRadioButton(LanguageEncoder.getText("Insert Command"));
        topPanel.add(this.insertReport);
        topPanel.add(this.insertCommand);
        ButtonGroup radio_gp = new ButtonGroup();
        radio_gp.add(this.insertReport);
        radio_gp.add(this.insertCommand);
        contentPane.add(topPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(new EmptyBorder(20, 0, 20, 0));
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        this.ok = new JButton(LanguageEncoder.getText("Next"));
        this.cancel = new JButton(LanguageEncoder.getText("Cancel"));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.ok);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.cancel);
        buttonPanel.add(Box.createHorizontalGlue());
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        contentPane.add(buttonPanel);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SelectScheduleObjectDialog.this.isCancelled = true;
            }
        });
    }

    ScheduleObject getScheduleObject() {
        return this.schObj;
    }

    boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        this.setVisible(false);
        this.dispose();
        if (target == this.cancel) {
            this.isCancelled = true;
        } else if (target == this.ok) {
            if (this.insertReport.isSelected()) {
                PackageDialog schDialog = new PackageDialog(this.parent);
                schDialog.setBrowseDirectories(this.browseDir);
                schDialog.setSecurityLevel(this.parent.getSecurityLevel());
                schDialog.setVisible(true);
                if (schDialog.isCancelled()) {
                    this.isCancelled = true;
                    return;
                }
                this.schObj = schDialog.getScheduleObject();
            } else {
                ScheduleCommandDialog schDialog = new ScheduleCommandDialog(this.parent);
                schDialog.setVisible(true);
                if (schDialog.isCancelled()) {
                    this.isCancelled = true;
                    return;
                }
                this.schObj = schDialog.getScheduleObject();
            }
        }
    }

    public void setBrowseDirectories(BrowseDirectories dir) {
        this.browseDir = dir;
    }
}

