/*
 * Decompiled with CFR 0.152.
 */
package quadbase.scheduler;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import quadbase.common.swing.JCalendar;
import quadbase.common.swing.JSpinField;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.scheduler.FixedDaysDialog;
import quadbase.scheduler.ScheduleObject;
import quadbase.scheduler.Scheduler;
import quadbase.scheduler.TimeIntervalDialog;

public class SetScheduleDialog
extends JDialog
implements ActionListener,
ItemListener {
    private JRadioButton oneTimeButton;
    private JRadioButton timeIntervalButton;
    private JRadioButton fixedDaysButton;
    private JButton back;
    private JButton ok;
    private JButton cancel;
    private JButton setTimeIntervalButton;
    private JButton setDayIntervalButton;
    private JCalendar startDateBox;
    private JCalendar endDateBox;
    private Calendar startDate;
    private Calendar endDate;
    private TimePanel startTime;
    private TimePanel endTime;
    private JCheckBox runIndefinity;
    private Scheduler scheduler;
    private TimeIntervalDialog intervalDialog;
    private FixedDaysDialog fixedDaysDialog;
    private boolean isCancel = false;
    private boolean goBack = false;
    private ScheduleObject schObj;
    private boolean initDone = false;

    public SetScheduleDialog(Scheduler sched, ScheduleObject schObj) {
        super(sched.getFrame(), LanguageEncoder.getText("Set Schedule"), true);
        this.scheduler = sched;
        this.schObj = schObj;
        this.init();
        this.setPosition();
    }

    void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    void init() {
        this.initDone = false;
        JPanel runTaskPanel = new JPanel();
        JPanel timeIntervalPanel = new JPanel();
        JPanel dayIntervalPanel = new JPanel();
        runTaskPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Schedule a job to run task")));
        runTaskPanel.setLayout(new GridLayout(3, 1, 5, 5));
        timeIntervalPanel.setLayout(new BoxLayout(timeIntervalPanel, 0));
        dayIntervalPanel.setLayout(new BoxLayout(dayIntervalPanel, 0));
        this.oneTimeButton = new JRadioButton(LanguageEncoder.getText("One time only"));
        this.oneTimeButton.setSelected(true);
        this.timeIntervalButton = new JRadioButton(LanguageEncoder.getText("At a regular time interval"));
        this.setTimeIntervalButton = new JButton(LanguageEncoder.getText("Time Interval"));
        this.setTimeIntervalButton.addActionListener(this);
        this.setTimeIntervalButton.setEnabled(false);
        this.fixedDaysButton = new JRadioButton(LanguageEncoder.getText("On fixed days/dates every week/month"));
        this.setDayIntervalButton = new JButton(LanguageEncoder.getText("Day Interval"));
        this.setDayIntervalButton.addActionListener(this);
        this.setDayIntervalButton.setEnabled(false);
        ButtonGroup radio_gp = new ButtonGroup();
        radio_gp.add(this.oneTimeButton);
        radio_gp.add(this.timeIntervalButton);
        radio_gp.add(this.fixedDaysButton);
        runTaskPanel.add(this.oneTimeButton);
        timeIntervalPanel.add(this.timeIntervalButton);
        timeIntervalPanel.add(this.setTimeIntervalButton);
        runTaskPanel.add(timeIntervalPanel);
        dayIntervalPanel.add(this.fixedDaysButton);
        dayIntervalPanel.add(this.setDayIntervalButton);
        runTaskPanel.add(dayIntervalPanel);
        this.startDate = Calendar.getInstance();
        this.startDate.add(12, 10);
        this.endDate = Calendar.getInstance();
        this.endDate.add(12, 15);
        JPanel startDatePanel = new JPanel();
        startDatePanel.setBorder(new TitledBorder(LanguageEncoder.getText("Begin On")));
        startDatePanel.setLayout(new BorderLayout());
        this.startDateBox = new JCalendar();
        this.startDateBox.setCalendar(this.startDate);
        startDatePanel.add("Center", this.startDateBox);
        JPanel timePanel1 = new JPanel();
        timePanel1.setLayout(new GridLayout(2, 1, 5, 5));
        this.startTime = new TimePanel();
        timePanel1.add("South", this.startTime);
        this.startTime.setValues(this.startDate);
        timePanel1.add(new JLabel(" "));
        startDatePanel.add("South", timePanel1);
        JPanel endDatePanel = new JPanel();
        endDatePanel.setBorder(new TitledBorder(LanguageEncoder.getText("End On")));
        endDatePanel.setLayout(new BorderLayout());
        this.endDateBox = new JCalendar();
        this.endDateBox.setCalendar(this.endDate);
        endDatePanel.add("Center", this.endDateBox);
        JPanel timePanel2 = new JPanel();
        timePanel2.setLayout(new GridLayout(2, 1, 5, 5));
        this.endTime = new TimePanel();
        timePanel2.add("South", this.endTime);
        this.endTime.setValues(this.endDate);
        this.runIndefinity = new JCheckBox(LanguageEncoder.getText("Run Indefinitely"), false);
        timePanel2.add(this.runIndefinity);
        endDatePanel.add("South", timePanel2);
        JPanel datePanel = new JPanel();
        datePanel.setLayout(new GridLayout(1, 2, 5, 5));
        datePanel.add(startDatePanel);
        datePanel.add(endDatePanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(new EmptyBorder(20, 0, 20, 0));
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        this.back = new JButton(LanguageEncoder.getText("Back"));
        this.ok = new JButton(LanguageEncoder.getText("Next"));
        this.cancel = new JButton(LanguageEncoder.getText("Cancel"));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.back);
        this.back.addActionListener(this);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.ok);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.cancel);
        buttonPanel.add(Box.createHorizontalGlue());
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add("Center", runTaskPanel);
        mainPanel.add("South", datePanel);
        this.oneTimeButton.addItemListener(this);
        this.timeIntervalButton.addItemListener(this);
        this.fixedDaysButton.addItemListener(this);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", mainPanel);
        contentPane.add("South", buttonPanel);
        this.itemStateChanged(null);
        this.initDone = true;
    }

    void preSetValues(ScheduleObject obj) {
        this.initDone = false;
        this.setTaskOption(obj.getTaskOption());
        this.setStartDate(obj.getStartDate());
        this.setEndDate(obj.getEndDate());
        this.itemStateChanged(null);
        this.initDone = true;
    }

    boolean isCancel() {
        return this.isCancel;
    }

    boolean goBack() {
        return this.goBack;
    }

    void setValues(ScheduleObject schObj) {
        schObj.setTaskOption(this.getTaskOption());
        schObj.setStartDate(this.startDate == null ? -1L : this.startDate.getTime().getTime());
        schObj.setEndDate(this.endDate == null ? -1L : this.endDate.getTime().getTime());
        if (this.timeIntervalButton.isSelected() && this.intervalDialog != null) {
            this.intervalDialog.setValues(schObj);
        } else if (this.fixedDaysButton.isSelected() && this.fixedDaysDialog != null) {
            this.fixedDaysDialog.setValues(schObj);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.runIndefinity.setEnabled(!this.oneTimeButton.isSelected());
        this.endDateBox.setEnabled(!this.oneTimeButton.isSelected() && !this.runIndefinity.isSelected());
        this.endTime.setEnabled(!this.oneTimeButton.isSelected() && !this.runIndefinity.isSelected());
        this.setTimeIntervalButton.setEnabled(this.timeIntervalButton.isSelected());
        this.setDayIntervalButton.setEnabled(this.fixedDaysButton.isSelected());
        if (!this.initDone) {
            return;
        }
        if (this.fixedDaysButton.isSelected()) {
            this.openFixedDaysDialog();
        }
        if (this.timeIntervalButton.isSelected()) {
            this.openTimeIntervalDialog();
        }
    }

    void openFixedDaysDialog() {
        if (this.fixedDaysDialog == null) {
            this.fixedDaysDialog = new FixedDaysDialog(this.scheduler);
        }
        this.fixedDaysDialog.preSetValues(this.schObj);
        this.fixedDaysDialog.setVisible(true);
        if (!this.fixedDaysDialog.isCancel()) {
            this.fixedDaysDialog.setValues(this.schObj);
        }
    }

    void openTimeIntervalDialog() {
        if (this.intervalDialog == null) {
            this.intervalDialog = new TimeIntervalDialog(this.scheduler);
        }
        this.intervalDialog.preSetValues(this.schObj);
        this.intervalDialog.setVisible(true);
        if (!this.intervalDialog.isCancel()) {
            this.intervalDialog.setValues(this.schObj);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        if (target == this.setTimeIntervalButton) {
            this.openTimeIntervalDialog();
        } else if (target == this.setDayIntervalButton) {
            this.openFixedDaysDialog();
        } else if (target == this.back) {
            this.goBack = true;
            this.isCancel = false;
            this.setVisible(false);
        } else if (target == this.cancel) {
            this.isCancel = true;
            this.goBack = false;
            this.setVisible(false);
            this.dispose();
        } else if (target == this.ok) {
            this.isCancel = false;
            this.goBack = false;
            String msg = null;
            this.startDate = this.startDateBox.getCalendar();
            this.startDate.set(11, this.startTime.getHour());
            this.startDate.set(12, this.startTime.getMinute());
            this.startDate.set(13, 0);
            Calendar currentCal = Calendar.getInstance();
            currentCal.add(12, 5);
            if (this.startDate.before(currentCal)) {
                msg = LanguageEncoder.getText("Start time has to be at least 5 mins ahead from the current time!");
            }
            if (!this.oneTimeButton.isSelected() && !this.runIndefinity.isSelected()) {
                this.endDate = this.endDateBox.getCalendar();
                this.endDate.set(11, this.endTime.getHour());
                this.endDate.set(12, this.endTime.getMinute());
                this.endDate.set(13, 0);
                if (!this.endDate.after(this.startDate)) {
                    msg = LanguageEncoder.getText("End date must after start date!");
                }
            } else {
                this.endDate = null;
            }
            if (msg != null) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), msg);
                return;
            }
            this.setVisible(false);
            this.dispose();
        }
    }

    private int getTaskOption() {
        if (this.oneTimeButton.isSelected()) {
            return 0;
        }
        if (this.timeIntervalButton.isSelected()) {
            return 1;
        }
        return 2;
    }

    private void setTaskOption(int option) {
        if (option == 0) {
            this.oneTimeButton.setSelected(true);
        } else if (option == 1) {
            this.timeIntervalButton.setSelected(true);
        } else {
            this.fixedDaysButton.setSelected(true);
        }
    }

    private void setStartDate(long time) {
        this.startDate = Calendar.getInstance();
        this.startDate.setTime(new Date(time));
        this.startDateBox.setCalendar(this.startDate);
        this.startTime.setValues(this.startDate);
    }

    private void setEndDate(long time) {
        if (time >= 0L) {
            this.endDate = Calendar.getInstance();
            this.endDate.setTime(new Date(time));
            this.endDateBox.setCalendar(this.endDate);
            this.endTime.setValues(this.endDate);
        }
        this.runIndefinity.setSelected(time <= 0L && !this.oneTimeButton.isSelected());
    }

    public class TimePanel
    extends JPanel {
        JSpinField hour;
        JSpinField min;

        public TimePanel() {
            this.setLayout(new GridLayout(1, 5, 5, 5));
            this.add(new JLabel(LanguageEncoder.getText("Time:")));
            this.hour = new JSpinField();
            this.hour.setMinimum(0);
            this.hour.setMaximum(23);
            this.hour.setValue(0);
            this.add(this.hour);
            this.add(new JLabel(LanguageEncoder.getText("HRS")));
            this.min = new JSpinField();
            this.min.setMinimum(0);
            this.min.setMaximum(59);
            this.min.setValue(0);
            this.add(this.min);
            this.add(new JLabel(LanguageEncoder.getText("MINS")));
        }

        public int getHour() {
            return this.hour.getValue();
        }

        public int getMinute() {
            return this.min.getValue();
        }

        public void setValues(Calendar cal) {
            this.hour.setValue(cal.get(11));
            this.min.setValue(cal.get(12));
        }

        @Override
        public void setEnabled(boolean b) {
            this.hour.setEnabled(b);
            this.min.setEnabled(b);
        }
    }
}

