/*
 * Decompiled with CFR 0.152.
 */
package quadbase.scheduler;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import quadbase.common.swing.UndoTextArea;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.scheduler.ScheduleObject;
import quadbase.scheduler.Scheduler;

public class SetScheduleEmailDialog2
extends JDialog
implements ActionListener,
ItemListener {
    private JButton ok;
    private JButton cancel;
    private JButton back;
    private JRadioButton asAttachmentButton;
    private JRadioButton asLinkButton;
    private JRadioButton asHTMLButton;
    private JCheckBox sendEmail;
    private JTextField urlMappingField;
    private JTextField fromField;
    private JTextField addressField;
    private JTextField subjectField;
    private UndoTextArea bodyTextArea;
    private boolean isCancel = false;
    private boolean isBack = false;
    private ScheduleObject schObj;

    public SetScheduleEmailDialog2(Scheduler sched, ScheduleObject schObj) {
        super(sched.getFrame(), LanguageEncoder.getText("Email Setting"), true);
        this.schObj = schObj;
        this.init();
        this.setPosition();
    }

    void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    void init() {
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JPanel infoPanel = new JPanel();
        infoPanel.setBorder(new TitledBorder(LanguageEncoder.getText("General Email Infomation:")));
        infoPanel.setLayout(new BorderLayout());
        JPanel infoPanelWest = new JPanel(new GridLayout(3, 1, 5, 5));
        JPanel infoPanelCenter = new JPanel(new GridLayout(3, 1, 5, 5));
        JLabel fromLbl = new JLabel(LanguageEncoder.getText("From:"));
        JLabel addressLbl = new JLabel(LanguageEncoder.getText("To:"));
        JLabel subjectLbl = new JLabel(LanguageEncoder.getText("Subject:"));
        this.fromField = new JTextField("", 30);
        this.addressField = new JTextField("", 30);
        this.subjectField = new JTextField("", 30);
        infoPanelWest.add(fromLbl);
        infoPanelWest.add(addressLbl);
        infoPanelWest.add(subjectLbl);
        infoPanelCenter.add(this.fromField);
        infoPanelCenter.add(this.addressField);
        infoPanelCenter.add(this.subjectField);
        infoPanel.add("West", infoPanelWest);
        infoPanel.add("Center", infoPanelCenter);
        JPanel bodyTextPanel = new JPanel();
        bodyTextPanel.setLayout(new FlowLayout(0));
        bodyTextPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Email Body Text:")));
        JLabel bodyTextLbl = new JLabel(LanguageEncoder.getText("Body Text:"));
        bodyTextLbl.setAlignmentY(0.5f);
        this.bodyTextArea = new UndoTextArea(7, 70);
        this.bodyTextArea.setLineWrap(true);
        this.bodyTextArea.setText("");
        JScrollPane textAreaPanel = new JScrollPane(20, 31);
        textAreaPanel.getViewport().add(this.bodyTextArea);
        bodyTextPanel.add(bodyTextLbl);
        bodyTextPanel.add(textAreaPanel);
        JPanel optionPanel = new JPanel();
        optionPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Email Option...")));
        optionPanel.setLayout(new BorderLayout());
        JPanel radioButtonPanel = new JPanel();
        radioButtonPanel.setLayout(new FlowLayout(0));
        this.asAttachmentButton = new JRadioButton(LanguageEncoder.getText("As Attachment"), true);
        this.asLinkButton = new JRadioButton(LanguageEncoder.getText("As Link"), false);
        this.asHTMLButton = new JRadioButton(LanguageEncoder.getText("As HTML"), false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.asAttachmentButton);
        group.add(this.asLinkButton);
        group.add(this.asHTMLButton);
        radioButtonPanel.add(this.asAttachmentButton);
        radioButtonPanel.add(this.asLinkButton);
        radioButtonPanel.add(this.asHTMLButton);
        this.asAttachmentButton.addItemListener(this);
        this.asLinkButton.addItemListener(this);
        this.asHTMLButton.addItemListener(this);
        JPanel urlMappingPanel = new JPanel();
        bodyTextPanel.setLayout(new FlowLayout(0));
        JLabel urlMappingLbl = new JLabel(LanguageEncoder.getText("URL Mapping:"));
        this.urlMappingField = new JTextField(25);
        urlMappingLbl.setAlignmentY(0.5f);
        urlMappingPanel.add(urlMappingLbl);
        urlMappingPanel.add(this.urlMappingField);
        JPanel checkBoxPanel = new JPanel();
        checkBoxPanel.setLayout(new FlowLayout(0));
        this.sendEmail = new JCheckBox(LanguageEncoder.getText("Send Email"), true);
        checkBoxPanel.add(this.sendEmail);
        this.sendEmail.addItemListener(this);
        optionPanel.add("North", radioButtonPanel);
        optionPanel.add("Center", urlMappingPanel);
        optionPanel.add("South", checkBoxPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(new EmptyBorder(20, 0, 20, 0));
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        this.back = new JButton(LanguageEncoder.getText("Back"));
        this.ok = new JButton(LanguageEncoder.getText("OK"));
        this.cancel = new JButton(LanguageEncoder.getText("Cancel"));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.back);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.ok);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.cancel);
        buttonPanel.add(Box.createHorizontalGlue());
        this.back.addActionListener(this);
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        contentPane.add(infoPanel);
        contentPane.add(bodyTextPanel);
        contentPane.add(optionPanel);
        contentPane.add(buttonPanel);
        this.preSetValues(this.schObj);
        this.itemStateChanged(null);
    }

    void preSetValues(ScheduleObject schObj) {
        if (schObj == null) {
            return;
        }
        this.sendEmail.setSelected(schObj.isSendEmail());
        if (schObj.isSendEmail()) {
            this.fromField.setText(schObj.getFromAddress());
            String[] addresses = schObj.getToAddresses();
            String address = "";
            if (addresses != null) {
                for (String addresse : addresses) {
                    address = address + addresse + ";";
                }
            }
            this.addressField.setText(address);
            this.subjectField.setText(schObj.getSubject());
            this.bodyTextArea.setText(schObj.getBodyText());
            if (schObj.getEmailType() == 2) {
                this.asHTMLButton.setSelected(true);
                this.bodyTextArea.setText("");
                this.bodyTextArea.setEnabled(false);
            } else if (schObj.getEmailType() == 1) {
                this.asLinkButton.setSelected(true);
            } else {
                this.asAttachmentButton.setSelected(true);
            }
            if (schObj.getReportType() != 4) {
                this.asAttachmentButton.setSelected(true);
                this.asHTMLButton.setSelected(false);
                this.asHTMLButton.setEnabled(false);
            }
            this.urlMappingField.setEnabled(this.enableURLMapping());
            if (this.enableURLMapping()) {
                this.urlMappingField.setText(schObj.getURLMapping());
            }
        }
    }

    private boolean enableURLMapping() {
        return this.asLinkButton.isSelected() || this.schObj.getReportType() == 4;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.urlMappingField.setEnabled(this.enableURLMapping());
        this.fromField.setEnabled(this.sendEmail.isSelected());
        this.addressField.setEnabled(this.sendEmail.isSelected());
        this.subjectField.setEnabled(this.sendEmail.isSelected());
        this.bodyTextArea.setEnabled(this.sendEmail.isSelected());
        this.bodyTextArea.setEnabled(!this.asHTMLButton.isSelected());
        if (this.asHTMLButton.isSelected()) {
            this.bodyTextArea.setEnabled(false);
            this.bodyTextArea.setText("");
        }
    }

    boolean isCancel() {
        return this.isCancel;
    }

    boolean isBack() {
        return this.isBack;
    }

    void setValues(ScheduleObject schObj) {
        schObj.setSendEmail(this.sendEmail.isSelected());
        if (this.sendEmail.isSelected()) {
            schObj.setFromAddress(this.fromField.getText().trim());
            schObj.setToAddresses(this.getToAddresses(this.addressField.getText().trim()));
            schObj.setSubject(this.subjectField.getText().trim());
            schObj.setBodyText(this.bodyTextArea.getText().trim());
        }
        if (this.asAttachmentButton.isSelected()) {
            schObj.setEmailType(0);
        }
        if (this.asLinkButton.isSelected()) {
            schObj.setEmailType(1);
        }
        if (this.asHTMLButton.isSelected()) {
            schObj.setEmailType(2);
            schObj.setBodyText("");
        }
        schObj.setURLMapping(this.urlMappingField.getText());
    }

    String[] getToAddresses(String str) {
        Vector<String> tokens = new Vector<String>();
        str = str.replace(',', ';');
        StringTokenizer token = new StringTokenizer(str, ";");
        while (token.hasMoreTokens()) {
            tokens.addElement(token.nextToken());
        }
        String[] addresses = new String[tokens.size()];
        for (int i = 0; i < tokens.size(); ++i) {
            addresses[i] = (String)tokens.elementAt(i);
        }
        return addresses;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        this.isBack = false;
        if (target == this.back) {
            this.isBack = true;
            this.setVisible(false);
            this.dispose();
        } else if (target == this.cancel) {
            this.isCancel = true;
            this.setVisible(false);
            this.dispose();
        } else if (target == this.ok) {
            this.isCancel = false;
            String msg = null;
            if (this.sendEmail.isSelected()) {
                if (this.fromField.getText() == null || this.fromField.getText().trim().equals("")) {
                    msg = LanguageEncoder.getText("Please enter the from address!");
                }
                if (this.addressField.getText() == null || this.addressField.getText().trim().equals("")) {
                    msg = LanguageEncoder.getText("Please enter email address you want to send to!");
                }
                if (this.urlMappingField.isEnabled() && (this.urlMappingField.getText() == null || this.urlMappingField.getText().trim().equals(""))) {
                    msg = LanguageEncoder.getText("Please provide the URL mapping!");
                }
            }
            if (msg != null) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), msg);
                return;
            }
            this.setVisible(false);
            this.dispose();
        }
    }
}

