/*
 * Decompiled with CFR 0.152.
 */
package quadbase.scheduler;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import quadbase.common.swing.JCalendar;
import quadbase.common.swing.JSpinField;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.scheduler.FixedDaysDialog;
import quadbase.scheduler.PackageDialog;
import quadbase.scheduler.ScheduleObject;
import quadbase.scheduler.Scheduler;
import quadbase.scheduler.TimeIntervalDialog;

public class SetTimingPanel
extends JPanel
implements ActionListener,
ItemListener {
    private JRadioButton oneTimeButton;
    private JRadioButton timeIntervalButton;
    private JRadioButton fixedDaysButton;
    private JRadioButton dailyRunTime;
    private JRadioButton dailyFixedInterval;
    private JTextField dailyRunTimeField;
    private TimePanel dailyStart;
    private TimePanel dailyEnd;
    private JSpinField intervalField;
    private JComboBox intervalTypeField;
    private JButton back;
    private JButton ok;
    private JButton cancel;
    private JButton done;
    private JButton setTimeIntervalButton;
    private JButton setDayIntervalButton;
    private JLabel startLabel;
    private JLabel endLabel;
    private JButton changeBut1;
    private JButton changeBut2;
    private Calendar startDate;
    private Calendar endDate;
    private JCheckBox runIndefinity;
    private Scheduler parent;
    private TimeIntervalDialog intervalDialog;
    private FixedDaysDialog fixedDaysDialog;
    private boolean isCancel = false;
    private boolean goBack = false;
    private ScheduleObject schObj;
    private boolean initDone = false;
    private boolean isEditMode = true;
    private JDialog parentDialog;
    private boolean isTabVersion;
    private boolean popWarning = false;

    public SetTimingPanel(Scheduler organizer, JDialog parentDialog, ScheduleObject schObj, boolean editSchedule, boolean isTabVersion) {
        this.parentDialog = parentDialog;
        this.isEditMode = editSchedule;
        this.parent = organizer;
        this.schObj = schObj;
        this.isTabVersion = isTabVersion;
        this.init();
    }

    void init() {
        this.initDone = false;
        JPanel runTaskPanel = new JPanel();
        JPanel timeIntervalPanel = new JPanel();
        JPanel dayIntervalPanel = new JPanel();
        runTaskPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Schedule a job to run task")));
        runTaskPanel.setLayout(new GridLayout(3, 1, 5, 5));
        timeIntervalPanel.setLayout(new BoxLayout(timeIntervalPanel, 0));
        dayIntervalPanel.setLayout(new BoxLayout(dayIntervalPanel, 0));
        this.oneTimeButton = new JRadioButton(LanguageEncoder.getText("One time only"));
        this.oneTimeButton.setSelected(true);
        this.timeIntervalButton = new JRadioButton(LanguageEncoder.getText("At a regular time interval"));
        this.setTimeIntervalButton = new JButton(LanguageEncoder.getText("Time Interval"));
        this.setTimeIntervalButton.addActionListener(this);
        this.setTimeIntervalButton.setEnabled(false);
        this.fixedDaysButton = new JRadioButton(LanguageEncoder.getText("On fixed days/dates every week/month"));
        this.setDayIntervalButton = new JButton(LanguageEncoder.getText("Day Interval"));
        this.setDayIntervalButton.addActionListener(this);
        this.setDayIntervalButton.setEnabled(false);
        ButtonGroup radio_gp = new ButtonGroup();
        radio_gp.add(this.oneTimeButton);
        radio_gp.add(this.timeIntervalButton);
        radio_gp.add(this.fixedDaysButton);
        runTaskPanel.add(this.oneTimeButton);
        timeIntervalPanel.add(this.timeIntervalButton);
        timeIntervalPanel.add(this.setTimeIntervalButton);
        runTaskPanel.add(timeIntervalPanel);
        dayIntervalPanel.add(this.fixedDaysButton);
        dayIntervalPanel.add(this.setDayIntervalButton);
        runTaskPanel.add(dayIntervalPanel);
        this.startDate = Calendar.getInstance();
        this.startDate.add(12, 10);
        this.endDate = Calendar.getInstance();
        this.endDate.add(5, 1);
        this.endDate.add(12, 10);
        JPanel startDatePanel = new JPanel();
        startDatePanel.setBorder(new TitledBorder(LanguageEncoder.getText("Begin On")));
        startDatePanel.setLayout(new FlowLayout(0));
        this.startLabel = new JLabel(this.toString(this.startDate));
        startDatePanel.add(this.startLabel);
        this.changeBut1 = new JButton("change");
        this.changeBut1.addActionListener(this);
        startDatePanel.add(this.changeBut1);
        JPanel endDatePanel = new JPanel();
        endDatePanel.setBorder(new TitledBorder(LanguageEncoder.getText("End On")));
        endDatePanel.setLayout(new FlowLayout(0));
        this.endLabel = new JLabel(this.toString(this.endDate));
        endDatePanel.add(this.endLabel);
        this.changeBut2 = new JButton("change");
        this.changeBut2.addActionListener(this);
        endDatePanel.add(this.changeBut2);
        this.runIndefinity = new JCheckBox(LanguageEncoder.getText("Run Indefinitely"), false);
        endDatePanel.add(this.runIndefinity);
        this.runIndefinity.addItemListener(this);
        JPanel datePanel = new JPanel();
        datePanel.setLayout(new GridLayout(2, 1, 5, 5));
        datePanel.add(startDatePanel);
        datePanel.add(endDatePanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(new EmptyBorder(20, 0, 20, 0));
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        this.back = new JButton(LanguageEncoder.getText("Back"));
        this.ok = new JButton(LanguageEncoder.getText("Next"));
        this.cancel = new JButton(LanguageEncoder.getText("Cancel"));
        this.done = new JButton(LanguageEncoder.getText("Done"));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.back);
        this.back.addActionListener(this);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.ok);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.cancel);
        buttonPanel.add(Box.createHorizontalGlue());
        if (this.isEditMode) {
            buttonPanel.add(this.done);
            buttonPanel.add(Box.createHorizontalGlue());
        }
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        this.done.addActionListener(this);
        JPanel dailyPanel = new JPanel();
        dailyPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Daily Frequency")));
        dailyPanel.setLayout(new GridLayout(2, 1, 5, 5));
        this.dailyRunTime = new JRadioButton(LanguageEncoder.getText("Set Run Times:"));
        this.dailyRunTime.setSelected(true);
        this.dailyFixedInterval = new JRadioButton(LanguageEncoder.getText("Set Fixed Interval"));
        ButtonGroup radio_gp2 = new ButtonGroup();
        radio_gp2.add(this.dailyRunTime);
        radio_gp2.add(this.dailyFixedInterval);
        JPanel dailyRunTimePanel = new JPanel();
        dailyRunTimePanel.setLayout(new FlowLayout(0));
        dailyRunTimePanel.add(this.dailyRunTime);
        this.dailyRunTimeField = new JTextField(50);
        dailyRunTimePanel.add(this.dailyRunTimeField);
        JPanel dailyFixedIntervalPanel = new JPanel();
        dailyFixedIntervalPanel.setLayout(new BoxLayout(dailyFixedIntervalPanel, 0));
        dailyFixedIntervalPanel.add(this.dailyFixedInterval);
        this.dailyStart = new TimePanel(LanguageEncoder.getText("From:"));
        dailyFixedIntervalPanel.add(this.dailyStart);
        this.dailyEnd = new TimePanel(LanguageEncoder.getText("To:"));
        dailyFixedIntervalPanel.add(this.dailyEnd);
        dailyFixedIntervalPanel.add(new JLabel(LanguageEncoder.getText("Every")));
        this.intervalField = new JSpinField();
        this.intervalField.setMinimum(1);
        this.intervalField.setMaximum(23);
        this.intervalTypeField = new JComboBox();
        this.intervalTypeField.addItem("Hours");
        this.intervalTypeField.addItem("Minutes");
        this.intervalTypeField.setSelectedIndex(0);
        this.intervalTypeField.addItemListener(this);
        dailyFixedIntervalPanel.add(this.intervalField);
        dailyFixedIntervalPanel.add(this.intervalTypeField);
        dailyPanel.add(dailyRunTimePanel);
        dailyPanel.add(dailyFixedIntervalPanel);
        this.dailyRunTime.addItemListener(this);
        this.dailyFixedInterval.addItemListener(this);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add("North", runTaskPanel);
        mainPanel.add("Center", datePanel);
        mainPanel.add("South", dailyPanel);
        this.oneTimeButton.addItemListener(this);
        this.timeIntervalButton.addItemListener(this);
        this.fixedDaysButton.addItemListener(this);
        this.setLayout(new BorderLayout());
        this.add("Center", mainPanel);
        this.add("South", buttonPanel);
        if (this.schObj == null) {
            this.schObj = new ScheduleObject("", false);
            this.isEditMode = false;
        }
        this.itemStateChanged(null);
        this.initDone = true;
    }

    String toString(Calendar cal) {
        return DateFormat.getInstance().format(cal.getTime());
    }

    void preSetValues(ScheduleObject obj) {
        this.initDone = false;
        this.setTaskOption(obj.getTaskOption());
        this.setStartDate(obj.getStartDate());
        this.setEndDate(obj.getEndDate());
        this.itemStateChanged(null);
        this.dailyEnd.setHour(23);
        this.dailyEnd.setMinute(59);
        if (obj.getTaskOption() == 2) {
            int[] specifyTime = obj.getSpecifyTime();
            if (specifyTime != null && specifyTime.length > 0) {
                String val = "";
                for (int i = 0; i < specifyTime.length; ++i) {
                    val = i != 0 ? val + ", " + this.minuteToString(specifyTime[i]) : this.minuteToString(specifyTime[i]);
                }
                this.dailyRunTime.setSelected(true);
                this.dailyRunTimeField.setText(val);
            } else if (obj.getTimeInterval() > 0) {
                this.dailyFixedInterval.setSelected(true);
                int stTime = obj.getStartTime();
                if (stTime < 0) {
                    stTime = 0;
                }
                this.dailyStart.setHour(stTime / 60);
                this.dailyStart.setMinute(stTime % 60);
                int edTime = obj.getEndTime();
                if (edTime <= 0) {
                    edTime = 1439;
                }
                this.dailyEnd.setHour(edTime / 60);
                this.dailyEnd.setMinute(edTime % 60);
                int interval = obj.getTimeInterval();
                if (interval % 60 == 0) {
                    this.intervalTypeField.setSelectedIndex(0);
                    this.intervalField.setMaximum(23);
                    this.intervalField.setValue(interval / 60);
                } else {
                    this.intervalTypeField.setSelectedIndex(1);
                    this.intervalField.setMaximum(1440);
                    this.intervalField.setValue(interval);
                }
            }
        }
        this.initDone = true;
    }

    boolean isCancel() {
        return this.isCancel;
    }

    boolean goBack() {
        return this.goBack;
    }

    void setValues(ScheduleObject schObj) {
        try {
            schObj.setTaskOption(this.getTaskOption());
            schObj.setStartDate(this.startDate == null ? -1L : this.startDate.getTime().getTime());
            schObj.setEndDate(this.endDate == null ? -1L : this.endDate.getTime().getTime());
            if (this.timeIntervalButton.isSelected() && this.intervalDialog != null) {
                this.intervalDialog.setValues(schObj);
            } else if (this.fixedDaysButton.isSelected() && this.fixedDaysDialog != null) {
                this.fixedDaysDialog.setValues(schObj);
            }
            if (this.fixedDaysButton.isSelected()) {
                if (this.dailyRunTime.isSelected()) {
                    schObj.setSpecifyTime(this.parseTimeField(this.dailyRunTimeField.getText()));
                } else {
                    schObj.setStartTime(this.dailyStart.getHour() * 60 + this.dailyStart.getMinute());
                    schObj.setEndTime(this.dailyEnd.getHour() * 60 + this.dailyEnd.getMinute());
                    if (this.intervalTypeField.getSelectedIndex() == 0) {
                        schObj.setTimeInterval(this.intervalField.getValue() * 60);
                    } else {
                        schObj.setTimeInterval(this.intervalField.getValue());
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    int[] parseTimeField(String text) throws Exception {
        StringTokenizer stToken = new StringTokenizer(text, ", ;");
        Vector<Integer> slot = new Vector<Integer>();
        while (stToken.hasMoreTokens()) {
            slot.add(this.parseTime(stToken.nextToken()));
        }
        int[] val = new int[slot.size()];
        for (int i = 0; i < slot.size(); ++i) {
            val[i] = (Integer)slot.elementAt(i);
        }
        return val;
    }

    int parseTime(String time) throws Exception {
        time = time.trim();
        int val = 0;
        boolean in24Clock = false;
        if (time.toUpperCase().endsWith("PM")) {
            val = 720;
        } else if (!time.toUpperCase().endsWith("AM")) {
            in24Clock = true;
        }
        if (!in24Clock) {
            time = time.substring(0, time.length() - 2);
        }
        int idx = time.indexOf(58);
        int hrs = Integer.parseInt(time.substring(0, idx));
        if (in24Clock) {
            val += hrs * 60;
        } else if (hrs != 12) {
            val += hrs * 60;
        }
        return val += Integer.parseInt(time.substring(idx + 1));
    }

    String minuteToString(int time) {
        String val = "";
        if (time > 720) {
            time -= 720;
            val = "PM";
        } else {
            val = "AM";
        }
        int hrs = time / 60;
        val = time % 60 + val;
        val = val.length() == 3 ? ":0" + val : ":" + val;
        if (hrs == 0) {
            hrs = 12;
        }
        return hrs + val;
    }

    private boolean isWithinValidTimeRange() {
        long value;
        if (this.oneTimeButton.isSelected()) {
            return true;
        }
        if (this.runIndefinity.isSelected()) {
            return true;
        }
        ScheduleObject schObj = new ScheduleObject("TESTING", false);
        schObj.setTaskOption(this.getTaskOption());
        schObj.setStartDate(this.startDate == null ? -1L : this.startDate.getTime().getTime());
        schObj.setEndDate(this.endDate == null ? -1L : this.endDate.getTime().getTime());
        if (this.timeIntervalButton.isSelected() && this.intervalDialog != null) {
            this.intervalDialog.setValues(schObj);
        } else if (this.fixedDaysButton.isSelected() && this.fixedDaysDialog != null) {
            this.fixedDaysDialog.setValues(schObj);
        }
        if (this.fixedDaysButton.isSelected()) {
            if (this.dailyRunTime.isSelected()) {
                try {
                    schObj.setSpecifyTime(this.parseTimeField(this.dailyRunTimeField.getText()));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else {
                schObj.setStartTime(this.dailyStart.getHour() * 60 + this.dailyStart.getMinute());
                schObj.setEndTime(this.dailyEnd.getHour() * 60 + this.dailyEnd.getMinute());
                if (this.intervalTypeField.getSelectedIndex() == 0) {
                    schObj.setTimeInterval(this.intervalField.getValue() * 60);
                } else {
                    schObj.setTimeInterval(this.intervalField.getValue());
                }
            }
        }
        return (value = schObj.getNextExportTime()) != -1L;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.runIndefinity.setEnabled(!this.oneTimeButton.isSelected());
        this.endLabel.setEnabled(!this.oneTimeButton.isSelected() && !this.runIndefinity.isSelected());
        this.changeBut2.setEnabled(!this.oneTimeButton.isSelected() && !this.runIndefinity.isSelected());
        this.setTimeIntervalButton.setEnabled(this.timeIntervalButton.isSelected());
        this.setDayIntervalButton.setEnabled(this.fixedDaysButton.isSelected());
        this.dailyRunTime.setEnabled(this.fixedDaysButton.isSelected());
        this.dailyRunTimeField.setEnabled(this.fixedDaysButton.isSelected() && this.dailyRunTime.isSelected());
        this.dailyFixedInterval.setEnabled(this.fixedDaysButton.isSelected());
        this.dailyStart.setEnabled(this.fixedDaysButton.isSelected() && this.dailyFixedInterval.isSelected());
        this.dailyEnd.setEnabled(this.fixedDaysButton.isSelected() && this.dailyFixedInterval.isSelected());
        this.intervalField.setEnabled(this.fixedDaysButton.isSelected() && this.dailyFixedInterval.isSelected());
        this.intervalTypeField.setEnabled(this.fixedDaysButton.isSelected() && this.dailyFixedInterval.isSelected());
        if (this.intervalTypeField.getSelectedIndex() == 1) {
            int val = this.intervalField.getValue();
            this.intervalField.setMaximum(1440);
            this.intervalField.setValue(val);
        } else {
            int val = this.intervalField.getValue();
            this.intervalField.setMaximum(23);
            if (val > 23) {
                this.intervalField.setValue(23);
            } else {
                this.intervalField.setValue(val);
            }
        }
        if (!this.initDone) {
            return;
        }
        if (e != null && (e.getSource() == this.fixedDaysButton || e.getSource() == this.timeIntervalButton)) {
            if (this.fixedDaysButton.isSelected()) {
                this.openFixedDaysDialog();
            }
            if (this.timeIntervalButton.isSelected()) {
                this.openTimeIntervalDialog();
            }
        }
    }

    void openFixedDaysDialog() {
        if (this.fixedDaysDialog == null) {
            this.fixedDaysDialog = new FixedDaysDialog(this.parent);
        }
        this.fixedDaysDialog.preSetValues(this.schObj);
        this.fixedDaysDialog.setVisible(true);
        if (!this.fixedDaysDialog.isCancel()) {
            this.fixedDaysDialog.setValues(this.schObj);
        }
    }

    void openTimeIntervalDialog() {
        if (this.intervalDialog == null) {
            this.intervalDialog = new TimeIntervalDialog(this.parent);
        }
        this.intervalDialog.preSetValues(this.schObj);
        this.intervalDialog.setVisible(true);
        if (!this.intervalDialog.isCancel()) {
            this.intervalDialog.setValues(this.schObj);
        }
    }

    boolean popWarning() {
        return this.popWarning;
    }

    void resetWarning() {
        this.popWarning = false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target;
        this.popWarning = false;
        boolean switchByTab = false;
        if (e == null) {
            target = this.ok;
            switchByTab = true;
        } else {
            target = e.getSource();
        }
        if (target == this.setTimeIntervalButton) {
            this.openTimeIntervalDialog();
        } else if (target == this.setDayIntervalButton) {
            this.openFixedDaysDialog();
        } else if (target == this.back) {
            this.goBack = true;
            this.isCancel = false;
            if (!this.isTabVersion) {
                this.parentDialog.setVisible(false);
            } else if (this.parentDialog instanceof PackageDialog) {
                ((PackageDialog)this.parentDialog).showFirstPanel();
            }
        } else if (target == this.cancel) {
            this.isCancel = true;
            this.goBack = false;
            if (this.parentDialog instanceof PackageDialog) {
                ((PackageDialog)this.parentDialog).setCancelled();
            }
            this.parentDialog.setVisible(false);
            this.parentDialog.dispose();
        } else if (target == this.ok || target == this.done) {
            Calendar currentCal;
            this.isCancel = false;
            this.goBack = false;
            String msg = null;
            if (!this.isEditMode) {
                currentCal = Calendar.getInstance();
                currentCal.add(12, 5);
                if (this.startDate.before(currentCal)) {
                    msg = LanguageEncoder.getText("Start time has to be at least 5 mins ahead from the current time!");
                }
            } else if (this.oneTimeButton.isSelected() && this.startDate.before(currentCal = Calendar.getInstance())) {
                msg = LanguageEncoder.getText("Start time has to be ahead from the current time!");
            }
            if (!this.oneTimeButton.isSelected() && !this.runIndefinity.isSelected()) {
                if (this.endDate != null && this.startDate != null && !this.endDate.after(this.startDate)) {
                    msg = LanguageEncoder.getText("End date must after start date!");
                }
                if (this.isEditMode) {
                    currentCal = Calendar.getInstance();
                    currentCal.add(12, 1);
                    if (this.endDate != null && this.endDate.before(currentCal)) {
                        msg = LanguageEncoder.getText("Start time has to be at least 1 min ahead from the current time!");
                    }
                }
            } else {
                this.endDate = null;
            }
            if (msg == null && this.fixedDaysButton.isSelected() && this.dailyRunTime.isSelected()) {
                try {
                    this.parseTimeField(this.dailyRunTimeField.getText());
                }
                catch (Exception ex) {
                    msg = LanguageEncoder.getText("Invalid daily run time input! [Correct Format: 9:30PM, 10:00PM]");
                }
            }
            if (msg == null && !this.isWithinValidTimeRange()) {
                msg = LanguageEncoder.getText("There is no time interval found between start date and end date!");
            }
            if (msg != null) {
                this.popWarning = true;
                new JMessageDialog((Frame)this.parent.getFrame(), LanguageEncoder.getText("Warning"), msg);
                return;
            }
            if (this.parentDialog instanceof PackageDialog) {
                this.setValues(((PackageDialog)this.parentDialog).getScheduleObject());
            }
            if (!this.isTabVersion) {
                this.parentDialog.setVisible(false);
                this.parentDialog.dispose();
            } else if (this.parentDialog instanceof PackageDialog) {
                if (target == this.done) {
                    ((PackageDialog)this.parentDialog).showSummaryDialog();
                    return;
                }
                if (!switchByTab) {
                    ((PackageDialog)this.parentDialog).showSetParametersPanel();
                }
            }
        } else if (target == this.changeBut1) {
            CalendarDialog popup1 = new CalendarDialog(this.parentDialog, this.startDate, LanguageEncoder.getText("Begin On"));
            popup1.setVisible(true);
            if (!popup1.isCancelled()) {
                this.startDate = popup1.getDate();
                this.startLabel.setText(this.toString(this.startDate));
            }
        } else if (target == this.changeBut2) {
            CalendarDialog popup2 = new CalendarDialog(this.parentDialog, this.endDate, LanguageEncoder.getText("End On"));
            popup2.setVisible(true);
            if (!popup2.isCancelled()) {
                this.endDate = popup2.getDate();
                this.endLabel.setText(this.toString(this.endDate));
            }
        }
    }

    private int getTaskOption() {
        if (this.oneTimeButton.isSelected()) {
            return 0;
        }
        if (this.timeIntervalButton.isSelected()) {
            return 1;
        }
        return 2;
    }

    private void setTaskOption(int option) {
        if (option == 0) {
            this.oneTimeButton.setSelected(true);
        } else if (option == 1) {
            this.timeIntervalButton.setSelected(true);
        } else {
            this.fixedDaysButton.setSelected(true);
        }
    }

    private void setStartDate(long time) {
        this.startDate = Calendar.getInstance();
        this.startDate.setTime(new Date(time));
        this.startLabel.setText(this.toString(this.startDate));
    }

    private void setEndDate(long time) {
        if (time >= 0L) {
            this.endDate = Calendar.getInstance();
            this.endDate.setTime(new Date(time));
            this.endLabel.setText(this.toString(this.endDate));
        } else {
            this.endDate = Calendar.getInstance();
            this.endDate.setTime(this.startDate.getTime());
            this.endDate.add(5, 1);
        }
        this.runIndefinity.setSelected(time <= 0L && !this.oneTimeButton.isSelected());
    }

    public class TimePanel
    extends JPanel {
        JSpinField hour;
        JSpinField min;

        public TimePanel() {
            this(null);
        }

        public TimePanel(String label) {
            if (label != null) {
                this.setLayout(new BoxLayout(this, 0));
                this.add(new JLabel(label));
            } else {
                this.setLayout(new BoxLayout(this, 0));
            }
            this.hour = new JSpinField();
            this.hour.setMinimum(0);
            this.hour.setMaximum(23);
            this.hour.setValue(0);
            this.add(this.hour);
            this.add(new JLabel(LanguageEncoder.getText("HRS")));
            this.min = new JSpinField();
            this.min.setMinimum(0);
            this.min.setMaximum(59);
            this.min.setValue(0);
            this.add(this.min);
            this.add(new JLabel(LanguageEncoder.getText("MINS")));
        }

        public int getHour() {
            return this.hour.getValue();
        }

        public int getMinute() {
            return this.min.getValue();
        }

        public void setHour(int hr) {
            this.hour.setValue(hr);
        }

        public void setMinute(int mi) {
            this.min.setValue(mi);
        }

        public void setValues(Calendar cal) {
            this.hour.setValue(cal.get(11));
            this.min.setValue(cal.get(12));
        }

        @Override
        public void setEnabled(boolean b) {
            this.hour.setEnabled(b);
            this.min.setEnabled(b);
        }
    }

    class CalendarDialog
    extends JDialog
    implements ActionListener {
        JCalendar calBox;
        TimePanel timePanel;
        JButton okButton;
        JButton cancelButton;
        boolean isCancel;

        public CalendarDialog(Dialog parent, Calendar date, String titleText) {
            super(parent, "Calendar", true);
            this.isCancel = false;
            JPanel panel = (JPanel)this.getContentPane();
            panel.setBorder(new TitledBorder(titleText));
            panel.setLayout(new BorderLayout());
            this.calBox = new JCalendar();
            this.calBox.setCalendar(date);
            panel.add("North", this.calBox);
            JPanel timePanel1 = new JPanel();
            timePanel1.setLayout(new GridLayout(2, 1, 5, 5));
            this.timePanel = new TimePanel(LanguageEncoder.getText("Time:"));
            timePanel1.add(this.timePanel);
            this.timePanel.setValues(date);
            timePanel1.add(new JLabel(" "));
            panel.add("Center", timePanel1);
            JPanel butPanel = new JPanel();
            butPanel.setLayout(new GridLayout(1, 2, 5, 5));
            this.okButton = new JButton("Ok");
            butPanel.add(this.okButton);
            this.cancelButton = new JButton("Cancel");
            butPanel.add(this.cancelButton);
            panel.add("South", butPanel);
            this.okButton.addActionListener(this);
            this.cancelButton.addActionListener(this);
            this.setPosition();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.cancelButton) {
                this.isCancel = true;
            }
            this.setVisible(false);
            this.dispose();
        }

        boolean isCancelled() {
            return this.isCancel;
        }

        public Calendar getDate() {
            Calendar date = this.calBox.getCalendar();
            date.set(11, this.timePanel.getHour());
            date.set(12, this.timePanel.getMinute());
            date.set(13, 0);
            return date;
        }

        public void setDate(Calendar date) {
            this.calBox.setCalendar(SetTimingPanel.this.startDate);
            this.timePanel.setValues(SetTimingPanel.this.startDate);
        }

        void setPosition() {
            this.pack();
            this.setLocationRelativeTo(this.getParent());
        }
    }
}

