/*
 * Decompiled with CFR 0.152.
 */
package quadbase.scheduler;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import quadbase.common.swing.JSpinField;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.scheduler.ScheduleObject;
import quadbase.scheduler.Scheduler;

public class TimeIntervalDialog
extends JDialog
implements ActionListener,
ItemListener {
    JRadioButton timeBut;
    JRadioButton dayBut;
    JRadioButton monthBut;
    JSpinField hourField;
    JSpinField minField;
    JTextField dayField;
    JTextField monthField;
    JButton ok;
    JButton cancel;
    boolean isCancel = false;
    int dayVal;
    int monthVal;
    Scheduler scheduler;

    public TimeIntervalDialog(Scheduler scheduler) {
        super(scheduler.getFrame(), LanguageEncoder.getText("Set Time Interval"), true);
        this.scheduler = scheduler;
        this.init();
        this.setPosition();
    }

    void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    void init() {
        JPanel radioPanel = new JPanel();
        radioPanel.setLayout(new GridLayout(3, 1, 5, 5));
        this.timeBut = new JRadioButton(LanguageEncoder.getText("Time"));
        this.timeBut.setSelected(true);
        this.dayBut = new JRadioButton(LanguageEncoder.getText("Day"));
        this.monthBut = new JRadioButton(LanguageEncoder.getText("Month"));
        radioPanel.add(this.timeBut);
        radioPanel.add(this.dayBut);
        radioPanel.add(this.monthBut);
        JPanel timePanel = new JPanel();
        timePanel.setLayout(new GridLayout(1, 4, 5, 5));
        this.hourField = new JSpinField();
        this.hourField.setMinimum(0);
        this.hourField.setMaximum(23);
        this.minField = new JSpinField();
        this.minField.setMinimum(0);
        this.minField.setMaximum(59);
        this.minField.setValue(1);
        timePanel.add(this.hourField);
        timePanel.add(new JLabel(LanguageEncoder.getText("HRS")));
        timePanel.add(this.minField);
        timePanel.add(new JLabel(LanguageEncoder.getText("MINS")));
        this.timeBut.addItemListener(this);
        this.dayBut.addItemListener(this);
        this.monthBut.addItemListener(this);
        JPanel radioPanel2 = new JPanel();
        radioPanel2.setLayout(new GridLayout(3, 1, 5, 5));
        radioPanel2.add(timePanel);
        this.dayField = new JTextField("1", 15);
        radioPanel2.add(this.dayField);
        this.monthField = new JTextField("1", 15);
        radioPanel2.add(this.monthField);
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Set Time Interval")));
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add("West", radioPanel);
        mainPanel.add("Center", radioPanel2);
        ButtonGroup radio_gp = new ButtonGroup();
        radio_gp.add(this.timeBut);
        radio_gp.add(this.dayBut);
        radio_gp.add(this.monthBut);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(new EmptyBorder(20, 0, 20, 0));
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        this.ok = new JButton(LanguageEncoder.getText("OK"));
        this.cancel = new JButton(LanguageEncoder.getText("Cancel"));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.ok);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.cancel);
        buttonPanel.add(Box.createHorizontalGlue());
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", mainPanel);
        contentPane.add("South", buttonPanel);
        this.setValues();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.setValues();
    }

    void preSetValues(ScheduleObject schObj) {
        int intervalType = schObj.getIntervalType();
        if (intervalType == 0) {
            this.timeBut.setSelected(true);
            int time = schObj.getTimeInterval();
            if (time <= 0) {
                time = 1;
            }
            this.minField.setValue(time % 60);
            this.hourField.setValue(time / 60);
        } else if (intervalType == 1) {
            this.dayBut.setSelected(true);
            this.dayField.setText(schObj.getDayInterval() + "");
        } else if (intervalType == 2) {
            this.monthBut.setSelected(true);
            this.monthField.setText(schObj.getMonthInterval() + "");
        }
    }

    private void setValues() {
        this.hourField.setEnabled(this.timeBut.isSelected());
        this.minField.setEnabled(this.timeBut.isSelected());
        this.dayField.setEnabled(this.dayBut.isSelected());
        this.monthField.setEnabled(this.monthBut.isSelected());
    }

    void setValues(ScheduleObject schObj) {
        if (this.timeBut.isSelected()) {
            int hr = this.hourField.getValue();
            int min = this.minField.getValue();
            schObj.setIntervalType(0);
            schObj.setTimeInterval(hr * 60 + min);
        } else if (this.dayBut.isSelected()) {
            schObj.setIntervalType(1);
            schObj.setDayInterval(this.dayVal);
        } else if (this.monthBut.isSelected()) {
            schObj.setIntervalType(2);
            schObj.setMonthInterval(this.monthVal);
        }
    }

    void setIntervalType(int intervalType) {
        if (intervalType == 0) {
            this.timeBut.setSelected(true);
        }
        if (intervalType == 1) {
            this.dayBut.setSelected(true);
        }
        if (intervalType == 2) {
            this.monthBut.setSelected(true);
        }
    }

    boolean isCancel() {
        return this.isCancel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        this.isCancel = true;
        if (target == this.ok) {
            int min;
            int hr;
            int tmp;
            this.isCancel = false;
            String msg = null;
            if (this.dayBut.isSelected()) {
                try {
                    this.dayVal = Integer.parseInt(this.dayField.getText());
                }
                catch (Exception ex) {
                    msg = LanguageEncoder.getText("Day interval must be integer!");
                }
                if (this.dayVal < 1) {
                    msg = LanguageEncoder.getText("Day interval must greater than 0!");
                }
            } else if (this.monthBut.isSelected()) {
                try {
                    this.monthVal = Integer.parseInt(this.monthField.getText());
                }
                catch (Exception ex) {
                    msg = LanguageEncoder.getText("Month interval must be integer!");
                }
                if (this.monthVal < 1) {
                    msg = LanguageEncoder.getText("Month interval must greater than 0!");
                }
            } else if (this.timeBut.isSelected() && (tmp = (hr = this.hourField.getValue()) * 60 + (min = this.minField.getValue())) < 1) {
                msg = LanguageEncoder.getText("time interval must greater than or equal 1 minute!");
            }
            if (msg != null) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), msg);
                return;
            }
        }
        this.setVisible(false);
        this.dispose();
    }
}

